// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// AccountDuogroupDeleteCollectionReader is a Reader for the AccountDuogroupDeleteCollection structure.
type AccountDuogroupDeleteCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *AccountDuogroupDeleteCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewAccountDuogroupDeleteCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewAccountDuogroupDeleteCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewAccountDuogroupDeleteCollectionOK creates a AccountDuogroupDeleteCollectionOK with default headers values
func NewAccountDuogroupDeleteCollectionOK() *AccountDuogroupDeleteCollectionOK {
	return &AccountDuogroupDeleteCollectionOK{}
}

/*
AccountDuogroupDeleteCollectionOK describes a response with status code 200, with default header values.

OK
*/
type AccountDuogroupDeleteCollectionOK struct {
}

// IsSuccess returns true when this account duogroup delete collection o k response has a 2xx status code
func (o *AccountDuogroupDeleteCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this account duogroup delete collection o k response has a 3xx status code
func (o *AccountDuogroupDeleteCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this account duogroup delete collection o k response has a 4xx status code
func (o *AccountDuogroupDeleteCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this account duogroup delete collection o k response has a 5xx status code
func (o *AccountDuogroupDeleteCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this account duogroup delete collection o k response a status code equal to that given
func (o *AccountDuogroupDeleteCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the account duogroup delete collection o k response
func (o *AccountDuogroupDeleteCollectionOK) Code() int {
	return 200
}

func (o *AccountDuogroupDeleteCollectionOK) Error() string {
	return fmt.Sprintf("[DELETE /security/authentication/duo/groups][%d] accountDuogroupDeleteCollectionOK", 200)
}

func (o *AccountDuogroupDeleteCollectionOK) String() string {
	return fmt.Sprintf("[DELETE /security/authentication/duo/groups][%d] accountDuogroupDeleteCollectionOK", 200)
}

func (o *AccountDuogroupDeleteCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewAccountDuogroupDeleteCollectionDefault creates a AccountDuogroupDeleteCollectionDefault with default headers values
func NewAccountDuogroupDeleteCollectionDefault(code int) *AccountDuogroupDeleteCollectionDefault {
	return &AccountDuogroupDeleteCollectionDefault{
		_statusCode: code,
	}
}

/*
AccountDuogroupDeleteCollectionDefault describes a response with status code -1, with default header values.

Error
*/
type AccountDuogroupDeleteCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this account duogroup delete collection default response has a 2xx status code
func (o *AccountDuogroupDeleteCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this account duogroup delete collection default response has a 3xx status code
func (o *AccountDuogroupDeleteCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this account duogroup delete collection default response has a 4xx status code
func (o *AccountDuogroupDeleteCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this account duogroup delete collection default response has a 5xx status code
func (o *AccountDuogroupDeleteCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this account duogroup delete collection default response a status code equal to that given
func (o *AccountDuogroupDeleteCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the account duogroup delete collection default response
func (o *AccountDuogroupDeleteCollectionDefault) Code() int {
	return o._statusCode
}

func (o *AccountDuogroupDeleteCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /security/authentication/duo/groups][%d] account_duogroup_delete_collection default %s", o._statusCode, payload)
}

func (o *AccountDuogroupDeleteCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /security/authentication/duo/groups][%d] account_duogroup_delete_collection default %s", o._statusCode, payload)
}

func (o *AccountDuogroupDeleteCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *AccountDuogroupDeleteCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
AccountDuogroupDeleteCollectionBody account duogroup delete collection body
swagger:model AccountDuogroupDeleteCollectionBody
*/
type AccountDuogroupDeleteCollectionBody struct {

	// duogroup response inline records
	DuogroupResponseInlineRecords []*models.Duogroup `json:"records,omitempty"`
}

// Validate validates this account duogroup delete collection body
func (o *AccountDuogroupDeleteCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateDuogroupResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *AccountDuogroupDeleteCollectionBody) validateDuogroupResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.DuogroupResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.DuogroupResponseInlineRecords); i++ {
		if swag.IsZero(o.DuogroupResponseInlineRecords[i]) { // not required
			continue
		}

		if o.DuogroupResponseInlineRecords[i] != nil {
			if err := o.DuogroupResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this account duogroup delete collection body based on the context it is used
func (o *AccountDuogroupDeleteCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateDuogroupResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *AccountDuogroupDeleteCollectionBody) contextValidateDuogroupResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.DuogroupResponseInlineRecords); i++ {

		if o.DuogroupResponseInlineRecords[i] != nil {
			if err := o.DuogroupResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *AccountDuogroupDeleteCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *AccountDuogroupDeleteCollectionBody) UnmarshalBinary(b []byte) error {
	var res AccountDuogroupDeleteCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
