// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// AccountDuogroupDeleteReader is a Reader for the AccountDuogroupDelete structure.
type AccountDuogroupDeleteReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *AccountDuogroupDeleteReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewAccountDuogroupDeleteOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewAccountDuogroupDeleteDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewAccountDuogroupDeleteOK creates a AccountDuogroupDeleteOK with default headers values
func NewAccountDuogroupDeleteOK() *AccountDuogroupDeleteOK {
	return &AccountDuogroupDeleteOK{}
}

/*
AccountDuogroupDeleteOK describes a response with status code 200, with default header values.

OK
*/
type AccountDuogroupDeleteOK struct {
}

// IsSuccess returns true when this account duogroup delete o k response has a 2xx status code
func (o *AccountDuogroupDeleteOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this account duogroup delete o k response has a 3xx status code
func (o *AccountDuogroupDeleteOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this account duogroup delete o k response has a 4xx status code
func (o *AccountDuogroupDeleteOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this account duogroup delete o k response has a 5xx status code
func (o *AccountDuogroupDeleteOK) IsServerError() bool {
	return false
}

// IsCode returns true when this account duogroup delete o k response a status code equal to that given
func (o *AccountDuogroupDeleteOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the account duogroup delete o k response
func (o *AccountDuogroupDeleteOK) Code() int {
	return 200
}

func (o *AccountDuogroupDeleteOK) Error() string {
	return fmt.Sprintf("[DELETE /security/authentication/duo/groups/{owner.uuid}/{name}][%d] accountDuogroupDeleteOK", 200)
}

func (o *AccountDuogroupDeleteOK) String() string {
	return fmt.Sprintf("[DELETE /security/authentication/duo/groups/{owner.uuid}/{name}][%d] accountDuogroupDeleteOK", 200)
}

func (o *AccountDuogroupDeleteOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewAccountDuogroupDeleteDefault creates a AccountDuogroupDeleteDefault with default headers values
func NewAccountDuogroupDeleteDefault(code int) *AccountDuogroupDeleteDefault {
	return &AccountDuogroupDeleteDefault{
		_statusCode: code,
	}
}

/*
AccountDuogroupDeleteDefault describes a response with status code -1, with default header values.

Error
*/
type AccountDuogroupDeleteDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this account duogroup delete default response has a 2xx status code
func (o *AccountDuogroupDeleteDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this account duogroup delete default response has a 3xx status code
func (o *AccountDuogroupDeleteDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this account duogroup delete default response has a 4xx status code
func (o *AccountDuogroupDeleteDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this account duogroup delete default response has a 5xx status code
func (o *AccountDuogroupDeleteDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this account duogroup delete default response a status code equal to that given
func (o *AccountDuogroupDeleteDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the account duogroup delete default response
func (o *AccountDuogroupDeleteDefault) Code() int {
	return o._statusCode
}

func (o *AccountDuogroupDeleteDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /security/authentication/duo/groups/{owner.uuid}/{name}][%d] account_duogroup_delete default %s", o._statusCode, payload)
}

func (o *AccountDuogroupDeleteDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /security/authentication/duo/groups/{owner.uuid}/{name}][%d] account_duogroup_delete default %s", o._statusCode, payload)
}

func (o *AccountDuogroupDeleteDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *AccountDuogroupDeleteDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
