// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewAccountGetParams creates a new AccountGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewAccountGetParams() *AccountGetParams {
	return &AccountGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewAccountGetParamsWithTimeout creates a new AccountGetParams object
// with the ability to set a timeout on a request.
func NewAccountGetParamsWithTimeout(timeout time.Duration) *AccountGetParams {
	return &AccountGetParams{
		timeout: timeout,
	}
}

// NewAccountGetParamsWithContext creates a new AccountGetParams object
// with the ability to set a context for a request.
func NewAccountGetParamsWithContext(ctx context.Context) *AccountGetParams {
	return &AccountGetParams{
		Context: ctx,
	}
}

// NewAccountGetParamsWithHTTPClient creates a new AccountGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewAccountGetParamsWithHTTPClient(client *http.Client) *AccountGetParams {
	return &AccountGetParams{
		HTTPClient: client,
	}
}

/*
AccountGetParams contains all the parameters to send to the API endpoint

	for the account get operation.

	Typically these are written to a http.Request.
*/
type AccountGetParams struct {

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* Name.

	   User account name
	*/
	Name string

	/* OwnerUUID.

	   Account owner UUID
	*/
	OwnerUUID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the account get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *AccountGetParams) WithDefaults() *AccountGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the account get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *AccountGetParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the account get params
func (o *AccountGetParams) WithTimeout(timeout time.Duration) *AccountGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the account get params
func (o *AccountGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the account get params
func (o *AccountGetParams) WithContext(ctx context.Context) *AccountGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the account get params
func (o *AccountGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the account get params
func (o *AccountGetParams) WithHTTPClient(client *http.Client) *AccountGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the account get params
func (o *AccountGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithFields adds the fields to the account get params
func (o *AccountGetParams) WithFields(fields []string) *AccountGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the account get params
func (o *AccountGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithName adds the name to the account get params
func (o *AccountGetParams) WithName(name string) *AccountGetParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the account get params
func (o *AccountGetParams) SetName(name string) {
	o.Name = name
}

// WithOwnerUUID adds the ownerUUID to the account get params
func (o *AccountGetParams) WithOwnerUUID(ownerUUID string) *AccountGetParams {
	o.SetOwnerUUID(ownerUUID)
	return o
}

// SetOwnerUUID adds the ownerUuid to the account get params
func (o *AccountGetParams) SetOwnerUUID(ownerUUID string) {
	o.OwnerUUID = ownerUUID
}

// WriteToRequest writes these params to a swagger request
func (o *AccountGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	// path param name
	if err := r.SetPathParam("name", o.Name); err != nil {
		return err
	}

	// path param owner.uuid
	if err := r.SetPathParam("owner.uuid", o.OwnerUUID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamAccountGet binds the parameter fields
func (o *AccountGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}
