// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// AccountGetReader is a Reader for the AccountGet structure.
type AccountGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *AccountGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewAccountGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewAccountGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewAccountGetOK creates a AccountGetOK with default headers values
func NewAccountGetOK() *AccountGetOK {
	return &AccountGetOK{}
}

/*
AccountGetOK describes a response with status code 200, with default header values.

OK
*/
type AccountGetOK struct {
	Payload *models.Account
}

// IsSuccess returns true when this account get o k response has a 2xx status code
func (o *AccountGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this account get o k response has a 3xx status code
func (o *AccountGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this account get o k response has a 4xx status code
func (o *AccountGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this account get o k response has a 5xx status code
func (o *AccountGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this account get o k response a status code equal to that given
func (o *AccountGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the account get o k response
func (o *AccountGetOK) Code() int {
	return 200
}

func (o *AccountGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /security/accounts/{owner.uuid}/{name}][%d] accountGetOK %s", 200, payload)
}

func (o *AccountGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /security/accounts/{owner.uuid}/{name}][%d] accountGetOK %s", 200, payload)
}

func (o *AccountGetOK) GetPayload() *models.Account {
	return o.Payload
}

func (o *AccountGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Account)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewAccountGetDefault creates a AccountGetDefault with default headers values
func NewAccountGetDefault(code int) *AccountGetDefault {
	return &AccountGetDefault{
		_statusCode: code,
	}
}

/*
AccountGetDefault describes a response with status code -1, with default header values.

Error
*/
type AccountGetDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this account get default response has a 2xx status code
func (o *AccountGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this account get default response has a 3xx status code
func (o *AccountGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this account get default response has a 4xx status code
func (o *AccountGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this account get default response has a 5xx status code
func (o *AccountGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this account get default response a status code equal to that given
func (o *AccountGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the account get default response
func (o *AccountGetDefault) Code() int {
	return o._statusCode
}

func (o *AccountGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /security/accounts/{owner.uuid}/{name}][%d] account_get default %s", o._statusCode, payload)
}

func (o *AccountGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /security/accounts/{owner.uuid}/{name}][%d] account_get default %s", o._statusCode, payload)
}

func (o *AccountGetDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *AccountGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
