// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewAccountPublickeyDeleteParams creates a new AccountPublickeyDeleteParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewAccountPublickeyDeleteParams() *AccountPublickeyDeleteParams {
	return &AccountPublickeyDeleteParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewAccountPublickeyDeleteParamsWithTimeout creates a new AccountPublickeyDeleteParams object
// with the ability to set a timeout on a request.
func NewAccountPublickeyDeleteParamsWithTimeout(timeout time.Duration) *AccountPublickeyDeleteParams {
	return &AccountPublickeyDeleteParams{
		timeout: timeout,
	}
}

// NewAccountPublickeyDeleteParamsWithContext creates a new AccountPublickeyDeleteParams object
// with the ability to set a context for a request.
func NewAccountPublickeyDeleteParamsWithContext(ctx context.Context) *AccountPublickeyDeleteParams {
	return &AccountPublickeyDeleteParams{
		Context: ctx,
	}
}

// NewAccountPublickeyDeleteParamsWithHTTPClient creates a new AccountPublickeyDeleteParams object
// with the ability to set a custom HTTPClient for a request.
func NewAccountPublickeyDeleteParamsWithHTTPClient(client *http.Client) *AccountPublickeyDeleteParams {
	return &AccountPublickeyDeleteParams{
		HTTPClient: client,
	}
}

/*
AccountPublickeyDeleteParams contains all the parameters to send to the API endpoint

	for the account publickey delete operation.

	Typically these are written to a http.Request.
*/
type AccountPublickeyDeleteParams struct {

	/* AccountName.

	   User account name
	*/
	AccountName string

	/* Index.

	   Index number for the public key (where there are multiple keys for the same account).
	*/
	Index int64

	/* OwnerUUID.

	   Account owner UUID
	*/
	OwnerUUID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the account publickey delete params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *AccountPublickeyDeleteParams) WithDefaults() *AccountPublickeyDeleteParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the account publickey delete params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *AccountPublickeyDeleteParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the account publickey delete params
func (o *AccountPublickeyDeleteParams) WithTimeout(timeout time.Duration) *AccountPublickeyDeleteParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the account publickey delete params
func (o *AccountPublickeyDeleteParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the account publickey delete params
func (o *AccountPublickeyDeleteParams) WithContext(ctx context.Context) *AccountPublickeyDeleteParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the account publickey delete params
func (o *AccountPublickeyDeleteParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the account publickey delete params
func (o *AccountPublickeyDeleteParams) WithHTTPClient(client *http.Client) *AccountPublickeyDeleteParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the account publickey delete params
func (o *AccountPublickeyDeleteParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithAccountName adds the accountName to the account publickey delete params
func (o *AccountPublickeyDeleteParams) WithAccountName(accountName string) *AccountPublickeyDeleteParams {
	o.SetAccountName(accountName)
	return o
}

// SetAccountName adds the accountName to the account publickey delete params
func (o *AccountPublickeyDeleteParams) SetAccountName(accountName string) {
	o.AccountName = accountName
}

// WithIndex adds the index to the account publickey delete params
func (o *AccountPublickeyDeleteParams) WithIndex(index int64) *AccountPublickeyDeleteParams {
	o.SetIndex(index)
	return o
}

// SetIndex adds the index to the account publickey delete params
func (o *AccountPublickeyDeleteParams) SetIndex(index int64) {
	o.Index = index
}

// WithOwnerUUID adds the ownerUUID to the account publickey delete params
func (o *AccountPublickeyDeleteParams) WithOwnerUUID(ownerUUID string) *AccountPublickeyDeleteParams {
	o.SetOwnerUUID(ownerUUID)
	return o
}

// SetOwnerUUID adds the ownerUuid to the account publickey delete params
func (o *AccountPublickeyDeleteParams) SetOwnerUUID(ownerUUID string) {
	o.OwnerUUID = ownerUUID
}

// WriteToRequest writes these params to a swagger request
func (o *AccountPublickeyDeleteParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param account.name
	if err := r.SetPathParam("account.name", o.AccountName); err != nil {
		return err
	}

	// path param index
	if err := r.SetPathParam("index", swag.FormatInt64(o.Index)); err != nil {
		return err
	}

	// path param owner.uuid
	if err := r.SetPathParam("owner.uuid", o.OwnerUUID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
