// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// AccountPublickeyDeleteReader is a Reader for the AccountPublickeyDelete structure.
type AccountPublickeyDeleteReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *AccountPublickeyDeleteReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewAccountPublickeyDeleteOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewAccountPublickeyDeleteDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewAccountPublickeyDeleteOK creates a AccountPublickeyDeleteOK with default headers values
func NewAccountPublickeyDeleteOK() *AccountPublickeyDeleteOK {
	return &AccountPublickeyDeleteOK{}
}

/*
AccountPublickeyDeleteOK describes a response with status code 200, with default header values.

OK
*/
type AccountPublickeyDeleteOK struct {
}

// IsSuccess returns true when this account publickey delete o k response has a 2xx status code
func (o *AccountPublickeyDeleteOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this account publickey delete o k response has a 3xx status code
func (o *AccountPublickeyDeleteOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this account publickey delete o k response has a 4xx status code
func (o *AccountPublickeyDeleteOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this account publickey delete o k response has a 5xx status code
func (o *AccountPublickeyDeleteOK) IsServerError() bool {
	return false
}

// IsCode returns true when this account publickey delete o k response a status code equal to that given
func (o *AccountPublickeyDeleteOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the account publickey delete o k response
func (o *AccountPublickeyDeleteOK) Code() int {
	return 200
}

func (o *AccountPublickeyDeleteOK) Error() string {
	return fmt.Sprintf("[DELETE /security/authentication/publickeys/{owner.uuid}/{account.name}/{index}][%d] accountPublickeyDeleteOK", 200)
}

func (o *AccountPublickeyDeleteOK) String() string {
	return fmt.Sprintf("[DELETE /security/authentication/publickeys/{owner.uuid}/{account.name}/{index}][%d] accountPublickeyDeleteOK", 200)
}

func (o *AccountPublickeyDeleteOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewAccountPublickeyDeleteDefault creates a AccountPublickeyDeleteDefault with default headers values
func NewAccountPublickeyDeleteDefault(code int) *AccountPublickeyDeleteDefault {
	return &AccountPublickeyDeleteDefault{
		_statusCode: code,
	}
}

/*
AccountPublickeyDeleteDefault describes a response with status code -1, with default header values.

Error
*/
type AccountPublickeyDeleteDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this account publickey delete default response has a 2xx status code
func (o *AccountPublickeyDeleteDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this account publickey delete default response has a 3xx status code
func (o *AccountPublickeyDeleteDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this account publickey delete default response has a 4xx status code
func (o *AccountPublickeyDeleteDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this account publickey delete default response has a 5xx status code
func (o *AccountPublickeyDeleteDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this account publickey delete default response a status code equal to that given
func (o *AccountPublickeyDeleteDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the account publickey delete default response
func (o *AccountPublickeyDeleteDefault) Code() int {
	return o._statusCode
}

func (o *AccountPublickeyDeleteDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /security/authentication/publickeys/{owner.uuid}/{account.name}/{index}][%d] account_publickey_delete default %s", o._statusCode, payload)
}

func (o *AccountPublickeyDeleteDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /security/authentication/publickeys/{owner.uuid}/{account.name}/{index}][%d] account_publickey_delete default %s", o._statusCode, payload)
}

func (o *AccountPublickeyDeleteDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *AccountPublickeyDeleteDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
