// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewAccountTotpDeleteCollectionParams creates a new AccountTotpDeleteCollectionParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewAccountTotpDeleteCollectionParams() *AccountTotpDeleteCollectionParams {
	return &AccountTotpDeleteCollectionParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewAccountTotpDeleteCollectionParamsWithTimeout creates a new AccountTotpDeleteCollectionParams object
// with the ability to set a timeout on a request.
func NewAccountTotpDeleteCollectionParamsWithTimeout(timeout time.Duration) *AccountTotpDeleteCollectionParams {
	return &AccountTotpDeleteCollectionParams{
		timeout: timeout,
	}
}

// NewAccountTotpDeleteCollectionParamsWithContext creates a new AccountTotpDeleteCollectionParams object
// with the ability to set a context for a request.
func NewAccountTotpDeleteCollectionParamsWithContext(ctx context.Context) *AccountTotpDeleteCollectionParams {
	return &AccountTotpDeleteCollectionParams{
		Context: ctx,
	}
}

// NewAccountTotpDeleteCollectionParamsWithHTTPClient creates a new AccountTotpDeleteCollectionParams object
// with the ability to set a custom HTTPClient for a request.
func NewAccountTotpDeleteCollectionParamsWithHTTPClient(client *http.Client) *AccountTotpDeleteCollectionParams {
	return &AccountTotpDeleteCollectionParams{
		HTTPClient: client,
	}
}

/*
AccountTotpDeleteCollectionParams contains all the parameters to send to the API endpoint

	for the account totp delete collection operation.

	Typically these are written to a http.Request.
*/
type AccountTotpDeleteCollectionParams struct {

	/* AccountName.

	   Filter by account.name
	*/
	AccountName *string

	/* Comment.

	   Filter by comment
	*/
	Comment *string

	/* ContinueOnFailure.

	   Continue even when the operation fails on one of the records.
	*/
	ContinueOnFailure *bool

	/* Enabled.

	   Filter by enabled
	*/
	Enabled *bool

	/* Info.

	   Info specification
	*/
	Info AccountTotpDeleteCollectionBody

	/* OwnerName.

	   Filter by owner.name
	*/
	OwnerName *string

	/* OwnerUUID.

	   Filter by owner.uuid
	*/
	OwnerUUID *string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* Scope.

	   Filter by scope
	*/
	Scope *string

	/* SerialRecords.

	   Perform the operation on the records synchronously.
	*/
	SerialRecords *bool

	/* ShaFingerprint.

	   Filter by sha_fingerprint
	*/
	ShaFingerprint *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the account totp delete collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *AccountTotpDeleteCollectionParams) WithDefaults() *AccountTotpDeleteCollectionParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the account totp delete collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *AccountTotpDeleteCollectionParams) SetDefaults() {
	var (
		continueOnFailureDefault = bool(false)

		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)

		serialRecordsDefault = bool(false)
	)

	val := AccountTotpDeleteCollectionParams{
		ContinueOnFailure: &continueOnFailureDefault,
		ReturnRecords:     &returnRecordsDefault,
		ReturnTimeout:     &returnTimeoutDefault,
		SerialRecords:     &serialRecordsDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the account totp delete collection params
func (o *AccountTotpDeleteCollectionParams) WithTimeout(timeout time.Duration) *AccountTotpDeleteCollectionParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the account totp delete collection params
func (o *AccountTotpDeleteCollectionParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the account totp delete collection params
func (o *AccountTotpDeleteCollectionParams) WithContext(ctx context.Context) *AccountTotpDeleteCollectionParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the account totp delete collection params
func (o *AccountTotpDeleteCollectionParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the account totp delete collection params
func (o *AccountTotpDeleteCollectionParams) WithHTTPClient(client *http.Client) *AccountTotpDeleteCollectionParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the account totp delete collection params
func (o *AccountTotpDeleteCollectionParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithAccountName adds the accountName to the account totp delete collection params
func (o *AccountTotpDeleteCollectionParams) WithAccountName(accountName *string) *AccountTotpDeleteCollectionParams {
	o.SetAccountName(accountName)
	return o
}

// SetAccountName adds the accountName to the account totp delete collection params
func (o *AccountTotpDeleteCollectionParams) SetAccountName(accountName *string) {
	o.AccountName = accountName
}

// WithComment adds the comment to the account totp delete collection params
func (o *AccountTotpDeleteCollectionParams) WithComment(comment *string) *AccountTotpDeleteCollectionParams {
	o.SetComment(comment)
	return o
}

// SetComment adds the comment to the account totp delete collection params
func (o *AccountTotpDeleteCollectionParams) SetComment(comment *string) {
	o.Comment = comment
}

// WithContinueOnFailure adds the continueOnFailure to the account totp delete collection params
func (o *AccountTotpDeleteCollectionParams) WithContinueOnFailure(continueOnFailure *bool) *AccountTotpDeleteCollectionParams {
	o.SetContinueOnFailure(continueOnFailure)
	return o
}

// SetContinueOnFailure adds the continueOnFailure to the account totp delete collection params
func (o *AccountTotpDeleteCollectionParams) SetContinueOnFailure(continueOnFailure *bool) {
	o.ContinueOnFailure = continueOnFailure
}

// WithEnabled adds the enabled to the account totp delete collection params
func (o *AccountTotpDeleteCollectionParams) WithEnabled(enabled *bool) *AccountTotpDeleteCollectionParams {
	o.SetEnabled(enabled)
	return o
}

// SetEnabled adds the enabled to the account totp delete collection params
func (o *AccountTotpDeleteCollectionParams) SetEnabled(enabled *bool) {
	o.Enabled = enabled
}

// WithInfo adds the info to the account totp delete collection params
func (o *AccountTotpDeleteCollectionParams) WithInfo(info AccountTotpDeleteCollectionBody) *AccountTotpDeleteCollectionParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the account totp delete collection params
func (o *AccountTotpDeleteCollectionParams) SetInfo(info AccountTotpDeleteCollectionBody) {
	o.Info = info
}

// WithOwnerName adds the ownerName to the account totp delete collection params
func (o *AccountTotpDeleteCollectionParams) WithOwnerName(ownerName *string) *AccountTotpDeleteCollectionParams {
	o.SetOwnerName(ownerName)
	return o
}

// SetOwnerName adds the ownerName to the account totp delete collection params
func (o *AccountTotpDeleteCollectionParams) SetOwnerName(ownerName *string) {
	o.OwnerName = ownerName
}

// WithOwnerUUID adds the ownerUUID to the account totp delete collection params
func (o *AccountTotpDeleteCollectionParams) WithOwnerUUID(ownerUUID *string) *AccountTotpDeleteCollectionParams {
	o.SetOwnerUUID(ownerUUID)
	return o
}

// SetOwnerUUID adds the ownerUuid to the account totp delete collection params
func (o *AccountTotpDeleteCollectionParams) SetOwnerUUID(ownerUUID *string) {
	o.OwnerUUID = ownerUUID
}

// WithReturnRecords adds the returnRecords to the account totp delete collection params
func (o *AccountTotpDeleteCollectionParams) WithReturnRecords(returnRecords *bool) *AccountTotpDeleteCollectionParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the account totp delete collection params
func (o *AccountTotpDeleteCollectionParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the account totp delete collection params
func (o *AccountTotpDeleteCollectionParams) WithReturnTimeout(returnTimeout *int64) *AccountTotpDeleteCollectionParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the account totp delete collection params
func (o *AccountTotpDeleteCollectionParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithScope adds the scope to the account totp delete collection params
func (o *AccountTotpDeleteCollectionParams) WithScope(scope *string) *AccountTotpDeleteCollectionParams {
	o.SetScope(scope)
	return o
}

// SetScope adds the scope to the account totp delete collection params
func (o *AccountTotpDeleteCollectionParams) SetScope(scope *string) {
	o.Scope = scope
}

// WithSerialRecords adds the serialRecords to the account totp delete collection params
func (o *AccountTotpDeleteCollectionParams) WithSerialRecords(serialRecords *bool) *AccountTotpDeleteCollectionParams {
	o.SetSerialRecords(serialRecords)
	return o
}

// SetSerialRecords adds the serialRecords to the account totp delete collection params
func (o *AccountTotpDeleteCollectionParams) SetSerialRecords(serialRecords *bool) {
	o.SerialRecords = serialRecords
}

// WithShaFingerprint adds the shaFingerprint to the account totp delete collection params
func (o *AccountTotpDeleteCollectionParams) WithShaFingerprint(shaFingerprint *string) *AccountTotpDeleteCollectionParams {
	o.SetShaFingerprint(shaFingerprint)
	return o
}

// SetShaFingerprint adds the shaFingerprint to the account totp delete collection params
func (o *AccountTotpDeleteCollectionParams) SetShaFingerprint(shaFingerprint *string) {
	o.ShaFingerprint = shaFingerprint
}

// WriteToRequest writes these params to a swagger request
func (o *AccountTotpDeleteCollectionParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.AccountName != nil {

		// query param account.name
		var qrAccountName string

		if o.AccountName != nil {
			qrAccountName = *o.AccountName
		}
		qAccountName := qrAccountName
		if qAccountName != "" {

			if err := r.SetQueryParam("account.name", qAccountName); err != nil {
				return err
			}
		}
	}

	if o.Comment != nil {

		// query param comment
		var qrComment string

		if o.Comment != nil {
			qrComment = *o.Comment
		}
		qComment := qrComment
		if qComment != "" {

			if err := r.SetQueryParam("comment", qComment); err != nil {
				return err
			}
		}
	}

	if o.ContinueOnFailure != nil {

		// query param continue_on_failure
		var qrContinueOnFailure bool

		if o.ContinueOnFailure != nil {
			qrContinueOnFailure = *o.ContinueOnFailure
		}
		qContinueOnFailure := swag.FormatBool(qrContinueOnFailure)
		if qContinueOnFailure != "" {

			if err := r.SetQueryParam("continue_on_failure", qContinueOnFailure); err != nil {
				return err
			}
		}
	}

	if o.Enabled != nil {

		// query param enabled
		var qrEnabled bool

		if o.Enabled != nil {
			qrEnabled = *o.Enabled
		}
		qEnabled := swag.FormatBool(qrEnabled)
		if qEnabled != "" {

			if err := r.SetQueryParam("enabled", qEnabled); err != nil {
				return err
			}
		}
	}
	if err := r.SetBodyParam(o.Info); err != nil {
		return err
	}

	if o.OwnerName != nil {

		// query param owner.name
		var qrOwnerName string

		if o.OwnerName != nil {
			qrOwnerName = *o.OwnerName
		}
		qOwnerName := qrOwnerName
		if qOwnerName != "" {

			if err := r.SetQueryParam("owner.name", qOwnerName); err != nil {
				return err
			}
		}
	}

	if o.OwnerUUID != nil {

		// query param owner.uuid
		var qrOwnerUUID string

		if o.OwnerUUID != nil {
			qrOwnerUUID = *o.OwnerUUID
		}
		qOwnerUUID := qrOwnerUUID
		if qOwnerUUID != "" {

			if err := r.SetQueryParam("owner.uuid", qOwnerUUID); err != nil {
				return err
			}
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.Scope != nil {

		// query param scope
		var qrScope string

		if o.Scope != nil {
			qrScope = *o.Scope
		}
		qScope := qrScope
		if qScope != "" {

			if err := r.SetQueryParam("scope", qScope); err != nil {
				return err
			}
		}
	}

	if o.SerialRecords != nil {

		// query param serial_records
		var qrSerialRecords bool

		if o.SerialRecords != nil {
			qrSerialRecords = *o.SerialRecords
		}
		qSerialRecords := swag.FormatBool(qrSerialRecords)
		if qSerialRecords != "" {

			if err := r.SetQueryParam("serial_records", qSerialRecords); err != nil {
				return err
			}
		}
	}

	if o.ShaFingerprint != nil {

		// query param sha_fingerprint
		var qrShaFingerprint string

		if o.ShaFingerprint != nil {
			qrShaFingerprint = *o.ShaFingerprint
		}
		qShaFingerprint := qrShaFingerprint
		if qShaFingerprint != "" {

			if err := r.SetQueryParam("sha_fingerprint", qShaFingerprint); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
