// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// NewAccountTotpDeleteParams creates a new AccountTotpDeleteParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewAccountTotpDeleteParams() *AccountTotpDeleteParams {
	return &AccountTotpDeleteParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewAccountTotpDeleteParamsWithTimeout creates a new AccountTotpDeleteParams object
// with the ability to set a timeout on a request.
func NewAccountTotpDeleteParamsWithTimeout(timeout time.Duration) *AccountTotpDeleteParams {
	return &AccountTotpDeleteParams{
		timeout: timeout,
	}
}

// NewAccountTotpDeleteParamsWithContext creates a new AccountTotpDeleteParams object
// with the ability to set a context for a request.
func NewAccountTotpDeleteParamsWithContext(ctx context.Context) *AccountTotpDeleteParams {
	return &AccountTotpDeleteParams{
		Context: ctx,
	}
}

// NewAccountTotpDeleteParamsWithHTTPClient creates a new AccountTotpDeleteParams object
// with the ability to set a custom HTTPClient for a request.
func NewAccountTotpDeleteParamsWithHTTPClient(client *http.Client) *AccountTotpDeleteParams {
	return &AccountTotpDeleteParams{
		HTTPClient: client,
	}
}

/*
AccountTotpDeleteParams contains all the parameters to send to the API endpoint

	for the account totp delete operation.

	Typically these are written to a http.Request.
*/
type AccountTotpDeleteParams struct {

	/* AccountName.

	   Account user name.
	*/
	AccountName string

	/* OwnerUUID.

	   Account owner UUID.
	*/
	OwnerUUID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the account totp delete params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *AccountTotpDeleteParams) WithDefaults() *AccountTotpDeleteParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the account totp delete params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *AccountTotpDeleteParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the account totp delete params
func (o *AccountTotpDeleteParams) WithTimeout(timeout time.Duration) *AccountTotpDeleteParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the account totp delete params
func (o *AccountTotpDeleteParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the account totp delete params
func (o *AccountTotpDeleteParams) WithContext(ctx context.Context) *AccountTotpDeleteParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the account totp delete params
func (o *AccountTotpDeleteParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the account totp delete params
func (o *AccountTotpDeleteParams) WithHTTPClient(client *http.Client) *AccountTotpDeleteParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the account totp delete params
func (o *AccountTotpDeleteParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithAccountName adds the accountName to the account totp delete params
func (o *AccountTotpDeleteParams) WithAccountName(accountName string) *AccountTotpDeleteParams {
	o.SetAccountName(accountName)
	return o
}

// SetAccountName adds the accountName to the account totp delete params
func (o *AccountTotpDeleteParams) SetAccountName(accountName string) {
	o.AccountName = accountName
}

// WithOwnerUUID adds the ownerUUID to the account totp delete params
func (o *AccountTotpDeleteParams) WithOwnerUUID(ownerUUID string) *AccountTotpDeleteParams {
	o.SetOwnerUUID(ownerUUID)
	return o
}

// SetOwnerUUID adds the ownerUuid to the account totp delete params
func (o *AccountTotpDeleteParams) SetOwnerUUID(ownerUUID string) {
	o.OwnerUUID = ownerUUID
}

// WriteToRequest writes these params to a swagger request
func (o *AccountTotpDeleteParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param account.name
	if err := r.SetPathParam("account.name", o.AccountName); err != nil {
		return err
	}

	// path param owner.uuid
	if err := r.SetPathParam("owner.uuid", o.OwnerUUID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
