// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// AntiRansomwareGetReader is a Reader for the AntiRansomwareGet structure.
type AntiRansomwareGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *AntiRansomwareGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewAntiRansomwareGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewAntiRansomwareGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewAntiRansomwareGetOK creates a AntiRansomwareGetOK with default headers values
func NewAntiRansomwareGetOK() *AntiRansomwareGetOK {
	return &AntiRansomwareGetOK{}
}

/*
AntiRansomwareGetOK describes a response with status code 200, with default header values.

OK
*/
type AntiRansomwareGetOK struct {
	Payload *models.AntiRansomware
}

// IsSuccess returns true when this anti ransomware get o k response has a 2xx status code
func (o *AntiRansomwareGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this anti ransomware get o k response has a 3xx status code
func (o *AntiRansomwareGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this anti ransomware get o k response has a 4xx status code
func (o *AntiRansomwareGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this anti ransomware get o k response has a 5xx status code
func (o *AntiRansomwareGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this anti ransomware get o k response a status code equal to that given
func (o *AntiRansomwareGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the anti ransomware get o k response
func (o *AntiRansomwareGetOK) Code() int {
	return 200
}

func (o *AntiRansomwareGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /security/anti-ransomware][%d] antiRansomwareGetOK %s", 200, payload)
}

func (o *AntiRansomwareGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /security/anti-ransomware][%d] antiRansomwareGetOK %s", 200, payload)
}

func (o *AntiRansomwareGetOK) GetPayload() *models.AntiRansomware {
	return o.Payload
}

func (o *AntiRansomwareGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.AntiRansomware)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewAntiRansomwareGetDefault creates a AntiRansomwareGetDefault with default headers values
func NewAntiRansomwareGetDefault(code int) *AntiRansomwareGetDefault {
	return &AntiRansomwareGetDefault{
		_statusCode: code,
	}
}

/*
	AntiRansomwareGetDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 917775 | Operation is not supported on offline volumes. |
| 203161606 | Failed to check the "anti-ransomware-state" of the volume. |
| 203162108 | Operation is not supported on volumes that contain LUNs or namespaces. |
| 203162109 | Operation is not supported on an anti-ransomware disable-in-progress volume. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type AntiRansomwareGetDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this anti ransomware get default response has a 2xx status code
func (o *AntiRansomwareGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this anti ransomware get default response has a 3xx status code
func (o *AntiRansomwareGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this anti ransomware get default response has a 4xx status code
func (o *AntiRansomwareGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this anti ransomware get default response has a 5xx status code
func (o *AntiRansomwareGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this anti ransomware get default response a status code equal to that given
func (o *AntiRansomwareGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the anti ransomware get default response
func (o *AntiRansomwareGetDefault) Code() int {
	return o._statusCode
}

func (o *AntiRansomwareGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /security/anti-ransomware][%d] anti_ransomware_get default %s", o._statusCode, payload)
}

func (o *AntiRansomwareGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /security/anti-ransomware][%d] anti_ransomware_get default %s", o._statusCode, payload)
}

func (o *AntiRansomwareGetDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *AntiRansomwareGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
