// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewAntiRansomwareSuspectCollectionGetParams creates a new AntiRansomwareSuspectCollectionGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewAntiRansomwareSuspectCollectionGetParams() *AntiRansomwareSuspectCollectionGetParams {
	return &AntiRansomwareSuspectCollectionGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewAntiRansomwareSuspectCollectionGetParamsWithTimeout creates a new AntiRansomwareSuspectCollectionGetParams object
// with the ability to set a timeout on a request.
func NewAntiRansomwareSuspectCollectionGetParamsWithTimeout(timeout time.Duration) *AntiRansomwareSuspectCollectionGetParams {
	return &AntiRansomwareSuspectCollectionGetParams{
		timeout: timeout,
	}
}

// NewAntiRansomwareSuspectCollectionGetParamsWithContext creates a new AntiRansomwareSuspectCollectionGetParams object
// with the ability to set a context for a request.
func NewAntiRansomwareSuspectCollectionGetParamsWithContext(ctx context.Context) *AntiRansomwareSuspectCollectionGetParams {
	return &AntiRansomwareSuspectCollectionGetParams{
		Context: ctx,
	}
}

// NewAntiRansomwareSuspectCollectionGetParamsWithHTTPClient creates a new AntiRansomwareSuspectCollectionGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewAntiRansomwareSuspectCollectionGetParamsWithHTTPClient(client *http.Client) *AntiRansomwareSuspectCollectionGetParams {
	return &AntiRansomwareSuspectCollectionGetParams{
		HTTPClient: client,
	}
}

/*
AntiRansomwareSuspectCollectionGetParams contains all the parameters to send to the API endpoint

	for the anti ransomware suspect collection get operation.

	Typically these are written to a http.Request.
*/
type AntiRansomwareSuspectCollectionGetParams struct {

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* FileFormat.

	   Filter by file.format
	*/
	FileFormat *string

	/* FileName.

	   Filter by file.name
	*/
	FileName *string

	/* FilePath.

	   Filter by file.path
	*/
	FilePath *string

	/* FileReason.

	   Filter by file.reason
	*/
	FileReason *string

	/* FileSuspectTime.

	   Filter by file.suspect_time
	*/
	FileSuspectTime *string

	/* MaxRecords.

	   Limit the number of records returned.
	*/
	MaxRecords *int64

	/* OrderBy.

	   Order results by specified fields and optional [asc|desc] direction. Default direction is 'asc' for ascending.
	*/
	OrderBy []string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* VolumeName.

	   Filter by volume.name
	*/
	VolumeName *string

	/* VolumeUUID.

	   Filter by volume.uuid
	*/
	VolumeUUID *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the anti ransomware suspect collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *AntiRansomwareSuspectCollectionGetParams) WithDefaults() *AntiRansomwareSuspectCollectionGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the anti ransomware suspect collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *AntiRansomwareSuspectCollectionGetParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)
	)

	val := AntiRansomwareSuspectCollectionGetParams{
		ReturnRecords: &returnRecordsDefault,
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the anti ransomware suspect collection get params
func (o *AntiRansomwareSuspectCollectionGetParams) WithTimeout(timeout time.Duration) *AntiRansomwareSuspectCollectionGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the anti ransomware suspect collection get params
func (o *AntiRansomwareSuspectCollectionGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the anti ransomware suspect collection get params
func (o *AntiRansomwareSuspectCollectionGetParams) WithContext(ctx context.Context) *AntiRansomwareSuspectCollectionGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the anti ransomware suspect collection get params
func (o *AntiRansomwareSuspectCollectionGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the anti ransomware suspect collection get params
func (o *AntiRansomwareSuspectCollectionGetParams) WithHTTPClient(client *http.Client) *AntiRansomwareSuspectCollectionGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the anti ransomware suspect collection get params
func (o *AntiRansomwareSuspectCollectionGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithFields adds the fields to the anti ransomware suspect collection get params
func (o *AntiRansomwareSuspectCollectionGetParams) WithFields(fields []string) *AntiRansomwareSuspectCollectionGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the anti ransomware suspect collection get params
func (o *AntiRansomwareSuspectCollectionGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithFileFormat adds the fileFormat to the anti ransomware suspect collection get params
func (o *AntiRansomwareSuspectCollectionGetParams) WithFileFormat(fileFormat *string) *AntiRansomwareSuspectCollectionGetParams {
	o.SetFileFormat(fileFormat)
	return o
}

// SetFileFormat adds the fileFormat to the anti ransomware suspect collection get params
func (o *AntiRansomwareSuspectCollectionGetParams) SetFileFormat(fileFormat *string) {
	o.FileFormat = fileFormat
}

// WithFileName adds the fileName to the anti ransomware suspect collection get params
func (o *AntiRansomwareSuspectCollectionGetParams) WithFileName(fileName *string) *AntiRansomwareSuspectCollectionGetParams {
	o.SetFileName(fileName)
	return o
}

// SetFileName adds the fileName to the anti ransomware suspect collection get params
func (o *AntiRansomwareSuspectCollectionGetParams) SetFileName(fileName *string) {
	o.FileName = fileName
}

// WithFilePath adds the filePath to the anti ransomware suspect collection get params
func (o *AntiRansomwareSuspectCollectionGetParams) WithFilePath(filePath *string) *AntiRansomwareSuspectCollectionGetParams {
	o.SetFilePath(filePath)
	return o
}

// SetFilePath adds the filePath to the anti ransomware suspect collection get params
func (o *AntiRansomwareSuspectCollectionGetParams) SetFilePath(filePath *string) {
	o.FilePath = filePath
}

// WithFileReason adds the fileReason to the anti ransomware suspect collection get params
func (o *AntiRansomwareSuspectCollectionGetParams) WithFileReason(fileReason *string) *AntiRansomwareSuspectCollectionGetParams {
	o.SetFileReason(fileReason)
	return o
}

// SetFileReason adds the fileReason to the anti ransomware suspect collection get params
func (o *AntiRansomwareSuspectCollectionGetParams) SetFileReason(fileReason *string) {
	o.FileReason = fileReason
}

// WithFileSuspectTime adds the fileSuspectTime to the anti ransomware suspect collection get params
func (o *AntiRansomwareSuspectCollectionGetParams) WithFileSuspectTime(fileSuspectTime *string) *AntiRansomwareSuspectCollectionGetParams {
	o.SetFileSuspectTime(fileSuspectTime)
	return o
}

// SetFileSuspectTime adds the fileSuspectTime to the anti ransomware suspect collection get params
func (o *AntiRansomwareSuspectCollectionGetParams) SetFileSuspectTime(fileSuspectTime *string) {
	o.FileSuspectTime = fileSuspectTime
}

// WithMaxRecords adds the maxRecords to the anti ransomware suspect collection get params
func (o *AntiRansomwareSuspectCollectionGetParams) WithMaxRecords(maxRecords *int64) *AntiRansomwareSuspectCollectionGetParams {
	o.SetMaxRecords(maxRecords)
	return o
}

// SetMaxRecords adds the maxRecords to the anti ransomware suspect collection get params
func (o *AntiRansomwareSuspectCollectionGetParams) SetMaxRecords(maxRecords *int64) {
	o.MaxRecords = maxRecords
}

// WithOrderBy adds the orderBy to the anti ransomware suspect collection get params
func (o *AntiRansomwareSuspectCollectionGetParams) WithOrderBy(orderBy []string) *AntiRansomwareSuspectCollectionGetParams {
	o.SetOrderBy(orderBy)
	return o
}

// SetOrderBy adds the orderBy to the anti ransomware suspect collection get params
func (o *AntiRansomwareSuspectCollectionGetParams) SetOrderBy(orderBy []string) {
	o.OrderBy = orderBy
}

// WithReturnRecords adds the returnRecords to the anti ransomware suspect collection get params
func (o *AntiRansomwareSuspectCollectionGetParams) WithReturnRecords(returnRecords *bool) *AntiRansomwareSuspectCollectionGetParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the anti ransomware suspect collection get params
func (o *AntiRansomwareSuspectCollectionGetParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the anti ransomware suspect collection get params
func (o *AntiRansomwareSuspectCollectionGetParams) WithReturnTimeout(returnTimeout *int64) *AntiRansomwareSuspectCollectionGetParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the anti ransomware suspect collection get params
func (o *AntiRansomwareSuspectCollectionGetParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithVolumeName adds the volumeName to the anti ransomware suspect collection get params
func (o *AntiRansomwareSuspectCollectionGetParams) WithVolumeName(volumeName *string) *AntiRansomwareSuspectCollectionGetParams {
	o.SetVolumeName(volumeName)
	return o
}

// SetVolumeName adds the volumeName to the anti ransomware suspect collection get params
func (o *AntiRansomwareSuspectCollectionGetParams) SetVolumeName(volumeName *string) {
	o.VolumeName = volumeName
}

// WithVolumeUUID adds the volumeUUID to the anti ransomware suspect collection get params
func (o *AntiRansomwareSuspectCollectionGetParams) WithVolumeUUID(volumeUUID *string) *AntiRansomwareSuspectCollectionGetParams {
	o.SetVolumeUUID(volumeUUID)
	return o
}

// SetVolumeUUID adds the volumeUuid to the anti ransomware suspect collection get params
func (o *AntiRansomwareSuspectCollectionGetParams) SetVolumeUUID(volumeUUID *string) {
	o.VolumeUUID = volumeUUID
}

// WriteToRequest writes these params to a swagger request
func (o *AntiRansomwareSuspectCollectionGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	if o.FileFormat != nil {

		// query param file.format
		var qrFileFormat string

		if o.FileFormat != nil {
			qrFileFormat = *o.FileFormat
		}
		qFileFormat := qrFileFormat
		if qFileFormat != "" {

			if err := r.SetQueryParam("file.format", qFileFormat); err != nil {
				return err
			}
		}
	}

	if o.FileName != nil {

		// query param file.name
		var qrFileName string

		if o.FileName != nil {
			qrFileName = *o.FileName
		}
		qFileName := qrFileName
		if qFileName != "" {

			if err := r.SetQueryParam("file.name", qFileName); err != nil {
				return err
			}
		}
	}

	if o.FilePath != nil {

		// query param file.path
		var qrFilePath string

		if o.FilePath != nil {
			qrFilePath = *o.FilePath
		}
		qFilePath := qrFilePath
		if qFilePath != "" {

			if err := r.SetQueryParam("file.path", qFilePath); err != nil {
				return err
			}
		}
	}

	if o.FileReason != nil {

		// query param file.reason
		var qrFileReason string

		if o.FileReason != nil {
			qrFileReason = *o.FileReason
		}
		qFileReason := qrFileReason
		if qFileReason != "" {

			if err := r.SetQueryParam("file.reason", qFileReason); err != nil {
				return err
			}
		}
	}

	if o.FileSuspectTime != nil {

		// query param file.suspect_time
		var qrFileSuspectTime string

		if o.FileSuspectTime != nil {
			qrFileSuspectTime = *o.FileSuspectTime
		}
		qFileSuspectTime := qrFileSuspectTime
		if qFileSuspectTime != "" {

			if err := r.SetQueryParam("file.suspect_time", qFileSuspectTime); err != nil {
				return err
			}
		}
	}

	if o.MaxRecords != nil {

		// query param max_records
		var qrMaxRecords int64

		if o.MaxRecords != nil {
			qrMaxRecords = *o.MaxRecords
		}
		qMaxRecords := swag.FormatInt64(qrMaxRecords)
		if qMaxRecords != "" {

			if err := r.SetQueryParam("max_records", qMaxRecords); err != nil {
				return err
			}
		}
	}

	if o.OrderBy != nil {

		// binding items for order_by
		joinedOrderBy := o.bindParamOrderBy(reg)

		// query array param order_by
		if err := r.SetQueryParam("order_by", joinedOrderBy...); err != nil {
			return err
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.VolumeName != nil {

		// query param volume.name
		var qrVolumeName string

		if o.VolumeName != nil {
			qrVolumeName = *o.VolumeName
		}
		qVolumeName := qrVolumeName
		if qVolumeName != "" {

			if err := r.SetQueryParam("volume.name", qVolumeName); err != nil {
				return err
			}
		}
	}

	if o.VolumeUUID != nil {

		// query param volume.uuid
		var qrVolumeUUID string

		if o.VolumeUUID != nil {
			qrVolumeUUID = *o.VolumeUUID
		}
		qVolumeUUID := qrVolumeUUID
		if qVolumeUUID != "" {

			if err := r.SetQueryParam("volume.uuid", qVolumeUUID); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamAntiRansomwareSuspectCollectionGet binds the parameter fields
func (o *AntiRansomwareSuspectCollectionGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}

// bindParamAntiRansomwareSuspectCollectionGet binds the parameter order_by
func (o *AntiRansomwareSuspectCollectionGetParams) bindParamOrderBy(formats strfmt.Registry) []string {
	orderByIR := o.OrderBy

	var orderByIC []string
	for _, orderByIIR := range orderByIR { // explode []string

		orderByIIV := orderByIIR // string as string
		orderByIC = append(orderByIC, orderByIIV)
	}

	// items.CollectionFormat: "csv"
	orderByIS := swag.JoinByFormat(orderByIC, "csv")

	return orderByIS
}
