// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewAntiRansomwareSuspectDeleteCollectionParams creates a new AntiRansomwareSuspectDeleteCollectionParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewAntiRansomwareSuspectDeleteCollectionParams() *AntiRansomwareSuspectDeleteCollectionParams {
	return &AntiRansomwareSuspectDeleteCollectionParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewAntiRansomwareSuspectDeleteCollectionParamsWithTimeout creates a new AntiRansomwareSuspectDeleteCollectionParams object
// with the ability to set a timeout on a request.
func NewAntiRansomwareSuspectDeleteCollectionParamsWithTimeout(timeout time.Duration) *AntiRansomwareSuspectDeleteCollectionParams {
	return &AntiRansomwareSuspectDeleteCollectionParams{
		timeout: timeout,
	}
}

// NewAntiRansomwareSuspectDeleteCollectionParamsWithContext creates a new AntiRansomwareSuspectDeleteCollectionParams object
// with the ability to set a context for a request.
func NewAntiRansomwareSuspectDeleteCollectionParamsWithContext(ctx context.Context) *AntiRansomwareSuspectDeleteCollectionParams {
	return &AntiRansomwareSuspectDeleteCollectionParams{
		Context: ctx,
	}
}

// NewAntiRansomwareSuspectDeleteCollectionParamsWithHTTPClient creates a new AntiRansomwareSuspectDeleteCollectionParams object
// with the ability to set a custom HTTPClient for a request.
func NewAntiRansomwareSuspectDeleteCollectionParamsWithHTTPClient(client *http.Client) *AntiRansomwareSuspectDeleteCollectionParams {
	return &AntiRansomwareSuspectDeleteCollectionParams{
		HTTPClient: client,
	}
}

/*
AntiRansomwareSuspectDeleteCollectionParams contains all the parameters to send to the API endpoint

	for the anti ransomware suspect delete collection operation.

	Typically these are written to a http.Request.
*/
type AntiRansomwareSuspectDeleteCollectionParams struct {

	/* ContinueOnFailure.

	   Continue even when the operation fails on one of the records.
	*/
	ContinueOnFailure *bool

	/* FileFormat.

	   Filter by file.format
	*/
	FileFormat *string

	/* FileName.

	   Filter by file.name
	*/
	FileName *string

	/* FilePath.

	   Filter by file.path
	*/
	FilePath *string

	/* FileReason.

	   Filter by file.reason
	*/
	FileReason *string

	/* FileSuspectTime.

	   Filter by file.suspect_time
	*/
	FileSuspectTime *string

	/* Info.

	   Info specification
	*/
	Info AntiRansomwareSuspectDeleteCollectionBody

	/* IsFalsePositive.

	   Specifies whether the suspected ransomware activity is a false positive or not.
	*/
	IsFalsePositive *bool

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* SerialRecords.

	   Perform the operation on the records synchronously.
	*/
	SerialRecords *bool

	/* VolumeName.

	   Filter by volume.name
	*/
	VolumeName *string

	/* VolumeUUID.

	   Filter by volume.uuid
	*/
	VolumeUUID *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the anti ransomware suspect delete collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *AntiRansomwareSuspectDeleteCollectionParams) WithDefaults() *AntiRansomwareSuspectDeleteCollectionParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the anti ransomware suspect delete collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *AntiRansomwareSuspectDeleteCollectionParams) SetDefaults() {
	var (
		continueOnFailureDefault = bool(false)

		isFalsePositiveDefault = bool(false)

		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)

		serialRecordsDefault = bool(false)
	)

	val := AntiRansomwareSuspectDeleteCollectionParams{
		ContinueOnFailure: &continueOnFailureDefault,
		IsFalsePositive:   &isFalsePositiveDefault,
		ReturnRecords:     &returnRecordsDefault,
		ReturnTimeout:     &returnTimeoutDefault,
		SerialRecords:     &serialRecordsDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the anti ransomware suspect delete collection params
func (o *AntiRansomwareSuspectDeleteCollectionParams) WithTimeout(timeout time.Duration) *AntiRansomwareSuspectDeleteCollectionParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the anti ransomware suspect delete collection params
func (o *AntiRansomwareSuspectDeleteCollectionParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the anti ransomware suspect delete collection params
func (o *AntiRansomwareSuspectDeleteCollectionParams) WithContext(ctx context.Context) *AntiRansomwareSuspectDeleteCollectionParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the anti ransomware suspect delete collection params
func (o *AntiRansomwareSuspectDeleteCollectionParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the anti ransomware suspect delete collection params
func (o *AntiRansomwareSuspectDeleteCollectionParams) WithHTTPClient(client *http.Client) *AntiRansomwareSuspectDeleteCollectionParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the anti ransomware suspect delete collection params
func (o *AntiRansomwareSuspectDeleteCollectionParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithContinueOnFailure adds the continueOnFailure to the anti ransomware suspect delete collection params
func (o *AntiRansomwareSuspectDeleteCollectionParams) WithContinueOnFailure(continueOnFailure *bool) *AntiRansomwareSuspectDeleteCollectionParams {
	o.SetContinueOnFailure(continueOnFailure)
	return o
}

// SetContinueOnFailure adds the continueOnFailure to the anti ransomware suspect delete collection params
func (o *AntiRansomwareSuspectDeleteCollectionParams) SetContinueOnFailure(continueOnFailure *bool) {
	o.ContinueOnFailure = continueOnFailure
}

// WithFileFormat adds the fileFormat to the anti ransomware suspect delete collection params
func (o *AntiRansomwareSuspectDeleteCollectionParams) WithFileFormat(fileFormat *string) *AntiRansomwareSuspectDeleteCollectionParams {
	o.SetFileFormat(fileFormat)
	return o
}

// SetFileFormat adds the fileFormat to the anti ransomware suspect delete collection params
func (o *AntiRansomwareSuspectDeleteCollectionParams) SetFileFormat(fileFormat *string) {
	o.FileFormat = fileFormat
}

// WithFileName adds the fileName to the anti ransomware suspect delete collection params
func (o *AntiRansomwareSuspectDeleteCollectionParams) WithFileName(fileName *string) *AntiRansomwareSuspectDeleteCollectionParams {
	o.SetFileName(fileName)
	return o
}

// SetFileName adds the fileName to the anti ransomware suspect delete collection params
func (o *AntiRansomwareSuspectDeleteCollectionParams) SetFileName(fileName *string) {
	o.FileName = fileName
}

// WithFilePath adds the filePath to the anti ransomware suspect delete collection params
func (o *AntiRansomwareSuspectDeleteCollectionParams) WithFilePath(filePath *string) *AntiRansomwareSuspectDeleteCollectionParams {
	o.SetFilePath(filePath)
	return o
}

// SetFilePath adds the filePath to the anti ransomware suspect delete collection params
func (o *AntiRansomwareSuspectDeleteCollectionParams) SetFilePath(filePath *string) {
	o.FilePath = filePath
}

// WithFileReason adds the fileReason to the anti ransomware suspect delete collection params
func (o *AntiRansomwareSuspectDeleteCollectionParams) WithFileReason(fileReason *string) *AntiRansomwareSuspectDeleteCollectionParams {
	o.SetFileReason(fileReason)
	return o
}

// SetFileReason adds the fileReason to the anti ransomware suspect delete collection params
func (o *AntiRansomwareSuspectDeleteCollectionParams) SetFileReason(fileReason *string) {
	o.FileReason = fileReason
}

// WithFileSuspectTime adds the fileSuspectTime to the anti ransomware suspect delete collection params
func (o *AntiRansomwareSuspectDeleteCollectionParams) WithFileSuspectTime(fileSuspectTime *string) *AntiRansomwareSuspectDeleteCollectionParams {
	o.SetFileSuspectTime(fileSuspectTime)
	return o
}

// SetFileSuspectTime adds the fileSuspectTime to the anti ransomware suspect delete collection params
func (o *AntiRansomwareSuspectDeleteCollectionParams) SetFileSuspectTime(fileSuspectTime *string) {
	o.FileSuspectTime = fileSuspectTime
}

// WithInfo adds the info to the anti ransomware suspect delete collection params
func (o *AntiRansomwareSuspectDeleteCollectionParams) WithInfo(info AntiRansomwareSuspectDeleteCollectionBody) *AntiRansomwareSuspectDeleteCollectionParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the anti ransomware suspect delete collection params
func (o *AntiRansomwareSuspectDeleteCollectionParams) SetInfo(info AntiRansomwareSuspectDeleteCollectionBody) {
	o.Info = info
}

// WithIsFalsePositive adds the isFalsePositive to the anti ransomware suspect delete collection params
func (o *AntiRansomwareSuspectDeleteCollectionParams) WithIsFalsePositive(isFalsePositive *bool) *AntiRansomwareSuspectDeleteCollectionParams {
	o.SetIsFalsePositive(isFalsePositive)
	return o
}

// SetIsFalsePositive adds the isFalsePositive to the anti ransomware suspect delete collection params
func (o *AntiRansomwareSuspectDeleteCollectionParams) SetIsFalsePositive(isFalsePositive *bool) {
	o.IsFalsePositive = isFalsePositive
}

// WithReturnRecords adds the returnRecords to the anti ransomware suspect delete collection params
func (o *AntiRansomwareSuspectDeleteCollectionParams) WithReturnRecords(returnRecords *bool) *AntiRansomwareSuspectDeleteCollectionParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the anti ransomware suspect delete collection params
func (o *AntiRansomwareSuspectDeleteCollectionParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the anti ransomware suspect delete collection params
func (o *AntiRansomwareSuspectDeleteCollectionParams) WithReturnTimeout(returnTimeout *int64) *AntiRansomwareSuspectDeleteCollectionParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the anti ransomware suspect delete collection params
func (o *AntiRansomwareSuspectDeleteCollectionParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithSerialRecords adds the serialRecords to the anti ransomware suspect delete collection params
func (o *AntiRansomwareSuspectDeleteCollectionParams) WithSerialRecords(serialRecords *bool) *AntiRansomwareSuspectDeleteCollectionParams {
	o.SetSerialRecords(serialRecords)
	return o
}

// SetSerialRecords adds the serialRecords to the anti ransomware suspect delete collection params
func (o *AntiRansomwareSuspectDeleteCollectionParams) SetSerialRecords(serialRecords *bool) {
	o.SerialRecords = serialRecords
}

// WithVolumeName adds the volumeName to the anti ransomware suspect delete collection params
func (o *AntiRansomwareSuspectDeleteCollectionParams) WithVolumeName(volumeName *string) *AntiRansomwareSuspectDeleteCollectionParams {
	o.SetVolumeName(volumeName)
	return o
}

// SetVolumeName adds the volumeName to the anti ransomware suspect delete collection params
func (o *AntiRansomwareSuspectDeleteCollectionParams) SetVolumeName(volumeName *string) {
	o.VolumeName = volumeName
}

// WithVolumeUUID adds the volumeUUID to the anti ransomware suspect delete collection params
func (o *AntiRansomwareSuspectDeleteCollectionParams) WithVolumeUUID(volumeUUID *string) *AntiRansomwareSuspectDeleteCollectionParams {
	o.SetVolumeUUID(volumeUUID)
	return o
}

// SetVolumeUUID adds the volumeUuid to the anti ransomware suspect delete collection params
func (o *AntiRansomwareSuspectDeleteCollectionParams) SetVolumeUUID(volumeUUID *string) {
	o.VolumeUUID = volumeUUID
}

// WriteToRequest writes these params to a swagger request
func (o *AntiRansomwareSuspectDeleteCollectionParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.ContinueOnFailure != nil {

		// query param continue_on_failure
		var qrContinueOnFailure bool

		if o.ContinueOnFailure != nil {
			qrContinueOnFailure = *o.ContinueOnFailure
		}
		qContinueOnFailure := swag.FormatBool(qrContinueOnFailure)
		if qContinueOnFailure != "" {

			if err := r.SetQueryParam("continue_on_failure", qContinueOnFailure); err != nil {
				return err
			}
		}
	}

	if o.FileFormat != nil {

		// query param file.format
		var qrFileFormat string

		if o.FileFormat != nil {
			qrFileFormat = *o.FileFormat
		}
		qFileFormat := qrFileFormat
		if qFileFormat != "" {

			if err := r.SetQueryParam("file.format", qFileFormat); err != nil {
				return err
			}
		}
	}

	if o.FileName != nil {

		// query param file.name
		var qrFileName string

		if o.FileName != nil {
			qrFileName = *o.FileName
		}
		qFileName := qrFileName
		if qFileName != "" {

			if err := r.SetQueryParam("file.name", qFileName); err != nil {
				return err
			}
		}
	}

	if o.FilePath != nil {

		// query param file.path
		var qrFilePath string

		if o.FilePath != nil {
			qrFilePath = *o.FilePath
		}
		qFilePath := qrFilePath
		if qFilePath != "" {

			if err := r.SetQueryParam("file.path", qFilePath); err != nil {
				return err
			}
		}
	}

	if o.FileReason != nil {

		// query param file.reason
		var qrFileReason string

		if o.FileReason != nil {
			qrFileReason = *o.FileReason
		}
		qFileReason := qrFileReason
		if qFileReason != "" {

			if err := r.SetQueryParam("file.reason", qFileReason); err != nil {
				return err
			}
		}
	}

	if o.FileSuspectTime != nil {

		// query param file.suspect_time
		var qrFileSuspectTime string

		if o.FileSuspectTime != nil {
			qrFileSuspectTime = *o.FileSuspectTime
		}
		qFileSuspectTime := qrFileSuspectTime
		if qFileSuspectTime != "" {

			if err := r.SetQueryParam("file.suspect_time", qFileSuspectTime); err != nil {
				return err
			}
		}
	}
	if err := r.SetBodyParam(o.Info); err != nil {
		return err
	}

	if o.IsFalsePositive != nil {

		// query param is_false_positive
		var qrIsFalsePositive bool

		if o.IsFalsePositive != nil {
			qrIsFalsePositive = *o.IsFalsePositive
		}
		qIsFalsePositive := swag.FormatBool(qrIsFalsePositive)
		if qIsFalsePositive != "" {

			if err := r.SetQueryParam("is_false_positive", qIsFalsePositive); err != nil {
				return err
			}
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.SerialRecords != nil {

		// query param serial_records
		var qrSerialRecords bool

		if o.SerialRecords != nil {
			qrSerialRecords = *o.SerialRecords
		}
		qSerialRecords := swag.FormatBool(qrSerialRecords)
		if qSerialRecords != "" {

			if err := r.SetQueryParam("serial_records", qSerialRecords); err != nil {
				return err
			}
		}
	}

	if o.VolumeName != nil {

		// query param volume.name
		var qrVolumeName string

		if o.VolumeName != nil {
			qrVolumeName = *o.VolumeName
		}
		qVolumeName := qrVolumeName
		if qVolumeName != "" {

			if err := r.SetQueryParam("volume.name", qVolumeName); err != nil {
				return err
			}
		}
	}

	if o.VolumeUUID != nil {

		// query param volume.uuid
		var qrVolumeUUID string

		if o.VolumeUUID != nil {
			qrVolumeUUID = *o.VolumeUUID
		}
		qVolumeUUID := qrVolumeUUID
		if qVolumeUUID != "" {

			if err := r.SetQueryParam("volume.uuid", qVolumeUUID); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
