// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewAntiRansomwareSuspectDeleteParams creates a new AntiRansomwareSuspectDeleteParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewAntiRansomwareSuspectDeleteParams() *AntiRansomwareSuspectDeleteParams {
	return &AntiRansomwareSuspectDeleteParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewAntiRansomwareSuspectDeleteParamsWithTimeout creates a new AntiRansomwareSuspectDeleteParams object
// with the ability to set a timeout on a request.
func NewAntiRansomwareSuspectDeleteParamsWithTimeout(timeout time.Duration) *AntiRansomwareSuspectDeleteParams {
	return &AntiRansomwareSuspectDeleteParams{
		timeout: timeout,
	}
}

// NewAntiRansomwareSuspectDeleteParamsWithContext creates a new AntiRansomwareSuspectDeleteParams object
// with the ability to set a context for a request.
func NewAntiRansomwareSuspectDeleteParamsWithContext(ctx context.Context) *AntiRansomwareSuspectDeleteParams {
	return &AntiRansomwareSuspectDeleteParams{
		Context: ctx,
	}
}

// NewAntiRansomwareSuspectDeleteParamsWithHTTPClient creates a new AntiRansomwareSuspectDeleteParams object
// with the ability to set a custom HTTPClient for a request.
func NewAntiRansomwareSuspectDeleteParamsWithHTTPClient(client *http.Client) *AntiRansomwareSuspectDeleteParams {
	return &AntiRansomwareSuspectDeleteParams{
		HTTPClient: client,
	}
}

/*
AntiRansomwareSuspectDeleteParams contains all the parameters to send to the API endpoint

	for the anti ransomware suspect delete operation.

	Typically these are written to a http.Request.
*/
type AntiRansomwareSuspectDeleteParams struct {

	/* FileFormat.

	   Specifies the file format of the suspect file.
	*/
	FileFormat *string

	/* IsFalsePositive.

	   Specifies whether the suspected ransomware activity is a false positive or not.
	*/
	IsFalsePositive *bool

	/* ReturnRecords.

	   The default is false.  If set to true, the records are returned.
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning. When doing a POST, PATCH, or DELETE operation on a single record, the default is 0 seconds.  This means that if an asynchronous operation is started, the server immediately returns HTTP code 202 (Accepted) along with a link to the job.  If a non-zero value is specified for POST, PATCH, or DELETE operations, ONTAP waits that length of time to see if the job completes so it can return something other than 202.
	*/
	ReturnTimeout *int64

	/* VolumeUUID.

	   Identification of the Anti-ransomware suspect file for the deletion.

	   Format: uuid
	*/
	VolumeUUID strfmt.UUID

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the anti ransomware suspect delete params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *AntiRansomwareSuspectDeleteParams) WithDefaults() *AntiRansomwareSuspectDeleteParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the anti ransomware suspect delete params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *AntiRansomwareSuspectDeleteParams) SetDefaults() {
	var (
		isFalsePositiveDefault = bool(false)

		returnRecordsDefault = bool(false)

		returnTimeoutDefault = int64(0)
	)

	val := AntiRansomwareSuspectDeleteParams{
		IsFalsePositive: &isFalsePositiveDefault,
		ReturnRecords:   &returnRecordsDefault,
		ReturnTimeout:   &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the anti ransomware suspect delete params
func (o *AntiRansomwareSuspectDeleteParams) WithTimeout(timeout time.Duration) *AntiRansomwareSuspectDeleteParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the anti ransomware suspect delete params
func (o *AntiRansomwareSuspectDeleteParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the anti ransomware suspect delete params
func (o *AntiRansomwareSuspectDeleteParams) WithContext(ctx context.Context) *AntiRansomwareSuspectDeleteParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the anti ransomware suspect delete params
func (o *AntiRansomwareSuspectDeleteParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the anti ransomware suspect delete params
func (o *AntiRansomwareSuspectDeleteParams) WithHTTPClient(client *http.Client) *AntiRansomwareSuspectDeleteParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the anti ransomware suspect delete params
func (o *AntiRansomwareSuspectDeleteParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithFileFormat adds the fileFormat to the anti ransomware suspect delete params
func (o *AntiRansomwareSuspectDeleteParams) WithFileFormat(fileFormat *string) *AntiRansomwareSuspectDeleteParams {
	o.SetFileFormat(fileFormat)
	return o
}

// SetFileFormat adds the fileFormat to the anti ransomware suspect delete params
func (o *AntiRansomwareSuspectDeleteParams) SetFileFormat(fileFormat *string) {
	o.FileFormat = fileFormat
}

// WithIsFalsePositive adds the isFalsePositive to the anti ransomware suspect delete params
func (o *AntiRansomwareSuspectDeleteParams) WithIsFalsePositive(isFalsePositive *bool) *AntiRansomwareSuspectDeleteParams {
	o.SetIsFalsePositive(isFalsePositive)
	return o
}

// SetIsFalsePositive adds the isFalsePositive to the anti ransomware suspect delete params
func (o *AntiRansomwareSuspectDeleteParams) SetIsFalsePositive(isFalsePositive *bool) {
	o.IsFalsePositive = isFalsePositive
}

// WithReturnRecords adds the returnRecords to the anti ransomware suspect delete params
func (o *AntiRansomwareSuspectDeleteParams) WithReturnRecords(returnRecords *bool) *AntiRansomwareSuspectDeleteParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the anti ransomware suspect delete params
func (o *AntiRansomwareSuspectDeleteParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the anti ransomware suspect delete params
func (o *AntiRansomwareSuspectDeleteParams) WithReturnTimeout(returnTimeout *int64) *AntiRansomwareSuspectDeleteParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the anti ransomware suspect delete params
func (o *AntiRansomwareSuspectDeleteParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithVolumeUUID adds the volumeUUID to the anti ransomware suspect delete params
func (o *AntiRansomwareSuspectDeleteParams) WithVolumeUUID(volumeUUID strfmt.UUID) *AntiRansomwareSuspectDeleteParams {
	o.SetVolumeUUID(volumeUUID)
	return o
}

// SetVolumeUUID adds the volumeUuid to the anti ransomware suspect delete params
func (o *AntiRansomwareSuspectDeleteParams) SetVolumeUUID(volumeUUID strfmt.UUID) {
	o.VolumeUUID = volumeUUID
}

// WriteToRequest writes these params to a swagger request
func (o *AntiRansomwareSuspectDeleteParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.FileFormat != nil {

		// query param file.format
		var qrFileFormat string

		if o.FileFormat != nil {
			qrFileFormat = *o.FileFormat
		}
		qFileFormat := qrFileFormat
		if qFileFormat != "" {

			if err := r.SetQueryParam("file.format", qFileFormat); err != nil {
				return err
			}
		}
	}

	if o.IsFalsePositive != nil {

		// query param is_false_positive
		var qrIsFalsePositive bool

		if o.IsFalsePositive != nil {
			qrIsFalsePositive = *o.IsFalsePositive
		}
		qIsFalsePositive := swag.FormatBool(qrIsFalsePositive)
		if qIsFalsePositive != "" {

			if err := r.SetQueryParam("is_false_positive", qIsFalsePositive); err != nil {
				return err
			}
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	// path param volume.uuid
	if err := r.SetPathParam("volume.uuid", o.VolumeUUID.String()); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
