// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewAntiRansomwareVolumeEntropyStatsCollectionGetParams creates a new AntiRansomwareVolumeEntropyStatsCollectionGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewAntiRansomwareVolumeEntropyStatsCollectionGetParams() *AntiRansomwareVolumeEntropyStatsCollectionGetParams {
	return &AntiRansomwareVolumeEntropyStatsCollectionGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewAntiRansomwareVolumeEntropyStatsCollectionGetParamsWithTimeout creates a new AntiRansomwareVolumeEntropyStatsCollectionGetParams object
// with the ability to set a timeout on a request.
func NewAntiRansomwareVolumeEntropyStatsCollectionGetParamsWithTimeout(timeout time.Duration) *AntiRansomwareVolumeEntropyStatsCollectionGetParams {
	return &AntiRansomwareVolumeEntropyStatsCollectionGetParams{
		timeout: timeout,
	}
}

// NewAntiRansomwareVolumeEntropyStatsCollectionGetParamsWithContext creates a new AntiRansomwareVolumeEntropyStatsCollectionGetParams object
// with the ability to set a context for a request.
func NewAntiRansomwareVolumeEntropyStatsCollectionGetParamsWithContext(ctx context.Context) *AntiRansomwareVolumeEntropyStatsCollectionGetParams {
	return &AntiRansomwareVolumeEntropyStatsCollectionGetParams{
		Context: ctx,
	}
}

// NewAntiRansomwareVolumeEntropyStatsCollectionGetParamsWithHTTPClient creates a new AntiRansomwareVolumeEntropyStatsCollectionGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewAntiRansomwareVolumeEntropyStatsCollectionGetParamsWithHTTPClient(client *http.Client) *AntiRansomwareVolumeEntropyStatsCollectionGetParams {
	return &AntiRansomwareVolumeEntropyStatsCollectionGetParams{
		HTTPClient: client,
	}
}

/*
AntiRansomwareVolumeEntropyStatsCollectionGetParams contains all the parameters to send to the API endpoint

	for the anti ransomware volume entropy stats collection get operation.

	Typically these are written to a http.Request.
*/
type AntiRansomwareVolumeEntropyStatsCollectionGetParams struct {

	/* DataWrittenInBytes.

	   Filter by data_written_in_bytes
	*/
	DataWrittenInBytes *int64

	/* Duration.

	   Filter by duration
	*/
	Duration *string

	/* EncryptionPercentage.

	   Filter by encryption_percentage
	*/
	EncryptionPercentage *int64

	/* EntropyStatsType.

	   Filter by entropy_stats_type
	*/
	EntropyStatsType *string

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* MaxRecords.

	   Limit the number of records returned.
	*/
	MaxRecords *int64

	/* OrderBy.

	   Order results by specified fields and optional [asc|desc] direction. Default direction is 'asc' for ascending.
	*/
	OrderBy []string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* Timestamp.

	   Filter by timestamp
	*/
	Timestamp *string

	/* VolumeName.

	   Filter by volume.name
	*/
	VolumeName *string

	/* VolumeUUID.

	   Filter by volume.uuid
	*/
	VolumeUUID *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the anti ransomware volume entropy stats collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *AntiRansomwareVolumeEntropyStatsCollectionGetParams) WithDefaults() *AntiRansomwareVolumeEntropyStatsCollectionGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the anti ransomware volume entropy stats collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *AntiRansomwareVolumeEntropyStatsCollectionGetParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)
	)

	val := AntiRansomwareVolumeEntropyStatsCollectionGetParams{
		ReturnRecords: &returnRecordsDefault,
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the anti ransomware volume entropy stats collection get params
func (o *AntiRansomwareVolumeEntropyStatsCollectionGetParams) WithTimeout(timeout time.Duration) *AntiRansomwareVolumeEntropyStatsCollectionGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the anti ransomware volume entropy stats collection get params
func (o *AntiRansomwareVolumeEntropyStatsCollectionGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the anti ransomware volume entropy stats collection get params
func (o *AntiRansomwareVolumeEntropyStatsCollectionGetParams) WithContext(ctx context.Context) *AntiRansomwareVolumeEntropyStatsCollectionGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the anti ransomware volume entropy stats collection get params
func (o *AntiRansomwareVolumeEntropyStatsCollectionGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the anti ransomware volume entropy stats collection get params
func (o *AntiRansomwareVolumeEntropyStatsCollectionGetParams) WithHTTPClient(client *http.Client) *AntiRansomwareVolumeEntropyStatsCollectionGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the anti ransomware volume entropy stats collection get params
func (o *AntiRansomwareVolumeEntropyStatsCollectionGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithDataWrittenInBytes adds the dataWrittenInBytes to the anti ransomware volume entropy stats collection get params
func (o *AntiRansomwareVolumeEntropyStatsCollectionGetParams) WithDataWrittenInBytes(dataWrittenInBytes *int64) *AntiRansomwareVolumeEntropyStatsCollectionGetParams {
	o.SetDataWrittenInBytes(dataWrittenInBytes)
	return o
}

// SetDataWrittenInBytes adds the dataWrittenInBytes to the anti ransomware volume entropy stats collection get params
func (o *AntiRansomwareVolumeEntropyStatsCollectionGetParams) SetDataWrittenInBytes(dataWrittenInBytes *int64) {
	o.DataWrittenInBytes = dataWrittenInBytes
}

// WithDuration adds the duration to the anti ransomware volume entropy stats collection get params
func (o *AntiRansomwareVolumeEntropyStatsCollectionGetParams) WithDuration(duration *string) *AntiRansomwareVolumeEntropyStatsCollectionGetParams {
	o.SetDuration(duration)
	return o
}

// SetDuration adds the duration to the anti ransomware volume entropy stats collection get params
func (o *AntiRansomwareVolumeEntropyStatsCollectionGetParams) SetDuration(duration *string) {
	o.Duration = duration
}

// WithEncryptionPercentage adds the encryptionPercentage to the anti ransomware volume entropy stats collection get params
func (o *AntiRansomwareVolumeEntropyStatsCollectionGetParams) WithEncryptionPercentage(encryptionPercentage *int64) *AntiRansomwareVolumeEntropyStatsCollectionGetParams {
	o.SetEncryptionPercentage(encryptionPercentage)
	return o
}

// SetEncryptionPercentage adds the encryptionPercentage to the anti ransomware volume entropy stats collection get params
func (o *AntiRansomwareVolumeEntropyStatsCollectionGetParams) SetEncryptionPercentage(encryptionPercentage *int64) {
	o.EncryptionPercentage = encryptionPercentage
}

// WithEntropyStatsType adds the entropyStatsType to the anti ransomware volume entropy stats collection get params
func (o *AntiRansomwareVolumeEntropyStatsCollectionGetParams) WithEntropyStatsType(entropyStatsType *string) *AntiRansomwareVolumeEntropyStatsCollectionGetParams {
	o.SetEntropyStatsType(entropyStatsType)
	return o
}

// SetEntropyStatsType adds the entropyStatsType to the anti ransomware volume entropy stats collection get params
func (o *AntiRansomwareVolumeEntropyStatsCollectionGetParams) SetEntropyStatsType(entropyStatsType *string) {
	o.EntropyStatsType = entropyStatsType
}

// WithFields adds the fields to the anti ransomware volume entropy stats collection get params
func (o *AntiRansomwareVolumeEntropyStatsCollectionGetParams) WithFields(fields []string) *AntiRansomwareVolumeEntropyStatsCollectionGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the anti ransomware volume entropy stats collection get params
func (o *AntiRansomwareVolumeEntropyStatsCollectionGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithMaxRecords adds the maxRecords to the anti ransomware volume entropy stats collection get params
func (o *AntiRansomwareVolumeEntropyStatsCollectionGetParams) WithMaxRecords(maxRecords *int64) *AntiRansomwareVolumeEntropyStatsCollectionGetParams {
	o.SetMaxRecords(maxRecords)
	return o
}

// SetMaxRecords adds the maxRecords to the anti ransomware volume entropy stats collection get params
func (o *AntiRansomwareVolumeEntropyStatsCollectionGetParams) SetMaxRecords(maxRecords *int64) {
	o.MaxRecords = maxRecords
}

// WithOrderBy adds the orderBy to the anti ransomware volume entropy stats collection get params
func (o *AntiRansomwareVolumeEntropyStatsCollectionGetParams) WithOrderBy(orderBy []string) *AntiRansomwareVolumeEntropyStatsCollectionGetParams {
	o.SetOrderBy(orderBy)
	return o
}

// SetOrderBy adds the orderBy to the anti ransomware volume entropy stats collection get params
func (o *AntiRansomwareVolumeEntropyStatsCollectionGetParams) SetOrderBy(orderBy []string) {
	o.OrderBy = orderBy
}

// WithReturnRecords adds the returnRecords to the anti ransomware volume entropy stats collection get params
func (o *AntiRansomwareVolumeEntropyStatsCollectionGetParams) WithReturnRecords(returnRecords *bool) *AntiRansomwareVolumeEntropyStatsCollectionGetParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the anti ransomware volume entropy stats collection get params
func (o *AntiRansomwareVolumeEntropyStatsCollectionGetParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the anti ransomware volume entropy stats collection get params
func (o *AntiRansomwareVolumeEntropyStatsCollectionGetParams) WithReturnTimeout(returnTimeout *int64) *AntiRansomwareVolumeEntropyStatsCollectionGetParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the anti ransomware volume entropy stats collection get params
func (o *AntiRansomwareVolumeEntropyStatsCollectionGetParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithTimestamp adds the timestamp to the anti ransomware volume entropy stats collection get params
func (o *AntiRansomwareVolumeEntropyStatsCollectionGetParams) WithTimestamp(timestamp *string) *AntiRansomwareVolumeEntropyStatsCollectionGetParams {
	o.SetTimestamp(timestamp)
	return o
}

// SetTimestamp adds the timestamp to the anti ransomware volume entropy stats collection get params
func (o *AntiRansomwareVolumeEntropyStatsCollectionGetParams) SetTimestamp(timestamp *string) {
	o.Timestamp = timestamp
}

// WithVolumeName adds the volumeName to the anti ransomware volume entropy stats collection get params
func (o *AntiRansomwareVolumeEntropyStatsCollectionGetParams) WithVolumeName(volumeName *string) *AntiRansomwareVolumeEntropyStatsCollectionGetParams {
	o.SetVolumeName(volumeName)
	return o
}

// SetVolumeName adds the volumeName to the anti ransomware volume entropy stats collection get params
func (o *AntiRansomwareVolumeEntropyStatsCollectionGetParams) SetVolumeName(volumeName *string) {
	o.VolumeName = volumeName
}

// WithVolumeUUID adds the volumeUUID to the anti ransomware volume entropy stats collection get params
func (o *AntiRansomwareVolumeEntropyStatsCollectionGetParams) WithVolumeUUID(volumeUUID *string) *AntiRansomwareVolumeEntropyStatsCollectionGetParams {
	o.SetVolumeUUID(volumeUUID)
	return o
}

// SetVolumeUUID adds the volumeUuid to the anti ransomware volume entropy stats collection get params
func (o *AntiRansomwareVolumeEntropyStatsCollectionGetParams) SetVolumeUUID(volumeUUID *string) {
	o.VolumeUUID = volumeUUID
}

// WriteToRequest writes these params to a swagger request
func (o *AntiRansomwareVolumeEntropyStatsCollectionGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.DataWrittenInBytes != nil {

		// query param data_written_in_bytes
		var qrDataWrittenInBytes int64

		if o.DataWrittenInBytes != nil {
			qrDataWrittenInBytes = *o.DataWrittenInBytes
		}
		qDataWrittenInBytes := swag.FormatInt64(qrDataWrittenInBytes)
		if qDataWrittenInBytes != "" {

			if err := r.SetQueryParam("data_written_in_bytes", qDataWrittenInBytes); err != nil {
				return err
			}
		}
	}

	if o.Duration != nil {

		// query param duration
		var qrDuration string

		if o.Duration != nil {
			qrDuration = *o.Duration
		}
		qDuration := qrDuration
		if qDuration != "" {

			if err := r.SetQueryParam("duration", qDuration); err != nil {
				return err
			}
		}
	}

	if o.EncryptionPercentage != nil {

		// query param encryption_percentage
		var qrEncryptionPercentage int64

		if o.EncryptionPercentage != nil {
			qrEncryptionPercentage = *o.EncryptionPercentage
		}
		qEncryptionPercentage := swag.FormatInt64(qrEncryptionPercentage)
		if qEncryptionPercentage != "" {

			if err := r.SetQueryParam("encryption_percentage", qEncryptionPercentage); err != nil {
				return err
			}
		}
	}

	if o.EntropyStatsType != nil {

		// query param entropy_stats_type
		var qrEntropyStatsType string

		if o.EntropyStatsType != nil {
			qrEntropyStatsType = *o.EntropyStatsType
		}
		qEntropyStatsType := qrEntropyStatsType
		if qEntropyStatsType != "" {

			if err := r.SetQueryParam("entropy_stats_type", qEntropyStatsType); err != nil {
				return err
			}
		}
	}

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	if o.MaxRecords != nil {

		// query param max_records
		var qrMaxRecords int64

		if o.MaxRecords != nil {
			qrMaxRecords = *o.MaxRecords
		}
		qMaxRecords := swag.FormatInt64(qrMaxRecords)
		if qMaxRecords != "" {

			if err := r.SetQueryParam("max_records", qMaxRecords); err != nil {
				return err
			}
		}
	}

	if o.OrderBy != nil {

		// binding items for order_by
		joinedOrderBy := o.bindParamOrderBy(reg)

		// query array param order_by
		if err := r.SetQueryParam("order_by", joinedOrderBy...); err != nil {
			return err
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.Timestamp != nil {

		// query param timestamp
		var qrTimestamp string

		if o.Timestamp != nil {
			qrTimestamp = *o.Timestamp
		}
		qTimestamp := qrTimestamp
		if qTimestamp != "" {

			if err := r.SetQueryParam("timestamp", qTimestamp); err != nil {
				return err
			}
		}
	}

	if o.VolumeName != nil {

		// query param volume.name
		var qrVolumeName string

		if o.VolumeName != nil {
			qrVolumeName = *o.VolumeName
		}
		qVolumeName := qrVolumeName
		if qVolumeName != "" {

			if err := r.SetQueryParam("volume.name", qVolumeName); err != nil {
				return err
			}
		}
	}

	if o.VolumeUUID != nil {

		// query param volume.uuid
		var qrVolumeUUID string

		if o.VolumeUUID != nil {
			qrVolumeUUID = *o.VolumeUUID
		}
		qVolumeUUID := qrVolumeUUID
		if qVolumeUUID != "" {

			if err := r.SetQueryParam("volume.uuid", qVolumeUUID); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamAntiRansomwareVolumeEntropyStatsCollectionGet binds the parameter fields
func (o *AntiRansomwareVolumeEntropyStatsCollectionGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}

// bindParamAntiRansomwareVolumeEntropyStatsCollectionGet binds the parameter order_by
func (o *AntiRansomwareVolumeEntropyStatsCollectionGetParams) bindParamOrderBy(formats strfmt.Registry) []string {
	orderByIR := o.OrderBy

	var orderByIC []string
	for _, orderByIIR := range orderByIR { // explode []string

		orderByIIV := orderByIIR // string as string
		orderByIC = append(orderByIC, orderByIIV)
	}

	// items.CollectionFormat: "csv"
	orderByIS := swag.JoinByFormat(orderByIC, "csv")

	return orderByIS
}
