// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewAntiRansomwareVolumeEntropyStatsGetParams creates a new AntiRansomwareVolumeEntropyStatsGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewAntiRansomwareVolumeEntropyStatsGetParams() *AntiRansomwareVolumeEntropyStatsGetParams {
	return &AntiRansomwareVolumeEntropyStatsGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewAntiRansomwareVolumeEntropyStatsGetParamsWithTimeout creates a new AntiRansomwareVolumeEntropyStatsGetParams object
// with the ability to set a timeout on a request.
func NewAntiRansomwareVolumeEntropyStatsGetParamsWithTimeout(timeout time.Duration) *AntiRansomwareVolumeEntropyStatsGetParams {
	return &AntiRansomwareVolumeEntropyStatsGetParams{
		timeout: timeout,
	}
}

// NewAntiRansomwareVolumeEntropyStatsGetParamsWithContext creates a new AntiRansomwareVolumeEntropyStatsGetParams object
// with the ability to set a context for a request.
func NewAntiRansomwareVolumeEntropyStatsGetParamsWithContext(ctx context.Context) *AntiRansomwareVolumeEntropyStatsGetParams {
	return &AntiRansomwareVolumeEntropyStatsGetParams{
		Context: ctx,
	}
}

// NewAntiRansomwareVolumeEntropyStatsGetParamsWithHTTPClient creates a new AntiRansomwareVolumeEntropyStatsGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewAntiRansomwareVolumeEntropyStatsGetParamsWithHTTPClient(client *http.Client) *AntiRansomwareVolumeEntropyStatsGetParams {
	return &AntiRansomwareVolumeEntropyStatsGetParams{
		HTTPClient: client,
	}
}

/*
AntiRansomwareVolumeEntropyStatsGetParams contains all the parameters to send to the API endpoint

	for the anti ransomware volume entropy stats get operation.

	Typically these are written to a http.Request.
*/
type AntiRansomwareVolumeEntropyStatsGetParams struct {

	/* EntropyStatsType.

	   The type of entropy statistics.
	*/
	EntropyStatsType string

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* Timestamp.

	   The timestamp of the statistics.

	   Format: date-time
	*/
	Timestamp strfmt.DateTime

	/* VolumeUUID.

	   The UUID of the volume.
	*/
	VolumeUUID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the anti ransomware volume entropy stats get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *AntiRansomwareVolumeEntropyStatsGetParams) WithDefaults() *AntiRansomwareVolumeEntropyStatsGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the anti ransomware volume entropy stats get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *AntiRansomwareVolumeEntropyStatsGetParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the anti ransomware volume entropy stats get params
func (o *AntiRansomwareVolumeEntropyStatsGetParams) WithTimeout(timeout time.Duration) *AntiRansomwareVolumeEntropyStatsGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the anti ransomware volume entropy stats get params
func (o *AntiRansomwareVolumeEntropyStatsGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the anti ransomware volume entropy stats get params
func (o *AntiRansomwareVolumeEntropyStatsGetParams) WithContext(ctx context.Context) *AntiRansomwareVolumeEntropyStatsGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the anti ransomware volume entropy stats get params
func (o *AntiRansomwareVolumeEntropyStatsGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the anti ransomware volume entropy stats get params
func (o *AntiRansomwareVolumeEntropyStatsGetParams) WithHTTPClient(client *http.Client) *AntiRansomwareVolumeEntropyStatsGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the anti ransomware volume entropy stats get params
func (o *AntiRansomwareVolumeEntropyStatsGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithEntropyStatsType adds the entropyStatsType to the anti ransomware volume entropy stats get params
func (o *AntiRansomwareVolumeEntropyStatsGetParams) WithEntropyStatsType(entropyStatsType string) *AntiRansomwareVolumeEntropyStatsGetParams {
	o.SetEntropyStatsType(entropyStatsType)
	return o
}

// SetEntropyStatsType adds the entropyStatsType to the anti ransomware volume entropy stats get params
func (o *AntiRansomwareVolumeEntropyStatsGetParams) SetEntropyStatsType(entropyStatsType string) {
	o.EntropyStatsType = entropyStatsType
}

// WithFields adds the fields to the anti ransomware volume entropy stats get params
func (o *AntiRansomwareVolumeEntropyStatsGetParams) WithFields(fields []string) *AntiRansomwareVolumeEntropyStatsGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the anti ransomware volume entropy stats get params
func (o *AntiRansomwareVolumeEntropyStatsGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithTimestamp adds the timestamp to the anti ransomware volume entropy stats get params
func (o *AntiRansomwareVolumeEntropyStatsGetParams) WithTimestamp(timestamp strfmt.DateTime) *AntiRansomwareVolumeEntropyStatsGetParams {
	o.SetTimestamp(timestamp)
	return o
}

// SetTimestamp adds the timestamp to the anti ransomware volume entropy stats get params
func (o *AntiRansomwareVolumeEntropyStatsGetParams) SetTimestamp(timestamp strfmt.DateTime) {
	o.Timestamp = timestamp
}

// WithVolumeUUID adds the volumeUUID to the anti ransomware volume entropy stats get params
func (o *AntiRansomwareVolumeEntropyStatsGetParams) WithVolumeUUID(volumeUUID string) *AntiRansomwareVolumeEntropyStatsGetParams {
	o.SetVolumeUUID(volumeUUID)
	return o
}

// SetVolumeUUID adds the volumeUuid to the anti ransomware volume entropy stats get params
func (o *AntiRansomwareVolumeEntropyStatsGetParams) SetVolumeUUID(volumeUUID string) {
	o.VolumeUUID = volumeUUID
}

// WriteToRequest writes these params to a swagger request
func (o *AntiRansomwareVolumeEntropyStatsGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param entropy_stats_type
	if err := r.SetPathParam("entropy_stats_type", o.EntropyStatsType); err != nil {
		return err
	}

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	// path param timestamp
	if err := r.SetPathParam("timestamp", o.Timestamp.String()); err != nil {
		return err
	}

	// path param volume.uuid
	if err := r.SetPathParam("volume.uuid", o.VolumeUUID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamAntiRansomwareVolumeEntropyStatsGet binds the parameter fields
func (o *AntiRansomwareVolumeEntropyStatsGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}
