// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewAuditLogForwardingGetParams creates a new AuditLogForwardingGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewAuditLogForwardingGetParams() *AuditLogForwardingGetParams {
	return &AuditLogForwardingGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewAuditLogForwardingGetParamsWithTimeout creates a new AuditLogForwardingGetParams object
// with the ability to set a timeout on a request.
func NewAuditLogForwardingGetParamsWithTimeout(timeout time.Duration) *AuditLogForwardingGetParams {
	return &AuditLogForwardingGetParams{
		timeout: timeout,
	}
}

// NewAuditLogForwardingGetParamsWithContext creates a new AuditLogForwardingGetParams object
// with the ability to set a context for a request.
func NewAuditLogForwardingGetParamsWithContext(ctx context.Context) *AuditLogForwardingGetParams {
	return &AuditLogForwardingGetParams{
		Context: ctx,
	}
}

// NewAuditLogForwardingGetParamsWithHTTPClient creates a new AuditLogForwardingGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewAuditLogForwardingGetParamsWithHTTPClient(client *http.Client) *AuditLogForwardingGetParams {
	return &AuditLogForwardingGetParams{
		HTTPClient: client,
	}
}

/*
AuditLogForwardingGetParams contains all the parameters to send to the API endpoint

	for the audit log forwarding get operation.

	Typically these are written to a http.Request.
*/
type AuditLogForwardingGetParams struct {

	/* Address.

	   Filter by address
	*/
	Address *string

	/* Facility.

	   Filter by facility
	*/
	Facility *string

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* HostnameFormatOverride.

	   Filter by hostname_format_override
	*/
	HostnameFormatOverride *string

	/* IpspaceName.

	   Filter by ipspace.name
	*/
	IpspaceName *string

	/* IpspaceUUID.

	   Filter by ipspace.uuid
	*/
	IpspaceUUID *string

	/* MaxRecords.

	   Limit the number of records returned.
	*/
	MaxRecords *int64

	/* MessageFormat.

	   Filter by message_format
	*/
	MessageFormat *string

	/* OrderBy.

	   Order results by specified fields and optional [asc|desc] direction. Default direction is 'asc' for ascending.
	*/
	OrderBy []string

	/* Port.

	   Filter by port
	*/
	Port *int64

	/* Protocol.

	   Filter by protocol
	*/
	Protocol *string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* TimestampFormatOverride.

	   Filter by timestamp_format_override
	*/
	TimestampFormatOverride *string

	/* VerifyServer.

	   Filter by verify_server
	*/
	VerifyServer *bool

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the audit log forwarding get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *AuditLogForwardingGetParams) WithDefaults() *AuditLogForwardingGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the audit log forwarding get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *AuditLogForwardingGetParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)
	)

	val := AuditLogForwardingGetParams{
		ReturnRecords: &returnRecordsDefault,
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the audit log forwarding get params
func (o *AuditLogForwardingGetParams) WithTimeout(timeout time.Duration) *AuditLogForwardingGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the audit log forwarding get params
func (o *AuditLogForwardingGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the audit log forwarding get params
func (o *AuditLogForwardingGetParams) WithContext(ctx context.Context) *AuditLogForwardingGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the audit log forwarding get params
func (o *AuditLogForwardingGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the audit log forwarding get params
func (o *AuditLogForwardingGetParams) WithHTTPClient(client *http.Client) *AuditLogForwardingGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the audit log forwarding get params
func (o *AuditLogForwardingGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithAddress adds the address to the audit log forwarding get params
func (o *AuditLogForwardingGetParams) WithAddress(address *string) *AuditLogForwardingGetParams {
	o.SetAddress(address)
	return o
}

// SetAddress adds the address to the audit log forwarding get params
func (o *AuditLogForwardingGetParams) SetAddress(address *string) {
	o.Address = address
}

// WithFacility adds the facility to the audit log forwarding get params
func (o *AuditLogForwardingGetParams) WithFacility(facility *string) *AuditLogForwardingGetParams {
	o.SetFacility(facility)
	return o
}

// SetFacility adds the facility to the audit log forwarding get params
func (o *AuditLogForwardingGetParams) SetFacility(facility *string) {
	o.Facility = facility
}

// WithFields adds the fields to the audit log forwarding get params
func (o *AuditLogForwardingGetParams) WithFields(fields []string) *AuditLogForwardingGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the audit log forwarding get params
func (o *AuditLogForwardingGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithHostnameFormatOverride adds the hostnameFormatOverride to the audit log forwarding get params
func (o *AuditLogForwardingGetParams) WithHostnameFormatOverride(hostnameFormatOverride *string) *AuditLogForwardingGetParams {
	o.SetHostnameFormatOverride(hostnameFormatOverride)
	return o
}

// SetHostnameFormatOverride adds the hostnameFormatOverride to the audit log forwarding get params
func (o *AuditLogForwardingGetParams) SetHostnameFormatOverride(hostnameFormatOverride *string) {
	o.HostnameFormatOverride = hostnameFormatOverride
}

// WithIpspaceName adds the ipspaceName to the audit log forwarding get params
func (o *AuditLogForwardingGetParams) WithIpspaceName(ipspaceName *string) *AuditLogForwardingGetParams {
	o.SetIpspaceName(ipspaceName)
	return o
}

// SetIpspaceName adds the ipspaceName to the audit log forwarding get params
func (o *AuditLogForwardingGetParams) SetIpspaceName(ipspaceName *string) {
	o.IpspaceName = ipspaceName
}

// WithIpspaceUUID adds the ipspaceUUID to the audit log forwarding get params
func (o *AuditLogForwardingGetParams) WithIpspaceUUID(ipspaceUUID *string) *AuditLogForwardingGetParams {
	o.SetIpspaceUUID(ipspaceUUID)
	return o
}

// SetIpspaceUUID adds the ipspaceUuid to the audit log forwarding get params
func (o *AuditLogForwardingGetParams) SetIpspaceUUID(ipspaceUUID *string) {
	o.IpspaceUUID = ipspaceUUID
}

// WithMaxRecords adds the maxRecords to the audit log forwarding get params
func (o *AuditLogForwardingGetParams) WithMaxRecords(maxRecords *int64) *AuditLogForwardingGetParams {
	o.SetMaxRecords(maxRecords)
	return o
}

// SetMaxRecords adds the maxRecords to the audit log forwarding get params
func (o *AuditLogForwardingGetParams) SetMaxRecords(maxRecords *int64) {
	o.MaxRecords = maxRecords
}

// WithMessageFormat adds the messageFormat to the audit log forwarding get params
func (o *AuditLogForwardingGetParams) WithMessageFormat(messageFormat *string) *AuditLogForwardingGetParams {
	o.SetMessageFormat(messageFormat)
	return o
}

// SetMessageFormat adds the messageFormat to the audit log forwarding get params
func (o *AuditLogForwardingGetParams) SetMessageFormat(messageFormat *string) {
	o.MessageFormat = messageFormat
}

// WithOrderBy adds the orderBy to the audit log forwarding get params
func (o *AuditLogForwardingGetParams) WithOrderBy(orderBy []string) *AuditLogForwardingGetParams {
	o.SetOrderBy(orderBy)
	return o
}

// SetOrderBy adds the orderBy to the audit log forwarding get params
func (o *AuditLogForwardingGetParams) SetOrderBy(orderBy []string) {
	o.OrderBy = orderBy
}

// WithPort adds the port to the audit log forwarding get params
func (o *AuditLogForwardingGetParams) WithPort(port *int64) *AuditLogForwardingGetParams {
	o.SetPort(port)
	return o
}

// SetPort adds the port to the audit log forwarding get params
func (o *AuditLogForwardingGetParams) SetPort(port *int64) {
	o.Port = port
}

// WithProtocol adds the protocol to the audit log forwarding get params
func (o *AuditLogForwardingGetParams) WithProtocol(protocol *string) *AuditLogForwardingGetParams {
	o.SetProtocol(protocol)
	return o
}

// SetProtocol adds the protocol to the audit log forwarding get params
func (o *AuditLogForwardingGetParams) SetProtocol(protocol *string) {
	o.Protocol = protocol
}

// WithReturnRecords adds the returnRecords to the audit log forwarding get params
func (o *AuditLogForwardingGetParams) WithReturnRecords(returnRecords *bool) *AuditLogForwardingGetParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the audit log forwarding get params
func (o *AuditLogForwardingGetParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the audit log forwarding get params
func (o *AuditLogForwardingGetParams) WithReturnTimeout(returnTimeout *int64) *AuditLogForwardingGetParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the audit log forwarding get params
func (o *AuditLogForwardingGetParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithTimestampFormatOverride adds the timestampFormatOverride to the audit log forwarding get params
func (o *AuditLogForwardingGetParams) WithTimestampFormatOverride(timestampFormatOverride *string) *AuditLogForwardingGetParams {
	o.SetTimestampFormatOverride(timestampFormatOverride)
	return o
}

// SetTimestampFormatOverride adds the timestampFormatOverride to the audit log forwarding get params
func (o *AuditLogForwardingGetParams) SetTimestampFormatOverride(timestampFormatOverride *string) {
	o.TimestampFormatOverride = timestampFormatOverride
}

// WithVerifyServer adds the verifyServer to the audit log forwarding get params
func (o *AuditLogForwardingGetParams) WithVerifyServer(verifyServer *bool) *AuditLogForwardingGetParams {
	o.SetVerifyServer(verifyServer)
	return o
}

// SetVerifyServer adds the verifyServer to the audit log forwarding get params
func (o *AuditLogForwardingGetParams) SetVerifyServer(verifyServer *bool) {
	o.VerifyServer = verifyServer
}

// WriteToRequest writes these params to a swagger request
func (o *AuditLogForwardingGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Address != nil {

		// query param address
		var qrAddress string

		if o.Address != nil {
			qrAddress = *o.Address
		}
		qAddress := qrAddress
		if qAddress != "" {

			if err := r.SetQueryParam("address", qAddress); err != nil {
				return err
			}
		}
	}

	if o.Facility != nil {

		// query param facility
		var qrFacility string

		if o.Facility != nil {
			qrFacility = *o.Facility
		}
		qFacility := qrFacility
		if qFacility != "" {

			if err := r.SetQueryParam("facility", qFacility); err != nil {
				return err
			}
		}
	}

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	if o.HostnameFormatOverride != nil {

		// query param hostname_format_override
		var qrHostnameFormatOverride string

		if o.HostnameFormatOverride != nil {
			qrHostnameFormatOverride = *o.HostnameFormatOverride
		}
		qHostnameFormatOverride := qrHostnameFormatOverride
		if qHostnameFormatOverride != "" {

			if err := r.SetQueryParam("hostname_format_override", qHostnameFormatOverride); err != nil {
				return err
			}
		}
	}

	if o.IpspaceName != nil {

		// query param ipspace.name
		var qrIpspaceName string

		if o.IpspaceName != nil {
			qrIpspaceName = *o.IpspaceName
		}
		qIpspaceName := qrIpspaceName
		if qIpspaceName != "" {

			if err := r.SetQueryParam("ipspace.name", qIpspaceName); err != nil {
				return err
			}
		}
	}

	if o.IpspaceUUID != nil {

		// query param ipspace.uuid
		var qrIpspaceUUID string

		if o.IpspaceUUID != nil {
			qrIpspaceUUID = *o.IpspaceUUID
		}
		qIpspaceUUID := qrIpspaceUUID
		if qIpspaceUUID != "" {

			if err := r.SetQueryParam("ipspace.uuid", qIpspaceUUID); err != nil {
				return err
			}
		}
	}

	if o.MaxRecords != nil {

		// query param max_records
		var qrMaxRecords int64

		if o.MaxRecords != nil {
			qrMaxRecords = *o.MaxRecords
		}
		qMaxRecords := swag.FormatInt64(qrMaxRecords)
		if qMaxRecords != "" {

			if err := r.SetQueryParam("max_records", qMaxRecords); err != nil {
				return err
			}
		}
	}

	if o.MessageFormat != nil {

		// query param message_format
		var qrMessageFormat string

		if o.MessageFormat != nil {
			qrMessageFormat = *o.MessageFormat
		}
		qMessageFormat := qrMessageFormat
		if qMessageFormat != "" {

			if err := r.SetQueryParam("message_format", qMessageFormat); err != nil {
				return err
			}
		}
	}

	if o.OrderBy != nil {

		// binding items for order_by
		joinedOrderBy := o.bindParamOrderBy(reg)

		// query array param order_by
		if err := r.SetQueryParam("order_by", joinedOrderBy...); err != nil {
			return err
		}
	}

	if o.Port != nil {

		// query param port
		var qrPort int64

		if o.Port != nil {
			qrPort = *o.Port
		}
		qPort := swag.FormatInt64(qrPort)
		if qPort != "" {

			if err := r.SetQueryParam("port", qPort); err != nil {
				return err
			}
		}
	}

	if o.Protocol != nil {

		// query param protocol
		var qrProtocol string

		if o.Protocol != nil {
			qrProtocol = *o.Protocol
		}
		qProtocol := qrProtocol
		if qProtocol != "" {

			if err := r.SetQueryParam("protocol", qProtocol); err != nil {
				return err
			}
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.TimestampFormatOverride != nil {

		// query param timestamp_format_override
		var qrTimestampFormatOverride string

		if o.TimestampFormatOverride != nil {
			qrTimestampFormatOverride = *o.TimestampFormatOverride
		}
		qTimestampFormatOverride := qrTimestampFormatOverride
		if qTimestampFormatOverride != "" {

			if err := r.SetQueryParam("timestamp_format_override", qTimestampFormatOverride); err != nil {
				return err
			}
		}
	}

	if o.VerifyServer != nil {

		// query param verify_server
		var qrVerifyServer bool

		if o.VerifyServer != nil {
			qrVerifyServer = *o.VerifyServer
		}
		qVerifyServer := swag.FormatBool(qrVerifyServer)
		if qVerifyServer != "" {

			if err := r.SetQueryParam("verify_server", qVerifyServer); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamAuditLogForwardingGet binds the parameter fields
func (o *AuditLogForwardingGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}

// bindParamAuditLogForwardingGet binds the parameter order_by
func (o *AuditLogForwardingGetParams) bindParamOrderBy(formats strfmt.Registry) []string {
	orderByIR := o.OrderBy

	var orderByIC []string
	for _, orderByIIR := range orderByIR { // explode []string

		orderByIIV := orderByIIR // string as string
		orderByIC = append(orderByIC, orderByIIV)
	}

	// items.CollectionFormat: "csv"
	orderByIS := swag.JoinByFormat(orderByIC, "csv")

	return orderByIS
}
