// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// AuditLogForwardingGetReader is a Reader for the AuditLogForwardingGet structure.
type AuditLogForwardingGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *AuditLogForwardingGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewAuditLogForwardingGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewAuditLogForwardingGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewAuditLogForwardingGetOK creates a AuditLogForwardingGetOK with default headers values
func NewAuditLogForwardingGetOK() *AuditLogForwardingGetOK {
	return &AuditLogForwardingGetOK{}
}

/*
AuditLogForwardingGetOK describes a response with status code 200, with default header values.

OK
*/
type AuditLogForwardingGetOK struct {
	Payload *models.SecurityAuditLogForwardResponse
}

// IsSuccess returns true when this audit log forwarding get o k response has a 2xx status code
func (o *AuditLogForwardingGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this audit log forwarding get o k response has a 3xx status code
func (o *AuditLogForwardingGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this audit log forwarding get o k response has a 4xx status code
func (o *AuditLogForwardingGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this audit log forwarding get o k response has a 5xx status code
func (o *AuditLogForwardingGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this audit log forwarding get o k response a status code equal to that given
func (o *AuditLogForwardingGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the audit log forwarding get o k response
func (o *AuditLogForwardingGetOK) Code() int {
	return 200
}

func (o *AuditLogForwardingGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /security/audit/destinations][%d] auditLogForwardingGetOK %s", 200, payload)
}

func (o *AuditLogForwardingGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /security/audit/destinations][%d] auditLogForwardingGetOK %s", 200, payload)
}

func (o *AuditLogForwardingGetOK) GetPayload() *models.SecurityAuditLogForwardResponse {
	return o.Payload
}

func (o *AuditLogForwardingGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.SecurityAuditLogForwardResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewAuditLogForwardingGetDefault creates a AuditLogForwardingGetDefault with default headers values
func NewAuditLogForwardingGetDefault(code int) *AuditLogForwardingGetDefault {
	return &AuditLogForwardingGetDefault{
		_statusCode: code,
	}
}

/*
AuditLogForwardingGetDefault describes a response with status code -1, with default header values.

error
*/
type AuditLogForwardingGetDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this audit log forwarding get default response has a 2xx status code
func (o *AuditLogForwardingGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this audit log forwarding get default response has a 3xx status code
func (o *AuditLogForwardingGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this audit log forwarding get default response has a 4xx status code
func (o *AuditLogForwardingGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this audit log forwarding get default response has a 5xx status code
func (o *AuditLogForwardingGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this audit log forwarding get default response a status code equal to that given
func (o *AuditLogForwardingGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the audit log forwarding get default response
func (o *AuditLogForwardingGetDefault) Code() int {
	return o._statusCode
}

func (o *AuditLogForwardingGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /security/audit/destinations][%d] audit_log_forwarding_get default %s", o._statusCode, payload)
}

func (o *AuditLogForwardingGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /security/audit/destinations][%d] audit_log_forwarding_get default %s", o._statusCode, payload)
}

func (o *AuditLogForwardingGetDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *AuditLogForwardingGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
