// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// AwsKmsDeleteCollectionReader is a Reader for the AwsKmsDeleteCollection structure.
type AwsKmsDeleteCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *AwsKmsDeleteCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewAwsKmsDeleteCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 202:
		result := NewAwsKmsDeleteCollectionAccepted()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewAwsKmsDeleteCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewAwsKmsDeleteCollectionOK creates a AwsKmsDeleteCollectionOK with default headers values
func NewAwsKmsDeleteCollectionOK() *AwsKmsDeleteCollectionOK {
	return &AwsKmsDeleteCollectionOK{}
}

/*
AwsKmsDeleteCollectionOK describes a response with status code 200, with default header values.

OK
*/
type AwsKmsDeleteCollectionOK struct {
}

// IsSuccess returns true when this aws kms delete collection o k response has a 2xx status code
func (o *AwsKmsDeleteCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this aws kms delete collection o k response has a 3xx status code
func (o *AwsKmsDeleteCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this aws kms delete collection o k response has a 4xx status code
func (o *AwsKmsDeleteCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this aws kms delete collection o k response has a 5xx status code
func (o *AwsKmsDeleteCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this aws kms delete collection o k response a status code equal to that given
func (o *AwsKmsDeleteCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the aws kms delete collection o k response
func (o *AwsKmsDeleteCollectionOK) Code() int {
	return 200
}

func (o *AwsKmsDeleteCollectionOK) Error() string {
	return fmt.Sprintf("[DELETE /security/aws-kms][%d] awsKmsDeleteCollectionOK", 200)
}

func (o *AwsKmsDeleteCollectionOK) String() string {
	return fmt.Sprintf("[DELETE /security/aws-kms][%d] awsKmsDeleteCollectionOK", 200)
}

func (o *AwsKmsDeleteCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewAwsKmsDeleteCollectionAccepted creates a AwsKmsDeleteCollectionAccepted with default headers values
func NewAwsKmsDeleteCollectionAccepted() *AwsKmsDeleteCollectionAccepted {
	return &AwsKmsDeleteCollectionAccepted{}
}

/*
AwsKmsDeleteCollectionAccepted describes a response with status code 202, with default header values.

Accepted
*/
type AwsKmsDeleteCollectionAccepted struct {
	Payload *models.AwsKmsJobLinkResponse
}

// IsSuccess returns true when this aws kms delete collection accepted response has a 2xx status code
func (o *AwsKmsDeleteCollectionAccepted) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this aws kms delete collection accepted response has a 3xx status code
func (o *AwsKmsDeleteCollectionAccepted) IsRedirect() bool {
	return false
}

// IsClientError returns true when this aws kms delete collection accepted response has a 4xx status code
func (o *AwsKmsDeleteCollectionAccepted) IsClientError() bool {
	return false
}

// IsServerError returns true when this aws kms delete collection accepted response has a 5xx status code
func (o *AwsKmsDeleteCollectionAccepted) IsServerError() bool {
	return false
}

// IsCode returns true when this aws kms delete collection accepted response a status code equal to that given
func (o *AwsKmsDeleteCollectionAccepted) IsCode(code int) bool {
	return code == 202
}

// Code gets the status code for the aws kms delete collection accepted response
func (o *AwsKmsDeleteCollectionAccepted) Code() int {
	return 202
}

func (o *AwsKmsDeleteCollectionAccepted) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /security/aws-kms][%d] awsKmsDeleteCollectionAccepted %s", 202, payload)
}

func (o *AwsKmsDeleteCollectionAccepted) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /security/aws-kms][%d] awsKmsDeleteCollectionAccepted %s", 202, payload)
}

func (o *AwsKmsDeleteCollectionAccepted) GetPayload() *models.AwsKmsJobLinkResponse {
	return o.Payload
}

func (o *AwsKmsDeleteCollectionAccepted) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.AwsKmsJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewAwsKmsDeleteCollectionDefault creates a AwsKmsDeleteCollectionDefault with default headers values
func NewAwsKmsDeleteCollectionDefault(code int) *AwsKmsDeleteCollectionDefault {
	return &AwsKmsDeleteCollectionDefault{
		_statusCode: code,
	}
}

/*
	AwsKmsDeleteCollectionDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 65536817 | Internal error. Failed to determine if it is safe to disable key manager. |
| 65536827 | Internal error. Failed to determine if the given SVM has any encrypted volumes. |
| 65536834 | Internal error. Failed to get existing key-server details for the given SVM. |
| 65536883 | Internal error. Volume encryption key is missing for a volume. |
| 65536884 | Internal error. Volume encryption key is invalid for a volume. |
| 65537106 | Volume encryption keys (VEK) for one or more encrypted volumes are stored on the key manager configured for the given SVM. |
| 65537926 | Amazon Web Service Key Management Service is not configured for SVM. |
| 196608080 | One or more nodes in the cluster have the root volume encrypted using NVE (NetApp Volume Encryption). |
| 196608301 | Internal error. Failed to get encryption type. |
| 196608332 | NAE aggregates found in the cluster. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type AwsKmsDeleteCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this aws kms delete collection default response has a 2xx status code
func (o *AwsKmsDeleteCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this aws kms delete collection default response has a 3xx status code
func (o *AwsKmsDeleteCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this aws kms delete collection default response has a 4xx status code
func (o *AwsKmsDeleteCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this aws kms delete collection default response has a 5xx status code
func (o *AwsKmsDeleteCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this aws kms delete collection default response a status code equal to that given
func (o *AwsKmsDeleteCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the aws kms delete collection default response
func (o *AwsKmsDeleteCollectionDefault) Code() int {
	return o._statusCode
}

func (o *AwsKmsDeleteCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /security/aws-kms][%d] aws_kms_delete_collection default %s", o._statusCode, payload)
}

func (o *AwsKmsDeleteCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /security/aws-kms][%d] aws_kms_delete_collection default %s", o._statusCode, payload)
}

func (o *AwsKmsDeleteCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *AwsKmsDeleteCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
AwsKmsDeleteCollectionBody aws kms delete collection body
swagger:model AwsKmsDeleteCollectionBody
*/
type AwsKmsDeleteCollectionBody struct {

	// aws kms response inline records
	AwsKmsResponseInlineRecords []*models.AwsKms `json:"records,omitempty"`
}

// Validate validates this aws kms delete collection body
func (o *AwsKmsDeleteCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateAwsKmsResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *AwsKmsDeleteCollectionBody) validateAwsKmsResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.AwsKmsResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.AwsKmsResponseInlineRecords); i++ {
		if swag.IsZero(o.AwsKmsResponseInlineRecords[i]) { // not required
			continue
		}

		if o.AwsKmsResponseInlineRecords[i] != nil {
			if err := o.AwsKmsResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this aws kms delete collection body based on the context it is used
func (o *AwsKmsDeleteCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateAwsKmsResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *AwsKmsDeleteCollectionBody) contextValidateAwsKmsResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.AwsKmsResponseInlineRecords); i++ {

		if o.AwsKmsResponseInlineRecords[i] != nil {
			if err := o.AwsKmsResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *AwsKmsDeleteCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *AwsKmsDeleteCollectionBody) UnmarshalBinary(b []byte) error {
	var res AwsKmsDeleteCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
