// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewAwsKmsDeleteParams creates a new AwsKmsDeleteParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewAwsKmsDeleteParams() *AwsKmsDeleteParams {
	return &AwsKmsDeleteParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewAwsKmsDeleteParamsWithTimeout creates a new AwsKmsDeleteParams object
// with the ability to set a timeout on a request.
func NewAwsKmsDeleteParamsWithTimeout(timeout time.Duration) *AwsKmsDeleteParams {
	return &AwsKmsDeleteParams{
		timeout: timeout,
	}
}

// NewAwsKmsDeleteParamsWithContext creates a new AwsKmsDeleteParams object
// with the ability to set a context for a request.
func NewAwsKmsDeleteParamsWithContext(ctx context.Context) *AwsKmsDeleteParams {
	return &AwsKmsDeleteParams{
		Context: ctx,
	}
}

// NewAwsKmsDeleteParamsWithHTTPClient creates a new AwsKmsDeleteParams object
// with the ability to set a custom HTTPClient for a request.
func NewAwsKmsDeleteParamsWithHTTPClient(client *http.Client) *AwsKmsDeleteParams {
	return &AwsKmsDeleteParams{
		HTTPClient: client,
	}
}

/*
AwsKmsDeleteParams contains all the parameters to send to the API endpoint

	for the aws kms delete operation.

	Typically these are written to a http.Request.
*/
type AwsKmsDeleteParams struct {

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning. When doing a POST, PATCH, or DELETE operation on a single record, the default is 0 seconds.  This means that if an asynchronous operation is started, the server immediately returns HTTP code 202 (Accepted) along with a link to the job.  If a non-zero value is specified for POST, PATCH, or DELETE operations, ONTAP waits that length of time to see if the job completes so it can return something other than 202.
	*/
	ReturnTimeout *int64

	/* UUID.

	   AWS KMS UUID
	*/
	UUID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the aws kms delete params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *AwsKmsDeleteParams) WithDefaults() *AwsKmsDeleteParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the aws kms delete params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *AwsKmsDeleteParams) SetDefaults() {
	var (
		returnTimeoutDefault = int64(0)
	)

	val := AwsKmsDeleteParams{
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the aws kms delete params
func (o *AwsKmsDeleteParams) WithTimeout(timeout time.Duration) *AwsKmsDeleteParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the aws kms delete params
func (o *AwsKmsDeleteParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the aws kms delete params
func (o *AwsKmsDeleteParams) WithContext(ctx context.Context) *AwsKmsDeleteParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the aws kms delete params
func (o *AwsKmsDeleteParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the aws kms delete params
func (o *AwsKmsDeleteParams) WithHTTPClient(client *http.Client) *AwsKmsDeleteParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the aws kms delete params
func (o *AwsKmsDeleteParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithReturnTimeout adds the returnTimeout to the aws kms delete params
func (o *AwsKmsDeleteParams) WithReturnTimeout(returnTimeout *int64) *AwsKmsDeleteParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the aws kms delete params
func (o *AwsKmsDeleteParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithUUID adds the uuid to the aws kms delete params
func (o *AwsKmsDeleteParams) WithUUID(uuid string) *AwsKmsDeleteParams {
	o.SetUUID(uuid)
	return o
}

// SetUUID adds the uuid to the aws kms delete params
func (o *AwsKmsDeleteParams) SetUUID(uuid string) {
	o.UUID = uuid
}

// WriteToRequest writes these params to a swagger request
func (o *AwsKmsDeleteParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	// path param uuid
	if err := r.SetPathParam("uuid", o.UUID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
