// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewAwsKmsGetParams creates a new AwsKmsGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewAwsKmsGetParams() *AwsKmsGetParams {
	return &AwsKmsGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewAwsKmsGetParamsWithTimeout creates a new AwsKmsGetParams object
// with the ability to set a timeout on a request.
func NewAwsKmsGetParamsWithTimeout(timeout time.Duration) *AwsKmsGetParams {
	return &AwsKmsGetParams{
		timeout: timeout,
	}
}

// NewAwsKmsGetParamsWithContext creates a new AwsKmsGetParams object
// with the ability to set a context for a request.
func NewAwsKmsGetParamsWithContext(ctx context.Context) *AwsKmsGetParams {
	return &AwsKmsGetParams{
		Context: ctx,
	}
}

// NewAwsKmsGetParamsWithHTTPClient creates a new AwsKmsGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewAwsKmsGetParamsWithHTTPClient(client *http.Client) *AwsKmsGetParams {
	return &AwsKmsGetParams{
		HTTPClient: client,
	}
}

/*
AwsKmsGetParams contains all the parameters to send to the API endpoint

	for the aws kms get operation.

	Typically these are written to a http.Request.
*/
type AwsKmsGetParams struct {

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* UUID.

	   AWS KMS UUID
	*/
	UUID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the aws kms get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *AwsKmsGetParams) WithDefaults() *AwsKmsGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the aws kms get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *AwsKmsGetParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the aws kms get params
func (o *AwsKmsGetParams) WithTimeout(timeout time.Duration) *AwsKmsGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the aws kms get params
func (o *AwsKmsGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the aws kms get params
func (o *AwsKmsGetParams) WithContext(ctx context.Context) *AwsKmsGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the aws kms get params
func (o *AwsKmsGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the aws kms get params
func (o *AwsKmsGetParams) WithHTTPClient(client *http.Client) *AwsKmsGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the aws kms get params
func (o *AwsKmsGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithFields adds the fields to the aws kms get params
func (o *AwsKmsGetParams) WithFields(fields []string) *AwsKmsGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the aws kms get params
func (o *AwsKmsGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithUUID adds the uuid to the aws kms get params
func (o *AwsKmsGetParams) WithUUID(uuid string) *AwsKmsGetParams {
	o.SetUUID(uuid)
	return o
}

// SetUUID adds the uuid to the aws kms get params
func (o *AwsKmsGetParams) SetUUID(uuid string) {
	o.UUID = uuid
}

// WriteToRequest writes these params to a swagger request
func (o *AwsKmsGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	// path param uuid
	if err := r.SetPathParam("uuid", o.UUID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamAwsKmsGet binds the parameter fields
func (o *AwsKmsGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}
