// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// AwsKmsModifyCollectionReader is a Reader for the AwsKmsModifyCollection structure.
type AwsKmsModifyCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *AwsKmsModifyCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewAwsKmsModifyCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 202:
		result := NewAwsKmsModifyCollectionAccepted()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewAwsKmsModifyCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewAwsKmsModifyCollectionOK creates a AwsKmsModifyCollectionOK with default headers values
func NewAwsKmsModifyCollectionOK() *AwsKmsModifyCollectionOK {
	return &AwsKmsModifyCollectionOK{}
}

/*
AwsKmsModifyCollectionOK describes a response with status code 200, with default header values.

OK
*/
type AwsKmsModifyCollectionOK struct {
}

// IsSuccess returns true when this aws kms modify collection o k response has a 2xx status code
func (o *AwsKmsModifyCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this aws kms modify collection o k response has a 3xx status code
func (o *AwsKmsModifyCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this aws kms modify collection o k response has a 4xx status code
func (o *AwsKmsModifyCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this aws kms modify collection o k response has a 5xx status code
func (o *AwsKmsModifyCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this aws kms modify collection o k response a status code equal to that given
func (o *AwsKmsModifyCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the aws kms modify collection o k response
func (o *AwsKmsModifyCollectionOK) Code() int {
	return 200
}

func (o *AwsKmsModifyCollectionOK) Error() string {
	return fmt.Sprintf("[PATCH /security/aws-kms][%d] awsKmsModifyCollectionOK", 200)
}

func (o *AwsKmsModifyCollectionOK) String() string {
	return fmt.Sprintf("[PATCH /security/aws-kms][%d] awsKmsModifyCollectionOK", 200)
}

func (o *AwsKmsModifyCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewAwsKmsModifyCollectionAccepted creates a AwsKmsModifyCollectionAccepted with default headers values
func NewAwsKmsModifyCollectionAccepted() *AwsKmsModifyCollectionAccepted {
	return &AwsKmsModifyCollectionAccepted{}
}

/*
AwsKmsModifyCollectionAccepted describes a response with status code 202, with default header values.

Accepted
*/
type AwsKmsModifyCollectionAccepted struct {
	Payload *models.AwsKmsJobLinkResponse
}

// IsSuccess returns true when this aws kms modify collection accepted response has a 2xx status code
func (o *AwsKmsModifyCollectionAccepted) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this aws kms modify collection accepted response has a 3xx status code
func (o *AwsKmsModifyCollectionAccepted) IsRedirect() bool {
	return false
}

// IsClientError returns true when this aws kms modify collection accepted response has a 4xx status code
func (o *AwsKmsModifyCollectionAccepted) IsClientError() bool {
	return false
}

// IsServerError returns true when this aws kms modify collection accepted response has a 5xx status code
func (o *AwsKmsModifyCollectionAccepted) IsServerError() bool {
	return false
}

// IsCode returns true when this aws kms modify collection accepted response a status code equal to that given
func (o *AwsKmsModifyCollectionAccepted) IsCode(code int) bool {
	return code == 202
}

// Code gets the status code for the aws kms modify collection accepted response
func (o *AwsKmsModifyCollectionAccepted) Code() int {
	return 202
}

func (o *AwsKmsModifyCollectionAccepted) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /security/aws-kms][%d] awsKmsModifyCollectionAccepted %s", 202, payload)
}

func (o *AwsKmsModifyCollectionAccepted) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /security/aws-kms][%d] awsKmsModifyCollectionAccepted %s", 202, payload)
}

func (o *AwsKmsModifyCollectionAccepted) GetPayload() *models.AwsKmsJobLinkResponse {
	return o.Payload
}

func (o *AwsKmsModifyCollectionAccepted) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.AwsKmsJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewAwsKmsModifyCollectionDefault creates a AwsKmsModifyCollectionDefault with default headers values
func NewAwsKmsModifyCollectionDefault(code int) *AwsKmsModifyCollectionDefault {
	return &AwsKmsModifyCollectionDefault{
		_statusCode: code,
	}
}

/*
	AwsKmsModifyCollectionDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 65537541 | No inputs provided for the REST API PATCH request. |
| 65537906 | Failed to store the secret access key. |
| 65537920 | Secret access key cannot be empty. |
| 65537921 | Unable to connect to the Amazon Web Service Key Management Service (AWSKMS) using these credentials. |
| 65537924 | Access key ID cannot be empty. |
| 65537926 | Amazon Web Service Key Management Service is not configured for SVM. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type AwsKmsModifyCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this aws kms modify collection default response has a 2xx status code
func (o *AwsKmsModifyCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this aws kms modify collection default response has a 3xx status code
func (o *AwsKmsModifyCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this aws kms modify collection default response has a 4xx status code
func (o *AwsKmsModifyCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this aws kms modify collection default response has a 5xx status code
func (o *AwsKmsModifyCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this aws kms modify collection default response a status code equal to that given
func (o *AwsKmsModifyCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the aws kms modify collection default response
func (o *AwsKmsModifyCollectionDefault) Code() int {
	return o._statusCode
}

func (o *AwsKmsModifyCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /security/aws-kms][%d] aws_kms_modify_collection default %s", o._statusCode, payload)
}

func (o *AwsKmsModifyCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /security/aws-kms][%d] aws_kms_modify_collection default %s", o._statusCode, payload)
}

func (o *AwsKmsModifyCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *AwsKmsModifyCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
AwsKmsModifyCollectionBody aws kms modify collection body
swagger:model AwsKmsModifyCollectionBody
*/
type AwsKmsModifyCollectionBody struct {

	// links
	Links *models.AwsKmsInlineLinks `json:"_links,omitempty"`

	// AWS Access Key ID of the user that has appropriate access to AWS KMS.
	// Example: AKIATCFKZXU6GKUDQUWN
	AccessKeyID *string `json:"access_key_id,omitempty"`

	// amazon reachability
	AmazonReachability *models.AwsKmsInlineAmazonReachability `json:"amazon_reachability,omitempty"`

	// aws kms inline ekmip reachability
	// Read Only: true
	AwsKmsInlineEkmipReachability []*models.AwsKmsInlineEkmipReachabilityInlineArrayItem `json:"ekmip_reachability,omitempty"`

	// aws kms response inline records
	AwsKmsResponseInlineRecords []*models.AwsKms `json:"records,omitempty"`

	// AWS KMS default domain.
	// Example: domainName
	DefaultDomain *string `json:"default_domain,omitempty"`

	// Additional layer of authentication and logging.
	// Example: aws:fsx:fs-id=fs-0785c8beceb895999
	EncryptionContext *string `json:"encryption_context,omitempty"`

	// AWS KMS host's hostname.
	// Example: aws-host.host.com
	Host *string `json:"host,omitempty"`

	// AWS Key ID.
	// Example: kmip-aws
	KeyID *string `json:"key_id,omitempty"`

	// Polling period in minutes.
	// Example: 55
	PollingPeriod *int64 `json:"polling_period,omitempty"`

	// AWS KMS port.
	// Example: 443
	Port *int64 `json:"port,omitempty"`

	// Proxy host.
	// Example: proxy.eng.com
	ProxyHost *string `json:"proxy_host,omitempty"`

	// Proxy password. Password is not audited.
	// Example: awskze-Jwjje2-WJJPer
	ProxyPassword *string `json:"proxy_password,omitempty"`

	// Proxy port.
	// Example: 1234
	ProxyPort *int64 `json:"proxy_port,omitempty"`

	// Proxy type.
	// Example: http
	// Enum: ["http","https"]
	ProxyType *string `json:"proxy_type,omitempty"`

	// Proxy username.
	// Example: proxyuser
	ProxyUsername *string `json:"proxy_username,omitempty"`

	// AWS region of the AWS KMS.
	// Example: us-east-1
	Region *string `json:"region,omitempty"`

	// Set to "svm" for interfaces owned by an SVM. Otherwise, set to "cluster".
	// Read Only: true
	// Enum: ["svm","cluster"]
	Scope *string `json:"scope,omitempty"`

	// AWS Secret Access Key for the provided access key ID.
	// Example: tyb1kA/bSr5654LncZNwNcvAOR7hu1vPo0nPrtoG
	// Format: password
	SecretAccessKey *strfmt.Password `json:"secret_access_key,omitempty"`

	// AWS service type.
	// Example: dynamodb.*.amazonaws.com
	Service *string `json:"service,omitempty"`

	// Set to true to bypass verification of the user provided access_key_id
	// and secret_access_key. An error will be returned if 'skip_verify' is
	// provided but 'access_key_id' is not.
	//
	// Example: false
	SkipVerify *bool `json:"skip_verify,omitempty"`

	// state
	State *models.AwsKmsInlineState `json:"state,omitempty"`

	// svm
	Svm *models.AwsKmsInlineSvm `json:"svm,omitempty"`

	// AWS Connection timeout, in seconds.
	// Example: 20
	Timeout *int64 `json:"timeout,omitempty"`

	// A unique identifier for the AWS KMS.
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`

	// Set to true to verify the AWS KMS host.
	// Example: false
	Verify *bool `json:"verify,omitempty"`

	// Set to true to verify the AWS KMS host's hostname.
	// Example: true
	VerifyHost *bool `json:"verify_host,omitempty"`

	// Set to true to verify the AWS KMS host's IP address.
	// Example: false
	VerifyIP *bool `json:"verify_ip,omitempty"`
}

// Validate validates this aws kms modify collection body
func (o *AwsKmsModifyCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateAmazonReachability(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateAwsKmsInlineEkmipReachability(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateAwsKmsResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateProxyType(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateScope(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSecretAccessKey(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateState(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSvm(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *AwsKmsModifyCollectionBody) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *AwsKmsModifyCollectionBody) validateAmazonReachability(formats strfmt.Registry) error {
	if swag.IsZero(o.AmazonReachability) { // not required
		return nil
	}

	if o.AmazonReachability != nil {
		if err := o.AmazonReachability.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "amazon_reachability")
			}
			return err
		}
	}

	return nil
}

func (o *AwsKmsModifyCollectionBody) validateAwsKmsInlineEkmipReachability(formats strfmt.Registry) error {
	if swag.IsZero(o.AwsKmsInlineEkmipReachability) { // not required
		return nil
	}

	for i := 0; i < len(o.AwsKmsInlineEkmipReachability); i++ {
		if swag.IsZero(o.AwsKmsInlineEkmipReachability[i]) { // not required
			continue
		}

		if o.AwsKmsInlineEkmipReachability[i] != nil {
			if err := o.AwsKmsInlineEkmipReachability[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "ekmip_reachability" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *AwsKmsModifyCollectionBody) validateAwsKmsResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.AwsKmsResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.AwsKmsResponseInlineRecords); i++ {
		if swag.IsZero(o.AwsKmsResponseInlineRecords[i]) { // not required
			continue
		}

		if o.AwsKmsResponseInlineRecords[i] != nil {
			if err := o.AwsKmsResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

var awsKmsModifyCollectionBodyTypeProxyTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["http","https"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		awsKmsModifyCollectionBodyTypeProxyTypePropEnum = append(awsKmsModifyCollectionBodyTypeProxyTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// AwsKmsModifyCollectionBody
	// AwsKmsModifyCollectionBody
	// proxy_type
	// ProxyType
	// http
	// END DEBUGGING
	// AwsKmsModifyCollectionBodyProxyTypeHTTP captures enum value "http"
	AwsKmsModifyCollectionBodyProxyTypeHTTP string = "http"

	// BEGIN DEBUGGING
	// AwsKmsModifyCollectionBody
	// AwsKmsModifyCollectionBody
	// proxy_type
	// ProxyType
	// https
	// END DEBUGGING
	// AwsKmsModifyCollectionBodyProxyTypeHTTPS captures enum value "https"
	AwsKmsModifyCollectionBodyProxyTypeHTTPS string = "https"
)

// prop value enum
func (o *AwsKmsModifyCollectionBody) validateProxyTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, awsKmsModifyCollectionBodyTypeProxyTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *AwsKmsModifyCollectionBody) validateProxyType(formats strfmt.Registry) error {
	if swag.IsZero(o.ProxyType) { // not required
		return nil
	}

	// value enum
	if err := o.validateProxyTypeEnum("info"+"."+"proxy_type", "body", *o.ProxyType); err != nil {
		return err
	}

	return nil
}

var awsKmsModifyCollectionBodyTypeScopePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["svm","cluster"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		awsKmsModifyCollectionBodyTypeScopePropEnum = append(awsKmsModifyCollectionBodyTypeScopePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// AwsKmsModifyCollectionBody
	// AwsKmsModifyCollectionBody
	// scope
	// Scope
	// svm
	// END DEBUGGING
	// AwsKmsModifyCollectionBodyScopeSvm captures enum value "svm"
	AwsKmsModifyCollectionBodyScopeSvm string = "svm"

	// BEGIN DEBUGGING
	// AwsKmsModifyCollectionBody
	// AwsKmsModifyCollectionBody
	// scope
	// Scope
	// cluster
	// END DEBUGGING
	// AwsKmsModifyCollectionBodyScopeCluster captures enum value "cluster"
	AwsKmsModifyCollectionBodyScopeCluster string = "cluster"
)

// prop value enum
func (o *AwsKmsModifyCollectionBody) validateScopeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, awsKmsModifyCollectionBodyTypeScopePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *AwsKmsModifyCollectionBody) validateScope(formats strfmt.Registry) error {
	if swag.IsZero(o.Scope) { // not required
		return nil
	}

	// value enum
	if err := o.validateScopeEnum("info"+"."+"scope", "body", *o.Scope); err != nil {
		return err
	}

	return nil
}

func (o *AwsKmsModifyCollectionBody) validateSecretAccessKey(formats strfmt.Registry) error {
	if swag.IsZero(o.SecretAccessKey) { // not required
		return nil
	}

	if err := validate.FormatOf("info"+"."+"secret_access_key", "body", "password", o.SecretAccessKey.String(), formats); err != nil {
		return err
	}

	return nil
}

func (o *AwsKmsModifyCollectionBody) validateState(formats strfmt.Registry) error {
	if swag.IsZero(o.State) { // not required
		return nil
	}

	if o.State != nil {
		if err := o.State.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "state")
			}
			return err
		}
	}

	return nil
}

func (o *AwsKmsModifyCollectionBody) validateSvm(formats strfmt.Registry) error {
	if swag.IsZero(o.Svm) { // not required
		return nil
	}

	if o.Svm != nil {
		if err := o.Svm.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this aws kms modify collection body based on the context it is used
func (o *AwsKmsModifyCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateAmazonReachability(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateAwsKmsInlineEkmipReachability(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateAwsKmsResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateScope(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSvm(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *AwsKmsModifyCollectionBody) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *AwsKmsModifyCollectionBody) contextValidateAmazonReachability(ctx context.Context, formats strfmt.Registry) error {

	if o.AmazonReachability != nil {
		if err := o.AmazonReachability.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "amazon_reachability")
			}
			return err
		}
	}

	return nil
}

func (o *AwsKmsModifyCollectionBody) contextValidateAwsKmsInlineEkmipReachability(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"ekmip_reachability", "body", []*models.AwsKmsInlineEkmipReachabilityInlineArrayItem(o.AwsKmsInlineEkmipReachability)); err != nil {
		return err
	}

	for i := 0; i < len(o.AwsKmsInlineEkmipReachability); i++ {

		if o.AwsKmsInlineEkmipReachability[i] != nil {
			if err := o.AwsKmsInlineEkmipReachability[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "ekmip_reachability" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *AwsKmsModifyCollectionBody) contextValidateAwsKmsResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.AwsKmsResponseInlineRecords); i++ {

		if o.AwsKmsResponseInlineRecords[i] != nil {
			if err := o.AwsKmsResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *AwsKmsModifyCollectionBody) contextValidateScope(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"scope", "body", o.Scope); err != nil {
		return err
	}

	return nil
}

func (o *AwsKmsModifyCollectionBody) contextValidateState(ctx context.Context, formats strfmt.Registry) error {

	if o.State != nil {
		if err := o.State.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "state")
			}
			return err
		}
	}

	return nil
}

func (o *AwsKmsModifyCollectionBody) contextValidateSvm(ctx context.Context, formats strfmt.Registry) error {

	if o.Svm != nil {
		if err := o.Svm.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm")
			}
			return err
		}
	}

	return nil
}

func (o *AwsKmsModifyCollectionBody) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"uuid", "body", o.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *AwsKmsModifyCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *AwsKmsModifyCollectionBody) UnmarshalBinary(b []byte) error {
	var res AwsKmsModifyCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
AwsKmsInlineLinks aws kms inline links
swagger:model aws_kms_inline__links
*/
type AwsKmsInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this aws kms inline links
func (o *AwsKmsInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *AwsKmsInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this aws kms inline links based on the context it is used
func (o *AwsKmsInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *AwsKmsInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *AwsKmsInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *AwsKmsInlineLinks) UnmarshalBinary(b []byte) error {
	var res AwsKmsInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
AwsKmsInlineAmazonReachability Indicates whether or not the Amazon KMS is reachable from all nodes in the cluster.
// This is an advanced property; there is an added computational cost to retrieving its value. The property is not populated for either a collection GET or an instance GET unless it is explicitly requested using the `fields` query parameter or GET for all advanced properties is enabled.
//
swagger:model aws_kms_inline_amazon_reachability
*/
type AwsKmsInlineAmazonReachability struct {

	// Code corresponding to the error message. Returns a 0 if Amazon KMS is reachable from all nodes in the cluster.
	// Example: 346758
	Code *string `json:"code,omitempty"`

	// Error message returned when 'reachable' is false.
	// Example: Amazon KMS is not reachable from all nodes - \u003creason\u003e.
	Message *string `json:"message,omitempty"`

	// Set to true if the Amazon KMS is reachable from all nodes of the cluster.
	Reachable *bool `json:"reachable,omitempty"`
}

// Validate validates this aws kms inline amazon reachability
func (o *AwsKmsInlineAmazonReachability) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this aws kms inline amazon reachability based on the context it is used
func (o *AwsKmsInlineAmazonReachability) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (o *AwsKmsInlineAmazonReachability) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *AwsKmsInlineAmazonReachability) UnmarshalBinary(b []byte) error {
	var res AwsKmsInlineAmazonReachability
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
AwsKmsInlineEkmipReachabilityInlineArrayItem Provides the connectivity status for the given SVM on the given node to all EKMIP servers configured on all nodes of the cluster.
// This is an advanced property; there is an added computational cost to retrieving its value. The property is not populated for either a collection GET or an instance GET unless it is explicitly requested using the `fields` query parameter or GET for all advanced properties is enabled.
//
swagger:model aws_kms_inline_ekmip_reachability_inline_array_item
*/
type AwsKmsInlineEkmipReachabilityInlineArrayItem struct {

	// Code corresponding to the error message. Returns a 0 if a given SVM is able to communicate to the EKMIP servers of all of the nodes in the cluster.
	// Example: 346758
	Code *string `json:"code,omitempty"`

	// Error message set when cluster-wide EKMIP server availability from the given SVM and node is false.
	// Example: embedded KMIP server status unavailable on node.
	Message *string `json:"message,omitempty"`

	// node
	Node *models.AwsKmsInlineEkmipReachabilityInlineArrayItemInlineNode `json:"node,omitempty"`

	// Set to true if the given SVM on the given node is able to communicate to all EKMIP servers configured on all nodes in the cluster.
	Reachable *bool `json:"reachable,omitempty"`
}

// Validate validates this aws kms inline ekmip reachability inline array item
func (o *AwsKmsInlineEkmipReachabilityInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateNode(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *AwsKmsInlineEkmipReachabilityInlineArrayItem) validateNode(formats strfmt.Registry) error {
	if swag.IsZero(o.Node) { // not required
		return nil
	}

	if o.Node != nil {
		if err := o.Node.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this aws kms inline ekmip reachability inline array item based on the context it is used
func (o *AwsKmsInlineEkmipReachabilityInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateNode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *AwsKmsInlineEkmipReachabilityInlineArrayItem) contextValidateNode(ctx context.Context, formats strfmt.Registry) error {

	if o.Node != nil {
		if err := o.Node.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *AwsKmsInlineEkmipReachabilityInlineArrayItem) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *AwsKmsInlineEkmipReachabilityInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res AwsKmsInlineEkmipReachabilityInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
AwsKmsInlineEkmipReachabilityInlineArrayItemInlineNode aws kms inline ekmip reachability inline array item inline node
swagger:model aws_kms_inline_ekmip_reachability_inline_array_item_inline_node
*/
type AwsKmsInlineEkmipReachabilityInlineArrayItemInlineNode struct {

	// links
	Links *models.AwsKmsInlineEkmipReachabilityInlineArrayItemInlineNodeInlineLinks `json:"_links,omitempty"`

	// name
	// Example: node1
	Name *string `json:"name,omitempty"`

	// uuid
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this aws kms inline ekmip reachability inline array item inline node
func (o *AwsKmsInlineEkmipReachabilityInlineArrayItemInlineNode) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *AwsKmsInlineEkmipReachabilityInlineArrayItemInlineNode) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this aws kms inline ekmip reachability inline array item inline node based on the context it is used
func (o *AwsKmsInlineEkmipReachabilityInlineArrayItemInlineNode) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *AwsKmsInlineEkmipReachabilityInlineArrayItemInlineNode) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *AwsKmsInlineEkmipReachabilityInlineArrayItemInlineNode) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *AwsKmsInlineEkmipReachabilityInlineArrayItemInlineNode) UnmarshalBinary(b []byte) error {
	var res AwsKmsInlineEkmipReachabilityInlineArrayItemInlineNode
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
AwsKmsInlineEkmipReachabilityInlineArrayItemInlineNodeInlineLinks aws kms inline ekmip reachability inline array item inline node inline links
swagger:model aws_kms_inline_ekmip_reachability_inline_array_item_inline_node_inline__links
*/
type AwsKmsInlineEkmipReachabilityInlineArrayItemInlineNodeInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this aws kms inline ekmip reachability inline array item inline node inline links
func (o *AwsKmsInlineEkmipReachabilityInlineArrayItemInlineNodeInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *AwsKmsInlineEkmipReachabilityInlineArrayItemInlineNodeInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this aws kms inline ekmip reachability inline array item inline node inline links based on the context it is used
func (o *AwsKmsInlineEkmipReachabilityInlineArrayItemInlineNodeInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *AwsKmsInlineEkmipReachabilityInlineArrayItemInlineNodeInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *AwsKmsInlineEkmipReachabilityInlineArrayItemInlineNodeInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *AwsKmsInlineEkmipReachabilityInlineArrayItemInlineNodeInlineLinks) UnmarshalBinary(b []byte) error {
	var res AwsKmsInlineEkmipReachabilityInlineArrayItemInlineNodeInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
AwsKmsInlineState Indicates whether or not the Amazon Web Services Key Management Service (AWS KMS) key protection is available cluster-wide.
//
swagger:model aws_kms_inline_state
*/
type AwsKmsInlineState struct {

	// Set to true when AWS KMS key protection is available on all nodes of the cluster.
	ClusterState *bool `json:"cluster_state,omitempty"`

	// Code corresponding to the message. Returns a 0 if AWS KMS key protection is available on all nodes of the cluster.
	// Example: 346758
	Code *string `json:"code,omitempty"`

	// Error message set when cluster_state is false.
	// Example: AWS KMS key protection is unavailable on the following nodes: node1, node2.
	Message *string `json:"message,omitempty"`
}

// Validate validates this aws kms inline state
func (o *AwsKmsInlineState) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this aws kms inline state based on the context it is used
func (o *AwsKmsInlineState) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (o *AwsKmsInlineState) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *AwsKmsInlineState) UnmarshalBinary(b []byte) error {
	var res AwsKmsInlineState
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
AwsKmsInlineSvm SVM, applies only to SVM-scoped objects.
swagger:model aws_kms_inline_svm
*/
type AwsKmsInlineSvm struct {

	// links
	Links *models.AwsKmsInlineSvmInlineLinks `json:"_links,omitempty"`

	// The name of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: svm1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: 02c9e252-41be-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this aws kms inline svm
func (o *AwsKmsInlineSvm) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *AwsKmsInlineSvm) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this aws kms inline svm based on the context it is used
func (o *AwsKmsInlineSvm) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *AwsKmsInlineSvm) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *AwsKmsInlineSvm) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *AwsKmsInlineSvm) UnmarshalBinary(b []byte) error {
	var res AwsKmsInlineSvm
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
AwsKmsInlineSvmInlineLinks aws kms inline svm inline links
swagger:model aws_kms_inline_svm_inline__links
*/
type AwsKmsInlineSvmInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this aws kms inline svm inline links
func (o *AwsKmsInlineSvmInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *AwsKmsInlineSvmInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this aws kms inline svm inline links based on the context it is used
func (o *AwsKmsInlineSvmInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *AwsKmsInlineSvmInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *AwsKmsInlineSvmInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *AwsKmsInlineSvmInlineLinks) UnmarshalBinary(b []byte) error {
	var res AwsKmsInlineSvmInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
