// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// AwsKmsRekeyExternalReader is a Reader for the AwsKmsRekeyExternal structure.
type AwsKmsRekeyExternalReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *AwsKmsRekeyExternalReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 201:
		result := NewAwsKmsRekeyExternalCreated()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 202:
		result := NewAwsKmsRekeyExternalAccepted()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewAwsKmsRekeyExternalDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewAwsKmsRekeyExternalCreated creates a AwsKmsRekeyExternalCreated with default headers values
func NewAwsKmsRekeyExternalCreated() *AwsKmsRekeyExternalCreated {
	return &AwsKmsRekeyExternalCreated{}
}

/*
AwsKmsRekeyExternalCreated describes a response with status code 201, with default header values.

Created
*/
type AwsKmsRekeyExternalCreated struct {
	Payload *models.AwsKmsKeyJobLinkResponse
}

// IsSuccess returns true when this aws kms rekey external created response has a 2xx status code
func (o *AwsKmsRekeyExternalCreated) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this aws kms rekey external created response has a 3xx status code
func (o *AwsKmsRekeyExternalCreated) IsRedirect() bool {
	return false
}

// IsClientError returns true when this aws kms rekey external created response has a 4xx status code
func (o *AwsKmsRekeyExternalCreated) IsClientError() bool {
	return false
}

// IsServerError returns true when this aws kms rekey external created response has a 5xx status code
func (o *AwsKmsRekeyExternalCreated) IsServerError() bool {
	return false
}

// IsCode returns true when this aws kms rekey external created response a status code equal to that given
func (o *AwsKmsRekeyExternalCreated) IsCode(code int) bool {
	return code == 201
}

// Code gets the status code for the aws kms rekey external created response
func (o *AwsKmsRekeyExternalCreated) Code() int {
	return 201
}

func (o *AwsKmsRekeyExternalCreated) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /security/aws-kms/{aws_kms.uuid}/rekey-external][%d] awsKmsRekeyExternalCreated %s", 201, payload)
}

func (o *AwsKmsRekeyExternalCreated) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /security/aws-kms/{aws_kms.uuid}/rekey-external][%d] awsKmsRekeyExternalCreated %s", 201, payload)
}

func (o *AwsKmsRekeyExternalCreated) GetPayload() *models.AwsKmsKeyJobLinkResponse {
	return o.Payload
}

func (o *AwsKmsRekeyExternalCreated) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.AwsKmsKeyJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewAwsKmsRekeyExternalAccepted creates a AwsKmsRekeyExternalAccepted with default headers values
func NewAwsKmsRekeyExternalAccepted() *AwsKmsRekeyExternalAccepted {
	return &AwsKmsRekeyExternalAccepted{}
}

/*
AwsKmsRekeyExternalAccepted describes a response with status code 202, with default header values.

Accepted
*/
type AwsKmsRekeyExternalAccepted struct {
	Payload *models.AwsKmsKeyJobLinkResponse
}

// IsSuccess returns true when this aws kms rekey external accepted response has a 2xx status code
func (o *AwsKmsRekeyExternalAccepted) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this aws kms rekey external accepted response has a 3xx status code
func (o *AwsKmsRekeyExternalAccepted) IsRedirect() bool {
	return false
}

// IsClientError returns true when this aws kms rekey external accepted response has a 4xx status code
func (o *AwsKmsRekeyExternalAccepted) IsClientError() bool {
	return false
}

// IsServerError returns true when this aws kms rekey external accepted response has a 5xx status code
func (o *AwsKmsRekeyExternalAccepted) IsServerError() bool {
	return false
}

// IsCode returns true when this aws kms rekey external accepted response a status code equal to that given
func (o *AwsKmsRekeyExternalAccepted) IsCode(code int) bool {
	return code == 202
}

// Code gets the status code for the aws kms rekey external accepted response
func (o *AwsKmsRekeyExternalAccepted) Code() int {
	return 202
}

func (o *AwsKmsRekeyExternalAccepted) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /security/aws-kms/{aws_kms.uuid}/rekey-external][%d] awsKmsRekeyExternalAccepted %s", 202, payload)
}

func (o *AwsKmsRekeyExternalAccepted) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /security/aws-kms/{aws_kms.uuid}/rekey-external][%d] awsKmsRekeyExternalAccepted %s", 202, payload)
}

func (o *AwsKmsRekeyExternalAccepted) GetPayload() *models.AwsKmsKeyJobLinkResponse {
	return o.Payload
}

func (o *AwsKmsRekeyExternalAccepted) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.AwsKmsKeyJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewAwsKmsRekeyExternalDefault creates a AwsKmsRekeyExternalDefault with default headers values
func NewAwsKmsRekeyExternalDefault(code int) *AwsKmsRekeyExternalDefault {
	return &AwsKmsRekeyExternalDefault{
		_statusCode: code,
	}
}

/*
	AwsKmsRekeyExternalDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 65537538 | Internal error. Failed to get unwrapped key for a given key ID. |
| 65537543 | Internal Error. Missing top-level internal key protection key (KEK) on a node. |
| 65537547 | One or more volume encryption keys for encrypted volumes of this data SVM are stored in the key manager configured for the admin SVM. Use the REST API POST method to migrate this data SVM's keys from the admin SVM's key manager before running the rekey operation. |
| 65537610 | Rekey cannot be performed on the SVM while the enabled keystore configuration is being switched. If a previous attempt to switch the keystore configuration failed, or was interrupted, the system will continue to prevent rekeying for the SVM. Use the REST API PATCH method "/api/security/key-stores/{uuid}" to re-run and complete the operation. |
| 65537919 | External rekey failed on one or more nodes. |
| 65537926 | AWS KMS is not configured for the given SVM. |
| 65539436 | Rekey cannot be performed on the SVM while the enabled keystore configuration is being initialized. Wait until the keystore is in the active state, and rerun the rekey operation. |
| 65539437 | Rekey cannot be performed on the SVM while the enabled keystore configuration is being disabled. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type AwsKmsRekeyExternalDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this aws kms rekey external default response has a 2xx status code
func (o *AwsKmsRekeyExternalDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this aws kms rekey external default response has a 3xx status code
func (o *AwsKmsRekeyExternalDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this aws kms rekey external default response has a 4xx status code
func (o *AwsKmsRekeyExternalDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this aws kms rekey external default response has a 5xx status code
func (o *AwsKmsRekeyExternalDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this aws kms rekey external default response a status code equal to that given
func (o *AwsKmsRekeyExternalDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the aws kms rekey external default response
func (o *AwsKmsRekeyExternalDefault) Code() int {
	return o._statusCode
}

func (o *AwsKmsRekeyExternalDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /security/aws-kms/{aws_kms.uuid}/rekey-external][%d] aws_kms_rekey_external default %s", o._statusCode, payload)
}

func (o *AwsKmsRekeyExternalDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /security/aws-kms/{aws_kms.uuid}/rekey-external][%d] aws_kms_rekey_external default %s", o._statusCode, payload)
}

func (o *AwsKmsRekeyExternalDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *AwsKmsRekeyExternalDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
