// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// AwsKmsRekeyInternalReader is a Reader for the AwsKmsRekeyInternal structure.
type AwsKmsRekeyInternalReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *AwsKmsRekeyInternalReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 201:
		result := NewAwsKmsRekeyInternalCreated()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 202:
		result := NewAwsKmsRekeyInternalAccepted()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewAwsKmsRekeyInternalDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewAwsKmsRekeyInternalCreated creates a AwsKmsRekeyInternalCreated with default headers values
func NewAwsKmsRekeyInternalCreated() *AwsKmsRekeyInternalCreated {
	return &AwsKmsRekeyInternalCreated{}
}

/*
AwsKmsRekeyInternalCreated describes a response with status code 201, with default header values.

Created
*/
type AwsKmsRekeyInternalCreated struct {

	/* Useful for tracking the resource location
	 */
	Location string

	Payload *models.AwsKmsKeyJobLinkResponse
}

// IsSuccess returns true when this aws kms rekey internal created response has a 2xx status code
func (o *AwsKmsRekeyInternalCreated) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this aws kms rekey internal created response has a 3xx status code
func (o *AwsKmsRekeyInternalCreated) IsRedirect() bool {
	return false
}

// IsClientError returns true when this aws kms rekey internal created response has a 4xx status code
func (o *AwsKmsRekeyInternalCreated) IsClientError() bool {
	return false
}

// IsServerError returns true when this aws kms rekey internal created response has a 5xx status code
func (o *AwsKmsRekeyInternalCreated) IsServerError() bool {
	return false
}

// IsCode returns true when this aws kms rekey internal created response a status code equal to that given
func (o *AwsKmsRekeyInternalCreated) IsCode(code int) bool {
	return code == 201
}

// Code gets the status code for the aws kms rekey internal created response
func (o *AwsKmsRekeyInternalCreated) Code() int {
	return 201
}

func (o *AwsKmsRekeyInternalCreated) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /security/aws-kms/{aws_kms.uuid}/rekey-internal][%d] awsKmsRekeyInternalCreated %s", 201, payload)
}

func (o *AwsKmsRekeyInternalCreated) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /security/aws-kms/{aws_kms.uuid}/rekey-internal][%d] awsKmsRekeyInternalCreated %s", 201, payload)
}

func (o *AwsKmsRekeyInternalCreated) GetPayload() *models.AwsKmsKeyJobLinkResponse {
	return o.Payload
}

func (o *AwsKmsRekeyInternalCreated) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header Location
	hdrLocation := response.GetHeader("Location")

	if hdrLocation != "" {
		o.Location = hdrLocation
	}

	o.Payload = new(models.AwsKmsKeyJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewAwsKmsRekeyInternalAccepted creates a AwsKmsRekeyInternalAccepted with default headers values
func NewAwsKmsRekeyInternalAccepted() *AwsKmsRekeyInternalAccepted {
	return &AwsKmsRekeyInternalAccepted{}
}

/*
AwsKmsRekeyInternalAccepted describes a response with status code 202, with default header values.

Accepted
*/
type AwsKmsRekeyInternalAccepted struct {

	/* Useful for tracking the resource location
	 */
	Location string

	Payload *models.AwsKmsKeyJobLinkResponse
}

// IsSuccess returns true when this aws kms rekey internal accepted response has a 2xx status code
func (o *AwsKmsRekeyInternalAccepted) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this aws kms rekey internal accepted response has a 3xx status code
func (o *AwsKmsRekeyInternalAccepted) IsRedirect() bool {
	return false
}

// IsClientError returns true when this aws kms rekey internal accepted response has a 4xx status code
func (o *AwsKmsRekeyInternalAccepted) IsClientError() bool {
	return false
}

// IsServerError returns true when this aws kms rekey internal accepted response has a 5xx status code
func (o *AwsKmsRekeyInternalAccepted) IsServerError() bool {
	return false
}

// IsCode returns true when this aws kms rekey internal accepted response a status code equal to that given
func (o *AwsKmsRekeyInternalAccepted) IsCode(code int) bool {
	return code == 202
}

// Code gets the status code for the aws kms rekey internal accepted response
func (o *AwsKmsRekeyInternalAccepted) Code() int {
	return 202
}

func (o *AwsKmsRekeyInternalAccepted) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /security/aws-kms/{aws_kms.uuid}/rekey-internal][%d] awsKmsRekeyInternalAccepted %s", 202, payload)
}

func (o *AwsKmsRekeyInternalAccepted) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /security/aws-kms/{aws_kms.uuid}/rekey-internal][%d] awsKmsRekeyInternalAccepted %s", 202, payload)
}

func (o *AwsKmsRekeyInternalAccepted) GetPayload() *models.AwsKmsKeyJobLinkResponse {
	return o.Payload
}

func (o *AwsKmsRekeyInternalAccepted) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header Location
	hdrLocation := response.GetHeader("Location")

	if hdrLocation != "" {
		o.Location = hdrLocation
	}

	o.Payload = new(models.AwsKmsKeyJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewAwsKmsRekeyInternalDefault creates a AwsKmsRekeyInternalDefault with default headers values
func NewAwsKmsRekeyInternalDefault(code int) *AwsKmsRekeyInternalDefault {
	return &AwsKmsRekeyInternalDefault{
		_statusCode: code,
	}
}

/*
	AwsKmsRekeyInternalDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 65537547 | One or more volume encryption keys for encrypted volumes of this data SVM are stored in the key manager configured for the admin SVM. Use the REST API POST method to migrate this data SVM's keys from the admin SVM's key manager to this data SVM's key manager before running the rekey operation. |
| 65537556 | Unable to successfully encrypt or decrypt because the configured external key manager for the given SVM is in a blocked state. |
| 65537559 | There are no existing internal keys for the SVM. A rekey operation is allowed for an SVM with one or more encryption keys. |
| 65537566 | Internal error. All nodes in the cluster are not currently online. |
| 65537610 | Rekey cannot be performed on the SVM while the enabled keystore configuration is being switched. If a previous attempt to switch the keystore configuration failed, or was interrupted, the system will continue to prevent rekeying for the SVM. Use the REST API PATCH method "/api/security/key-stores/{uuid}" to re-run and complete the operation. |
| 65537926 | AWS KMS is not configured for the given SVM. |
| 65539436 | Rekey cannot be performed on the SVM while the enabled keystore configuration is being initialized. Wait until the keystore is in the active state, and rerun the rekey operation. |
| 65539437 | Rekey cannot be performed on the SVM while the enabled keystore configuration is being disabled. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type AwsKmsRekeyInternalDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this aws kms rekey internal default response has a 2xx status code
func (o *AwsKmsRekeyInternalDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this aws kms rekey internal default response has a 3xx status code
func (o *AwsKmsRekeyInternalDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this aws kms rekey internal default response has a 4xx status code
func (o *AwsKmsRekeyInternalDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this aws kms rekey internal default response has a 5xx status code
func (o *AwsKmsRekeyInternalDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this aws kms rekey internal default response a status code equal to that given
func (o *AwsKmsRekeyInternalDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the aws kms rekey internal default response
func (o *AwsKmsRekeyInternalDefault) Code() int {
	return o._statusCode
}

func (o *AwsKmsRekeyInternalDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /security/aws-kms/{aws_kms.uuid}/rekey-internal][%d] aws_kms_rekey_internal default %s", o._statusCode, payload)
}

func (o *AwsKmsRekeyInternalDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /security/aws-kms/{aws_kms.uuid}/rekey-internal][%d] aws_kms_rekey_internal default %s", o._statusCode, payload)
}

func (o *AwsKmsRekeyInternalDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *AwsKmsRekeyInternalDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
