// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewAwsKmsRestoreParams creates a new AwsKmsRestoreParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewAwsKmsRestoreParams() *AwsKmsRestoreParams {
	return &AwsKmsRestoreParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewAwsKmsRestoreParamsWithTimeout creates a new AwsKmsRestoreParams object
// with the ability to set a timeout on a request.
func NewAwsKmsRestoreParamsWithTimeout(timeout time.Duration) *AwsKmsRestoreParams {
	return &AwsKmsRestoreParams{
		timeout: timeout,
	}
}

// NewAwsKmsRestoreParamsWithContext creates a new AwsKmsRestoreParams object
// with the ability to set a context for a request.
func NewAwsKmsRestoreParamsWithContext(ctx context.Context) *AwsKmsRestoreParams {
	return &AwsKmsRestoreParams{
		Context: ctx,
	}
}

// NewAwsKmsRestoreParamsWithHTTPClient creates a new AwsKmsRestoreParams object
// with the ability to set a custom HTTPClient for a request.
func NewAwsKmsRestoreParamsWithHTTPClient(client *http.Client) *AwsKmsRestoreParams {
	return &AwsKmsRestoreParams{
		HTTPClient: client,
	}
}

/*
AwsKmsRestoreParams contains all the parameters to send to the API endpoint

	for the aws kms restore operation.

	Typically these are written to a http.Request.
*/
type AwsKmsRestoreParams struct {

	/* AwsKmsUUID.

	   UUID of the existing AWS KMS configuration.
	*/
	AwsKmsUUID string

	/* ReturnRecords.

	   The default is false.  If set to true, the records are returned.
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning. When doing a POST, PATCH, or DELETE operation on a single record, the default is 0 seconds.  This means that if an asynchronous operation is started, the server immediately returns HTTP code 202 (Accepted) along with a link to the job.  If a non-zero value is specified for POST, PATCH, or DELETE operations, ONTAP waits that length of time to see if the job completes so it can return something other than 202.
	*/
	ReturnTimeout *int64

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the aws kms restore params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *AwsKmsRestoreParams) WithDefaults() *AwsKmsRestoreParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the aws kms restore params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *AwsKmsRestoreParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(false)

		returnTimeoutDefault = int64(0)
	)

	val := AwsKmsRestoreParams{
		ReturnRecords: &returnRecordsDefault,
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the aws kms restore params
func (o *AwsKmsRestoreParams) WithTimeout(timeout time.Duration) *AwsKmsRestoreParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the aws kms restore params
func (o *AwsKmsRestoreParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the aws kms restore params
func (o *AwsKmsRestoreParams) WithContext(ctx context.Context) *AwsKmsRestoreParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the aws kms restore params
func (o *AwsKmsRestoreParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the aws kms restore params
func (o *AwsKmsRestoreParams) WithHTTPClient(client *http.Client) *AwsKmsRestoreParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the aws kms restore params
func (o *AwsKmsRestoreParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithAwsKmsUUID adds the awsKmsUUID to the aws kms restore params
func (o *AwsKmsRestoreParams) WithAwsKmsUUID(awsKmsUUID string) *AwsKmsRestoreParams {
	o.SetAwsKmsUUID(awsKmsUUID)
	return o
}

// SetAwsKmsUUID adds the awsKmsUuid to the aws kms restore params
func (o *AwsKmsRestoreParams) SetAwsKmsUUID(awsKmsUUID string) {
	o.AwsKmsUUID = awsKmsUUID
}

// WithReturnRecords adds the returnRecords to the aws kms restore params
func (o *AwsKmsRestoreParams) WithReturnRecords(returnRecords *bool) *AwsKmsRestoreParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the aws kms restore params
func (o *AwsKmsRestoreParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the aws kms restore params
func (o *AwsKmsRestoreParams) WithReturnTimeout(returnTimeout *int64) *AwsKmsRestoreParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the aws kms restore params
func (o *AwsKmsRestoreParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WriteToRequest writes these params to a swagger request
func (o *AwsKmsRestoreParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param aws_kms.uuid
	if err := r.SetPathParam("aws_kms.uuid", o.AwsKmsUUID); err != nil {
		return err
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
