// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewAzureKeyVaultCollectionGetParams creates a new AzureKeyVaultCollectionGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewAzureKeyVaultCollectionGetParams() *AzureKeyVaultCollectionGetParams {
	return &AzureKeyVaultCollectionGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewAzureKeyVaultCollectionGetParamsWithTimeout creates a new AzureKeyVaultCollectionGetParams object
// with the ability to set a timeout on a request.
func NewAzureKeyVaultCollectionGetParamsWithTimeout(timeout time.Duration) *AzureKeyVaultCollectionGetParams {
	return &AzureKeyVaultCollectionGetParams{
		timeout: timeout,
	}
}

// NewAzureKeyVaultCollectionGetParamsWithContext creates a new AzureKeyVaultCollectionGetParams object
// with the ability to set a context for a request.
func NewAzureKeyVaultCollectionGetParamsWithContext(ctx context.Context) *AzureKeyVaultCollectionGetParams {
	return &AzureKeyVaultCollectionGetParams{
		Context: ctx,
	}
}

// NewAzureKeyVaultCollectionGetParamsWithHTTPClient creates a new AzureKeyVaultCollectionGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewAzureKeyVaultCollectionGetParamsWithHTTPClient(client *http.Client) *AzureKeyVaultCollectionGetParams {
	return &AzureKeyVaultCollectionGetParams{
		HTTPClient: client,
	}
}

/*
AzureKeyVaultCollectionGetParams contains all the parameters to send to the API endpoint

	for the azure key vault collection get operation.

	Typically these are written to a http.Request.
*/
type AzureKeyVaultCollectionGetParams struct {

	/* AuthenticationMethod.

	   Filter by authentication_method
	*/
	AuthenticationMethod *string

	/* AzureReachabilityCode.

	   Filter by azure_reachability.code
	*/
	AzureReachabilityCode *string

	/* AzureReachabilityMessage.

	   Filter by azure_reachability.message
	*/
	AzureReachabilityMessage *string

	/* AzureReachabilityReachable.

	   Filter by azure_reachability.reachable
	*/
	AzureReachabilityReachable *bool

	/* ClientID.

	   Filter by client_id
	*/
	ClientID *string

	/* ConfigurationName.

	   Filter by configuration.name
	*/
	ConfigurationName *string

	/* ConfigurationUUID.

	   Filter by configuration.uuid
	*/
	ConfigurationUUID *string

	/* EkmipReachabilityCode.

	   Filter by ekmip_reachability.code
	*/
	EkmipReachabilityCode *string

	/* EkmipReachabilityMessage.

	   Filter by ekmip_reachability.message
	*/
	EkmipReachabilityMessage *string

	/* EkmipReachabilityNodeName.

	   Filter by ekmip_reachability.node.name
	*/
	EkmipReachabilityNodeName *string

	/* EkmipReachabilityNodeUUID.

	   Filter by ekmip_reachability.node.uuid
	*/
	EkmipReachabilityNodeUUID *string

	/* EkmipReachabilityReachable.

	   Filter by ekmip_reachability.reachable
	*/
	EkmipReachabilityReachable *bool

	/* Enabled.

	   Filter by enabled
	*/
	Enabled *bool

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* KeyID.

	   Filter by key_id
	*/
	KeyID *string

	/* MaxRecords.

	   Limit the number of records returned.
	*/
	MaxRecords *int64

	/* Name.

	   Filter by name
	*/
	Name *string

	/* OauthHost.

	   Filter by oauth_host
	*/
	OauthHost *string

	/* OrderBy.

	   Order results by specified fields and optional [asc|desc] direction. Default direction is 'asc' for ascending.
	*/
	OrderBy []string

	/* Port.

	   Filter by port
	*/
	Port *int64

	/* ProxyHost.

	   Filter by proxy_host
	*/
	ProxyHost *string

	/* ProxyPort.

	   Filter by proxy_port
	*/
	ProxyPort *int64

	/* ProxyType.

	   Filter by proxy_type
	*/
	ProxyType *string

	/* ProxyUsername.

	   Filter by proxy_username
	*/
	ProxyUsername *string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* Scope.

	   Filter by scope
	*/
	Scope *string

	/* SkipVerification.

	   Filter by skip_verification
	*/
	SkipVerification *bool

	/* StateAvailable.

	   Filter by state.available
	*/
	StateAvailable *bool

	/* StateCode.

	   Filter by state.code
	*/
	StateCode *string

	/* StateMessage.

	   Filter by state.message
	*/
	StateMessage *string

	/* SvmName.

	   Filter by svm.name
	*/
	SvmName *string

	/* SvmUUID.

	   Filter by svm.uuid
	*/
	SvmUUID *string

	/* TenantID.

	   Filter by tenant_id
	*/
	TenantID *string

	/* UUID.

	   Filter by uuid
	*/
	UUID *string

	/* VaultHost.

	   Filter by vault_host
	*/
	VaultHost *string

	/* VerifyHost.

	   Filter by verify_host
	*/
	VerifyHost *bool

	/* VerifyIP.

	   Filter by verify_ip
	*/
	VerifyIP *bool

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the azure key vault collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *AzureKeyVaultCollectionGetParams) WithDefaults() *AzureKeyVaultCollectionGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the azure key vault collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *AzureKeyVaultCollectionGetParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)
	)

	val := AzureKeyVaultCollectionGetParams{
		ReturnRecords: &returnRecordsDefault,
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the azure key vault collection get params
func (o *AzureKeyVaultCollectionGetParams) WithTimeout(timeout time.Duration) *AzureKeyVaultCollectionGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the azure key vault collection get params
func (o *AzureKeyVaultCollectionGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the azure key vault collection get params
func (o *AzureKeyVaultCollectionGetParams) WithContext(ctx context.Context) *AzureKeyVaultCollectionGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the azure key vault collection get params
func (o *AzureKeyVaultCollectionGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the azure key vault collection get params
func (o *AzureKeyVaultCollectionGetParams) WithHTTPClient(client *http.Client) *AzureKeyVaultCollectionGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the azure key vault collection get params
func (o *AzureKeyVaultCollectionGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithAuthenticationMethod adds the authenticationMethod to the azure key vault collection get params
func (o *AzureKeyVaultCollectionGetParams) WithAuthenticationMethod(authenticationMethod *string) *AzureKeyVaultCollectionGetParams {
	o.SetAuthenticationMethod(authenticationMethod)
	return o
}

// SetAuthenticationMethod adds the authenticationMethod to the azure key vault collection get params
func (o *AzureKeyVaultCollectionGetParams) SetAuthenticationMethod(authenticationMethod *string) {
	o.AuthenticationMethod = authenticationMethod
}

// WithAzureReachabilityCode adds the azureReachabilityCode to the azure key vault collection get params
func (o *AzureKeyVaultCollectionGetParams) WithAzureReachabilityCode(azureReachabilityCode *string) *AzureKeyVaultCollectionGetParams {
	o.SetAzureReachabilityCode(azureReachabilityCode)
	return o
}

// SetAzureReachabilityCode adds the azureReachabilityCode to the azure key vault collection get params
func (o *AzureKeyVaultCollectionGetParams) SetAzureReachabilityCode(azureReachabilityCode *string) {
	o.AzureReachabilityCode = azureReachabilityCode
}

// WithAzureReachabilityMessage adds the azureReachabilityMessage to the azure key vault collection get params
func (o *AzureKeyVaultCollectionGetParams) WithAzureReachabilityMessage(azureReachabilityMessage *string) *AzureKeyVaultCollectionGetParams {
	o.SetAzureReachabilityMessage(azureReachabilityMessage)
	return o
}

// SetAzureReachabilityMessage adds the azureReachabilityMessage to the azure key vault collection get params
func (o *AzureKeyVaultCollectionGetParams) SetAzureReachabilityMessage(azureReachabilityMessage *string) {
	o.AzureReachabilityMessage = azureReachabilityMessage
}

// WithAzureReachabilityReachable adds the azureReachabilityReachable to the azure key vault collection get params
func (o *AzureKeyVaultCollectionGetParams) WithAzureReachabilityReachable(azureReachabilityReachable *bool) *AzureKeyVaultCollectionGetParams {
	o.SetAzureReachabilityReachable(azureReachabilityReachable)
	return o
}

// SetAzureReachabilityReachable adds the azureReachabilityReachable to the azure key vault collection get params
func (o *AzureKeyVaultCollectionGetParams) SetAzureReachabilityReachable(azureReachabilityReachable *bool) {
	o.AzureReachabilityReachable = azureReachabilityReachable
}

// WithClientID adds the clientID to the azure key vault collection get params
func (o *AzureKeyVaultCollectionGetParams) WithClientID(clientID *string) *AzureKeyVaultCollectionGetParams {
	o.SetClientID(clientID)
	return o
}

// SetClientID adds the clientId to the azure key vault collection get params
func (o *AzureKeyVaultCollectionGetParams) SetClientID(clientID *string) {
	o.ClientID = clientID
}

// WithConfigurationName adds the configurationName to the azure key vault collection get params
func (o *AzureKeyVaultCollectionGetParams) WithConfigurationName(configurationName *string) *AzureKeyVaultCollectionGetParams {
	o.SetConfigurationName(configurationName)
	return o
}

// SetConfigurationName adds the configurationName to the azure key vault collection get params
func (o *AzureKeyVaultCollectionGetParams) SetConfigurationName(configurationName *string) {
	o.ConfigurationName = configurationName
}

// WithConfigurationUUID adds the configurationUUID to the azure key vault collection get params
func (o *AzureKeyVaultCollectionGetParams) WithConfigurationUUID(configurationUUID *string) *AzureKeyVaultCollectionGetParams {
	o.SetConfigurationUUID(configurationUUID)
	return o
}

// SetConfigurationUUID adds the configurationUuid to the azure key vault collection get params
func (o *AzureKeyVaultCollectionGetParams) SetConfigurationUUID(configurationUUID *string) {
	o.ConfigurationUUID = configurationUUID
}

// WithEkmipReachabilityCode adds the ekmipReachabilityCode to the azure key vault collection get params
func (o *AzureKeyVaultCollectionGetParams) WithEkmipReachabilityCode(ekmipReachabilityCode *string) *AzureKeyVaultCollectionGetParams {
	o.SetEkmipReachabilityCode(ekmipReachabilityCode)
	return o
}

// SetEkmipReachabilityCode adds the ekmipReachabilityCode to the azure key vault collection get params
func (o *AzureKeyVaultCollectionGetParams) SetEkmipReachabilityCode(ekmipReachabilityCode *string) {
	o.EkmipReachabilityCode = ekmipReachabilityCode
}

// WithEkmipReachabilityMessage adds the ekmipReachabilityMessage to the azure key vault collection get params
func (o *AzureKeyVaultCollectionGetParams) WithEkmipReachabilityMessage(ekmipReachabilityMessage *string) *AzureKeyVaultCollectionGetParams {
	o.SetEkmipReachabilityMessage(ekmipReachabilityMessage)
	return o
}

// SetEkmipReachabilityMessage adds the ekmipReachabilityMessage to the azure key vault collection get params
func (o *AzureKeyVaultCollectionGetParams) SetEkmipReachabilityMessage(ekmipReachabilityMessage *string) {
	o.EkmipReachabilityMessage = ekmipReachabilityMessage
}

// WithEkmipReachabilityNodeName adds the ekmipReachabilityNodeName to the azure key vault collection get params
func (o *AzureKeyVaultCollectionGetParams) WithEkmipReachabilityNodeName(ekmipReachabilityNodeName *string) *AzureKeyVaultCollectionGetParams {
	o.SetEkmipReachabilityNodeName(ekmipReachabilityNodeName)
	return o
}

// SetEkmipReachabilityNodeName adds the ekmipReachabilityNodeName to the azure key vault collection get params
func (o *AzureKeyVaultCollectionGetParams) SetEkmipReachabilityNodeName(ekmipReachabilityNodeName *string) {
	o.EkmipReachabilityNodeName = ekmipReachabilityNodeName
}

// WithEkmipReachabilityNodeUUID adds the ekmipReachabilityNodeUUID to the azure key vault collection get params
func (o *AzureKeyVaultCollectionGetParams) WithEkmipReachabilityNodeUUID(ekmipReachabilityNodeUUID *string) *AzureKeyVaultCollectionGetParams {
	o.SetEkmipReachabilityNodeUUID(ekmipReachabilityNodeUUID)
	return o
}

// SetEkmipReachabilityNodeUUID adds the ekmipReachabilityNodeUuid to the azure key vault collection get params
func (o *AzureKeyVaultCollectionGetParams) SetEkmipReachabilityNodeUUID(ekmipReachabilityNodeUUID *string) {
	o.EkmipReachabilityNodeUUID = ekmipReachabilityNodeUUID
}

// WithEkmipReachabilityReachable adds the ekmipReachabilityReachable to the azure key vault collection get params
func (o *AzureKeyVaultCollectionGetParams) WithEkmipReachabilityReachable(ekmipReachabilityReachable *bool) *AzureKeyVaultCollectionGetParams {
	o.SetEkmipReachabilityReachable(ekmipReachabilityReachable)
	return o
}

// SetEkmipReachabilityReachable adds the ekmipReachabilityReachable to the azure key vault collection get params
func (o *AzureKeyVaultCollectionGetParams) SetEkmipReachabilityReachable(ekmipReachabilityReachable *bool) {
	o.EkmipReachabilityReachable = ekmipReachabilityReachable
}

// WithEnabled adds the enabled to the azure key vault collection get params
func (o *AzureKeyVaultCollectionGetParams) WithEnabled(enabled *bool) *AzureKeyVaultCollectionGetParams {
	o.SetEnabled(enabled)
	return o
}

// SetEnabled adds the enabled to the azure key vault collection get params
func (o *AzureKeyVaultCollectionGetParams) SetEnabled(enabled *bool) {
	o.Enabled = enabled
}

// WithFields adds the fields to the azure key vault collection get params
func (o *AzureKeyVaultCollectionGetParams) WithFields(fields []string) *AzureKeyVaultCollectionGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the azure key vault collection get params
func (o *AzureKeyVaultCollectionGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithKeyID adds the keyID to the azure key vault collection get params
func (o *AzureKeyVaultCollectionGetParams) WithKeyID(keyID *string) *AzureKeyVaultCollectionGetParams {
	o.SetKeyID(keyID)
	return o
}

// SetKeyID adds the keyId to the azure key vault collection get params
func (o *AzureKeyVaultCollectionGetParams) SetKeyID(keyID *string) {
	o.KeyID = keyID
}

// WithMaxRecords adds the maxRecords to the azure key vault collection get params
func (o *AzureKeyVaultCollectionGetParams) WithMaxRecords(maxRecords *int64) *AzureKeyVaultCollectionGetParams {
	o.SetMaxRecords(maxRecords)
	return o
}

// SetMaxRecords adds the maxRecords to the azure key vault collection get params
func (o *AzureKeyVaultCollectionGetParams) SetMaxRecords(maxRecords *int64) {
	o.MaxRecords = maxRecords
}

// WithName adds the name to the azure key vault collection get params
func (o *AzureKeyVaultCollectionGetParams) WithName(name *string) *AzureKeyVaultCollectionGetParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the azure key vault collection get params
func (o *AzureKeyVaultCollectionGetParams) SetName(name *string) {
	o.Name = name
}

// WithOauthHost adds the oauthHost to the azure key vault collection get params
func (o *AzureKeyVaultCollectionGetParams) WithOauthHost(oauthHost *string) *AzureKeyVaultCollectionGetParams {
	o.SetOauthHost(oauthHost)
	return o
}

// SetOauthHost adds the oauthHost to the azure key vault collection get params
func (o *AzureKeyVaultCollectionGetParams) SetOauthHost(oauthHost *string) {
	o.OauthHost = oauthHost
}

// WithOrderBy adds the orderBy to the azure key vault collection get params
func (o *AzureKeyVaultCollectionGetParams) WithOrderBy(orderBy []string) *AzureKeyVaultCollectionGetParams {
	o.SetOrderBy(orderBy)
	return o
}

// SetOrderBy adds the orderBy to the azure key vault collection get params
func (o *AzureKeyVaultCollectionGetParams) SetOrderBy(orderBy []string) {
	o.OrderBy = orderBy
}

// WithPort adds the port to the azure key vault collection get params
func (o *AzureKeyVaultCollectionGetParams) WithPort(port *int64) *AzureKeyVaultCollectionGetParams {
	o.SetPort(port)
	return o
}

// SetPort adds the port to the azure key vault collection get params
func (o *AzureKeyVaultCollectionGetParams) SetPort(port *int64) {
	o.Port = port
}

// WithProxyHost adds the proxyHost to the azure key vault collection get params
func (o *AzureKeyVaultCollectionGetParams) WithProxyHost(proxyHost *string) *AzureKeyVaultCollectionGetParams {
	o.SetProxyHost(proxyHost)
	return o
}

// SetProxyHost adds the proxyHost to the azure key vault collection get params
func (o *AzureKeyVaultCollectionGetParams) SetProxyHost(proxyHost *string) {
	o.ProxyHost = proxyHost
}

// WithProxyPort adds the proxyPort to the azure key vault collection get params
func (o *AzureKeyVaultCollectionGetParams) WithProxyPort(proxyPort *int64) *AzureKeyVaultCollectionGetParams {
	o.SetProxyPort(proxyPort)
	return o
}

// SetProxyPort adds the proxyPort to the azure key vault collection get params
func (o *AzureKeyVaultCollectionGetParams) SetProxyPort(proxyPort *int64) {
	o.ProxyPort = proxyPort
}

// WithProxyType adds the proxyType to the azure key vault collection get params
func (o *AzureKeyVaultCollectionGetParams) WithProxyType(proxyType *string) *AzureKeyVaultCollectionGetParams {
	o.SetProxyType(proxyType)
	return o
}

// SetProxyType adds the proxyType to the azure key vault collection get params
func (o *AzureKeyVaultCollectionGetParams) SetProxyType(proxyType *string) {
	o.ProxyType = proxyType
}

// WithProxyUsername adds the proxyUsername to the azure key vault collection get params
func (o *AzureKeyVaultCollectionGetParams) WithProxyUsername(proxyUsername *string) *AzureKeyVaultCollectionGetParams {
	o.SetProxyUsername(proxyUsername)
	return o
}

// SetProxyUsername adds the proxyUsername to the azure key vault collection get params
func (o *AzureKeyVaultCollectionGetParams) SetProxyUsername(proxyUsername *string) {
	o.ProxyUsername = proxyUsername
}

// WithReturnRecords adds the returnRecords to the azure key vault collection get params
func (o *AzureKeyVaultCollectionGetParams) WithReturnRecords(returnRecords *bool) *AzureKeyVaultCollectionGetParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the azure key vault collection get params
func (o *AzureKeyVaultCollectionGetParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the azure key vault collection get params
func (o *AzureKeyVaultCollectionGetParams) WithReturnTimeout(returnTimeout *int64) *AzureKeyVaultCollectionGetParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the azure key vault collection get params
func (o *AzureKeyVaultCollectionGetParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithScope adds the scope to the azure key vault collection get params
func (o *AzureKeyVaultCollectionGetParams) WithScope(scope *string) *AzureKeyVaultCollectionGetParams {
	o.SetScope(scope)
	return o
}

// SetScope adds the scope to the azure key vault collection get params
func (o *AzureKeyVaultCollectionGetParams) SetScope(scope *string) {
	o.Scope = scope
}

// WithSkipVerification adds the skipVerification to the azure key vault collection get params
func (o *AzureKeyVaultCollectionGetParams) WithSkipVerification(skipVerification *bool) *AzureKeyVaultCollectionGetParams {
	o.SetSkipVerification(skipVerification)
	return o
}

// SetSkipVerification adds the skipVerification to the azure key vault collection get params
func (o *AzureKeyVaultCollectionGetParams) SetSkipVerification(skipVerification *bool) {
	o.SkipVerification = skipVerification
}

// WithStateAvailable adds the stateAvailable to the azure key vault collection get params
func (o *AzureKeyVaultCollectionGetParams) WithStateAvailable(stateAvailable *bool) *AzureKeyVaultCollectionGetParams {
	o.SetStateAvailable(stateAvailable)
	return o
}

// SetStateAvailable adds the stateAvailable to the azure key vault collection get params
func (o *AzureKeyVaultCollectionGetParams) SetStateAvailable(stateAvailable *bool) {
	o.StateAvailable = stateAvailable
}

// WithStateCode adds the stateCode to the azure key vault collection get params
func (o *AzureKeyVaultCollectionGetParams) WithStateCode(stateCode *string) *AzureKeyVaultCollectionGetParams {
	o.SetStateCode(stateCode)
	return o
}

// SetStateCode adds the stateCode to the azure key vault collection get params
func (o *AzureKeyVaultCollectionGetParams) SetStateCode(stateCode *string) {
	o.StateCode = stateCode
}

// WithStateMessage adds the stateMessage to the azure key vault collection get params
func (o *AzureKeyVaultCollectionGetParams) WithStateMessage(stateMessage *string) *AzureKeyVaultCollectionGetParams {
	o.SetStateMessage(stateMessage)
	return o
}

// SetStateMessage adds the stateMessage to the azure key vault collection get params
func (o *AzureKeyVaultCollectionGetParams) SetStateMessage(stateMessage *string) {
	o.StateMessage = stateMessage
}

// WithSvmName adds the svmName to the azure key vault collection get params
func (o *AzureKeyVaultCollectionGetParams) WithSvmName(svmName *string) *AzureKeyVaultCollectionGetParams {
	o.SetSvmName(svmName)
	return o
}

// SetSvmName adds the svmName to the azure key vault collection get params
func (o *AzureKeyVaultCollectionGetParams) SetSvmName(svmName *string) {
	o.SvmName = svmName
}

// WithSvmUUID adds the svmUUID to the azure key vault collection get params
func (o *AzureKeyVaultCollectionGetParams) WithSvmUUID(svmUUID *string) *AzureKeyVaultCollectionGetParams {
	o.SetSvmUUID(svmUUID)
	return o
}

// SetSvmUUID adds the svmUuid to the azure key vault collection get params
func (o *AzureKeyVaultCollectionGetParams) SetSvmUUID(svmUUID *string) {
	o.SvmUUID = svmUUID
}

// WithTenantID adds the tenantID to the azure key vault collection get params
func (o *AzureKeyVaultCollectionGetParams) WithTenantID(tenantID *string) *AzureKeyVaultCollectionGetParams {
	o.SetTenantID(tenantID)
	return o
}

// SetTenantID adds the tenantId to the azure key vault collection get params
func (o *AzureKeyVaultCollectionGetParams) SetTenantID(tenantID *string) {
	o.TenantID = tenantID
}

// WithUUID adds the uuid to the azure key vault collection get params
func (o *AzureKeyVaultCollectionGetParams) WithUUID(uuid *string) *AzureKeyVaultCollectionGetParams {
	o.SetUUID(uuid)
	return o
}

// SetUUID adds the uuid to the azure key vault collection get params
func (o *AzureKeyVaultCollectionGetParams) SetUUID(uuid *string) {
	o.UUID = uuid
}

// WithVaultHost adds the vaultHost to the azure key vault collection get params
func (o *AzureKeyVaultCollectionGetParams) WithVaultHost(vaultHost *string) *AzureKeyVaultCollectionGetParams {
	o.SetVaultHost(vaultHost)
	return o
}

// SetVaultHost adds the vaultHost to the azure key vault collection get params
func (o *AzureKeyVaultCollectionGetParams) SetVaultHost(vaultHost *string) {
	o.VaultHost = vaultHost
}

// WithVerifyHost adds the verifyHost to the azure key vault collection get params
func (o *AzureKeyVaultCollectionGetParams) WithVerifyHost(verifyHost *bool) *AzureKeyVaultCollectionGetParams {
	o.SetVerifyHost(verifyHost)
	return o
}

// SetVerifyHost adds the verifyHost to the azure key vault collection get params
func (o *AzureKeyVaultCollectionGetParams) SetVerifyHost(verifyHost *bool) {
	o.VerifyHost = verifyHost
}

// WithVerifyIP adds the verifyIP to the azure key vault collection get params
func (o *AzureKeyVaultCollectionGetParams) WithVerifyIP(verifyIP *bool) *AzureKeyVaultCollectionGetParams {
	o.SetVerifyIP(verifyIP)
	return o
}

// SetVerifyIP adds the verifyIp to the azure key vault collection get params
func (o *AzureKeyVaultCollectionGetParams) SetVerifyIP(verifyIP *bool) {
	o.VerifyIP = verifyIP
}

// WriteToRequest writes these params to a swagger request
func (o *AzureKeyVaultCollectionGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.AuthenticationMethod != nil {

		// query param authentication_method
		var qrAuthenticationMethod string

		if o.AuthenticationMethod != nil {
			qrAuthenticationMethod = *o.AuthenticationMethod
		}
		qAuthenticationMethod := qrAuthenticationMethod
		if qAuthenticationMethod != "" {

			if err := r.SetQueryParam("authentication_method", qAuthenticationMethod); err != nil {
				return err
			}
		}
	}

	if o.AzureReachabilityCode != nil {

		// query param azure_reachability.code
		var qrAzureReachabilityCode string

		if o.AzureReachabilityCode != nil {
			qrAzureReachabilityCode = *o.AzureReachabilityCode
		}
		qAzureReachabilityCode := qrAzureReachabilityCode
		if qAzureReachabilityCode != "" {

			if err := r.SetQueryParam("azure_reachability.code", qAzureReachabilityCode); err != nil {
				return err
			}
		}
	}

	if o.AzureReachabilityMessage != nil {

		// query param azure_reachability.message
		var qrAzureReachabilityMessage string

		if o.AzureReachabilityMessage != nil {
			qrAzureReachabilityMessage = *o.AzureReachabilityMessage
		}
		qAzureReachabilityMessage := qrAzureReachabilityMessage
		if qAzureReachabilityMessage != "" {

			if err := r.SetQueryParam("azure_reachability.message", qAzureReachabilityMessage); err != nil {
				return err
			}
		}
	}

	if o.AzureReachabilityReachable != nil {

		// query param azure_reachability.reachable
		var qrAzureReachabilityReachable bool

		if o.AzureReachabilityReachable != nil {
			qrAzureReachabilityReachable = *o.AzureReachabilityReachable
		}
		qAzureReachabilityReachable := swag.FormatBool(qrAzureReachabilityReachable)
		if qAzureReachabilityReachable != "" {

			if err := r.SetQueryParam("azure_reachability.reachable", qAzureReachabilityReachable); err != nil {
				return err
			}
		}
	}

	if o.ClientID != nil {

		// query param client_id
		var qrClientID string

		if o.ClientID != nil {
			qrClientID = *o.ClientID
		}
		qClientID := qrClientID
		if qClientID != "" {

			if err := r.SetQueryParam("client_id", qClientID); err != nil {
				return err
			}
		}
	}

	if o.ConfigurationName != nil {

		// query param configuration.name
		var qrConfigurationName string

		if o.ConfigurationName != nil {
			qrConfigurationName = *o.ConfigurationName
		}
		qConfigurationName := qrConfigurationName
		if qConfigurationName != "" {

			if err := r.SetQueryParam("configuration.name", qConfigurationName); err != nil {
				return err
			}
		}
	}

	if o.ConfigurationUUID != nil {

		// query param configuration.uuid
		var qrConfigurationUUID string

		if o.ConfigurationUUID != nil {
			qrConfigurationUUID = *o.ConfigurationUUID
		}
		qConfigurationUUID := qrConfigurationUUID
		if qConfigurationUUID != "" {

			if err := r.SetQueryParam("configuration.uuid", qConfigurationUUID); err != nil {
				return err
			}
		}
	}

	if o.EkmipReachabilityCode != nil {

		// query param ekmip_reachability.code
		var qrEkmipReachabilityCode string

		if o.EkmipReachabilityCode != nil {
			qrEkmipReachabilityCode = *o.EkmipReachabilityCode
		}
		qEkmipReachabilityCode := qrEkmipReachabilityCode
		if qEkmipReachabilityCode != "" {

			if err := r.SetQueryParam("ekmip_reachability.code", qEkmipReachabilityCode); err != nil {
				return err
			}
		}
	}

	if o.EkmipReachabilityMessage != nil {

		// query param ekmip_reachability.message
		var qrEkmipReachabilityMessage string

		if o.EkmipReachabilityMessage != nil {
			qrEkmipReachabilityMessage = *o.EkmipReachabilityMessage
		}
		qEkmipReachabilityMessage := qrEkmipReachabilityMessage
		if qEkmipReachabilityMessage != "" {

			if err := r.SetQueryParam("ekmip_reachability.message", qEkmipReachabilityMessage); err != nil {
				return err
			}
		}
	}

	if o.EkmipReachabilityNodeName != nil {

		// query param ekmip_reachability.node.name
		var qrEkmipReachabilityNodeName string

		if o.EkmipReachabilityNodeName != nil {
			qrEkmipReachabilityNodeName = *o.EkmipReachabilityNodeName
		}
		qEkmipReachabilityNodeName := qrEkmipReachabilityNodeName
		if qEkmipReachabilityNodeName != "" {

			if err := r.SetQueryParam("ekmip_reachability.node.name", qEkmipReachabilityNodeName); err != nil {
				return err
			}
		}
	}

	if o.EkmipReachabilityNodeUUID != nil {

		// query param ekmip_reachability.node.uuid
		var qrEkmipReachabilityNodeUUID string

		if o.EkmipReachabilityNodeUUID != nil {
			qrEkmipReachabilityNodeUUID = *o.EkmipReachabilityNodeUUID
		}
		qEkmipReachabilityNodeUUID := qrEkmipReachabilityNodeUUID
		if qEkmipReachabilityNodeUUID != "" {

			if err := r.SetQueryParam("ekmip_reachability.node.uuid", qEkmipReachabilityNodeUUID); err != nil {
				return err
			}
		}
	}

	if o.EkmipReachabilityReachable != nil {

		// query param ekmip_reachability.reachable
		var qrEkmipReachabilityReachable bool

		if o.EkmipReachabilityReachable != nil {
			qrEkmipReachabilityReachable = *o.EkmipReachabilityReachable
		}
		qEkmipReachabilityReachable := swag.FormatBool(qrEkmipReachabilityReachable)
		if qEkmipReachabilityReachable != "" {

			if err := r.SetQueryParam("ekmip_reachability.reachable", qEkmipReachabilityReachable); err != nil {
				return err
			}
		}
	}

	if o.Enabled != nil {

		// query param enabled
		var qrEnabled bool

		if o.Enabled != nil {
			qrEnabled = *o.Enabled
		}
		qEnabled := swag.FormatBool(qrEnabled)
		if qEnabled != "" {

			if err := r.SetQueryParam("enabled", qEnabled); err != nil {
				return err
			}
		}
	}

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	if o.KeyID != nil {

		// query param key_id
		var qrKeyID string

		if o.KeyID != nil {
			qrKeyID = *o.KeyID
		}
		qKeyID := qrKeyID
		if qKeyID != "" {

			if err := r.SetQueryParam("key_id", qKeyID); err != nil {
				return err
			}
		}
	}

	if o.MaxRecords != nil {

		// query param max_records
		var qrMaxRecords int64

		if o.MaxRecords != nil {
			qrMaxRecords = *o.MaxRecords
		}
		qMaxRecords := swag.FormatInt64(qrMaxRecords)
		if qMaxRecords != "" {

			if err := r.SetQueryParam("max_records", qMaxRecords); err != nil {
				return err
			}
		}
	}

	if o.Name != nil {

		// query param name
		var qrName string

		if o.Name != nil {
			qrName = *o.Name
		}
		qName := qrName
		if qName != "" {

			if err := r.SetQueryParam("name", qName); err != nil {
				return err
			}
		}
	}

	if o.OauthHost != nil {

		// query param oauth_host
		var qrOauthHost string

		if o.OauthHost != nil {
			qrOauthHost = *o.OauthHost
		}
		qOauthHost := qrOauthHost
		if qOauthHost != "" {

			if err := r.SetQueryParam("oauth_host", qOauthHost); err != nil {
				return err
			}
		}
	}

	if o.OrderBy != nil {

		// binding items for order_by
		joinedOrderBy := o.bindParamOrderBy(reg)

		// query array param order_by
		if err := r.SetQueryParam("order_by", joinedOrderBy...); err != nil {
			return err
		}
	}

	if o.Port != nil {

		// query param port
		var qrPort int64

		if o.Port != nil {
			qrPort = *o.Port
		}
		qPort := swag.FormatInt64(qrPort)
		if qPort != "" {

			if err := r.SetQueryParam("port", qPort); err != nil {
				return err
			}
		}
	}

	if o.ProxyHost != nil {

		// query param proxy_host
		var qrProxyHost string

		if o.ProxyHost != nil {
			qrProxyHost = *o.ProxyHost
		}
		qProxyHost := qrProxyHost
		if qProxyHost != "" {

			if err := r.SetQueryParam("proxy_host", qProxyHost); err != nil {
				return err
			}
		}
	}

	if o.ProxyPort != nil {

		// query param proxy_port
		var qrProxyPort int64

		if o.ProxyPort != nil {
			qrProxyPort = *o.ProxyPort
		}
		qProxyPort := swag.FormatInt64(qrProxyPort)
		if qProxyPort != "" {

			if err := r.SetQueryParam("proxy_port", qProxyPort); err != nil {
				return err
			}
		}
	}

	if o.ProxyType != nil {

		// query param proxy_type
		var qrProxyType string

		if o.ProxyType != nil {
			qrProxyType = *o.ProxyType
		}
		qProxyType := qrProxyType
		if qProxyType != "" {

			if err := r.SetQueryParam("proxy_type", qProxyType); err != nil {
				return err
			}
		}
	}

	if o.ProxyUsername != nil {

		// query param proxy_username
		var qrProxyUsername string

		if o.ProxyUsername != nil {
			qrProxyUsername = *o.ProxyUsername
		}
		qProxyUsername := qrProxyUsername
		if qProxyUsername != "" {

			if err := r.SetQueryParam("proxy_username", qProxyUsername); err != nil {
				return err
			}
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.Scope != nil {

		// query param scope
		var qrScope string

		if o.Scope != nil {
			qrScope = *o.Scope
		}
		qScope := qrScope
		if qScope != "" {

			if err := r.SetQueryParam("scope", qScope); err != nil {
				return err
			}
		}
	}

	if o.SkipVerification != nil {

		// query param skip_verification
		var qrSkipVerification bool

		if o.SkipVerification != nil {
			qrSkipVerification = *o.SkipVerification
		}
		qSkipVerification := swag.FormatBool(qrSkipVerification)
		if qSkipVerification != "" {

			if err := r.SetQueryParam("skip_verification", qSkipVerification); err != nil {
				return err
			}
		}
	}

	if o.StateAvailable != nil {

		// query param state.available
		var qrStateAvailable bool

		if o.StateAvailable != nil {
			qrStateAvailable = *o.StateAvailable
		}
		qStateAvailable := swag.FormatBool(qrStateAvailable)
		if qStateAvailable != "" {

			if err := r.SetQueryParam("state.available", qStateAvailable); err != nil {
				return err
			}
		}
	}

	if o.StateCode != nil {

		// query param state.code
		var qrStateCode string

		if o.StateCode != nil {
			qrStateCode = *o.StateCode
		}
		qStateCode := qrStateCode
		if qStateCode != "" {

			if err := r.SetQueryParam("state.code", qStateCode); err != nil {
				return err
			}
		}
	}

	if o.StateMessage != nil {

		// query param state.message
		var qrStateMessage string

		if o.StateMessage != nil {
			qrStateMessage = *o.StateMessage
		}
		qStateMessage := qrStateMessage
		if qStateMessage != "" {

			if err := r.SetQueryParam("state.message", qStateMessage); err != nil {
				return err
			}
		}
	}

	if o.SvmName != nil {

		// query param svm.name
		var qrSvmName string

		if o.SvmName != nil {
			qrSvmName = *o.SvmName
		}
		qSvmName := qrSvmName
		if qSvmName != "" {

			if err := r.SetQueryParam("svm.name", qSvmName); err != nil {
				return err
			}
		}
	}

	if o.SvmUUID != nil {

		// query param svm.uuid
		var qrSvmUUID string

		if o.SvmUUID != nil {
			qrSvmUUID = *o.SvmUUID
		}
		qSvmUUID := qrSvmUUID
		if qSvmUUID != "" {

			if err := r.SetQueryParam("svm.uuid", qSvmUUID); err != nil {
				return err
			}
		}
	}

	if o.TenantID != nil {

		// query param tenant_id
		var qrTenantID string

		if o.TenantID != nil {
			qrTenantID = *o.TenantID
		}
		qTenantID := qrTenantID
		if qTenantID != "" {

			if err := r.SetQueryParam("tenant_id", qTenantID); err != nil {
				return err
			}
		}
	}

	if o.UUID != nil {

		// query param uuid
		var qrUUID string

		if o.UUID != nil {
			qrUUID = *o.UUID
		}
		qUUID := qrUUID
		if qUUID != "" {

			if err := r.SetQueryParam("uuid", qUUID); err != nil {
				return err
			}
		}
	}

	if o.VaultHost != nil {

		// query param vault_host
		var qrVaultHost string

		if o.VaultHost != nil {
			qrVaultHost = *o.VaultHost
		}
		qVaultHost := qrVaultHost
		if qVaultHost != "" {

			if err := r.SetQueryParam("vault_host", qVaultHost); err != nil {
				return err
			}
		}
	}

	if o.VerifyHost != nil {

		// query param verify_host
		var qrVerifyHost bool

		if o.VerifyHost != nil {
			qrVerifyHost = *o.VerifyHost
		}
		qVerifyHost := swag.FormatBool(qrVerifyHost)
		if qVerifyHost != "" {

			if err := r.SetQueryParam("verify_host", qVerifyHost); err != nil {
				return err
			}
		}
	}

	if o.VerifyIP != nil {

		// query param verify_ip
		var qrVerifyIP bool

		if o.VerifyIP != nil {
			qrVerifyIP = *o.VerifyIP
		}
		qVerifyIP := swag.FormatBool(qrVerifyIP)
		if qVerifyIP != "" {

			if err := r.SetQueryParam("verify_ip", qVerifyIP); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamAzureKeyVaultCollectionGet binds the parameter fields
func (o *AzureKeyVaultCollectionGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}

// bindParamAzureKeyVaultCollectionGet binds the parameter order_by
func (o *AzureKeyVaultCollectionGetParams) bindParamOrderBy(formats strfmt.Registry) []string {
	orderByIR := o.OrderBy

	var orderByIC []string
	for _, orderByIIR := range orderByIR { // explode []string

		orderByIIV := orderByIIR // string as string
		orderByIC = append(orderByIC, orderByIIV)
	}

	// items.CollectionFormat: "csv"
	orderByIS := swag.JoinByFormat(orderByIC, "csv")

	return orderByIS
}
