// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// AzureKeyVaultCreateReader is a Reader for the AzureKeyVaultCreate structure.
type AzureKeyVaultCreateReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *AzureKeyVaultCreateReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 201:
		result := NewAzureKeyVaultCreateCreated()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 202:
		result := NewAzureKeyVaultCreateAccepted()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewAzureKeyVaultCreateDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewAzureKeyVaultCreateCreated creates a AzureKeyVaultCreateCreated with default headers values
func NewAzureKeyVaultCreateCreated() *AzureKeyVaultCreateCreated {
	return &AzureKeyVaultCreateCreated{}
}

/*
AzureKeyVaultCreateCreated describes a response with status code 201, with default header values.

Created
*/
type AzureKeyVaultCreateCreated struct {

	/* Useful for tracking the resource location
	 */
	Location string

	Payload *models.AzureKeyVaultResponse
}

// IsSuccess returns true when this azure key vault create created response has a 2xx status code
func (o *AzureKeyVaultCreateCreated) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this azure key vault create created response has a 3xx status code
func (o *AzureKeyVaultCreateCreated) IsRedirect() bool {
	return false
}

// IsClientError returns true when this azure key vault create created response has a 4xx status code
func (o *AzureKeyVaultCreateCreated) IsClientError() bool {
	return false
}

// IsServerError returns true when this azure key vault create created response has a 5xx status code
func (o *AzureKeyVaultCreateCreated) IsServerError() bool {
	return false
}

// IsCode returns true when this azure key vault create created response a status code equal to that given
func (o *AzureKeyVaultCreateCreated) IsCode(code int) bool {
	return code == 201
}

// Code gets the status code for the azure key vault create created response
func (o *AzureKeyVaultCreateCreated) Code() int {
	return 201
}

func (o *AzureKeyVaultCreateCreated) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /security/azure-key-vaults][%d] azureKeyVaultCreateCreated %s", 201, payload)
}

func (o *AzureKeyVaultCreateCreated) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /security/azure-key-vaults][%d] azureKeyVaultCreateCreated %s", 201, payload)
}

func (o *AzureKeyVaultCreateCreated) GetPayload() *models.AzureKeyVaultResponse {
	return o.Payload
}

func (o *AzureKeyVaultCreateCreated) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header Location
	hdrLocation := response.GetHeader("Location")

	if hdrLocation != "" {
		o.Location = hdrLocation
	}

	o.Payload = new(models.AzureKeyVaultResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewAzureKeyVaultCreateAccepted creates a AzureKeyVaultCreateAccepted with default headers values
func NewAzureKeyVaultCreateAccepted() *AzureKeyVaultCreateAccepted {
	return &AzureKeyVaultCreateAccepted{}
}

/*
AzureKeyVaultCreateAccepted describes a response with status code 202, with default header values.

Accepted
*/
type AzureKeyVaultCreateAccepted struct {

	/* Useful for tracking the resource location
	 */
	Location string

	Payload *models.AzureKeyVaultJobLinkResponse
}

// IsSuccess returns true when this azure key vault create accepted response has a 2xx status code
func (o *AzureKeyVaultCreateAccepted) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this azure key vault create accepted response has a 3xx status code
func (o *AzureKeyVaultCreateAccepted) IsRedirect() bool {
	return false
}

// IsClientError returns true when this azure key vault create accepted response has a 4xx status code
func (o *AzureKeyVaultCreateAccepted) IsClientError() bool {
	return false
}

// IsServerError returns true when this azure key vault create accepted response has a 5xx status code
func (o *AzureKeyVaultCreateAccepted) IsServerError() bool {
	return false
}

// IsCode returns true when this azure key vault create accepted response a status code equal to that given
func (o *AzureKeyVaultCreateAccepted) IsCode(code int) bool {
	return code == 202
}

// Code gets the status code for the azure key vault create accepted response
func (o *AzureKeyVaultCreateAccepted) Code() int {
	return 202
}

func (o *AzureKeyVaultCreateAccepted) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /security/azure-key-vaults][%d] azureKeyVaultCreateAccepted %s", 202, payload)
}

func (o *AzureKeyVaultCreateAccepted) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /security/azure-key-vaults][%d] azureKeyVaultCreateAccepted %s", 202, payload)
}

func (o *AzureKeyVaultCreateAccepted) GetPayload() *models.AzureKeyVaultJobLinkResponse {
	return o.Payload
}

func (o *AzureKeyVaultCreateAccepted) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header Location
	hdrLocation := response.GetHeader("Location")

	if hdrLocation != "" {
		o.Location = hdrLocation
	}

	o.Payload = new(models.AzureKeyVaultJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewAzureKeyVaultCreateDefault creates a AzureKeyVaultCreateDefault with default headers values
func NewAzureKeyVaultCreateDefault(code int) *AzureKeyVaultCreateDefault {
	return &AzureKeyVaultCreateDefault{
		_statusCode: code,
	}
}

/*
	AzureKeyVaultCreateDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 3735553 | Failed to create self-signed certificate. |
| 3735664 | The specified key size is not supported in FIPS mode. |
| 3735665 | The specified hash function is not supported in FIPS mode. |
| 3735700 | The specified key size is not supported. |
| 52559972 | The certificates start date is later than the current date. |
| 65537500 | A key manager has already been configured for this SVM. |
| 65537504 | Internal error. Failed to store configuration in internal database. |
| 65537505 | One or more volume encryption keys of the given SVM are stored on a key manager configured for the admin SVM. |
| 65537506 | AKV is not supported in MetroCluster configurations. |
| 65537512 | AKV cannot be configured for the given SVM as not all nodes in the cluster can enable the Azure Key Vault feature. |
| 65537514 | Failed to check if the Azure Key Vault feature is enabled. |
| 65537518 | Failed to find an interface with Cluster role. |
| 65537523 | Invalid key ID format. Example key ID format\":" "https://mykeyvault.vault.azure.net/keys/key1/a8e619fd8f234db3b0b95c59540e2a74". |
| 65537526 | Failed to enable Azure Key Vault feature. |
| 65537553 | Invalid vault name format. Example vault name format\":" "https://mykeyvault.vault.azure.net". |
| 65537567 | No authentication method provided. |
| 65537573 | Invalid client certificate. |
| 65537589 | The specified configuration.name already exists on the given SVM. |
| 65537592 | The configuration.name field requires an ECV of 9.14.0 or greater. |
| 65537593 | The create_inactive flag requires an effective cluster version of 9.14.0 or greater. |
| 65537594 | The configuration.name field is required when the create_inactive flag is set to true. |
| 65537595 | The configuration.name field can only be specified when the create_inactive flag is set to true. |
| 65538902 | The configuration.name is reserved for use by the system. |
| 65538903 | The configuration.name field cannot be an empty string. |
| 65539704 | The key manager cannot be configured because the SVM has NAE volumes. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type AzureKeyVaultCreateDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this azure key vault create default response has a 2xx status code
func (o *AzureKeyVaultCreateDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this azure key vault create default response has a 3xx status code
func (o *AzureKeyVaultCreateDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this azure key vault create default response has a 4xx status code
func (o *AzureKeyVaultCreateDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this azure key vault create default response has a 5xx status code
func (o *AzureKeyVaultCreateDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this azure key vault create default response a status code equal to that given
func (o *AzureKeyVaultCreateDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the azure key vault create default response
func (o *AzureKeyVaultCreateDefault) Code() int {
	return o._statusCode
}

func (o *AzureKeyVaultCreateDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /security/azure-key-vaults][%d] azure_key_vault_create default %s", o._statusCode, payload)
}

func (o *AzureKeyVaultCreateDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /security/azure-key-vaults][%d] azure_key_vault_create default %s", o._statusCode, payload)
}

func (o *AzureKeyVaultCreateDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *AzureKeyVaultCreateDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
