// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewAzureKeyVaultDeleteCollectionParams creates a new AzureKeyVaultDeleteCollectionParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewAzureKeyVaultDeleteCollectionParams() *AzureKeyVaultDeleteCollectionParams {
	return &AzureKeyVaultDeleteCollectionParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewAzureKeyVaultDeleteCollectionParamsWithTimeout creates a new AzureKeyVaultDeleteCollectionParams object
// with the ability to set a timeout on a request.
func NewAzureKeyVaultDeleteCollectionParamsWithTimeout(timeout time.Duration) *AzureKeyVaultDeleteCollectionParams {
	return &AzureKeyVaultDeleteCollectionParams{
		timeout: timeout,
	}
}

// NewAzureKeyVaultDeleteCollectionParamsWithContext creates a new AzureKeyVaultDeleteCollectionParams object
// with the ability to set a context for a request.
func NewAzureKeyVaultDeleteCollectionParamsWithContext(ctx context.Context) *AzureKeyVaultDeleteCollectionParams {
	return &AzureKeyVaultDeleteCollectionParams{
		Context: ctx,
	}
}

// NewAzureKeyVaultDeleteCollectionParamsWithHTTPClient creates a new AzureKeyVaultDeleteCollectionParams object
// with the ability to set a custom HTTPClient for a request.
func NewAzureKeyVaultDeleteCollectionParamsWithHTTPClient(client *http.Client) *AzureKeyVaultDeleteCollectionParams {
	return &AzureKeyVaultDeleteCollectionParams{
		HTTPClient: client,
	}
}

/*
AzureKeyVaultDeleteCollectionParams contains all the parameters to send to the API endpoint

	for the azure key vault delete collection operation.

	Typically these are written to a http.Request.
*/
type AzureKeyVaultDeleteCollectionParams struct {

	/* AuthenticationMethod.

	   Filter by authentication_method
	*/
	AuthenticationMethod *string

	/* AzureReachabilityCode.

	   Filter by azure_reachability.code
	*/
	AzureReachabilityCode *string

	/* AzureReachabilityMessage.

	   Filter by azure_reachability.message
	*/
	AzureReachabilityMessage *string

	/* AzureReachabilityReachable.

	   Filter by azure_reachability.reachable
	*/
	AzureReachabilityReachable *bool

	/* ClientID.

	   Filter by client_id
	*/
	ClientID *string

	/* ConfigurationName.

	   Filter by configuration.name
	*/
	ConfigurationName *string

	/* ConfigurationUUID.

	   Filter by configuration.uuid
	*/
	ConfigurationUUID *string

	/* ContinueOnFailure.

	   Continue even when the operation fails on one of the records.
	*/
	ContinueOnFailure *bool

	/* EkmipReachabilityCode.

	   Filter by ekmip_reachability.code
	*/
	EkmipReachabilityCode *string

	/* EkmipReachabilityMessage.

	   Filter by ekmip_reachability.message
	*/
	EkmipReachabilityMessage *string

	/* EkmipReachabilityNodeName.

	   Filter by ekmip_reachability.node.name
	*/
	EkmipReachabilityNodeName *string

	/* EkmipReachabilityNodeUUID.

	   Filter by ekmip_reachability.node.uuid
	*/
	EkmipReachabilityNodeUUID *string

	/* EkmipReachabilityReachable.

	   Filter by ekmip_reachability.reachable
	*/
	EkmipReachabilityReachable *bool

	/* Enabled.

	   Filter by enabled
	*/
	Enabled *bool

	/* Info.

	   Info specification
	*/
	Info AzureKeyVaultDeleteCollectionBody

	/* KeyID.

	   Filter by key_id
	*/
	KeyID *string

	/* Name.

	   Filter by name
	*/
	Name *string

	/* OauthHost.

	   Filter by oauth_host
	*/
	OauthHost *string

	/* Port.

	   Filter by port
	*/
	Port *int64

	/* ProxyHost.

	   Filter by proxy_host
	*/
	ProxyHost *string

	/* ProxyPort.

	   Filter by proxy_port
	*/
	ProxyPort *int64

	/* ProxyType.

	   Filter by proxy_type
	*/
	ProxyType *string

	/* ProxyUsername.

	   Filter by proxy_username
	*/
	ProxyUsername *string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* Scope.

	   Filter by scope
	*/
	Scope *string

	/* SerialRecords.

	   Perform the operation on the records synchronously.
	*/
	SerialRecords *bool

	/* SkipVerification.

	   Filter by skip_verification
	*/
	SkipVerification *bool

	/* StateAvailable.

	   Filter by state.available
	*/
	StateAvailable *bool

	/* StateCode.

	   Filter by state.code
	*/
	StateCode *string

	/* StateMessage.

	   Filter by state.message
	*/
	StateMessage *string

	/* SvmName.

	   Filter by svm.name
	*/
	SvmName *string

	/* SvmUUID.

	   Filter by svm.uuid
	*/
	SvmUUID *string

	/* TenantID.

	   Filter by tenant_id
	*/
	TenantID *string

	/* UUID.

	   Filter by uuid
	*/
	UUID *string

	/* VaultHost.

	   Filter by vault_host
	*/
	VaultHost *string

	/* VerifyHost.

	   Filter by verify_host
	*/
	VerifyHost *bool

	/* VerifyIP.

	   Filter by verify_ip
	*/
	VerifyIP *bool

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the azure key vault delete collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *AzureKeyVaultDeleteCollectionParams) WithDefaults() *AzureKeyVaultDeleteCollectionParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the azure key vault delete collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *AzureKeyVaultDeleteCollectionParams) SetDefaults() {
	var (
		continueOnFailureDefault = bool(false)

		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)

		serialRecordsDefault = bool(false)
	)

	val := AzureKeyVaultDeleteCollectionParams{
		ContinueOnFailure: &continueOnFailureDefault,
		ReturnRecords:     &returnRecordsDefault,
		ReturnTimeout:     &returnTimeoutDefault,
		SerialRecords:     &serialRecordsDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the azure key vault delete collection params
func (o *AzureKeyVaultDeleteCollectionParams) WithTimeout(timeout time.Duration) *AzureKeyVaultDeleteCollectionParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the azure key vault delete collection params
func (o *AzureKeyVaultDeleteCollectionParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the azure key vault delete collection params
func (o *AzureKeyVaultDeleteCollectionParams) WithContext(ctx context.Context) *AzureKeyVaultDeleteCollectionParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the azure key vault delete collection params
func (o *AzureKeyVaultDeleteCollectionParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the azure key vault delete collection params
func (o *AzureKeyVaultDeleteCollectionParams) WithHTTPClient(client *http.Client) *AzureKeyVaultDeleteCollectionParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the azure key vault delete collection params
func (o *AzureKeyVaultDeleteCollectionParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithAuthenticationMethod adds the authenticationMethod to the azure key vault delete collection params
func (o *AzureKeyVaultDeleteCollectionParams) WithAuthenticationMethod(authenticationMethod *string) *AzureKeyVaultDeleteCollectionParams {
	o.SetAuthenticationMethod(authenticationMethod)
	return o
}

// SetAuthenticationMethod adds the authenticationMethod to the azure key vault delete collection params
func (o *AzureKeyVaultDeleteCollectionParams) SetAuthenticationMethod(authenticationMethod *string) {
	o.AuthenticationMethod = authenticationMethod
}

// WithAzureReachabilityCode adds the azureReachabilityCode to the azure key vault delete collection params
func (o *AzureKeyVaultDeleteCollectionParams) WithAzureReachabilityCode(azureReachabilityCode *string) *AzureKeyVaultDeleteCollectionParams {
	o.SetAzureReachabilityCode(azureReachabilityCode)
	return o
}

// SetAzureReachabilityCode adds the azureReachabilityCode to the azure key vault delete collection params
func (o *AzureKeyVaultDeleteCollectionParams) SetAzureReachabilityCode(azureReachabilityCode *string) {
	o.AzureReachabilityCode = azureReachabilityCode
}

// WithAzureReachabilityMessage adds the azureReachabilityMessage to the azure key vault delete collection params
func (o *AzureKeyVaultDeleteCollectionParams) WithAzureReachabilityMessage(azureReachabilityMessage *string) *AzureKeyVaultDeleteCollectionParams {
	o.SetAzureReachabilityMessage(azureReachabilityMessage)
	return o
}

// SetAzureReachabilityMessage adds the azureReachabilityMessage to the azure key vault delete collection params
func (o *AzureKeyVaultDeleteCollectionParams) SetAzureReachabilityMessage(azureReachabilityMessage *string) {
	o.AzureReachabilityMessage = azureReachabilityMessage
}

// WithAzureReachabilityReachable adds the azureReachabilityReachable to the azure key vault delete collection params
func (o *AzureKeyVaultDeleteCollectionParams) WithAzureReachabilityReachable(azureReachabilityReachable *bool) *AzureKeyVaultDeleteCollectionParams {
	o.SetAzureReachabilityReachable(azureReachabilityReachable)
	return o
}

// SetAzureReachabilityReachable adds the azureReachabilityReachable to the azure key vault delete collection params
func (o *AzureKeyVaultDeleteCollectionParams) SetAzureReachabilityReachable(azureReachabilityReachable *bool) {
	o.AzureReachabilityReachable = azureReachabilityReachable
}

// WithClientID adds the clientID to the azure key vault delete collection params
func (o *AzureKeyVaultDeleteCollectionParams) WithClientID(clientID *string) *AzureKeyVaultDeleteCollectionParams {
	o.SetClientID(clientID)
	return o
}

// SetClientID adds the clientId to the azure key vault delete collection params
func (o *AzureKeyVaultDeleteCollectionParams) SetClientID(clientID *string) {
	o.ClientID = clientID
}

// WithConfigurationName adds the configurationName to the azure key vault delete collection params
func (o *AzureKeyVaultDeleteCollectionParams) WithConfigurationName(configurationName *string) *AzureKeyVaultDeleteCollectionParams {
	o.SetConfigurationName(configurationName)
	return o
}

// SetConfigurationName adds the configurationName to the azure key vault delete collection params
func (o *AzureKeyVaultDeleteCollectionParams) SetConfigurationName(configurationName *string) {
	o.ConfigurationName = configurationName
}

// WithConfigurationUUID adds the configurationUUID to the azure key vault delete collection params
func (o *AzureKeyVaultDeleteCollectionParams) WithConfigurationUUID(configurationUUID *string) *AzureKeyVaultDeleteCollectionParams {
	o.SetConfigurationUUID(configurationUUID)
	return o
}

// SetConfigurationUUID adds the configurationUuid to the azure key vault delete collection params
func (o *AzureKeyVaultDeleteCollectionParams) SetConfigurationUUID(configurationUUID *string) {
	o.ConfigurationUUID = configurationUUID
}

// WithContinueOnFailure adds the continueOnFailure to the azure key vault delete collection params
func (o *AzureKeyVaultDeleteCollectionParams) WithContinueOnFailure(continueOnFailure *bool) *AzureKeyVaultDeleteCollectionParams {
	o.SetContinueOnFailure(continueOnFailure)
	return o
}

// SetContinueOnFailure adds the continueOnFailure to the azure key vault delete collection params
func (o *AzureKeyVaultDeleteCollectionParams) SetContinueOnFailure(continueOnFailure *bool) {
	o.ContinueOnFailure = continueOnFailure
}

// WithEkmipReachabilityCode adds the ekmipReachabilityCode to the azure key vault delete collection params
func (o *AzureKeyVaultDeleteCollectionParams) WithEkmipReachabilityCode(ekmipReachabilityCode *string) *AzureKeyVaultDeleteCollectionParams {
	o.SetEkmipReachabilityCode(ekmipReachabilityCode)
	return o
}

// SetEkmipReachabilityCode adds the ekmipReachabilityCode to the azure key vault delete collection params
func (o *AzureKeyVaultDeleteCollectionParams) SetEkmipReachabilityCode(ekmipReachabilityCode *string) {
	o.EkmipReachabilityCode = ekmipReachabilityCode
}

// WithEkmipReachabilityMessage adds the ekmipReachabilityMessage to the azure key vault delete collection params
func (o *AzureKeyVaultDeleteCollectionParams) WithEkmipReachabilityMessage(ekmipReachabilityMessage *string) *AzureKeyVaultDeleteCollectionParams {
	o.SetEkmipReachabilityMessage(ekmipReachabilityMessage)
	return o
}

// SetEkmipReachabilityMessage adds the ekmipReachabilityMessage to the azure key vault delete collection params
func (o *AzureKeyVaultDeleteCollectionParams) SetEkmipReachabilityMessage(ekmipReachabilityMessage *string) {
	o.EkmipReachabilityMessage = ekmipReachabilityMessage
}

// WithEkmipReachabilityNodeName adds the ekmipReachabilityNodeName to the azure key vault delete collection params
func (o *AzureKeyVaultDeleteCollectionParams) WithEkmipReachabilityNodeName(ekmipReachabilityNodeName *string) *AzureKeyVaultDeleteCollectionParams {
	o.SetEkmipReachabilityNodeName(ekmipReachabilityNodeName)
	return o
}

// SetEkmipReachabilityNodeName adds the ekmipReachabilityNodeName to the azure key vault delete collection params
func (o *AzureKeyVaultDeleteCollectionParams) SetEkmipReachabilityNodeName(ekmipReachabilityNodeName *string) {
	o.EkmipReachabilityNodeName = ekmipReachabilityNodeName
}

// WithEkmipReachabilityNodeUUID adds the ekmipReachabilityNodeUUID to the azure key vault delete collection params
func (o *AzureKeyVaultDeleteCollectionParams) WithEkmipReachabilityNodeUUID(ekmipReachabilityNodeUUID *string) *AzureKeyVaultDeleteCollectionParams {
	o.SetEkmipReachabilityNodeUUID(ekmipReachabilityNodeUUID)
	return o
}

// SetEkmipReachabilityNodeUUID adds the ekmipReachabilityNodeUuid to the azure key vault delete collection params
func (o *AzureKeyVaultDeleteCollectionParams) SetEkmipReachabilityNodeUUID(ekmipReachabilityNodeUUID *string) {
	o.EkmipReachabilityNodeUUID = ekmipReachabilityNodeUUID
}

// WithEkmipReachabilityReachable adds the ekmipReachabilityReachable to the azure key vault delete collection params
func (o *AzureKeyVaultDeleteCollectionParams) WithEkmipReachabilityReachable(ekmipReachabilityReachable *bool) *AzureKeyVaultDeleteCollectionParams {
	o.SetEkmipReachabilityReachable(ekmipReachabilityReachable)
	return o
}

// SetEkmipReachabilityReachable adds the ekmipReachabilityReachable to the azure key vault delete collection params
func (o *AzureKeyVaultDeleteCollectionParams) SetEkmipReachabilityReachable(ekmipReachabilityReachable *bool) {
	o.EkmipReachabilityReachable = ekmipReachabilityReachable
}

// WithEnabled adds the enabled to the azure key vault delete collection params
func (o *AzureKeyVaultDeleteCollectionParams) WithEnabled(enabled *bool) *AzureKeyVaultDeleteCollectionParams {
	o.SetEnabled(enabled)
	return o
}

// SetEnabled adds the enabled to the azure key vault delete collection params
func (o *AzureKeyVaultDeleteCollectionParams) SetEnabled(enabled *bool) {
	o.Enabled = enabled
}

// WithInfo adds the info to the azure key vault delete collection params
func (o *AzureKeyVaultDeleteCollectionParams) WithInfo(info AzureKeyVaultDeleteCollectionBody) *AzureKeyVaultDeleteCollectionParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the azure key vault delete collection params
func (o *AzureKeyVaultDeleteCollectionParams) SetInfo(info AzureKeyVaultDeleteCollectionBody) {
	o.Info = info
}

// WithKeyID adds the keyID to the azure key vault delete collection params
func (o *AzureKeyVaultDeleteCollectionParams) WithKeyID(keyID *string) *AzureKeyVaultDeleteCollectionParams {
	o.SetKeyID(keyID)
	return o
}

// SetKeyID adds the keyId to the azure key vault delete collection params
func (o *AzureKeyVaultDeleteCollectionParams) SetKeyID(keyID *string) {
	o.KeyID = keyID
}

// WithName adds the name to the azure key vault delete collection params
func (o *AzureKeyVaultDeleteCollectionParams) WithName(name *string) *AzureKeyVaultDeleteCollectionParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the azure key vault delete collection params
func (o *AzureKeyVaultDeleteCollectionParams) SetName(name *string) {
	o.Name = name
}

// WithOauthHost adds the oauthHost to the azure key vault delete collection params
func (o *AzureKeyVaultDeleteCollectionParams) WithOauthHost(oauthHost *string) *AzureKeyVaultDeleteCollectionParams {
	o.SetOauthHost(oauthHost)
	return o
}

// SetOauthHost adds the oauthHost to the azure key vault delete collection params
func (o *AzureKeyVaultDeleteCollectionParams) SetOauthHost(oauthHost *string) {
	o.OauthHost = oauthHost
}

// WithPort adds the port to the azure key vault delete collection params
func (o *AzureKeyVaultDeleteCollectionParams) WithPort(port *int64) *AzureKeyVaultDeleteCollectionParams {
	o.SetPort(port)
	return o
}

// SetPort adds the port to the azure key vault delete collection params
func (o *AzureKeyVaultDeleteCollectionParams) SetPort(port *int64) {
	o.Port = port
}

// WithProxyHost adds the proxyHost to the azure key vault delete collection params
func (o *AzureKeyVaultDeleteCollectionParams) WithProxyHost(proxyHost *string) *AzureKeyVaultDeleteCollectionParams {
	o.SetProxyHost(proxyHost)
	return o
}

// SetProxyHost adds the proxyHost to the azure key vault delete collection params
func (o *AzureKeyVaultDeleteCollectionParams) SetProxyHost(proxyHost *string) {
	o.ProxyHost = proxyHost
}

// WithProxyPort adds the proxyPort to the azure key vault delete collection params
func (o *AzureKeyVaultDeleteCollectionParams) WithProxyPort(proxyPort *int64) *AzureKeyVaultDeleteCollectionParams {
	o.SetProxyPort(proxyPort)
	return o
}

// SetProxyPort adds the proxyPort to the azure key vault delete collection params
func (o *AzureKeyVaultDeleteCollectionParams) SetProxyPort(proxyPort *int64) {
	o.ProxyPort = proxyPort
}

// WithProxyType adds the proxyType to the azure key vault delete collection params
func (o *AzureKeyVaultDeleteCollectionParams) WithProxyType(proxyType *string) *AzureKeyVaultDeleteCollectionParams {
	o.SetProxyType(proxyType)
	return o
}

// SetProxyType adds the proxyType to the azure key vault delete collection params
func (o *AzureKeyVaultDeleteCollectionParams) SetProxyType(proxyType *string) {
	o.ProxyType = proxyType
}

// WithProxyUsername adds the proxyUsername to the azure key vault delete collection params
func (o *AzureKeyVaultDeleteCollectionParams) WithProxyUsername(proxyUsername *string) *AzureKeyVaultDeleteCollectionParams {
	o.SetProxyUsername(proxyUsername)
	return o
}

// SetProxyUsername adds the proxyUsername to the azure key vault delete collection params
func (o *AzureKeyVaultDeleteCollectionParams) SetProxyUsername(proxyUsername *string) {
	o.ProxyUsername = proxyUsername
}

// WithReturnRecords adds the returnRecords to the azure key vault delete collection params
func (o *AzureKeyVaultDeleteCollectionParams) WithReturnRecords(returnRecords *bool) *AzureKeyVaultDeleteCollectionParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the azure key vault delete collection params
func (o *AzureKeyVaultDeleteCollectionParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the azure key vault delete collection params
func (o *AzureKeyVaultDeleteCollectionParams) WithReturnTimeout(returnTimeout *int64) *AzureKeyVaultDeleteCollectionParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the azure key vault delete collection params
func (o *AzureKeyVaultDeleteCollectionParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithScope adds the scope to the azure key vault delete collection params
func (o *AzureKeyVaultDeleteCollectionParams) WithScope(scope *string) *AzureKeyVaultDeleteCollectionParams {
	o.SetScope(scope)
	return o
}

// SetScope adds the scope to the azure key vault delete collection params
func (o *AzureKeyVaultDeleteCollectionParams) SetScope(scope *string) {
	o.Scope = scope
}

// WithSerialRecords adds the serialRecords to the azure key vault delete collection params
func (o *AzureKeyVaultDeleteCollectionParams) WithSerialRecords(serialRecords *bool) *AzureKeyVaultDeleteCollectionParams {
	o.SetSerialRecords(serialRecords)
	return o
}

// SetSerialRecords adds the serialRecords to the azure key vault delete collection params
func (o *AzureKeyVaultDeleteCollectionParams) SetSerialRecords(serialRecords *bool) {
	o.SerialRecords = serialRecords
}

// WithSkipVerification adds the skipVerification to the azure key vault delete collection params
func (o *AzureKeyVaultDeleteCollectionParams) WithSkipVerification(skipVerification *bool) *AzureKeyVaultDeleteCollectionParams {
	o.SetSkipVerification(skipVerification)
	return o
}

// SetSkipVerification adds the skipVerification to the azure key vault delete collection params
func (o *AzureKeyVaultDeleteCollectionParams) SetSkipVerification(skipVerification *bool) {
	o.SkipVerification = skipVerification
}

// WithStateAvailable adds the stateAvailable to the azure key vault delete collection params
func (o *AzureKeyVaultDeleteCollectionParams) WithStateAvailable(stateAvailable *bool) *AzureKeyVaultDeleteCollectionParams {
	o.SetStateAvailable(stateAvailable)
	return o
}

// SetStateAvailable adds the stateAvailable to the azure key vault delete collection params
func (o *AzureKeyVaultDeleteCollectionParams) SetStateAvailable(stateAvailable *bool) {
	o.StateAvailable = stateAvailable
}

// WithStateCode adds the stateCode to the azure key vault delete collection params
func (o *AzureKeyVaultDeleteCollectionParams) WithStateCode(stateCode *string) *AzureKeyVaultDeleteCollectionParams {
	o.SetStateCode(stateCode)
	return o
}

// SetStateCode adds the stateCode to the azure key vault delete collection params
func (o *AzureKeyVaultDeleteCollectionParams) SetStateCode(stateCode *string) {
	o.StateCode = stateCode
}

// WithStateMessage adds the stateMessage to the azure key vault delete collection params
func (o *AzureKeyVaultDeleteCollectionParams) WithStateMessage(stateMessage *string) *AzureKeyVaultDeleteCollectionParams {
	o.SetStateMessage(stateMessage)
	return o
}

// SetStateMessage adds the stateMessage to the azure key vault delete collection params
func (o *AzureKeyVaultDeleteCollectionParams) SetStateMessage(stateMessage *string) {
	o.StateMessage = stateMessage
}

// WithSvmName adds the svmName to the azure key vault delete collection params
func (o *AzureKeyVaultDeleteCollectionParams) WithSvmName(svmName *string) *AzureKeyVaultDeleteCollectionParams {
	o.SetSvmName(svmName)
	return o
}

// SetSvmName adds the svmName to the azure key vault delete collection params
func (o *AzureKeyVaultDeleteCollectionParams) SetSvmName(svmName *string) {
	o.SvmName = svmName
}

// WithSvmUUID adds the svmUUID to the azure key vault delete collection params
func (o *AzureKeyVaultDeleteCollectionParams) WithSvmUUID(svmUUID *string) *AzureKeyVaultDeleteCollectionParams {
	o.SetSvmUUID(svmUUID)
	return o
}

// SetSvmUUID adds the svmUuid to the azure key vault delete collection params
func (o *AzureKeyVaultDeleteCollectionParams) SetSvmUUID(svmUUID *string) {
	o.SvmUUID = svmUUID
}

// WithTenantID adds the tenantID to the azure key vault delete collection params
func (o *AzureKeyVaultDeleteCollectionParams) WithTenantID(tenantID *string) *AzureKeyVaultDeleteCollectionParams {
	o.SetTenantID(tenantID)
	return o
}

// SetTenantID adds the tenantId to the azure key vault delete collection params
func (o *AzureKeyVaultDeleteCollectionParams) SetTenantID(tenantID *string) {
	o.TenantID = tenantID
}

// WithUUID adds the uuid to the azure key vault delete collection params
func (o *AzureKeyVaultDeleteCollectionParams) WithUUID(uuid *string) *AzureKeyVaultDeleteCollectionParams {
	o.SetUUID(uuid)
	return o
}

// SetUUID adds the uuid to the azure key vault delete collection params
func (o *AzureKeyVaultDeleteCollectionParams) SetUUID(uuid *string) {
	o.UUID = uuid
}

// WithVaultHost adds the vaultHost to the azure key vault delete collection params
func (o *AzureKeyVaultDeleteCollectionParams) WithVaultHost(vaultHost *string) *AzureKeyVaultDeleteCollectionParams {
	o.SetVaultHost(vaultHost)
	return o
}

// SetVaultHost adds the vaultHost to the azure key vault delete collection params
func (o *AzureKeyVaultDeleteCollectionParams) SetVaultHost(vaultHost *string) {
	o.VaultHost = vaultHost
}

// WithVerifyHost adds the verifyHost to the azure key vault delete collection params
func (o *AzureKeyVaultDeleteCollectionParams) WithVerifyHost(verifyHost *bool) *AzureKeyVaultDeleteCollectionParams {
	o.SetVerifyHost(verifyHost)
	return o
}

// SetVerifyHost adds the verifyHost to the azure key vault delete collection params
func (o *AzureKeyVaultDeleteCollectionParams) SetVerifyHost(verifyHost *bool) {
	o.VerifyHost = verifyHost
}

// WithVerifyIP adds the verifyIP to the azure key vault delete collection params
func (o *AzureKeyVaultDeleteCollectionParams) WithVerifyIP(verifyIP *bool) *AzureKeyVaultDeleteCollectionParams {
	o.SetVerifyIP(verifyIP)
	return o
}

// SetVerifyIP adds the verifyIp to the azure key vault delete collection params
func (o *AzureKeyVaultDeleteCollectionParams) SetVerifyIP(verifyIP *bool) {
	o.VerifyIP = verifyIP
}

// WriteToRequest writes these params to a swagger request
func (o *AzureKeyVaultDeleteCollectionParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.AuthenticationMethod != nil {

		// query param authentication_method
		var qrAuthenticationMethod string

		if o.AuthenticationMethod != nil {
			qrAuthenticationMethod = *o.AuthenticationMethod
		}
		qAuthenticationMethod := qrAuthenticationMethod
		if qAuthenticationMethod != "" {

			if err := r.SetQueryParam("authentication_method", qAuthenticationMethod); err != nil {
				return err
			}
		}
	}

	if o.AzureReachabilityCode != nil {

		// query param azure_reachability.code
		var qrAzureReachabilityCode string

		if o.AzureReachabilityCode != nil {
			qrAzureReachabilityCode = *o.AzureReachabilityCode
		}
		qAzureReachabilityCode := qrAzureReachabilityCode
		if qAzureReachabilityCode != "" {

			if err := r.SetQueryParam("azure_reachability.code", qAzureReachabilityCode); err != nil {
				return err
			}
		}
	}

	if o.AzureReachabilityMessage != nil {

		// query param azure_reachability.message
		var qrAzureReachabilityMessage string

		if o.AzureReachabilityMessage != nil {
			qrAzureReachabilityMessage = *o.AzureReachabilityMessage
		}
		qAzureReachabilityMessage := qrAzureReachabilityMessage
		if qAzureReachabilityMessage != "" {

			if err := r.SetQueryParam("azure_reachability.message", qAzureReachabilityMessage); err != nil {
				return err
			}
		}
	}

	if o.AzureReachabilityReachable != nil {

		// query param azure_reachability.reachable
		var qrAzureReachabilityReachable bool

		if o.AzureReachabilityReachable != nil {
			qrAzureReachabilityReachable = *o.AzureReachabilityReachable
		}
		qAzureReachabilityReachable := swag.FormatBool(qrAzureReachabilityReachable)
		if qAzureReachabilityReachable != "" {

			if err := r.SetQueryParam("azure_reachability.reachable", qAzureReachabilityReachable); err != nil {
				return err
			}
		}
	}

	if o.ClientID != nil {

		// query param client_id
		var qrClientID string

		if o.ClientID != nil {
			qrClientID = *o.ClientID
		}
		qClientID := qrClientID
		if qClientID != "" {

			if err := r.SetQueryParam("client_id", qClientID); err != nil {
				return err
			}
		}
	}

	if o.ConfigurationName != nil {

		// query param configuration.name
		var qrConfigurationName string

		if o.ConfigurationName != nil {
			qrConfigurationName = *o.ConfigurationName
		}
		qConfigurationName := qrConfigurationName
		if qConfigurationName != "" {

			if err := r.SetQueryParam("configuration.name", qConfigurationName); err != nil {
				return err
			}
		}
	}

	if o.ConfigurationUUID != nil {

		// query param configuration.uuid
		var qrConfigurationUUID string

		if o.ConfigurationUUID != nil {
			qrConfigurationUUID = *o.ConfigurationUUID
		}
		qConfigurationUUID := qrConfigurationUUID
		if qConfigurationUUID != "" {

			if err := r.SetQueryParam("configuration.uuid", qConfigurationUUID); err != nil {
				return err
			}
		}
	}

	if o.ContinueOnFailure != nil {

		// query param continue_on_failure
		var qrContinueOnFailure bool

		if o.ContinueOnFailure != nil {
			qrContinueOnFailure = *o.ContinueOnFailure
		}
		qContinueOnFailure := swag.FormatBool(qrContinueOnFailure)
		if qContinueOnFailure != "" {

			if err := r.SetQueryParam("continue_on_failure", qContinueOnFailure); err != nil {
				return err
			}
		}
	}

	if o.EkmipReachabilityCode != nil {

		// query param ekmip_reachability.code
		var qrEkmipReachabilityCode string

		if o.EkmipReachabilityCode != nil {
			qrEkmipReachabilityCode = *o.EkmipReachabilityCode
		}
		qEkmipReachabilityCode := qrEkmipReachabilityCode
		if qEkmipReachabilityCode != "" {

			if err := r.SetQueryParam("ekmip_reachability.code", qEkmipReachabilityCode); err != nil {
				return err
			}
		}
	}

	if o.EkmipReachabilityMessage != nil {

		// query param ekmip_reachability.message
		var qrEkmipReachabilityMessage string

		if o.EkmipReachabilityMessage != nil {
			qrEkmipReachabilityMessage = *o.EkmipReachabilityMessage
		}
		qEkmipReachabilityMessage := qrEkmipReachabilityMessage
		if qEkmipReachabilityMessage != "" {

			if err := r.SetQueryParam("ekmip_reachability.message", qEkmipReachabilityMessage); err != nil {
				return err
			}
		}
	}

	if o.EkmipReachabilityNodeName != nil {

		// query param ekmip_reachability.node.name
		var qrEkmipReachabilityNodeName string

		if o.EkmipReachabilityNodeName != nil {
			qrEkmipReachabilityNodeName = *o.EkmipReachabilityNodeName
		}
		qEkmipReachabilityNodeName := qrEkmipReachabilityNodeName
		if qEkmipReachabilityNodeName != "" {

			if err := r.SetQueryParam("ekmip_reachability.node.name", qEkmipReachabilityNodeName); err != nil {
				return err
			}
		}
	}

	if o.EkmipReachabilityNodeUUID != nil {

		// query param ekmip_reachability.node.uuid
		var qrEkmipReachabilityNodeUUID string

		if o.EkmipReachabilityNodeUUID != nil {
			qrEkmipReachabilityNodeUUID = *o.EkmipReachabilityNodeUUID
		}
		qEkmipReachabilityNodeUUID := qrEkmipReachabilityNodeUUID
		if qEkmipReachabilityNodeUUID != "" {

			if err := r.SetQueryParam("ekmip_reachability.node.uuid", qEkmipReachabilityNodeUUID); err != nil {
				return err
			}
		}
	}

	if o.EkmipReachabilityReachable != nil {

		// query param ekmip_reachability.reachable
		var qrEkmipReachabilityReachable bool

		if o.EkmipReachabilityReachable != nil {
			qrEkmipReachabilityReachable = *o.EkmipReachabilityReachable
		}
		qEkmipReachabilityReachable := swag.FormatBool(qrEkmipReachabilityReachable)
		if qEkmipReachabilityReachable != "" {

			if err := r.SetQueryParam("ekmip_reachability.reachable", qEkmipReachabilityReachable); err != nil {
				return err
			}
		}
	}

	if o.Enabled != nil {

		// query param enabled
		var qrEnabled bool

		if o.Enabled != nil {
			qrEnabled = *o.Enabled
		}
		qEnabled := swag.FormatBool(qrEnabled)
		if qEnabled != "" {

			if err := r.SetQueryParam("enabled", qEnabled); err != nil {
				return err
			}
		}
	}
	if err := r.SetBodyParam(o.Info); err != nil {
		return err
	}

	if o.KeyID != nil {

		// query param key_id
		var qrKeyID string

		if o.KeyID != nil {
			qrKeyID = *o.KeyID
		}
		qKeyID := qrKeyID
		if qKeyID != "" {

			if err := r.SetQueryParam("key_id", qKeyID); err != nil {
				return err
			}
		}
	}

	if o.Name != nil {

		// query param name
		var qrName string

		if o.Name != nil {
			qrName = *o.Name
		}
		qName := qrName
		if qName != "" {

			if err := r.SetQueryParam("name", qName); err != nil {
				return err
			}
		}
	}

	if o.OauthHost != nil {

		// query param oauth_host
		var qrOauthHost string

		if o.OauthHost != nil {
			qrOauthHost = *o.OauthHost
		}
		qOauthHost := qrOauthHost
		if qOauthHost != "" {

			if err := r.SetQueryParam("oauth_host", qOauthHost); err != nil {
				return err
			}
		}
	}

	if o.Port != nil {

		// query param port
		var qrPort int64

		if o.Port != nil {
			qrPort = *o.Port
		}
		qPort := swag.FormatInt64(qrPort)
		if qPort != "" {

			if err := r.SetQueryParam("port", qPort); err != nil {
				return err
			}
		}
	}

	if o.ProxyHost != nil {

		// query param proxy_host
		var qrProxyHost string

		if o.ProxyHost != nil {
			qrProxyHost = *o.ProxyHost
		}
		qProxyHost := qrProxyHost
		if qProxyHost != "" {

			if err := r.SetQueryParam("proxy_host", qProxyHost); err != nil {
				return err
			}
		}
	}

	if o.ProxyPort != nil {

		// query param proxy_port
		var qrProxyPort int64

		if o.ProxyPort != nil {
			qrProxyPort = *o.ProxyPort
		}
		qProxyPort := swag.FormatInt64(qrProxyPort)
		if qProxyPort != "" {

			if err := r.SetQueryParam("proxy_port", qProxyPort); err != nil {
				return err
			}
		}
	}

	if o.ProxyType != nil {

		// query param proxy_type
		var qrProxyType string

		if o.ProxyType != nil {
			qrProxyType = *o.ProxyType
		}
		qProxyType := qrProxyType
		if qProxyType != "" {

			if err := r.SetQueryParam("proxy_type", qProxyType); err != nil {
				return err
			}
		}
	}

	if o.ProxyUsername != nil {

		// query param proxy_username
		var qrProxyUsername string

		if o.ProxyUsername != nil {
			qrProxyUsername = *o.ProxyUsername
		}
		qProxyUsername := qrProxyUsername
		if qProxyUsername != "" {

			if err := r.SetQueryParam("proxy_username", qProxyUsername); err != nil {
				return err
			}
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.Scope != nil {

		// query param scope
		var qrScope string

		if o.Scope != nil {
			qrScope = *o.Scope
		}
		qScope := qrScope
		if qScope != "" {

			if err := r.SetQueryParam("scope", qScope); err != nil {
				return err
			}
		}
	}

	if o.SerialRecords != nil {

		// query param serial_records
		var qrSerialRecords bool

		if o.SerialRecords != nil {
			qrSerialRecords = *o.SerialRecords
		}
		qSerialRecords := swag.FormatBool(qrSerialRecords)
		if qSerialRecords != "" {

			if err := r.SetQueryParam("serial_records", qSerialRecords); err != nil {
				return err
			}
		}
	}

	if o.SkipVerification != nil {

		// query param skip_verification
		var qrSkipVerification bool

		if o.SkipVerification != nil {
			qrSkipVerification = *o.SkipVerification
		}
		qSkipVerification := swag.FormatBool(qrSkipVerification)
		if qSkipVerification != "" {

			if err := r.SetQueryParam("skip_verification", qSkipVerification); err != nil {
				return err
			}
		}
	}

	if o.StateAvailable != nil {

		// query param state.available
		var qrStateAvailable bool

		if o.StateAvailable != nil {
			qrStateAvailable = *o.StateAvailable
		}
		qStateAvailable := swag.FormatBool(qrStateAvailable)
		if qStateAvailable != "" {

			if err := r.SetQueryParam("state.available", qStateAvailable); err != nil {
				return err
			}
		}
	}

	if o.StateCode != nil {

		// query param state.code
		var qrStateCode string

		if o.StateCode != nil {
			qrStateCode = *o.StateCode
		}
		qStateCode := qrStateCode
		if qStateCode != "" {

			if err := r.SetQueryParam("state.code", qStateCode); err != nil {
				return err
			}
		}
	}

	if o.StateMessage != nil {

		// query param state.message
		var qrStateMessage string

		if o.StateMessage != nil {
			qrStateMessage = *o.StateMessage
		}
		qStateMessage := qrStateMessage
		if qStateMessage != "" {

			if err := r.SetQueryParam("state.message", qStateMessage); err != nil {
				return err
			}
		}
	}

	if o.SvmName != nil {

		// query param svm.name
		var qrSvmName string

		if o.SvmName != nil {
			qrSvmName = *o.SvmName
		}
		qSvmName := qrSvmName
		if qSvmName != "" {

			if err := r.SetQueryParam("svm.name", qSvmName); err != nil {
				return err
			}
		}
	}

	if o.SvmUUID != nil {

		// query param svm.uuid
		var qrSvmUUID string

		if o.SvmUUID != nil {
			qrSvmUUID = *o.SvmUUID
		}
		qSvmUUID := qrSvmUUID
		if qSvmUUID != "" {

			if err := r.SetQueryParam("svm.uuid", qSvmUUID); err != nil {
				return err
			}
		}
	}

	if o.TenantID != nil {

		// query param tenant_id
		var qrTenantID string

		if o.TenantID != nil {
			qrTenantID = *o.TenantID
		}
		qTenantID := qrTenantID
		if qTenantID != "" {

			if err := r.SetQueryParam("tenant_id", qTenantID); err != nil {
				return err
			}
		}
	}

	if o.UUID != nil {

		// query param uuid
		var qrUUID string

		if o.UUID != nil {
			qrUUID = *o.UUID
		}
		qUUID := qrUUID
		if qUUID != "" {

			if err := r.SetQueryParam("uuid", qUUID); err != nil {
				return err
			}
		}
	}

	if o.VaultHost != nil {

		// query param vault_host
		var qrVaultHost string

		if o.VaultHost != nil {
			qrVaultHost = *o.VaultHost
		}
		qVaultHost := qrVaultHost
		if qVaultHost != "" {

			if err := r.SetQueryParam("vault_host", qVaultHost); err != nil {
				return err
			}
		}
	}

	if o.VerifyHost != nil {

		// query param verify_host
		var qrVerifyHost bool

		if o.VerifyHost != nil {
			qrVerifyHost = *o.VerifyHost
		}
		qVerifyHost := swag.FormatBool(qrVerifyHost)
		if qVerifyHost != "" {

			if err := r.SetQueryParam("verify_host", qVerifyHost); err != nil {
				return err
			}
		}
	}

	if o.VerifyIP != nil {

		// query param verify_ip
		var qrVerifyIP bool

		if o.VerifyIP != nil {
			qrVerifyIP = *o.VerifyIP
		}
		qVerifyIP := swag.FormatBool(qrVerifyIP)
		if qVerifyIP != "" {

			if err := r.SetQueryParam("verify_ip", qVerifyIP); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
