// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewAzureKeyVaultGetParams creates a new AzureKeyVaultGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewAzureKeyVaultGetParams() *AzureKeyVaultGetParams {
	return &AzureKeyVaultGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewAzureKeyVaultGetParamsWithTimeout creates a new AzureKeyVaultGetParams object
// with the ability to set a timeout on a request.
func NewAzureKeyVaultGetParamsWithTimeout(timeout time.Duration) *AzureKeyVaultGetParams {
	return &AzureKeyVaultGetParams{
		timeout: timeout,
	}
}

// NewAzureKeyVaultGetParamsWithContext creates a new AzureKeyVaultGetParams object
// with the ability to set a context for a request.
func NewAzureKeyVaultGetParamsWithContext(ctx context.Context) *AzureKeyVaultGetParams {
	return &AzureKeyVaultGetParams{
		Context: ctx,
	}
}

// NewAzureKeyVaultGetParamsWithHTTPClient creates a new AzureKeyVaultGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewAzureKeyVaultGetParamsWithHTTPClient(client *http.Client) *AzureKeyVaultGetParams {
	return &AzureKeyVaultGetParams{
		HTTPClient: client,
	}
}

/*
AzureKeyVaultGetParams contains all the parameters to send to the API endpoint

	for the azure key vault get operation.

	Typically these are written to a http.Request.
*/
type AzureKeyVaultGetParams struct {

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* UUID.

	   AKV UUID
	*/
	UUID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the azure key vault get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *AzureKeyVaultGetParams) WithDefaults() *AzureKeyVaultGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the azure key vault get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *AzureKeyVaultGetParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the azure key vault get params
func (o *AzureKeyVaultGetParams) WithTimeout(timeout time.Duration) *AzureKeyVaultGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the azure key vault get params
func (o *AzureKeyVaultGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the azure key vault get params
func (o *AzureKeyVaultGetParams) WithContext(ctx context.Context) *AzureKeyVaultGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the azure key vault get params
func (o *AzureKeyVaultGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the azure key vault get params
func (o *AzureKeyVaultGetParams) WithHTTPClient(client *http.Client) *AzureKeyVaultGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the azure key vault get params
func (o *AzureKeyVaultGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithFields adds the fields to the azure key vault get params
func (o *AzureKeyVaultGetParams) WithFields(fields []string) *AzureKeyVaultGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the azure key vault get params
func (o *AzureKeyVaultGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithUUID adds the uuid to the azure key vault get params
func (o *AzureKeyVaultGetParams) WithUUID(uuid string) *AzureKeyVaultGetParams {
	o.SetUUID(uuid)
	return o
}

// SetUUID adds the uuid to the azure key vault get params
func (o *AzureKeyVaultGetParams) SetUUID(uuid string) {
	o.UUID = uuid
}

// WriteToRequest writes these params to a swagger request
func (o *AzureKeyVaultGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	// path param uuid
	if err := r.SetPathParam("uuid", o.UUID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamAzureKeyVaultGet binds the parameter fields
func (o *AzureKeyVaultGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}
