// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewAzureKeyVaultRestoreParams creates a new AzureKeyVaultRestoreParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewAzureKeyVaultRestoreParams() *AzureKeyVaultRestoreParams {
	return &AzureKeyVaultRestoreParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewAzureKeyVaultRestoreParamsWithTimeout creates a new AzureKeyVaultRestoreParams object
// with the ability to set a timeout on a request.
func NewAzureKeyVaultRestoreParamsWithTimeout(timeout time.Duration) *AzureKeyVaultRestoreParams {
	return &AzureKeyVaultRestoreParams{
		timeout: timeout,
	}
}

// NewAzureKeyVaultRestoreParamsWithContext creates a new AzureKeyVaultRestoreParams object
// with the ability to set a context for a request.
func NewAzureKeyVaultRestoreParamsWithContext(ctx context.Context) *AzureKeyVaultRestoreParams {
	return &AzureKeyVaultRestoreParams{
		Context: ctx,
	}
}

// NewAzureKeyVaultRestoreParamsWithHTTPClient creates a new AzureKeyVaultRestoreParams object
// with the ability to set a custom HTTPClient for a request.
func NewAzureKeyVaultRestoreParamsWithHTTPClient(client *http.Client) *AzureKeyVaultRestoreParams {
	return &AzureKeyVaultRestoreParams{
		HTTPClient: client,
	}
}

/*
AzureKeyVaultRestoreParams contains all the parameters to send to the API endpoint

	for the azure key vault restore operation.

	Typically these are written to a http.Request.
*/
type AzureKeyVaultRestoreParams struct {

	/* ReturnRecords.

	   The default is false.  If set to true, the records are returned.
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning. When doing a POST, PATCH, or DELETE operation on a single record, the default is 0 seconds.  This means that if an asynchronous operation is started, the server immediately returns HTTP code 202 (Accepted) along with a link to the job.  If a non-zero value is specified for POST, PATCH, or DELETE operations, ONTAP waits that length of time to see if the job completes so it can return something other than 202.
	*/
	ReturnTimeout *int64

	/* UUID.

	   UUID of the existing AKV configuration.
	*/
	UUID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the azure key vault restore params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *AzureKeyVaultRestoreParams) WithDefaults() *AzureKeyVaultRestoreParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the azure key vault restore params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *AzureKeyVaultRestoreParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(false)

		returnTimeoutDefault = int64(0)
	)

	val := AzureKeyVaultRestoreParams{
		ReturnRecords: &returnRecordsDefault,
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the azure key vault restore params
func (o *AzureKeyVaultRestoreParams) WithTimeout(timeout time.Duration) *AzureKeyVaultRestoreParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the azure key vault restore params
func (o *AzureKeyVaultRestoreParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the azure key vault restore params
func (o *AzureKeyVaultRestoreParams) WithContext(ctx context.Context) *AzureKeyVaultRestoreParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the azure key vault restore params
func (o *AzureKeyVaultRestoreParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the azure key vault restore params
func (o *AzureKeyVaultRestoreParams) WithHTTPClient(client *http.Client) *AzureKeyVaultRestoreParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the azure key vault restore params
func (o *AzureKeyVaultRestoreParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithReturnRecords adds the returnRecords to the azure key vault restore params
func (o *AzureKeyVaultRestoreParams) WithReturnRecords(returnRecords *bool) *AzureKeyVaultRestoreParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the azure key vault restore params
func (o *AzureKeyVaultRestoreParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the azure key vault restore params
func (o *AzureKeyVaultRestoreParams) WithReturnTimeout(returnTimeout *int64) *AzureKeyVaultRestoreParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the azure key vault restore params
func (o *AzureKeyVaultRestoreParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithUUID adds the uuid to the azure key vault restore params
func (o *AzureKeyVaultRestoreParams) WithUUID(uuid string) *AzureKeyVaultRestoreParams {
	o.SetUUID(uuid)
	return o
}

// SetUUID adds the uuid to the azure key vault restore params
func (o *AzureKeyVaultRestoreParams) SetUUID(uuid string) {
	o.UUID = uuid
}

// WriteToRequest writes these params to a swagger request
func (o *AzureKeyVaultRestoreParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	// path param uuid
	if err := r.SetPathParam("uuid", o.UUID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
