// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewBarbicanCollectionGetParams creates a new BarbicanCollectionGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewBarbicanCollectionGetParams() *BarbicanCollectionGetParams {
	return &BarbicanCollectionGetParams{
		requestTimeout: cr.DefaultTimeout,
	}
}

// NewBarbicanCollectionGetParamsWithTimeout creates a new BarbicanCollectionGetParams object
// with the ability to set a timeout on a request.
func NewBarbicanCollectionGetParamsWithTimeout(timeout time.Duration) *BarbicanCollectionGetParams {
	return &BarbicanCollectionGetParams{
		requestTimeout: timeout,
	}
}

// NewBarbicanCollectionGetParamsWithContext creates a new BarbicanCollectionGetParams object
// with the ability to set a context for a request.
func NewBarbicanCollectionGetParamsWithContext(ctx context.Context) *BarbicanCollectionGetParams {
	return &BarbicanCollectionGetParams{
		Context: ctx,
	}
}

// NewBarbicanCollectionGetParamsWithHTTPClient creates a new BarbicanCollectionGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewBarbicanCollectionGetParamsWithHTTPClient(client *http.Client) *BarbicanCollectionGetParams {
	return &BarbicanCollectionGetParams{
		HTTPClient: client,
	}
}

/*
BarbicanCollectionGetParams contains all the parameters to send to the API endpoint

	for the barbican collection get operation.

	Typically these are written to a http.Request.
*/
type BarbicanCollectionGetParams struct {

	/* ApplicationCredID.

	   Filter by application_cred_id
	*/
	ApplicationCredID *string

	/* BarbicanReachabilityCode.

	   Filter by barbican_reachability.code
	*/
	BarbicanReachabilityCode *string

	/* BarbicanReachabilityMessage.

	   Filter by barbican_reachability.message
	*/
	BarbicanReachabilityMessage *string

	/* BarbicanReachabilityReachable.

	   Filter by barbican_reachability.reachable
	*/
	BarbicanReachabilityReachable *bool

	/* ConfigurationName.

	   Filter by configuration.name
	*/
	ConfigurationName *string

	/* ConfigurationUUID.

	   Filter by configuration.uuid
	*/
	ConfigurationUUID *string

	/* Enabled.

	   Filter by enabled
	*/
	Enabled *bool

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* KeyID.

	   Filter by key_id
	*/
	KeyID *string

	/* KeystoneURL.

	   Filter by keystone_url
	*/
	KeystoneURL *string

	/* MaxRecords.

	   Limit the number of records returned.
	*/
	MaxRecords *int64

	/* OrderBy.

	   Order results by specified fields and optional [asc|desc] direction. Default direction is 'asc' for ascending.
	*/
	OrderBy []string

	/* ProxyHost.

	   Filter by proxy_host
	*/
	ProxyHost *string

	/* ProxyPort.

	   Filter by proxy_port
	*/
	ProxyPort *int64

	/* ProxyType.

	   Filter by proxy_type
	*/
	ProxyType *string

	/* ProxyUsername.

	   Filter by proxy_username
	*/
	ProxyUsername *string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* Scope.

	   Filter by scope
	*/
	Scope *string

	/* StateClusterState.

	   Filter by state.cluster_state
	*/
	StateClusterState *bool

	/* StateCode.

	   Filter by state.code
	*/
	StateCode *string

	/* StateMessage.

	   Filter by state.message
	*/
	StateMessage *string

	/* SvmName.

	   Filter by svm.name
	*/
	SvmName *string

	/* SvmUUID.

	   Filter by svm.uuid
	*/
	SvmUUID *string

	/* Timeout.

	   Filter by timeout
	*/
	Timeout *int64

	/* UUID.

	   Filter by uuid
	*/
	UUID *string

	/* Verify.

	   Filter by verify
	*/
	Verify *bool

	/* VerifyHost.

	   Filter by verify_host
	*/
	VerifyHost *bool

	requestTimeout time.Duration
	Context        context.Context
	HTTPClient     *http.Client
}

// WithDefaults hydrates default values in the barbican collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *BarbicanCollectionGetParams) WithDefaults() *BarbicanCollectionGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the barbican collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *BarbicanCollectionGetParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)
	)

	val := BarbicanCollectionGetParams{
		ReturnRecords: &returnRecordsDefault,
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.requestTimeout = o.requestTimeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithRequestTimeout adds the timeout to the barbican collection get params
func (o *BarbicanCollectionGetParams) WithRequestTimeout(timeout time.Duration) *BarbicanCollectionGetParams {
	o.SetRequestTimeout(timeout)
	return o
}

// SetRequestTimeout adds the timeout to the barbican collection get params
func (o *BarbicanCollectionGetParams) SetRequestTimeout(timeout time.Duration) {
	o.requestTimeout = timeout
}

// WithContext adds the context to the barbican collection get params
func (o *BarbicanCollectionGetParams) WithContext(ctx context.Context) *BarbicanCollectionGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the barbican collection get params
func (o *BarbicanCollectionGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the barbican collection get params
func (o *BarbicanCollectionGetParams) WithHTTPClient(client *http.Client) *BarbicanCollectionGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the barbican collection get params
func (o *BarbicanCollectionGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithApplicationCredID adds the applicationCredID to the barbican collection get params
func (o *BarbicanCollectionGetParams) WithApplicationCredID(applicationCredID *string) *BarbicanCollectionGetParams {
	o.SetApplicationCredID(applicationCredID)
	return o
}

// SetApplicationCredID adds the applicationCredId to the barbican collection get params
func (o *BarbicanCollectionGetParams) SetApplicationCredID(applicationCredID *string) {
	o.ApplicationCredID = applicationCredID
}

// WithBarbicanReachabilityCode adds the barbicanReachabilityCode to the barbican collection get params
func (o *BarbicanCollectionGetParams) WithBarbicanReachabilityCode(barbicanReachabilityCode *string) *BarbicanCollectionGetParams {
	o.SetBarbicanReachabilityCode(barbicanReachabilityCode)
	return o
}

// SetBarbicanReachabilityCode adds the barbicanReachabilityCode to the barbican collection get params
func (o *BarbicanCollectionGetParams) SetBarbicanReachabilityCode(barbicanReachabilityCode *string) {
	o.BarbicanReachabilityCode = barbicanReachabilityCode
}

// WithBarbicanReachabilityMessage adds the barbicanReachabilityMessage to the barbican collection get params
func (o *BarbicanCollectionGetParams) WithBarbicanReachabilityMessage(barbicanReachabilityMessage *string) *BarbicanCollectionGetParams {
	o.SetBarbicanReachabilityMessage(barbicanReachabilityMessage)
	return o
}

// SetBarbicanReachabilityMessage adds the barbicanReachabilityMessage to the barbican collection get params
func (o *BarbicanCollectionGetParams) SetBarbicanReachabilityMessage(barbicanReachabilityMessage *string) {
	o.BarbicanReachabilityMessage = barbicanReachabilityMessage
}

// WithBarbicanReachabilityReachable adds the barbicanReachabilityReachable to the barbican collection get params
func (o *BarbicanCollectionGetParams) WithBarbicanReachabilityReachable(barbicanReachabilityReachable *bool) *BarbicanCollectionGetParams {
	o.SetBarbicanReachabilityReachable(barbicanReachabilityReachable)
	return o
}

// SetBarbicanReachabilityReachable adds the barbicanReachabilityReachable to the barbican collection get params
func (o *BarbicanCollectionGetParams) SetBarbicanReachabilityReachable(barbicanReachabilityReachable *bool) {
	o.BarbicanReachabilityReachable = barbicanReachabilityReachable
}

// WithConfigurationName adds the configurationName to the barbican collection get params
func (o *BarbicanCollectionGetParams) WithConfigurationName(configurationName *string) *BarbicanCollectionGetParams {
	o.SetConfigurationName(configurationName)
	return o
}

// SetConfigurationName adds the configurationName to the barbican collection get params
func (o *BarbicanCollectionGetParams) SetConfigurationName(configurationName *string) {
	o.ConfigurationName = configurationName
}

// WithConfigurationUUID adds the configurationUUID to the barbican collection get params
func (o *BarbicanCollectionGetParams) WithConfigurationUUID(configurationUUID *string) *BarbicanCollectionGetParams {
	o.SetConfigurationUUID(configurationUUID)
	return o
}

// SetConfigurationUUID adds the configurationUuid to the barbican collection get params
func (o *BarbicanCollectionGetParams) SetConfigurationUUID(configurationUUID *string) {
	o.ConfigurationUUID = configurationUUID
}

// WithEnabled adds the enabled to the barbican collection get params
func (o *BarbicanCollectionGetParams) WithEnabled(enabled *bool) *BarbicanCollectionGetParams {
	o.SetEnabled(enabled)
	return o
}

// SetEnabled adds the enabled to the barbican collection get params
func (o *BarbicanCollectionGetParams) SetEnabled(enabled *bool) {
	o.Enabled = enabled
}

// WithFields adds the fields to the barbican collection get params
func (o *BarbicanCollectionGetParams) WithFields(fields []string) *BarbicanCollectionGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the barbican collection get params
func (o *BarbicanCollectionGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithKeyID adds the keyID to the barbican collection get params
func (o *BarbicanCollectionGetParams) WithKeyID(keyID *string) *BarbicanCollectionGetParams {
	o.SetKeyID(keyID)
	return o
}

// SetKeyID adds the keyId to the barbican collection get params
func (o *BarbicanCollectionGetParams) SetKeyID(keyID *string) {
	o.KeyID = keyID
}

// WithKeystoneURL adds the keystoneURL to the barbican collection get params
func (o *BarbicanCollectionGetParams) WithKeystoneURL(keystoneURL *string) *BarbicanCollectionGetParams {
	o.SetKeystoneURL(keystoneURL)
	return o
}

// SetKeystoneURL adds the keystoneUrl to the barbican collection get params
func (o *BarbicanCollectionGetParams) SetKeystoneURL(keystoneURL *string) {
	o.KeystoneURL = keystoneURL
}

// WithMaxRecords adds the maxRecords to the barbican collection get params
func (o *BarbicanCollectionGetParams) WithMaxRecords(maxRecords *int64) *BarbicanCollectionGetParams {
	o.SetMaxRecords(maxRecords)
	return o
}

// SetMaxRecords adds the maxRecords to the barbican collection get params
func (o *BarbicanCollectionGetParams) SetMaxRecords(maxRecords *int64) {
	o.MaxRecords = maxRecords
}

// WithOrderBy adds the orderBy to the barbican collection get params
func (o *BarbicanCollectionGetParams) WithOrderBy(orderBy []string) *BarbicanCollectionGetParams {
	o.SetOrderBy(orderBy)
	return o
}

// SetOrderBy adds the orderBy to the barbican collection get params
func (o *BarbicanCollectionGetParams) SetOrderBy(orderBy []string) {
	o.OrderBy = orderBy
}

// WithProxyHost adds the proxyHost to the barbican collection get params
func (o *BarbicanCollectionGetParams) WithProxyHost(proxyHost *string) *BarbicanCollectionGetParams {
	o.SetProxyHost(proxyHost)
	return o
}

// SetProxyHost adds the proxyHost to the barbican collection get params
func (o *BarbicanCollectionGetParams) SetProxyHost(proxyHost *string) {
	o.ProxyHost = proxyHost
}

// WithProxyPort adds the proxyPort to the barbican collection get params
func (o *BarbicanCollectionGetParams) WithProxyPort(proxyPort *int64) *BarbicanCollectionGetParams {
	o.SetProxyPort(proxyPort)
	return o
}

// SetProxyPort adds the proxyPort to the barbican collection get params
func (o *BarbicanCollectionGetParams) SetProxyPort(proxyPort *int64) {
	o.ProxyPort = proxyPort
}

// WithProxyType adds the proxyType to the barbican collection get params
func (o *BarbicanCollectionGetParams) WithProxyType(proxyType *string) *BarbicanCollectionGetParams {
	o.SetProxyType(proxyType)
	return o
}

// SetProxyType adds the proxyType to the barbican collection get params
func (o *BarbicanCollectionGetParams) SetProxyType(proxyType *string) {
	o.ProxyType = proxyType
}

// WithProxyUsername adds the proxyUsername to the barbican collection get params
func (o *BarbicanCollectionGetParams) WithProxyUsername(proxyUsername *string) *BarbicanCollectionGetParams {
	o.SetProxyUsername(proxyUsername)
	return o
}

// SetProxyUsername adds the proxyUsername to the barbican collection get params
func (o *BarbicanCollectionGetParams) SetProxyUsername(proxyUsername *string) {
	o.ProxyUsername = proxyUsername
}

// WithReturnRecords adds the returnRecords to the barbican collection get params
func (o *BarbicanCollectionGetParams) WithReturnRecords(returnRecords *bool) *BarbicanCollectionGetParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the barbican collection get params
func (o *BarbicanCollectionGetParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the barbican collection get params
func (o *BarbicanCollectionGetParams) WithReturnTimeout(returnTimeout *int64) *BarbicanCollectionGetParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the barbican collection get params
func (o *BarbicanCollectionGetParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithScope adds the scope to the barbican collection get params
func (o *BarbicanCollectionGetParams) WithScope(scope *string) *BarbicanCollectionGetParams {
	o.SetScope(scope)
	return o
}

// SetScope adds the scope to the barbican collection get params
func (o *BarbicanCollectionGetParams) SetScope(scope *string) {
	o.Scope = scope
}

// WithStateClusterState adds the stateClusterState to the barbican collection get params
func (o *BarbicanCollectionGetParams) WithStateClusterState(stateClusterState *bool) *BarbicanCollectionGetParams {
	o.SetStateClusterState(stateClusterState)
	return o
}

// SetStateClusterState adds the stateClusterState to the barbican collection get params
func (o *BarbicanCollectionGetParams) SetStateClusterState(stateClusterState *bool) {
	o.StateClusterState = stateClusterState
}

// WithStateCode adds the stateCode to the barbican collection get params
func (o *BarbicanCollectionGetParams) WithStateCode(stateCode *string) *BarbicanCollectionGetParams {
	o.SetStateCode(stateCode)
	return o
}

// SetStateCode adds the stateCode to the barbican collection get params
func (o *BarbicanCollectionGetParams) SetStateCode(stateCode *string) {
	o.StateCode = stateCode
}

// WithStateMessage adds the stateMessage to the barbican collection get params
func (o *BarbicanCollectionGetParams) WithStateMessage(stateMessage *string) *BarbicanCollectionGetParams {
	o.SetStateMessage(stateMessage)
	return o
}

// SetStateMessage adds the stateMessage to the barbican collection get params
func (o *BarbicanCollectionGetParams) SetStateMessage(stateMessage *string) {
	o.StateMessage = stateMessage
}

// WithSvmName adds the svmName to the barbican collection get params
func (o *BarbicanCollectionGetParams) WithSvmName(svmName *string) *BarbicanCollectionGetParams {
	o.SetSvmName(svmName)
	return o
}

// SetSvmName adds the svmName to the barbican collection get params
func (o *BarbicanCollectionGetParams) SetSvmName(svmName *string) {
	o.SvmName = svmName
}

// WithSvmUUID adds the svmUUID to the barbican collection get params
func (o *BarbicanCollectionGetParams) WithSvmUUID(svmUUID *string) *BarbicanCollectionGetParams {
	o.SetSvmUUID(svmUUID)
	return o
}

// SetSvmUUID adds the svmUuid to the barbican collection get params
func (o *BarbicanCollectionGetParams) SetSvmUUID(svmUUID *string) {
	o.SvmUUID = svmUUID
}

// WithTimeout adds the timeout to the barbican collection get params
func (o *BarbicanCollectionGetParams) WithTimeout(timeout *int64) *BarbicanCollectionGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the barbican collection get params
func (o *BarbicanCollectionGetParams) SetTimeout(timeout *int64) {
	o.Timeout = timeout
}

// WithUUID adds the uuid to the barbican collection get params
func (o *BarbicanCollectionGetParams) WithUUID(uuid *string) *BarbicanCollectionGetParams {
	o.SetUUID(uuid)
	return o
}

// SetUUID adds the uuid to the barbican collection get params
func (o *BarbicanCollectionGetParams) SetUUID(uuid *string) {
	o.UUID = uuid
}

// WithVerify adds the verify to the barbican collection get params
func (o *BarbicanCollectionGetParams) WithVerify(verify *bool) *BarbicanCollectionGetParams {
	o.SetVerify(verify)
	return o
}

// SetVerify adds the verify to the barbican collection get params
func (o *BarbicanCollectionGetParams) SetVerify(verify *bool) {
	o.Verify = verify
}

// WithVerifyHost adds the verifyHost to the barbican collection get params
func (o *BarbicanCollectionGetParams) WithVerifyHost(verifyHost *bool) *BarbicanCollectionGetParams {
	o.SetVerifyHost(verifyHost)
	return o
}

// SetVerifyHost adds the verifyHost to the barbican collection get params
func (o *BarbicanCollectionGetParams) SetVerifyHost(verifyHost *bool) {
	o.VerifyHost = verifyHost
}

// WriteToRequest writes these params to a swagger request
func (o *BarbicanCollectionGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.requestTimeout); err != nil {
		return err
	}
	var res []error

	if o.ApplicationCredID != nil {

		// query param application_cred_id
		var qrApplicationCredID string

		if o.ApplicationCredID != nil {
			qrApplicationCredID = *o.ApplicationCredID
		}
		qApplicationCredID := qrApplicationCredID
		if qApplicationCredID != "" {

			if err := r.SetQueryParam("application_cred_id", qApplicationCredID); err != nil {
				return err
			}
		}
	}

	if o.BarbicanReachabilityCode != nil {

		// query param barbican_reachability.code
		var qrBarbicanReachabilityCode string

		if o.BarbicanReachabilityCode != nil {
			qrBarbicanReachabilityCode = *o.BarbicanReachabilityCode
		}
		qBarbicanReachabilityCode := qrBarbicanReachabilityCode
		if qBarbicanReachabilityCode != "" {

			if err := r.SetQueryParam("barbican_reachability.code", qBarbicanReachabilityCode); err != nil {
				return err
			}
		}
	}

	if o.BarbicanReachabilityMessage != nil {

		// query param barbican_reachability.message
		var qrBarbicanReachabilityMessage string

		if o.BarbicanReachabilityMessage != nil {
			qrBarbicanReachabilityMessage = *o.BarbicanReachabilityMessage
		}
		qBarbicanReachabilityMessage := qrBarbicanReachabilityMessage
		if qBarbicanReachabilityMessage != "" {

			if err := r.SetQueryParam("barbican_reachability.message", qBarbicanReachabilityMessage); err != nil {
				return err
			}
		}
	}

	if o.BarbicanReachabilityReachable != nil {

		// query param barbican_reachability.reachable
		var qrBarbicanReachabilityReachable bool

		if o.BarbicanReachabilityReachable != nil {
			qrBarbicanReachabilityReachable = *o.BarbicanReachabilityReachable
		}
		qBarbicanReachabilityReachable := swag.FormatBool(qrBarbicanReachabilityReachable)
		if qBarbicanReachabilityReachable != "" {

			if err := r.SetQueryParam("barbican_reachability.reachable", qBarbicanReachabilityReachable); err != nil {
				return err
			}
		}
	}

	if o.ConfigurationName != nil {

		// query param configuration.name
		var qrConfigurationName string

		if o.ConfigurationName != nil {
			qrConfigurationName = *o.ConfigurationName
		}
		qConfigurationName := qrConfigurationName
		if qConfigurationName != "" {

			if err := r.SetQueryParam("configuration.name", qConfigurationName); err != nil {
				return err
			}
		}
	}

	if o.ConfigurationUUID != nil {

		// query param configuration.uuid
		var qrConfigurationUUID string

		if o.ConfigurationUUID != nil {
			qrConfigurationUUID = *o.ConfigurationUUID
		}
		qConfigurationUUID := qrConfigurationUUID
		if qConfigurationUUID != "" {

			if err := r.SetQueryParam("configuration.uuid", qConfigurationUUID); err != nil {
				return err
			}
		}
	}

	if o.Enabled != nil {

		// query param enabled
		var qrEnabled bool

		if o.Enabled != nil {
			qrEnabled = *o.Enabled
		}
		qEnabled := swag.FormatBool(qrEnabled)
		if qEnabled != "" {

			if err := r.SetQueryParam("enabled", qEnabled); err != nil {
				return err
			}
		}
	}

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	if o.KeyID != nil {

		// query param key_id
		var qrKeyID string

		if o.KeyID != nil {
			qrKeyID = *o.KeyID
		}
		qKeyID := qrKeyID
		if qKeyID != "" {

			if err := r.SetQueryParam("key_id", qKeyID); err != nil {
				return err
			}
		}
	}

	if o.KeystoneURL != nil {

		// query param keystone_url
		var qrKeystoneURL string

		if o.KeystoneURL != nil {
			qrKeystoneURL = *o.KeystoneURL
		}
		qKeystoneURL := qrKeystoneURL
		if qKeystoneURL != "" {

			if err := r.SetQueryParam("keystone_url", qKeystoneURL); err != nil {
				return err
			}
		}
	}

	if o.MaxRecords != nil {

		// query param max_records
		var qrMaxRecords int64

		if o.MaxRecords != nil {
			qrMaxRecords = *o.MaxRecords
		}
		qMaxRecords := swag.FormatInt64(qrMaxRecords)
		if qMaxRecords != "" {

			if err := r.SetQueryParam("max_records", qMaxRecords); err != nil {
				return err
			}
		}
	}

	if o.OrderBy != nil {

		// binding items for order_by
		joinedOrderBy := o.bindParamOrderBy(reg)

		// query array param order_by
		if err := r.SetQueryParam("order_by", joinedOrderBy...); err != nil {
			return err
		}
	}

	if o.ProxyHost != nil {

		// query param proxy_host
		var qrProxyHost string

		if o.ProxyHost != nil {
			qrProxyHost = *o.ProxyHost
		}
		qProxyHost := qrProxyHost
		if qProxyHost != "" {

			if err := r.SetQueryParam("proxy_host", qProxyHost); err != nil {
				return err
			}
		}
	}

	if o.ProxyPort != nil {

		// query param proxy_port
		var qrProxyPort int64

		if o.ProxyPort != nil {
			qrProxyPort = *o.ProxyPort
		}
		qProxyPort := swag.FormatInt64(qrProxyPort)
		if qProxyPort != "" {

			if err := r.SetQueryParam("proxy_port", qProxyPort); err != nil {
				return err
			}
		}
	}

	if o.ProxyType != nil {

		// query param proxy_type
		var qrProxyType string

		if o.ProxyType != nil {
			qrProxyType = *o.ProxyType
		}
		qProxyType := qrProxyType
		if qProxyType != "" {

			if err := r.SetQueryParam("proxy_type", qProxyType); err != nil {
				return err
			}
		}
	}

	if o.ProxyUsername != nil {

		// query param proxy_username
		var qrProxyUsername string

		if o.ProxyUsername != nil {
			qrProxyUsername = *o.ProxyUsername
		}
		qProxyUsername := qrProxyUsername
		if qProxyUsername != "" {

			if err := r.SetQueryParam("proxy_username", qProxyUsername); err != nil {
				return err
			}
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.Scope != nil {

		// query param scope
		var qrScope string

		if o.Scope != nil {
			qrScope = *o.Scope
		}
		qScope := qrScope
		if qScope != "" {

			if err := r.SetQueryParam("scope", qScope); err != nil {
				return err
			}
		}
	}

	if o.StateClusterState != nil {

		// query param state.cluster_state
		var qrStateClusterState bool

		if o.StateClusterState != nil {
			qrStateClusterState = *o.StateClusterState
		}
		qStateClusterState := swag.FormatBool(qrStateClusterState)
		if qStateClusterState != "" {

			if err := r.SetQueryParam("state.cluster_state", qStateClusterState); err != nil {
				return err
			}
		}
	}

	if o.StateCode != nil {

		// query param state.code
		var qrStateCode string

		if o.StateCode != nil {
			qrStateCode = *o.StateCode
		}
		qStateCode := qrStateCode
		if qStateCode != "" {

			if err := r.SetQueryParam("state.code", qStateCode); err != nil {
				return err
			}
		}
	}

	if o.StateMessage != nil {

		// query param state.message
		var qrStateMessage string

		if o.StateMessage != nil {
			qrStateMessage = *o.StateMessage
		}
		qStateMessage := qrStateMessage
		if qStateMessage != "" {

			if err := r.SetQueryParam("state.message", qStateMessage); err != nil {
				return err
			}
		}
	}

	if o.SvmName != nil {

		// query param svm.name
		var qrSvmName string

		if o.SvmName != nil {
			qrSvmName = *o.SvmName
		}
		qSvmName := qrSvmName
		if qSvmName != "" {

			if err := r.SetQueryParam("svm.name", qSvmName); err != nil {
				return err
			}
		}
	}

	if o.SvmUUID != nil {

		// query param svm.uuid
		var qrSvmUUID string

		if o.SvmUUID != nil {
			qrSvmUUID = *o.SvmUUID
		}
		qSvmUUID := qrSvmUUID
		if qSvmUUID != "" {

			if err := r.SetQueryParam("svm.uuid", qSvmUUID); err != nil {
				return err
			}
		}
	}

	if o.Timeout != nil {

		// query param timeout
		var qrTimeout int64

		if o.Timeout != nil {
			qrTimeout = *o.Timeout
		}
		qTimeout := swag.FormatInt64(qrTimeout)
		if qTimeout != "" {

			if err := r.SetQueryParam("timeout", qTimeout); err != nil {
				return err
			}
		}
	}

	if o.UUID != nil {

		// query param uuid
		var qrUUID string

		if o.UUID != nil {
			qrUUID = *o.UUID
		}
		qUUID := qrUUID
		if qUUID != "" {

			if err := r.SetQueryParam("uuid", qUUID); err != nil {
				return err
			}
		}
	}

	if o.Verify != nil {

		// query param verify
		var qrVerify bool

		if o.Verify != nil {
			qrVerify = *o.Verify
		}
		qVerify := swag.FormatBool(qrVerify)
		if qVerify != "" {

			if err := r.SetQueryParam("verify", qVerify); err != nil {
				return err
			}
		}
	}

	if o.VerifyHost != nil {

		// query param verify_host
		var qrVerifyHost bool

		if o.VerifyHost != nil {
			qrVerifyHost = *o.VerifyHost
		}
		qVerifyHost := swag.FormatBool(qrVerifyHost)
		if qVerifyHost != "" {

			if err := r.SetQueryParam("verify_host", qVerifyHost); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamBarbicanCollectionGet binds the parameter fields
func (o *BarbicanCollectionGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}

// bindParamBarbicanCollectionGet binds the parameter order_by
func (o *BarbicanCollectionGetParams) bindParamOrderBy(formats strfmt.Registry) []string {
	orderByIR := o.OrderBy

	var orderByIC []string
	for _, orderByIIR := range orderByIR { // explode []string

		orderByIIV := orderByIIR // string as string
		orderByIC = append(orderByIC, orderByIIV)
	}

	// items.CollectionFormat: "csv"
	orderByIS := swag.JoinByFormat(orderByIC, "csv")

	return orderByIS
}
