// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// BarbicanCollectionGetReader is a Reader for the BarbicanCollectionGet structure.
type BarbicanCollectionGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *BarbicanCollectionGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewBarbicanCollectionGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewBarbicanCollectionGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewBarbicanCollectionGetOK creates a BarbicanCollectionGetOK with default headers values
func NewBarbicanCollectionGetOK() *BarbicanCollectionGetOK {
	return &BarbicanCollectionGetOK{}
}

/*
BarbicanCollectionGetOK describes a response with status code 200, with default header values.

OK
*/
type BarbicanCollectionGetOK struct {
	Payload *models.BarbicanResponse
}

// IsSuccess returns true when this barbican collection get o k response has a 2xx status code
func (o *BarbicanCollectionGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this barbican collection get o k response has a 3xx status code
func (o *BarbicanCollectionGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this barbican collection get o k response has a 4xx status code
func (o *BarbicanCollectionGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this barbican collection get o k response has a 5xx status code
func (o *BarbicanCollectionGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this barbican collection get o k response a status code equal to that given
func (o *BarbicanCollectionGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the barbican collection get o k response
func (o *BarbicanCollectionGetOK) Code() int {
	return 200
}

func (o *BarbicanCollectionGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /security/barbican-kms][%d] barbicanCollectionGetOK %s", 200, payload)
}

func (o *BarbicanCollectionGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /security/barbican-kms][%d] barbicanCollectionGetOK %s", 200, payload)
}

func (o *BarbicanCollectionGetOK) GetPayload() *models.BarbicanResponse {
	return o.Payload
}

func (o *BarbicanCollectionGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.BarbicanResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewBarbicanCollectionGetDefault creates a BarbicanCollectionGetDefault with default headers values
func NewBarbicanCollectionGetDefault(code int) *BarbicanCollectionGetDefault {
	return &BarbicanCollectionGetDefault{
		_statusCode: code,
	}
}

/*
	BarbicanCollectionGetDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 65539801 | The Barbican Key Management Service is unreachable from one or more nodes. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type BarbicanCollectionGetDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this barbican collection get default response has a 2xx status code
func (o *BarbicanCollectionGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this barbican collection get default response has a 3xx status code
func (o *BarbicanCollectionGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this barbican collection get default response has a 4xx status code
func (o *BarbicanCollectionGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this barbican collection get default response has a 5xx status code
func (o *BarbicanCollectionGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this barbican collection get default response a status code equal to that given
func (o *BarbicanCollectionGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the barbican collection get default response
func (o *BarbicanCollectionGetDefault) Code() int {
	return o._statusCode
}

func (o *BarbicanCollectionGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /security/barbican-kms][%d] barbican_collection_get default %s", o._statusCode, payload)
}

func (o *BarbicanCollectionGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /security/barbican-kms][%d] barbican_collection_get default %s", o._statusCode, payload)
}

func (o *BarbicanCollectionGetDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *BarbicanCollectionGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
