// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// NewBarbicanCreateParams creates a new BarbicanCreateParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewBarbicanCreateParams() *BarbicanCreateParams {
	return &BarbicanCreateParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewBarbicanCreateParamsWithTimeout creates a new BarbicanCreateParams object
// with the ability to set a timeout on a request.
func NewBarbicanCreateParamsWithTimeout(timeout time.Duration) *BarbicanCreateParams {
	return &BarbicanCreateParams{
		timeout: timeout,
	}
}

// NewBarbicanCreateParamsWithContext creates a new BarbicanCreateParams object
// with the ability to set a context for a request.
func NewBarbicanCreateParamsWithContext(ctx context.Context) *BarbicanCreateParams {
	return &BarbicanCreateParams{
		Context: ctx,
	}
}

// NewBarbicanCreateParamsWithHTTPClient creates a new BarbicanCreateParams object
// with the ability to set a custom HTTPClient for a request.
func NewBarbicanCreateParamsWithHTTPClient(client *http.Client) *BarbicanCreateParams {
	return &BarbicanCreateParams{
		HTTPClient: client,
	}
}

/*
BarbicanCreateParams contains all the parameters to send to the API endpoint

	for the barbican create operation.

	Typically these are written to a http.Request.
*/
type BarbicanCreateParams struct {

	/* Info.

	   Info specification
	*/
	Info *models.Barbican

	/* ReturnRecords.

	   The default is false.  If set to true, the records are returned.
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning. When doing a POST, PATCH, or DELETE operation on a single record, the default is 0 seconds.  This means that if an asynchronous operation is started, the server immediately returns HTTP code 202 (Accepted) along with a link to the job.  If a non-zero value is specified for POST, PATCH, or DELETE operations, ONTAP waits that length of time to see if the job completes so it can return something other than 202.
	*/
	ReturnTimeout *int64

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the barbican create params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *BarbicanCreateParams) WithDefaults() *BarbicanCreateParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the barbican create params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *BarbicanCreateParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(false)

		returnTimeoutDefault = int64(0)
	)

	val := BarbicanCreateParams{
		ReturnRecords: &returnRecordsDefault,
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the barbican create params
func (o *BarbicanCreateParams) WithTimeout(timeout time.Duration) *BarbicanCreateParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the barbican create params
func (o *BarbicanCreateParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the barbican create params
func (o *BarbicanCreateParams) WithContext(ctx context.Context) *BarbicanCreateParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the barbican create params
func (o *BarbicanCreateParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the barbican create params
func (o *BarbicanCreateParams) WithHTTPClient(client *http.Client) *BarbicanCreateParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the barbican create params
func (o *BarbicanCreateParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithInfo adds the info to the barbican create params
func (o *BarbicanCreateParams) WithInfo(info *models.Barbican) *BarbicanCreateParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the barbican create params
func (o *BarbicanCreateParams) SetInfo(info *models.Barbican) {
	o.Info = info
}

// WithReturnRecords adds the returnRecords to the barbican create params
func (o *BarbicanCreateParams) WithReturnRecords(returnRecords *bool) *BarbicanCreateParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the barbican create params
func (o *BarbicanCreateParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the barbican create params
func (o *BarbicanCreateParams) WithReturnTimeout(returnTimeout *int64) *BarbicanCreateParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the barbican create params
func (o *BarbicanCreateParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WriteToRequest writes these params to a swagger request
func (o *BarbicanCreateParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Info != nil {
		if err := r.SetBodyParam(o.Info); err != nil {
			return err
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
