// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// BarbicanCreateReader is a Reader for the BarbicanCreate structure.
type BarbicanCreateReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *BarbicanCreateReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 201:
		result := NewBarbicanCreateCreated()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 202:
		result := NewBarbicanCreateAccepted()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewBarbicanCreateDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewBarbicanCreateCreated creates a BarbicanCreateCreated with default headers values
func NewBarbicanCreateCreated() *BarbicanCreateCreated {
	return &BarbicanCreateCreated{}
}

/*
BarbicanCreateCreated describes a response with status code 201, with default header values.

Created
*/
type BarbicanCreateCreated struct {

	/* Useful for tracking the resource location
	 */
	Location string

	Payload *models.BarbicanJobLinkResponse
}

// IsSuccess returns true when this barbican create created response has a 2xx status code
func (o *BarbicanCreateCreated) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this barbican create created response has a 3xx status code
func (o *BarbicanCreateCreated) IsRedirect() bool {
	return false
}

// IsClientError returns true when this barbican create created response has a 4xx status code
func (o *BarbicanCreateCreated) IsClientError() bool {
	return false
}

// IsServerError returns true when this barbican create created response has a 5xx status code
func (o *BarbicanCreateCreated) IsServerError() bool {
	return false
}

// IsCode returns true when this barbican create created response a status code equal to that given
func (o *BarbicanCreateCreated) IsCode(code int) bool {
	return code == 201
}

// Code gets the status code for the barbican create created response
func (o *BarbicanCreateCreated) Code() int {
	return 201
}

func (o *BarbicanCreateCreated) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /security/barbican-kms][%d] barbicanCreateCreated %s", 201, payload)
}

func (o *BarbicanCreateCreated) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /security/barbican-kms][%d] barbicanCreateCreated %s", 201, payload)
}

func (o *BarbicanCreateCreated) GetPayload() *models.BarbicanJobLinkResponse {
	return o.Payload
}

func (o *BarbicanCreateCreated) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header Location
	hdrLocation := response.GetHeader("Location")

	if hdrLocation != "" {
		o.Location = hdrLocation
	}

	o.Payload = new(models.BarbicanJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewBarbicanCreateAccepted creates a BarbicanCreateAccepted with default headers values
func NewBarbicanCreateAccepted() *BarbicanCreateAccepted {
	return &BarbicanCreateAccepted{}
}

/*
BarbicanCreateAccepted describes a response with status code 202, with default header values.

Accepted
*/
type BarbicanCreateAccepted struct {

	/* Useful for tracking the resource location
	 */
	Location string

	Payload *models.BarbicanJobLinkResponse
}

// IsSuccess returns true when this barbican create accepted response has a 2xx status code
func (o *BarbicanCreateAccepted) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this barbican create accepted response has a 3xx status code
func (o *BarbicanCreateAccepted) IsRedirect() bool {
	return false
}

// IsClientError returns true when this barbican create accepted response has a 4xx status code
func (o *BarbicanCreateAccepted) IsClientError() bool {
	return false
}

// IsServerError returns true when this barbican create accepted response has a 5xx status code
func (o *BarbicanCreateAccepted) IsServerError() bool {
	return false
}

// IsCode returns true when this barbican create accepted response a status code equal to that given
func (o *BarbicanCreateAccepted) IsCode(code int) bool {
	return code == 202
}

// Code gets the status code for the barbican create accepted response
func (o *BarbicanCreateAccepted) Code() int {
	return 202
}

func (o *BarbicanCreateAccepted) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /security/barbican-kms][%d] barbicanCreateAccepted %s", 202, payload)
}

func (o *BarbicanCreateAccepted) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /security/barbican-kms][%d] barbicanCreateAccepted %s", 202, payload)
}

func (o *BarbicanCreateAccepted) GetPayload() *models.BarbicanJobLinkResponse {
	return o.Payload
}

func (o *BarbicanCreateAccepted) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header Location
	hdrLocation := response.GetHeader("Location")

	if hdrLocation != "" {
		o.Location = hdrLocation
	}

	o.Payload = new(models.BarbicanJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewBarbicanCreateDefault creates a BarbicanCreateDefault with default headers values
func NewBarbicanCreateDefault(code int) *BarbicanCreateDefault {
	return &BarbicanCreateDefault{
		_statusCode: code,
	}
}

/*
	BarbicanCreateDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 1115127 | Package MT_EK_MGMT is not licensed in the cluster. |
| 65539805 | Failed to create a Barbican Key Management Service configuration because the "application-cred-secret" field is invalid or was not provided. |
| 65539806 | Barbican Key Management Service (KMS) cannot be configured because not all nodes in the cluster are running an effective cluster version of 9.17 or later to support the Barbican KMS feature. |
| 65539807 | Barbican Key Management Service is not supported for the admin SVM. |
| 65539808 | Failed to create the specified Barbican Key Management Service configuration because a Barbican Key Management Service configuration with the same name already exists. |
| 65539809 | Barbican Key Management Service is not supported in MetroCluster configurations. |
| 65539810 | Failed to create a Barbican Key Management Service configuration because the "key-id" field is invalid or was not provided. The URI scheme must be HTTPS. |
| 65539811 | Failed to create a Barbican Key Management Service configuration because the "keystone-url" field is invalid or was not provided. The URI scheme must be HTTPS. |
| 65539835 | Failed to create a Barbican Key Management Service configuration because the "application-cred-id" field cannot be empty. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type BarbicanCreateDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this barbican create default response has a 2xx status code
func (o *BarbicanCreateDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this barbican create default response has a 3xx status code
func (o *BarbicanCreateDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this barbican create default response has a 4xx status code
func (o *BarbicanCreateDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this barbican create default response has a 5xx status code
func (o *BarbicanCreateDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this barbican create default response a status code equal to that given
func (o *BarbicanCreateDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the barbican create default response
func (o *BarbicanCreateDefault) Code() int {
	return o._statusCode
}

func (o *BarbicanCreateDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /security/barbican-kms][%d] barbican_create default %s", o._statusCode, payload)
}

func (o *BarbicanCreateDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /security/barbican-kms][%d] barbican_create default %s", o._statusCode, payload)
}

func (o *BarbicanCreateDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *BarbicanCreateDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
