// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// BarbicanGetReader is a Reader for the BarbicanGet structure.
type BarbicanGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *BarbicanGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewBarbicanGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewBarbicanGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewBarbicanGetOK creates a BarbicanGetOK with default headers values
func NewBarbicanGetOK() *BarbicanGetOK {
	return &BarbicanGetOK{}
}

/*
BarbicanGetOK describes a response with status code 200, with default header values.

OK
*/
type BarbicanGetOK struct {
	Payload *models.Barbican
}

// IsSuccess returns true when this barbican get o k response has a 2xx status code
func (o *BarbicanGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this barbican get o k response has a 3xx status code
func (o *BarbicanGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this barbican get o k response has a 4xx status code
func (o *BarbicanGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this barbican get o k response has a 5xx status code
func (o *BarbicanGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this barbican get o k response a status code equal to that given
func (o *BarbicanGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the barbican get o k response
func (o *BarbicanGetOK) Code() int {
	return 200
}

func (o *BarbicanGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /security/barbican-kms/{uuid}][%d] barbicanGetOK %s", 200, payload)
}

func (o *BarbicanGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /security/barbican-kms/{uuid}][%d] barbicanGetOK %s", 200, payload)
}

func (o *BarbicanGetOK) GetPayload() *models.Barbican {
	return o.Payload
}

func (o *BarbicanGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Barbican)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewBarbicanGetDefault creates a BarbicanGetDefault with default headers values
func NewBarbicanGetDefault(code int) *BarbicanGetDefault {
	return &BarbicanGetDefault{
		_statusCode: code,
	}
}

/*
	BarbicanGetDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 65539801 | The Barbican Key Management Service is unreachable from one or more nodes. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type BarbicanGetDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this barbican get default response has a 2xx status code
func (o *BarbicanGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this barbican get default response has a 3xx status code
func (o *BarbicanGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this barbican get default response has a 4xx status code
func (o *BarbicanGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this barbican get default response has a 5xx status code
func (o *BarbicanGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this barbican get default response a status code equal to that given
func (o *BarbicanGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the barbican get default response
func (o *BarbicanGetDefault) Code() int {
	return o._statusCode
}

func (o *BarbicanGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /security/barbican-kms/{uuid}][%d] barbican_get default %s", o._statusCode, payload)
}

func (o *BarbicanGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /security/barbican-kms/{uuid}][%d] barbican_get default %s", o._statusCode, payload)
}

func (o *BarbicanGetDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *BarbicanGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
