// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewBarbicanModifyCollectionParams creates a new BarbicanModifyCollectionParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewBarbicanModifyCollectionParams() *BarbicanModifyCollectionParams {
	return &BarbicanModifyCollectionParams{
		requestTimeout: cr.DefaultTimeout,
	}
}

// NewBarbicanModifyCollectionParamsWithTimeout creates a new BarbicanModifyCollectionParams object
// with the ability to set a timeout on a request.
func NewBarbicanModifyCollectionParamsWithTimeout(timeout time.Duration) *BarbicanModifyCollectionParams {
	return &BarbicanModifyCollectionParams{
		requestTimeout: timeout,
	}
}

// NewBarbicanModifyCollectionParamsWithContext creates a new BarbicanModifyCollectionParams object
// with the ability to set a context for a request.
func NewBarbicanModifyCollectionParamsWithContext(ctx context.Context) *BarbicanModifyCollectionParams {
	return &BarbicanModifyCollectionParams{
		Context: ctx,
	}
}

// NewBarbicanModifyCollectionParamsWithHTTPClient creates a new BarbicanModifyCollectionParams object
// with the ability to set a custom HTTPClient for a request.
func NewBarbicanModifyCollectionParamsWithHTTPClient(client *http.Client) *BarbicanModifyCollectionParams {
	return &BarbicanModifyCollectionParams{
		HTTPClient: client,
	}
}

/*
BarbicanModifyCollectionParams contains all the parameters to send to the API endpoint

	for the barbican modify collection operation.

	Typically these are written to a http.Request.
*/
type BarbicanModifyCollectionParams struct {

	/* ApplicationCredID.

	   Filter by application_cred_id
	*/
	ApplicationCredID *string

	/* BarbicanReachabilityCode.

	   Filter by barbican_reachability.code
	*/
	BarbicanReachabilityCode *string

	/* BarbicanReachabilityMessage.

	   Filter by barbican_reachability.message
	*/
	BarbicanReachabilityMessage *string

	/* BarbicanReachabilityReachable.

	   Filter by barbican_reachability.reachable
	*/
	BarbicanReachabilityReachable *bool

	/* ConfigurationName.

	   Filter by configuration.name
	*/
	ConfigurationName *string

	/* ConfigurationUUID.

	   Filter by configuration.uuid
	*/
	ConfigurationUUID *string

	/* ContinueOnFailure.

	   Continue even when the operation fails on one of the records.
	*/
	ContinueOnFailure *bool

	/* Enabled.

	   Filter by enabled
	*/
	Enabled *bool

	/* Info.

	   Info specification
	*/
	Info BarbicanModifyCollectionBody

	/* KeyID.

	   Filter by key_id
	*/
	KeyID *string

	/* KeystoneURL.

	   Filter by keystone_url
	*/
	KeystoneURL *string

	/* ProxyHost.

	   Filter by proxy_host
	*/
	ProxyHost *string

	/* ProxyPort.

	   Filter by proxy_port
	*/
	ProxyPort *int64

	/* ProxyType.

	   Filter by proxy_type
	*/
	ProxyType *string

	/* ProxyUsername.

	   Filter by proxy_username
	*/
	ProxyUsername *string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* Scope.

	   Filter by scope
	*/
	Scope *string

	/* SerialRecords.

	   Perform the operation on the records synchronously.
	*/
	SerialRecords *bool

	/* StateClusterState.

	   Filter by state.cluster_state
	*/
	StateClusterState *bool

	/* StateCode.

	   Filter by state.code
	*/
	StateCode *string

	/* StateMessage.

	   Filter by state.message
	*/
	StateMessage *string

	/* SvmName.

	   Filter by svm.name
	*/
	SvmName *string

	/* SvmUUID.

	   Filter by svm.uuid
	*/
	SvmUUID *string

	/* Timeout.

	   Filter by timeout
	*/
	Timeout *int64

	/* UUID.

	   Filter by uuid
	*/
	UUID *string

	/* Verify.

	   Filter by verify
	*/
	Verify *bool

	/* VerifyHost.

	   Filter by verify_host
	*/
	VerifyHost *bool

	requestTimeout time.Duration
	Context        context.Context
	HTTPClient     *http.Client
}

// WithDefaults hydrates default values in the barbican modify collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *BarbicanModifyCollectionParams) WithDefaults() *BarbicanModifyCollectionParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the barbican modify collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *BarbicanModifyCollectionParams) SetDefaults() {
	var (
		continueOnFailureDefault = bool(false)

		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)

		serialRecordsDefault = bool(false)
	)

	val := BarbicanModifyCollectionParams{
		ContinueOnFailure: &continueOnFailureDefault,
		ReturnRecords:     &returnRecordsDefault,
		ReturnTimeout:     &returnTimeoutDefault,
		SerialRecords:     &serialRecordsDefault,
	}

	val.requestTimeout = o.requestTimeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithRequestTimeout adds the timeout to the barbican modify collection params
func (o *BarbicanModifyCollectionParams) WithRequestTimeout(timeout time.Duration) *BarbicanModifyCollectionParams {
	o.SetRequestTimeout(timeout)
	return o
}

// SetRequestTimeout adds the timeout to the barbican modify collection params
func (o *BarbicanModifyCollectionParams) SetRequestTimeout(timeout time.Duration) {
	o.requestTimeout = timeout
}

// WithContext adds the context to the barbican modify collection params
func (o *BarbicanModifyCollectionParams) WithContext(ctx context.Context) *BarbicanModifyCollectionParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the barbican modify collection params
func (o *BarbicanModifyCollectionParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the barbican modify collection params
func (o *BarbicanModifyCollectionParams) WithHTTPClient(client *http.Client) *BarbicanModifyCollectionParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the barbican modify collection params
func (o *BarbicanModifyCollectionParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithApplicationCredID adds the applicationCredID to the barbican modify collection params
func (o *BarbicanModifyCollectionParams) WithApplicationCredID(applicationCredID *string) *BarbicanModifyCollectionParams {
	o.SetApplicationCredID(applicationCredID)
	return o
}

// SetApplicationCredID adds the applicationCredId to the barbican modify collection params
func (o *BarbicanModifyCollectionParams) SetApplicationCredID(applicationCredID *string) {
	o.ApplicationCredID = applicationCredID
}

// WithBarbicanReachabilityCode adds the barbicanReachabilityCode to the barbican modify collection params
func (o *BarbicanModifyCollectionParams) WithBarbicanReachabilityCode(barbicanReachabilityCode *string) *BarbicanModifyCollectionParams {
	o.SetBarbicanReachabilityCode(barbicanReachabilityCode)
	return o
}

// SetBarbicanReachabilityCode adds the barbicanReachabilityCode to the barbican modify collection params
func (o *BarbicanModifyCollectionParams) SetBarbicanReachabilityCode(barbicanReachabilityCode *string) {
	o.BarbicanReachabilityCode = barbicanReachabilityCode
}

// WithBarbicanReachabilityMessage adds the barbicanReachabilityMessage to the barbican modify collection params
func (o *BarbicanModifyCollectionParams) WithBarbicanReachabilityMessage(barbicanReachabilityMessage *string) *BarbicanModifyCollectionParams {
	o.SetBarbicanReachabilityMessage(barbicanReachabilityMessage)
	return o
}

// SetBarbicanReachabilityMessage adds the barbicanReachabilityMessage to the barbican modify collection params
func (o *BarbicanModifyCollectionParams) SetBarbicanReachabilityMessage(barbicanReachabilityMessage *string) {
	o.BarbicanReachabilityMessage = barbicanReachabilityMessage
}

// WithBarbicanReachabilityReachable adds the barbicanReachabilityReachable to the barbican modify collection params
func (o *BarbicanModifyCollectionParams) WithBarbicanReachabilityReachable(barbicanReachabilityReachable *bool) *BarbicanModifyCollectionParams {
	o.SetBarbicanReachabilityReachable(barbicanReachabilityReachable)
	return o
}

// SetBarbicanReachabilityReachable adds the barbicanReachabilityReachable to the barbican modify collection params
func (o *BarbicanModifyCollectionParams) SetBarbicanReachabilityReachable(barbicanReachabilityReachable *bool) {
	o.BarbicanReachabilityReachable = barbicanReachabilityReachable
}

// WithConfigurationName adds the configurationName to the barbican modify collection params
func (o *BarbicanModifyCollectionParams) WithConfigurationName(configurationName *string) *BarbicanModifyCollectionParams {
	o.SetConfigurationName(configurationName)
	return o
}

// SetConfigurationName adds the configurationName to the barbican modify collection params
func (o *BarbicanModifyCollectionParams) SetConfigurationName(configurationName *string) {
	o.ConfigurationName = configurationName
}

// WithConfigurationUUID adds the configurationUUID to the barbican modify collection params
func (o *BarbicanModifyCollectionParams) WithConfigurationUUID(configurationUUID *string) *BarbicanModifyCollectionParams {
	o.SetConfigurationUUID(configurationUUID)
	return o
}

// SetConfigurationUUID adds the configurationUuid to the barbican modify collection params
func (o *BarbicanModifyCollectionParams) SetConfigurationUUID(configurationUUID *string) {
	o.ConfigurationUUID = configurationUUID
}

// WithContinueOnFailure adds the continueOnFailure to the barbican modify collection params
func (o *BarbicanModifyCollectionParams) WithContinueOnFailure(continueOnFailure *bool) *BarbicanModifyCollectionParams {
	o.SetContinueOnFailure(continueOnFailure)
	return o
}

// SetContinueOnFailure adds the continueOnFailure to the barbican modify collection params
func (o *BarbicanModifyCollectionParams) SetContinueOnFailure(continueOnFailure *bool) {
	o.ContinueOnFailure = continueOnFailure
}

// WithEnabled adds the enabled to the barbican modify collection params
func (o *BarbicanModifyCollectionParams) WithEnabled(enabled *bool) *BarbicanModifyCollectionParams {
	o.SetEnabled(enabled)
	return o
}

// SetEnabled adds the enabled to the barbican modify collection params
func (o *BarbicanModifyCollectionParams) SetEnabled(enabled *bool) {
	o.Enabled = enabled
}

// WithInfo adds the info to the barbican modify collection params
func (o *BarbicanModifyCollectionParams) WithInfo(info BarbicanModifyCollectionBody) *BarbicanModifyCollectionParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the barbican modify collection params
func (o *BarbicanModifyCollectionParams) SetInfo(info BarbicanModifyCollectionBody) {
	o.Info = info
}

// WithKeyID adds the keyID to the barbican modify collection params
func (o *BarbicanModifyCollectionParams) WithKeyID(keyID *string) *BarbicanModifyCollectionParams {
	o.SetKeyID(keyID)
	return o
}

// SetKeyID adds the keyId to the barbican modify collection params
func (o *BarbicanModifyCollectionParams) SetKeyID(keyID *string) {
	o.KeyID = keyID
}

// WithKeystoneURL adds the keystoneURL to the barbican modify collection params
func (o *BarbicanModifyCollectionParams) WithKeystoneURL(keystoneURL *string) *BarbicanModifyCollectionParams {
	o.SetKeystoneURL(keystoneURL)
	return o
}

// SetKeystoneURL adds the keystoneUrl to the barbican modify collection params
func (o *BarbicanModifyCollectionParams) SetKeystoneURL(keystoneURL *string) {
	o.KeystoneURL = keystoneURL
}

// WithProxyHost adds the proxyHost to the barbican modify collection params
func (o *BarbicanModifyCollectionParams) WithProxyHost(proxyHost *string) *BarbicanModifyCollectionParams {
	o.SetProxyHost(proxyHost)
	return o
}

// SetProxyHost adds the proxyHost to the barbican modify collection params
func (o *BarbicanModifyCollectionParams) SetProxyHost(proxyHost *string) {
	o.ProxyHost = proxyHost
}

// WithProxyPort adds the proxyPort to the barbican modify collection params
func (o *BarbicanModifyCollectionParams) WithProxyPort(proxyPort *int64) *BarbicanModifyCollectionParams {
	o.SetProxyPort(proxyPort)
	return o
}

// SetProxyPort adds the proxyPort to the barbican modify collection params
func (o *BarbicanModifyCollectionParams) SetProxyPort(proxyPort *int64) {
	o.ProxyPort = proxyPort
}

// WithProxyType adds the proxyType to the barbican modify collection params
func (o *BarbicanModifyCollectionParams) WithProxyType(proxyType *string) *BarbicanModifyCollectionParams {
	o.SetProxyType(proxyType)
	return o
}

// SetProxyType adds the proxyType to the barbican modify collection params
func (o *BarbicanModifyCollectionParams) SetProxyType(proxyType *string) {
	o.ProxyType = proxyType
}

// WithProxyUsername adds the proxyUsername to the barbican modify collection params
func (o *BarbicanModifyCollectionParams) WithProxyUsername(proxyUsername *string) *BarbicanModifyCollectionParams {
	o.SetProxyUsername(proxyUsername)
	return o
}

// SetProxyUsername adds the proxyUsername to the barbican modify collection params
func (o *BarbicanModifyCollectionParams) SetProxyUsername(proxyUsername *string) {
	o.ProxyUsername = proxyUsername
}

// WithReturnRecords adds the returnRecords to the barbican modify collection params
func (o *BarbicanModifyCollectionParams) WithReturnRecords(returnRecords *bool) *BarbicanModifyCollectionParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the barbican modify collection params
func (o *BarbicanModifyCollectionParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the barbican modify collection params
func (o *BarbicanModifyCollectionParams) WithReturnTimeout(returnTimeout *int64) *BarbicanModifyCollectionParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the barbican modify collection params
func (o *BarbicanModifyCollectionParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithScope adds the scope to the barbican modify collection params
func (o *BarbicanModifyCollectionParams) WithScope(scope *string) *BarbicanModifyCollectionParams {
	o.SetScope(scope)
	return o
}

// SetScope adds the scope to the barbican modify collection params
func (o *BarbicanModifyCollectionParams) SetScope(scope *string) {
	o.Scope = scope
}

// WithSerialRecords adds the serialRecords to the barbican modify collection params
func (o *BarbicanModifyCollectionParams) WithSerialRecords(serialRecords *bool) *BarbicanModifyCollectionParams {
	o.SetSerialRecords(serialRecords)
	return o
}

// SetSerialRecords adds the serialRecords to the barbican modify collection params
func (o *BarbicanModifyCollectionParams) SetSerialRecords(serialRecords *bool) {
	o.SerialRecords = serialRecords
}

// WithStateClusterState adds the stateClusterState to the barbican modify collection params
func (o *BarbicanModifyCollectionParams) WithStateClusterState(stateClusterState *bool) *BarbicanModifyCollectionParams {
	o.SetStateClusterState(stateClusterState)
	return o
}

// SetStateClusterState adds the stateClusterState to the barbican modify collection params
func (o *BarbicanModifyCollectionParams) SetStateClusterState(stateClusterState *bool) {
	o.StateClusterState = stateClusterState
}

// WithStateCode adds the stateCode to the barbican modify collection params
func (o *BarbicanModifyCollectionParams) WithStateCode(stateCode *string) *BarbicanModifyCollectionParams {
	o.SetStateCode(stateCode)
	return o
}

// SetStateCode adds the stateCode to the barbican modify collection params
func (o *BarbicanModifyCollectionParams) SetStateCode(stateCode *string) {
	o.StateCode = stateCode
}

// WithStateMessage adds the stateMessage to the barbican modify collection params
func (o *BarbicanModifyCollectionParams) WithStateMessage(stateMessage *string) *BarbicanModifyCollectionParams {
	o.SetStateMessage(stateMessage)
	return o
}

// SetStateMessage adds the stateMessage to the barbican modify collection params
func (o *BarbicanModifyCollectionParams) SetStateMessage(stateMessage *string) {
	o.StateMessage = stateMessage
}

// WithSvmName adds the svmName to the barbican modify collection params
func (o *BarbicanModifyCollectionParams) WithSvmName(svmName *string) *BarbicanModifyCollectionParams {
	o.SetSvmName(svmName)
	return o
}

// SetSvmName adds the svmName to the barbican modify collection params
func (o *BarbicanModifyCollectionParams) SetSvmName(svmName *string) {
	o.SvmName = svmName
}

// WithSvmUUID adds the svmUUID to the barbican modify collection params
func (o *BarbicanModifyCollectionParams) WithSvmUUID(svmUUID *string) *BarbicanModifyCollectionParams {
	o.SetSvmUUID(svmUUID)
	return o
}

// SetSvmUUID adds the svmUuid to the barbican modify collection params
func (o *BarbicanModifyCollectionParams) SetSvmUUID(svmUUID *string) {
	o.SvmUUID = svmUUID
}

// WithTimeout adds the timeout to the barbican modify collection params
func (o *BarbicanModifyCollectionParams) WithTimeout(timeout *int64) *BarbicanModifyCollectionParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the barbican modify collection params
func (o *BarbicanModifyCollectionParams) SetTimeout(timeout *int64) {
	o.Timeout = timeout
}

// WithUUID adds the uuid to the barbican modify collection params
func (o *BarbicanModifyCollectionParams) WithUUID(uuid *string) *BarbicanModifyCollectionParams {
	o.SetUUID(uuid)
	return o
}

// SetUUID adds the uuid to the barbican modify collection params
func (o *BarbicanModifyCollectionParams) SetUUID(uuid *string) {
	o.UUID = uuid
}

// WithVerify adds the verify to the barbican modify collection params
func (o *BarbicanModifyCollectionParams) WithVerify(verify *bool) *BarbicanModifyCollectionParams {
	o.SetVerify(verify)
	return o
}

// SetVerify adds the verify to the barbican modify collection params
func (o *BarbicanModifyCollectionParams) SetVerify(verify *bool) {
	o.Verify = verify
}

// WithVerifyHost adds the verifyHost to the barbican modify collection params
func (o *BarbicanModifyCollectionParams) WithVerifyHost(verifyHost *bool) *BarbicanModifyCollectionParams {
	o.SetVerifyHost(verifyHost)
	return o
}

// SetVerifyHost adds the verifyHost to the barbican modify collection params
func (o *BarbicanModifyCollectionParams) SetVerifyHost(verifyHost *bool) {
	o.VerifyHost = verifyHost
}

// WriteToRequest writes these params to a swagger request
func (o *BarbicanModifyCollectionParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.requestTimeout); err != nil {
		return err
	}
	var res []error

	if o.ApplicationCredID != nil {

		// query param application_cred_id
		var qrApplicationCredID string

		if o.ApplicationCredID != nil {
			qrApplicationCredID = *o.ApplicationCredID
		}
		qApplicationCredID := qrApplicationCredID
		if qApplicationCredID != "" {

			if err := r.SetQueryParam("application_cred_id", qApplicationCredID); err != nil {
				return err
			}
		}
	}

	if o.BarbicanReachabilityCode != nil {

		// query param barbican_reachability.code
		var qrBarbicanReachabilityCode string

		if o.BarbicanReachabilityCode != nil {
			qrBarbicanReachabilityCode = *o.BarbicanReachabilityCode
		}
		qBarbicanReachabilityCode := qrBarbicanReachabilityCode
		if qBarbicanReachabilityCode != "" {

			if err := r.SetQueryParam("barbican_reachability.code", qBarbicanReachabilityCode); err != nil {
				return err
			}
		}
	}

	if o.BarbicanReachabilityMessage != nil {

		// query param barbican_reachability.message
		var qrBarbicanReachabilityMessage string

		if o.BarbicanReachabilityMessage != nil {
			qrBarbicanReachabilityMessage = *o.BarbicanReachabilityMessage
		}
		qBarbicanReachabilityMessage := qrBarbicanReachabilityMessage
		if qBarbicanReachabilityMessage != "" {

			if err := r.SetQueryParam("barbican_reachability.message", qBarbicanReachabilityMessage); err != nil {
				return err
			}
		}
	}

	if o.BarbicanReachabilityReachable != nil {

		// query param barbican_reachability.reachable
		var qrBarbicanReachabilityReachable bool

		if o.BarbicanReachabilityReachable != nil {
			qrBarbicanReachabilityReachable = *o.BarbicanReachabilityReachable
		}
		qBarbicanReachabilityReachable := swag.FormatBool(qrBarbicanReachabilityReachable)
		if qBarbicanReachabilityReachable != "" {

			if err := r.SetQueryParam("barbican_reachability.reachable", qBarbicanReachabilityReachable); err != nil {
				return err
			}
		}
	}

	if o.ConfigurationName != nil {

		// query param configuration.name
		var qrConfigurationName string

		if o.ConfigurationName != nil {
			qrConfigurationName = *o.ConfigurationName
		}
		qConfigurationName := qrConfigurationName
		if qConfigurationName != "" {

			if err := r.SetQueryParam("configuration.name", qConfigurationName); err != nil {
				return err
			}
		}
	}

	if o.ConfigurationUUID != nil {

		// query param configuration.uuid
		var qrConfigurationUUID string

		if o.ConfigurationUUID != nil {
			qrConfigurationUUID = *o.ConfigurationUUID
		}
		qConfigurationUUID := qrConfigurationUUID
		if qConfigurationUUID != "" {

			if err := r.SetQueryParam("configuration.uuid", qConfigurationUUID); err != nil {
				return err
			}
		}
	}

	if o.ContinueOnFailure != nil {

		// query param continue_on_failure
		var qrContinueOnFailure bool

		if o.ContinueOnFailure != nil {
			qrContinueOnFailure = *o.ContinueOnFailure
		}
		qContinueOnFailure := swag.FormatBool(qrContinueOnFailure)
		if qContinueOnFailure != "" {

			if err := r.SetQueryParam("continue_on_failure", qContinueOnFailure); err != nil {
				return err
			}
		}
	}

	if o.Enabled != nil {

		// query param enabled
		var qrEnabled bool

		if o.Enabled != nil {
			qrEnabled = *o.Enabled
		}
		qEnabled := swag.FormatBool(qrEnabled)
		if qEnabled != "" {

			if err := r.SetQueryParam("enabled", qEnabled); err != nil {
				return err
			}
		}
	}
	if err := r.SetBodyParam(o.Info); err != nil {
		return err
	}

	if o.KeyID != nil {

		// query param key_id
		var qrKeyID string

		if o.KeyID != nil {
			qrKeyID = *o.KeyID
		}
		qKeyID := qrKeyID
		if qKeyID != "" {

			if err := r.SetQueryParam("key_id", qKeyID); err != nil {
				return err
			}
		}
	}

	if o.KeystoneURL != nil {

		// query param keystone_url
		var qrKeystoneURL string

		if o.KeystoneURL != nil {
			qrKeystoneURL = *o.KeystoneURL
		}
		qKeystoneURL := qrKeystoneURL
		if qKeystoneURL != "" {

			if err := r.SetQueryParam("keystone_url", qKeystoneURL); err != nil {
				return err
			}
		}
	}

	if o.ProxyHost != nil {

		// query param proxy_host
		var qrProxyHost string

		if o.ProxyHost != nil {
			qrProxyHost = *o.ProxyHost
		}
		qProxyHost := qrProxyHost
		if qProxyHost != "" {

			if err := r.SetQueryParam("proxy_host", qProxyHost); err != nil {
				return err
			}
		}
	}

	if o.ProxyPort != nil {

		// query param proxy_port
		var qrProxyPort int64

		if o.ProxyPort != nil {
			qrProxyPort = *o.ProxyPort
		}
		qProxyPort := swag.FormatInt64(qrProxyPort)
		if qProxyPort != "" {

			if err := r.SetQueryParam("proxy_port", qProxyPort); err != nil {
				return err
			}
		}
	}

	if o.ProxyType != nil {

		// query param proxy_type
		var qrProxyType string

		if o.ProxyType != nil {
			qrProxyType = *o.ProxyType
		}
		qProxyType := qrProxyType
		if qProxyType != "" {

			if err := r.SetQueryParam("proxy_type", qProxyType); err != nil {
				return err
			}
		}
	}

	if o.ProxyUsername != nil {

		// query param proxy_username
		var qrProxyUsername string

		if o.ProxyUsername != nil {
			qrProxyUsername = *o.ProxyUsername
		}
		qProxyUsername := qrProxyUsername
		if qProxyUsername != "" {

			if err := r.SetQueryParam("proxy_username", qProxyUsername); err != nil {
				return err
			}
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.Scope != nil {

		// query param scope
		var qrScope string

		if o.Scope != nil {
			qrScope = *o.Scope
		}
		qScope := qrScope
		if qScope != "" {

			if err := r.SetQueryParam("scope", qScope); err != nil {
				return err
			}
		}
	}

	if o.SerialRecords != nil {

		// query param serial_records
		var qrSerialRecords bool

		if o.SerialRecords != nil {
			qrSerialRecords = *o.SerialRecords
		}
		qSerialRecords := swag.FormatBool(qrSerialRecords)
		if qSerialRecords != "" {

			if err := r.SetQueryParam("serial_records", qSerialRecords); err != nil {
				return err
			}
		}
	}

	if o.StateClusterState != nil {

		// query param state.cluster_state
		var qrStateClusterState bool

		if o.StateClusterState != nil {
			qrStateClusterState = *o.StateClusterState
		}
		qStateClusterState := swag.FormatBool(qrStateClusterState)
		if qStateClusterState != "" {

			if err := r.SetQueryParam("state.cluster_state", qStateClusterState); err != nil {
				return err
			}
		}
	}

	if o.StateCode != nil {

		// query param state.code
		var qrStateCode string

		if o.StateCode != nil {
			qrStateCode = *o.StateCode
		}
		qStateCode := qrStateCode
		if qStateCode != "" {

			if err := r.SetQueryParam("state.code", qStateCode); err != nil {
				return err
			}
		}
	}

	if o.StateMessage != nil {

		// query param state.message
		var qrStateMessage string

		if o.StateMessage != nil {
			qrStateMessage = *o.StateMessage
		}
		qStateMessage := qrStateMessage
		if qStateMessage != "" {

			if err := r.SetQueryParam("state.message", qStateMessage); err != nil {
				return err
			}
		}
	}

	if o.SvmName != nil {

		// query param svm.name
		var qrSvmName string

		if o.SvmName != nil {
			qrSvmName = *o.SvmName
		}
		qSvmName := qrSvmName
		if qSvmName != "" {

			if err := r.SetQueryParam("svm.name", qSvmName); err != nil {
				return err
			}
		}
	}

	if o.SvmUUID != nil {

		// query param svm.uuid
		var qrSvmUUID string

		if o.SvmUUID != nil {
			qrSvmUUID = *o.SvmUUID
		}
		qSvmUUID := qrSvmUUID
		if qSvmUUID != "" {

			if err := r.SetQueryParam("svm.uuid", qSvmUUID); err != nil {
				return err
			}
		}
	}

	if o.Timeout != nil {

		// query param timeout
		var qrTimeout int64

		if o.Timeout != nil {
			qrTimeout = *o.Timeout
		}
		qTimeout := swag.FormatInt64(qrTimeout)
		if qTimeout != "" {

			if err := r.SetQueryParam("timeout", qTimeout); err != nil {
				return err
			}
		}
	}

	if o.UUID != nil {

		// query param uuid
		var qrUUID string

		if o.UUID != nil {
			qrUUID = *o.UUID
		}
		qUUID := qrUUID
		if qUUID != "" {

			if err := r.SetQueryParam("uuid", qUUID); err != nil {
				return err
			}
		}
	}

	if o.Verify != nil {

		// query param verify
		var qrVerify bool

		if o.Verify != nil {
			qrVerify = *o.Verify
		}
		qVerify := swag.FormatBool(qrVerify)
		if qVerify != "" {

			if err := r.SetQueryParam("verify", qVerify); err != nil {
				return err
			}
		}
	}

	if o.VerifyHost != nil {

		// query param verify_host
		var qrVerifyHost bool

		if o.VerifyHost != nil {
			qrVerifyHost = *o.VerifyHost
		}
		qVerifyHost := swag.FormatBool(qrVerifyHost)
		if qVerifyHost != "" {

			if err := r.SetQueryParam("verify_host", qVerifyHost); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
