// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// BarbicanModifyCollectionReader is a Reader for the BarbicanModifyCollection structure.
type BarbicanModifyCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *BarbicanModifyCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewBarbicanModifyCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 202:
		result := NewBarbicanModifyCollectionAccepted()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewBarbicanModifyCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewBarbicanModifyCollectionOK creates a BarbicanModifyCollectionOK with default headers values
func NewBarbicanModifyCollectionOK() *BarbicanModifyCollectionOK {
	return &BarbicanModifyCollectionOK{}
}

/*
BarbicanModifyCollectionOK describes a response with status code 200, with default header values.

OK
*/
type BarbicanModifyCollectionOK struct {
	Payload *models.BarbicanJobLinkResponse
}

// IsSuccess returns true when this barbican modify collection o k response has a 2xx status code
func (o *BarbicanModifyCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this barbican modify collection o k response has a 3xx status code
func (o *BarbicanModifyCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this barbican modify collection o k response has a 4xx status code
func (o *BarbicanModifyCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this barbican modify collection o k response has a 5xx status code
func (o *BarbicanModifyCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this barbican modify collection o k response a status code equal to that given
func (o *BarbicanModifyCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the barbican modify collection o k response
func (o *BarbicanModifyCollectionOK) Code() int {
	return 200
}

func (o *BarbicanModifyCollectionOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /security/barbican-kms][%d] barbicanModifyCollectionOK %s", 200, payload)
}

func (o *BarbicanModifyCollectionOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /security/barbican-kms][%d] barbicanModifyCollectionOK %s", 200, payload)
}

func (o *BarbicanModifyCollectionOK) GetPayload() *models.BarbicanJobLinkResponse {
	return o.Payload
}

func (o *BarbicanModifyCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.BarbicanJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewBarbicanModifyCollectionAccepted creates a BarbicanModifyCollectionAccepted with default headers values
func NewBarbicanModifyCollectionAccepted() *BarbicanModifyCollectionAccepted {
	return &BarbicanModifyCollectionAccepted{}
}

/*
BarbicanModifyCollectionAccepted describes a response with status code 202, with default header values.

Accepted
*/
type BarbicanModifyCollectionAccepted struct {
	Payload *models.BarbicanJobLinkResponse
}

// IsSuccess returns true when this barbican modify collection accepted response has a 2xx status code
func (o *BarbicanModifyCollectionAccepted) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this barbican modify collection accepted response has a 3xx status code
func (o *BarbicanModifyCollectionAccepted) IsRedirect() bool {
	return false
}

// IsClientError returns true when this barbican modify collection accepted response has a 4xx status code
func (o *BarbicanModifyCollectionAccepted) IsClientError() bool {
	return false
}

// IsServerError returns true when this barbican modify collection accepted response has a 5xx status code
func (o *BarbicanModifyCollectionAccepted) IsServerError() bool {
	return false
}

// IsCode returns true when this barbican modify collection accepted response a status code equal to that given
func (o *BarbicanModifyCollectionAccepted) IsCode(code int) bool {
	return code == 202
}

// Code gets the status code for the barbican modify collection accepted response
func (o *BarbicanModifyCollectionAccepted) Code() int {
	return 202
}

func (o *BarbicanModifyCollectionAccepted) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /security/barbican-kms][%d] barbicanModifyCollectionAccepted %s", 202, payload)
}

func (o *BarbicanModifyCollectionAccepted) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /security/barbican-kms][%d] barbicanModifyCollectionAccepted %s", 202, payload)
}

func (o *BarbicanModifyCollectionAccepted) GetPayload() *models.BarbicanJobLinkResponse {
	return o.Payload
}

func (o *BarbicanModifyCollectionAccepted) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.BarbicanJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewBarbicanModifyCollectionDefault creates a BarbicanModifyCollectionDefault with default headers values
func NewBarbicanModifyCollectionDefault(code int) *BarbicanModifyCollectionDefault {
	return &BarbicanModifyCollectionDefault{
		_statusCode: code,
	}
}

/*
	BarbicanModifyCollectionDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 65539223 | Failed to check the health of the Barbican Key Management Service. |
| 65539814 | Failed to update the Barbican Key Management Service configuration because the "application-cred-secret" field is invalid or was not provided. |
| 65539815 | Failed to update the Barbican Key Management Service configuration because the "application-cred-id" field is invalid or was not provided. |
| 65539832 | Specified Barbican Key Management Service configuration does not exist. |
| 65539841 | Both "application_cred_id" and "application_cred_secret" are required. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type BarbicanModifyCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this barbican modify collection default response has a 2xx status code
func (o *BarbicanModifyCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this barbican modify collection default response has a 3xx status code
func (o *BarbicanModifyCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this barbican modify collection default response has a 4xx status code
func (o *BarbicanModifyCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this barbican modify collection default response has a 5xx status code
func (o *BarbicanModifyCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this barbican modify collection default response a status code equal to that given
func (o *BarbicanModifyCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the barbican modify collection default response
func (o *BarbicanModifyCollectionDefault) Code() int {
	return o._statusCode
}

func (o *BarbicanModifyCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /security/barbican-kms][%d] barbican_modify_collection default %s", o._statusCode, payload)
}

func (o *BarbicanModifyCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /security/barbican-kms][%d] barbican_modify_collection default %s", o._statusCode, payload)
}

func (o *BarbicanModifyCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *BarbicanModifyCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
BarbicanModifyCollectionBody barbican modify collection body
swagger:model BarbicanModifyCollectionBody
*/
type BarbicanModifyCollectionBody struct {

	// links
	Links *models.BarbicanInlineLinks `json:"_links,omitempty"`

	// Keystone application credentials ID required to access the specified Barbican KMS.
	// Example: 63e3cb77f84f42b7a0395a3efb7636f9
	ApplicationCredID *string `json:"application_cred_id,omitempty"`

	// Keystone application credentials secret required to access the specified Barbican KMS. It is not audited.
	// Example: secret
	// Format: password
	ApplicationCredSecret *strfmt.Password `json:"application_cred_secret,omitempty"`

	// barbican reachability
	BarbicanReachability *models.BarbicanInlineBarbicanReachability `json:"barbican_reachability,omitempty"`

	// barbican response inline records
	BarbicanResponseInlineRecords []*models.Barbican `json:"records,omitempty"`

	// configuration
	Configuration *models.BarbicanInlineConfiguration `json:"configuration,omitempty"`

	// Indicates whether the configuration is enabled.
	// Read Only: true
	Enabled *bool `json:"enabled,omitempty"`

	// Key Identifier URL of the Barbican KMS key encryption key. Must be an HTTPS URL.
	// Example: https://172.29.58.184:9311/v1/secrets/5c610a4f-ea97-44b5-8682-f4daeafa9647
	// Format: uri
	KeyID *strfmt.URI `json:"key_id,omitempty"`

	// Keystone URL for the access token. Must be an HTTPS URL.
	// Example: https://keystoneip:5000/v3/auth/tokens
	// Format: uri
	KeystoneURL *strfmt.URI `json:"keystone_url,omitempty"`

	// Proxy host name.
	// Example: proxy.eng.com
	ProxyHost *string `json:"proxy_host,omitempty"`

	// Proxy password. Password is not audited.
	// Example: proxypassword
	// Format: password
	ProxyPassword *strfmt.Password `json:"proxy_password,omitempty"`

	// Proxy port number.
	// Example: 1234
	ProxyPort *int64 `json:"proxy_port,omitempty"`

	// Type of proxy.
	// Example: http
	// Enum: ["http","https"]
	ProxyType *string `json:"proxy_type,omitempty"`

	// Proxy username.
	// Example: proxyuser
	ProxyUsername *string `json:"proxy_username,omitempty"`

	// Set to "svm" for interfaces owned by an SVM. Otherwise, set to "cluster".
	// Read Only: true
	// Enum: ["svm","cluster"]
	Scope *string `json:"scope,omitempty"`

	// state
	State *models.BarbicanInlineState `json:"state,omitempty"`

	// svm
	Svm *models.BarbicanInlineSvm `json:"svm,omitempty"`

	// Connection timeout in seconds.
	// Example: 60
	Timeout *int64 `json:"timeout,omitempty"`

	// A unique identifier of the Barbican KMS.
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563434
	// Read Only: true
	// Format: uuid
	UUID *strfmt.UUID `json:"uuid,omitempty"`

	// Verify the identity of the Barbican KMS.
	Verify *bool `json:"verify,omitempty"`

	// Verify the identity of the Barbican KMS host name.
	VerifyHost *bool `json:"verify_host,omitempty"`
}

// Validate validates this barbican modify collection body
func (o *BarbicanModifyCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateApplicationCredSecret(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateBarbicanReachability(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateBarbicanResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateConfiguration(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateKeyID(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateKeystoneURL(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateProxyPassword(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateProxyType(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateScope(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateState(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSvm(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateUUID(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *BarbicanModifyCollectionBody) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *BarbicanModifyCollectionBody) validateApplicationCredSecret(formats strfmt.Registry) error {
	if swag.IsZero(o.ApplicationCredSecret) { // not required
		return nil
	}

	if err := validate.FormatOf("info"+"."+"application_cred_secret", "body", "password", o.ApplicationCredSecret.String(), formats); err != nil {
		return err
	}

	return nil
}

func (o *BarbicanModifyCollectionBody) validateBarbicanReachability(formats strfmt.Registry) error {
	if swag.IsZero(o.BarbicanReachability) { // not required
		return nil
	}

	if o.BarbicanReachability != nil {
		if err := o.BarbicanReachability.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "barbican_reachability")
			}
			return err
		}
	}

	return nil
}

func (o *BarbicanModifyCollectionBody) validateBarbicanResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.BarbicanResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.BarbicanResponseInlineRecords); i++ {
		if swag.IsZero(o.BarbicanResponseInlineRecords[i]) { // not required
			continue
		}

		if o.BarbicanResponseInlineRecords[i] != nil {
			if err := o.BarbicanResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *BarbicanModifyCollectionBody) validateConfiguration(formats strfmt.Registry) error {
	if swag.IsZero(o.Configuration) { // not required
		return nil
	}

	if o.Configuration != nil {
		if err := o.Configuration.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "configuration")
			}
			return err
		}
	}

	return nil
}

func (o *BarbicanModifyCollectionBody) validateKeyID(formats strfmt.Registry) error {
	if swag.IsZero(o.KeyID) { // not required
		return nil
	}

	if err := validate.FormatOf("info"+"."+"key_id", "body", "uri", o.KeyID.String(), formats); err != nil {
		return err
	}

	return nil
}

func (o *BarbicanModifyCollectionBody) validateKeystoneURL(formats strfmt.Registry) error {
	if swag.IsZero(o.KeystoneURL) { // not required
		return nil
	}

	if err := validate.FormatOf("info"+"."+"keystone_url", "body", "uri", o.KeystoneURL.String(), formats); err != nil {
		return err
	}

	return nil
}

func (o *BarbicanModifyCollectionBody) validateProxyPassword(formats strfmt.Registry) error {
	if swag.IsZero(o.ProxyPassword) { // not required
		return nil
	}

	if err := validate.FormatOf("info"+"."+"proxy_password", "body", "password", o.ProxyPassword.String(), formats); err != nil {
		return err
	}

	return nil
}

var barbicanModifyCollectionBodyTypeProxyTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["http","https"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		barbicanModifyCollectionBodyTypeProxyTypePropEnum = append(barbicanModifyCollectionBodyTypeProxyTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// BarbicanModifyCollectionBody
	// BarbicanModifyCollectionBody
	// proxy_type
	// ProxyType
	// http
	// END DEBUGGING
	// BarbicanModifyCollectionBodyProxyTypeHTTP captures enum value "http"
	BarbicanModifyCollectionBodyProxyTypeHTTP string = "http"

	// BEGIN DEBUGGING
	// BarbicanModifyCollectionBody
	// BarbicanModifyCollectionBody
	// proxy_type
	// ProxyType
	// https
	// END DEBUGGING
	// BarbicanModifyCollectionBodyProxyTypeHTTPS captures enum value "https"
	BarbicanModifyCollectionBodyProxyTypeHTTPS string = "https"
)

// prop value enum
func (o *BarbicanModifyCollectionBody) validateProxyTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, barbicanModifyCollectionBodyTypeProxyTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *BarbicanModifyCollectionBody) validateProxyType(formats strfmt.Registry) error {
	if swag.IsZero(o.ProxyType) { // not required
		return nil
	}

	// value enum
	if err := o.validateProxyTypeEnum("info"+"."+"proxy_type", "body", *o.ProxyType); err != nil {
		return err
	}

	return nil
}

var barbicanModifyCollectionBodyTypeScopePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["svm","cluster"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		barbicanModifyCollectionBodyTypeScopePropEnum = append(barbicanModifyCollectionBodyTypeScopePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// BarbicanModifyCollectionBody
	// BarbicanModifyCollectionBody
	// scope
	// Scope
	// svm
	// END DEBUGGING
	// BarbicanModifyCollectionBodyScopeSvm captures enum value "svm"
	BarbicanModifyCollectionBodyScopeSvm string = "svm"

	// BEGIN DEBUGGING
	// BarbicanModifyCollectionBody
	// BarbicanModifyCollectionBody
	// scope
	// Scope
	// cluster
	// END DEBUGGING
	// BarbicanModifyCollectionBodyScopeCluster captures enum value "cluster"
	BarbicanModifyCollectionBodyScopeCluster string = "cluster"
)

// prop value enum
func (o *BarbicanModifyCollectionBody) validateScopeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, barbicanModifyCollectionBodyTypeScopePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *BarbicanModifyCollectionBody) validateScope(formats strfmt.Registry) error {
	if swag.IsZero(o.Scope) { // not required
		return nil
	}

	// value enum
	if err := o.validateScopeEnum("info"+"."+"scope", "body", *o.Scope); err != nil {
		return err
	}

	return nil
}

func (o *BarbicanModifyCollectionBody) validateState(formats strfmt.Registry) error {
	if swag.IsZero(o.State) { // not required
		return nil
	}

	if o.State != nil {
		if err := o.State.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "state")
			}
			return err
		}
	}

	return nil
}

func (o *BarbicanModifyCollectionBody) validateSvm(formats strfmt.Registry) error {
	if swag.IsZero(o.Svm) { // not required
		return nil
	}

	if o.Svm != nil {
		if err := o.Svm.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm")
			}
			return err
		}
	}

	return nil
}

func (o *BarbicanModifyCollectionBody) validateUUID(formats strfmt.Registry) error {
	if swag.IsZero(o.UUID) { // not required
		return nil
	}

	if err := validate.FormatOf("info"+"."+"uuid", "body", "uuid", o.UUID.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this barbican modify collection body based on the context it is used
func (o *BarbicanModifyCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateBarbicanReachability(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateBarbicanResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateConfiguration(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateEnabled(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateScope(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSvm(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *BarbicanModifyCollectionBody) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *BarbicanModifyCollectionBody) contextValidateBarbicanReachability(ctx context.Context, formats strfmt.Registry) error {

	if o.BarbicanReachability != nil {
		if err := o.BarbicanReachability.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "barbican_reachability")
			}
			return err
		}
	}

	return nil
}

func (o *BarbicanModifyCollectionBody) contextValidateBarbicanResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.BarbicanResponseInlineRecords); i++ {

		if o.BarbicanResponseInlineRecords[i] != nil {
			if err := o.BarbicanResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *BarbicanModifyCollectionBody) contextValidateConfiguration(ctx context.Context, formats strfmt.Registry) error {

	if o.Configuration != nil {
		if err := o.Configuration.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "configuration")
			}
			return err
		}
	}

	return nil
}

func (o *BarbicanModifyCollectionBody) contextValidateEnabled(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"enabled", "body", o.Enabled); err != nil {
		return err
	}

	return nil
}

func (o *BarbicanModifyCollectionBody) contextValidateScope(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"scope", "body", o.Scope); err != nil {
		return err
	}

	return nil
}

func (o *BarbicanModifyCollectionBody) contextValidateState(ctx context.Context, formats strfmt.Registry) error {

	if o.State != nil {
		if err := o.State.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "state")
			}
			return err
		}
	}

	return nil
}

func (o *BarbicanModifyCollectionBody) contextValidateSvm(ctx context.Context, formats strfmt.Registry) error {

	if o.Svm != nil {
		if err := o.Svm.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm")
			}
			return err
		}
	}

	return nil
}

func (o *BarbicanModifyCollectionBody) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"uuid", "body", o.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *BarbicanModifyCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *BarbicanModifyCollectionBody) UnmarshalBinary(b []byte) error {
	var res BarbicanModifyCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
BarbicanInlineLinks barbican inline links
swagger:model barbican_inline__links
*/
type BarbicanInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this barbican inline links
func (o *BarbicanInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *BarbicanInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this barbican inline links based on the context it is used
func (o *BarbicanInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *BarbicanInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *BarbicanInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *BarbicanInlineLinks) UnmarshalBinary(b []byte) error {
	var res BarbicanInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
BarbicanInlineBarbicanReachability Indicates whether the Barbican KMS is reachable from all nodes in the cluster.
// This is an advanced property; there is an added computational cost to retrieving its value. The property is not populated for either a collection GET request or an instance GET request unless it is explicitly requested using the field's query parameter or GET for all advanced properties is enabled.
//
swagger:model barbican_inline_barbican_reachability
*/
type BarbicanInlineBarbicanReachability struct {

	// Code corresponding to the error message. Returns 0 if Barbican KMS is reachable from all nodes in the cluster.
	// Example: 346758
	Code *string `json:"code,omitempty"`

	// Set to the appropriate error message when 'reachable' is false.
	// Example: Barbican KMS is not reachable from all nodes - \u003creason\u003e.
	Message *string `json:"message,omitempty"`

	// Set to true if the Barbican KMS is reachable from all nodes of the cluster.
	// Example: false
	Reachable *bool `json:"reachable,omitempty"`
}

// Validate validates this barbican inline barbican reachability
func (o *BarbicanInlineBarbicanReachability) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this barbican inline barbican reachability based on the context it is used
func (o *BarbicanInlineBarbicanReachability) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (o *BarbicanInlineBarbicanReachability) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *BarbicanInlineBarbicanReachability) UnmarshalBinary(b []byte) error {
	var res BarbicanInlineBarbicanReachability
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
BarbicanInlineConfiguration Security keystore object reference.
swagger:model barbican_inline_configuration
*/
type BarbicanInlineConfiguration struct {

	// links
	Links *models.BarbicanInlineConfigurationInlineLinks `json:"_links,omitempty"`

	// Name of the configuration.
	// Example: default
	Name *string `json:"name,omitempty"`

	// Keystore UUID.
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563434
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this barbican inline configuration
func (o *BarbicanInlineConfiguration) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *BarbicanInlineConfiguration) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "configuration" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this barbican inline configuration based on the context it is used
func (o *BarbicanInlineConfiguration) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *BarbicanInlineConfiguration) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "configuration" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *BarbicanInlineConfiguration) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *BarbicanInlineConfiguration) UnmarshalBinary(b []byte) error {
	var res BarbicanInlineConfiguration
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
BarbicanInlineConfigurationInlineLinks barbican inline configuration inline links
swagger:model barbican_inline_configuration_inline__links
*/
type BarbicanInlineConfigurationInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this barbican inline configuration inline links
func (o *BarbicanInlineConfigurationInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *BarbicanInlineConfigurationInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "configuration" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this barbican inline configuration inline links based on the context it is used
func (o *BarbicanInlineConfigurationInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *BarbicanInlineConfigurationInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "configuration" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *BarbicanInlineConfigurationInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *BarbicanInlineConfigurationInlineLinks) UnmarshalBinary(b []byte) error {
	var res BarbicanInlineConfigurationInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
BarbicanInlineState Indicates whether or not the SVM key encryption key (KEK) is available cluster wide.
// This is an advanced property; there is an added computational cost to retrieving its value. The property is not populated for either a collection GET or an instance GET unless it is explicitly requested using the `fields` query parameter or GET for all advanced properties is enabled.
//
swagger:model barbican_inline_state
*/
type BarbicanInlineState struct {

	// Set to true when an SVM-KEK is present on all nodes of the cluster.
	// Example: false
	ClusterState *bool `json:"cluster_state,omitempty"`

	// Code corresponding to the status message. Returns a 0 if the SVM-KEK is available on all nodes in the cluster.
	// Example: 346758
	Code *string `json:"code,omitempty"`

	// Error message returned when there's no SVM-KEK availability on the cluster.
	// Example: Top-level internal key encryption key is unavailable on the following nodes with the associated reasons: Node: node1. Reason: No volumes created yet for the SVM. Wrapped KEK status will be available after creating encrypted volumes.
	Message *string `json:"message,omitempty"`
}

// Validate validates this barbican inline state
func (o *BarbicanInlineState) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this barbican inline state based on the context it is used
func (o *BarbicanInlineState) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (o *BarbicanInlineState) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *BarbicanInlineState) UnmarshalBinary(b []byte) error {
	var res BarbicanInlineState
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
BarbicanInlineSvm SVM, applies only to SVM-scoped objects.
swagger:model barbican_inline_svm
*/
type BarbicanInlineSvm struct {

	// links
	Links *models.BarbicanInlineSvmInlineLinks `json:"_links,omitempty"`

	// The name of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: svm1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: 02c9e252-41be-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this barbican inline svm
func (o *BarbicanInlineSvm) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *BarbicanInlineSvm) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this barbican inline svm based on the context it is used
func (o *BarbicanInlineSvm) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *BarbicanInlineSvm) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *BarbicanInlineSvm) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *BarbicanInlineSvm) UnmarshalBinary(b []byte) error {
	var res BarbicanInlineSvm
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
BarbicanInlineSvmInlineLinks barbican inline svm inline links
swagger:model barbican_inline_svm_inline__links
*/
type BarbicanInlineSvmInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this barbican inline svm inline links
func (o *BarbicanInlineSvmInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *BarbicanInlineSvmInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this barbican inline svm inline links based on the context it is used
func (o *BarbicanInlineSvmInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *BarbicanInlineSvmInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *BarbicanInlineSvmInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *BarbicanInlineSvmInlineLinks) UnmarshalBinary(b []byte) error {
	var res BarbicanInlineSvmInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
