// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// BarbicanModifyReader is a Reader for the BarbicanModify structure.
type BarbicanModifyReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *BarbicanModifyReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewBarbicanModifyOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 202:
		result := NewBarbicanModifyAccepted()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewBarbicanModifyDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewBarbicanModifyOK creates a BarbicanModifyOK with default headers values
func NewBarbicanModifyOK() *BarbicanModifyOK {
	return &BarbicanModifyOK{}
}

/*
BarbicanModifyOK describes a response with status code 200, with default header values.

OK
*/
type BarbicanModifyOK struct {
	Payload *models.BarbicanJobLinkResponse
}

// IsSuccess returns true when this barbican modify o k response has a 2xx status code
func (o *BarbicanModifyOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this barbican modify o k response has a 3xx status code
func (o *BarbicanModifyOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this barbican modify o k response has a 4xx status code
func (o *BarbicanModifyOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this barbican modify o k response has a 5xx status code
func (o *BarbicanModifyOK) IsServerError() bool {
	return false
}

// IsCode returns true when this barbican modify o k response a status code equal to that given
func (o *BarbicanModifyOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the barbican modify o k response
func (o *BarbicanModifyOK) Code() int {
	return 200
}

func (o *BarbicanModifyOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /security/barbican-kms/{uuid}][%d] barbicanModifyOK %s", 200, payload)
}

func (o *BarbicanModifyOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /security/barbican-kms/{uuid}][%d] barbicanModifyOK %s", 200, payload)
}

func (o *BarbicanModifyOK) GetPayload() *models.BarbicanJobLinkResponse {
	return o.Payload
}

func (o *BarbicanModifyOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.BarbicanJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewBarbicanModifyAccepted creates a BarbicanModifyAccepted with default headers values
func NewBarbicanModifyAccepted() *BarbicanModifyAccepted {
	return &BarbicanModifyAccepted{}
}

/*
BarbicanModifyAccepted describes a response with status code 202, with default header values.

Accepted
*/
type BarbicanModifyAccepted struct {
	Payload *models.BarbicanJobLinkResponse
}

// IsSuccess returns true when this barbican modify accepted response has a 2xx status code
func (o *BarbicanModifyAccepted) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this barbican modify accepted response has a 3xx status code
func (o *BarbicanModifyAccepted) IsRedirect() bool {
	return false
}

// IsClientError returns true when this barbican modify accepted response has a 4xx status code
func (o *BarbicanModifyAccepted) IsClientError() bool {
	return false
}

// IsServerError returns true when this barbican modify accepted response has a 5xx status code
func (o *BarbicanModifyAccepted) IsServerError() bool {
	return false
}

// IsCode returns true when this barbican modify accepted response a status code equal to that given
func (o *BarbicanModifyAccepted) IsCode(code int) bool {
	return code == 202
}

// Code gets the status code for the barbican modify accepted response
func (o *BarbicanModifyAccepted) Code() int {
	return 202
}

func (o *BarbicanModifyAccepted) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /security/barbican-kms/{uuid}][%d] barbicanModifyAccepted %s", 202, payload)
}

func (o *BarbicanModifyAccepted) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /security/barbican-kms/{uuid}][%d] barbicanModifyAccepted %s", 202, payload)
}

func (o *BarbicanModifyAccepted) GetPayload() *models.BarbicanJobLinkResponse {
	return o.Payload
}

func (o *BarbicanModifyAccepted) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.BarbicanJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewBarbicanModifyDefault creates a BarbicanModifyDefault with default headers values
func NewBarbicanModifyDefault(code int) *BarbicanModifyDefault {
	return &BarbicanModifyDefault{
		_statusCode: code,
	}
}

/*
	BarbicanModifyDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 65539223 | Failed to check the health of the Barbican Key Management Service. |
| 65539814 | Failed to update the Barbican Key Management Service configuration because the "application-cred-secret" field is invalid or was not provided. |
| 65539815 | Failed to update the Barbican Key Management Service configuration because the "application-cred-id" field is invalid or was not provided. |
| 65539832 | Specified Barbican Key Management Service configuration does not exist. |
| 65539841 | Both "application_cred_id" and "application_cred_secret" are required. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type BarbicanModifyDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this barbican modify default response has a 2xx status code
func (o *BarbicanModifyDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this barbican modify default response has a 3xx status code
func (o *BarbicanModifyDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this barbican modify default response has a 4xx status code
func (o *BarbicanModifyDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this barbican modify default response has a 5xx status code
func (o *BarbicanModifyDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this barbican modify default response a status code equal to that given
func (o *BarbicanModifyDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the barbican modify default response
func (o *BarbicanModifyDefault) Code() int {
	return o._statusCode
}

func (o *BarbicanModifyDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /security/barbican-kms/{uuid}][%d] barbican_modify default %s", o._statusCode, payload)
}

func (o *BarbicanModifyDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /security/barbican-kms/{uuid}][%d] barbican_modify default %s", o._statusCode, payload)
}

func (o *BarbicanModifyDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *BarbicanModifyDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
