// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewBarbicanRekeyInternalParams creates a new BarbicanRekeyInternalParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewBarbicanRekeyInternalParams() *BarbicanRekeyInternalParams {
	return &BarbicanRekeyInternalParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewBarbicanRekeyInternalParamsWithTimeout creates a new BarbicanRekeyInternalParams object
// with the ability to set a timeout on a request.
func NewBarbicanRekeyInternalParamsWithTimeout(timeout time.Duration) *BarbicanRekeyInternalParams {
	return &BarbicanRekeyInternalParams{
		timeout: timeout,
	}
}

// NewBarbicanRekeyInternalParamsWithContext creates a new BarbicanRekeyInternalParams object
// with the ability to set a context for a request.
func NewBarbicanRekeyInternalParamsWithContext(ctx context.Context) *BarbicanRekeyInternalParams {
	return &BarbicanRekeyInternalParams{
		Context: ctx,
	}
}

// NewBarbicanRekeyInternalParamsWithHTTPClient creates a new BarbicanRekeyInternalParams object
// with the ability to set a custom HTTPClient for a request.
func NewBarbicanRekeyInternalParamsWithHTTPClient(client *http.Client) *BarbicanRekeyInternalParams {
	return &BarbicanRekeyInternalParams{
		HTTPClient: client,
	}
}

/*
BarbicanRekeyInternalParams contains all the parameters to send to the API endpoint

	for the barbican rekey internal operation.

	Typically these are written to a http.Request.
*/
type BarbicanRekeyInternalParams struct {

	/* ReturnRecords.

	   The default is false.  If set to true, the records are returned.
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning. When doing a POST, PATCH, or DELETE operation on a single record, the default is 0 seconds.  This means that if an asynchronous operation is started, the server immediately returns HTTP code 202 (Accepted) along with a link to the job.  If a non-zero value is specified for POST, PATCH, or DELETE operations, ONTAP waits that length of time to see if the job completes so it can return something other than 202.
	*/
	ReturnTimeout *int64

	/* UUID.

	   UUID of the existing Barbican KMS configuration.
	*/
	UUID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the barbican rekey internal params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *BarbicanRekeyInternalParams) WithDefaults() *BarbicanRekeyInternalParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the barbican rekey internal params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *BarbicanRekeyInternalParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(false)

		returnTimeoutDefault = int64(0)
	)

	val := BarbicanRekeyInternalParams{
		ReturnRecords: &returnRecordsDefault,
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the barbican rekey internal params
func (o *BarbicanRekeyInternalParams) WithTimeout(timeout time.Duration) *BarbicanRekeyInternalParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the barbican rekey internal params
func (o *BarbicanRekeyInternalParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the barbican rekey internal params
func (o *BarbicanRekeyInternalParams) WithContext(ctx context.Context) *BarbicanRekeyInternalParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the barbican rekey internal params
func (o *BarbicanRekeyInternalParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the barbican rekey internal params
func (o *BarbicanRekeyInternalParams) WithHTTPClient(client *http.Client) *BarbicanRekeyInternalParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the barbican rekey internal params
func (o *BarbicanRekeyInternalParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithReturnRecords adds the returnRecords to the barbican rekey internal params
func (o *BarbicanRekeyInternalParams) WithReturnRecords(returnRecords *bool) *BarbicanRekeyInternalParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the barbican rekey internal params
func (o *BarbicanRekeyInternalParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the barbican rekey internal params
func (o *BarbicanRekeyInternalParams) WithReturnTimeout(returnTimeout *int64) *BarbicanRekeyInternalParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the barbican rekey internal params
func (o *BarbicanRekeyInternalParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithUUID adds the uuid to the barbican rekey internal params
func (o *BarbicanRekeyInternalParams) WithUUID(uuid string) *BarbicanRekeyInternalParams {
	o.SetUUID(uuid)
	return o
}

// SetUUID adds the uuid to the barbican rekey internal params
func (o *BarbicanRekeyInternalParams) SetUUID(uuid string) {
	o.UUID = uuid
}

// WriteToRequest writes these params to a swagger request
func (o *BarbicanRekeyInternalParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	// path param uuid
	if err := r.SetPathParam("uuid", o.UUID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
