// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// BarbicanRekeyInternalReader is a Reader for the BarbicanRekeyInternal structure.
type BarbicanRekeyInternalReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *BarbicanRekeyInternalReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 201:
		result := NewBarbicanRekeyInternalCreated()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 202:
		result := NewBarbicanRekeyInternalAccepted()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewBarbicanRekeyInternalDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewBarbicanRekeyInternalCreated creates a BarbicanRekeyInternalCreated with default headers values
func NewBarbicanRekeyInternalCreated() *BarbicanRekeyInternalCreated {
	return &BarbicanRekeyInternalCreated{}
}

/*
BarbicanRekeyInternalCreated describes a response with status code 201, with default header values.

Created
*/
type BarbicanRekeyInternalCreated struct {
	Payload *models.BarbicanJobLinkResponse
}

// IsSuccess returns true when this barbican rekey internal created response has a 2xx status code
func (o *BarbicanRekeyInternalCreated) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this barbican rekey internal created response has a 3xx status code
func (o *BarbicanRekeyInternalCreated) IsRedirect() bool {
	return false
}

// IsClientError returns true when this barbican rekey internal created response has a 4xx status code
func (o *BarbicanRekeyInternalCreated) IsClientError() bool {
	return false
}

// IsServerError returns true when this barbican rekey internal created response has a 5xx status code
func (o *BarbicanRekeyInternalCreated) IsServerError() bool {
	return false
}

// IsCode returns true when this barbican rekey internal created response a status code equal to that given
func (o *BarbicanRekeyInternalCreated) IsCode(code int) bool {
	return code == 201
}

// Code gets the status code for the barbican rekey internal created response
func (o *BarbicanRekeyInternalCreated) Code() int {
	return 201
}

func (o *BarbicanRekeyInternalCreated) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /security/barbican-kms/{uuid}/rekey-internal][%d] barbicanRekeyInternalCreated %s", 201, payload)
}

func (o *BarbicanRekeyInternalCreated) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /security/barbican-kms/{uuid}/rekey-internal][%d] barbicanRekeyInternalCreated %s", 201, payload)
}

func (o *BarbicanRekeyInternalCreated) GetPayload() *models.BarbicanJobLinkResponse {
	return o.Payload
}

func (o *BarbicanRekeyInternalCreated) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.BarbicanJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewBarbicanRekeyInternalAccepted creates a BarbicanRekeyInternalAccepted with default headers values
func NewBarbicanRekeyInternalAccepted() *BarbicanRekeyInternalAccepted {
	return &BarbicanRekeyInternalAccepted{}
}

/*
BarbicanRekeyInternalAccepted describes a response with status code 202, with default header values.

Accepted
*/
type BarbicanRekeyInternalAccepted struct {
	Payload *models.BarbicanJobLinkResponse
}

// IsSuccess returns true when this barbican rekey internal accepted response has a 2xx status code
func (o *BarbicanRekeyInternalAccepted) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this barbican rekey internal accepted response has a 3xx status code
func (o *BarbicanRekeyInternalAccepted) IsRedirect() bool {
	return false
}

// IsClientError returns true when this barbican rekey internal accepted response has a 4xx status code
func (o *BarbicanRekeyInternalAccepted) IsClientError() bool {
	return false
}

// IsServerError returns true when this barbican rekey internal accepted response has a 5xx status code
func (o *BarbicanRekeyInternalAccepted) IsServerError() bool {
	return false
}

// IsCode returns true when this barbican rekey internal accepted response a status code equal to that given
func (o *BarbicanRekeyInternalAccepted) IsCode(code int) bool {
	return code == 202
}

// Code gets the status code for the barbican rekey internal accepted response
func (o *BarbicanRekeyInternalAccepted) Code() int {
	return 202
}

func (o *BarbicanRekeyInternalAccepted) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /security/barbican-kms/{uuid}/rekey-internal][%d] barbicanRekeyInternalAccepted %s", 202, payload)
}

func (o *BarbicanRekeyInternalAccepted) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /security/barbican-kms/{uuid}/rekey-internal][%d] barbicanRekeyInternalAccepted %s", 202, payload)
}

func (o *BarbicanRekeyInternalAccepted) GetPayload() *models.BarbicanJobLinkResponse {
	return o.Payload
}

func (o *BarbicanRekeyInternalAccepted) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.BarbicanJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewBarbicanRekeyInternalDefault creates a BarbicanRekeyInternalDefault with default headers values
func NewBarbicanRekeyInternalDefault(code int) *BarbicanRekeyInternalDefault {
	return &BarbicanRekeyInternalDefault{
		_statusCode: code,
	}
}

/*
	BarbicanRekeyInternalDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 65536205 | Internal error. Failed to generate SVM key in the kernel. |
| 65536882 | Internal error. UUID is missing. |
| 65536883 | Internal error. Volume encryption key is missing. |
| 65536884 | Internal error. Volume encryption key is invalid. |
| 65536889 | Internal error. Volume has invalid encryption blob. |
| 65536973 | Internal error. Volume DSID is missing. |
| 65537533 | Internal error. Failed to unwrap SVM key encryption key. |
| 65537547 | One or more volume encryption keys (VEKs) for this data SVM's encrypted volumes are stored in the key manager configured for the admin SVM. Use the REST API POST method "/api/security/key-managers/{source.svm.uuid}/migrate" to migrate these keys from the admin SVM's key manager to this data SVM's key manager before running the rekey operation. |
| 65537556 | ONTAP is unable to encrypt or decrypt because the configured external key manager is in a blocked state. Possible reasons for a blocked state include the top-level external key protection key is not found, disabled or has insufficient privileges. Resolve the external key manager key issues at the key manager's portal before running the rekey operation. |
| 65537565 | Internal error. Failed to update the VDEK blob. |
| 65537610 | Rekey cannot be performed while the enabled keystore configuration is being switched. If a previous attempt to switch the keystore configuration failed, or was interrupted, the system will continue to prevent rekeying. Use the REST API PATCH method "/api/security/key-stores/{uuid}" to re-run and complete the operation. |
| 65539200 | The key custodian not provided with an external key value store. |
| 65539201 | Failed to encrypt. |
| 65539202 | Failed to decrypt. |
| 65539416 | Internal error. Failed to parse the key value store response. |
| 65539436 | Rekey cannot be performed while the enabled keystore configuration is being initialized. Wait until the keystore is in the active state, and rerun the rekey operation. |
| 65539437 | Rekey cannot be performed while the enabled keystore configuration is being disabled. |
| 65539817 | The Barbican Key Management Service is not configured. |
| 65539834 | New Key ID not found. |
| 65539836 | No Key Management Service configured. |
| 65539844 | Failed to import the SVM-KEK. |
| 196608088 | Internal error. Failed to get encryption operation status. |
| 196608352 | Internal error. The encryption blob was not found in the RDB table. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type BarbicanRekeyInternalDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this barbican rekey internal default response has a 2xx status code
func (o *BarbicanRekeyInternalDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this barbican rekey internal default response has a 3xx status code
func (o *BarbicanRekeyInternalDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this barbican rekey internal default response has a 4xx status code
func (o *BarbicanRekeyInternalDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this barbican rekey internal default response has a 5xx status code
func (o *BarbicanRekeyInternalDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this barbican rekey internal default response a status code equal to that given
func (o *BarbicanRekeyInternalDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the barbican rekey internal default response
func (o *BarbicanRekeyInternalDefault) Code() int {
	return o._statusCode
}

func (o *BarbicanRekeyInternalDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /security/barbican-kms/{uuid}/rekey-internal][%d] barbican_rekey_internal default %s", o._statusCode, payload)
}

func (o *BarbicanRekeyInternalDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /security/barbican-kms/{uuid}/rekey-internal][%d] barbican_rekey_internal default %s", o._statusCode, payload)
}

func (o *BarbicanRekeyInternalDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *BarbicanRekeyInternalDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
