// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewBarbicanRestoreParams creates a new BarbicanRestoreParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewBarbicanRestoreParams() *BarbicanRestoreParams {
	return &BarbicanRestoreParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewBarbicanRestoreParamsWithTimeout creates a new BarbicanRestoreParams object
// with the ability to set a timeout on a request.
func NewBarbicanRestoreParamsWithTimeout(timeout time.Duration) *BarbicanRestoreParams {
	return &BarbicanRestoreParams{
		timeout: timeout,
	}
}

// NewBarbicanRestoreParamsWithContext creates a new BarbicanRestoreParams object
// with the ability to set a context for a request.
func NewBarbicanRestoreParamsWithContext(ctx context.Context) *BarbicanRestoreParams {
	return &BarbicanRestoreParams{
		Context: ctx,
	}
}

// NewBarbicanRestoreParamsWithHTTPClient creates a new BarbicanRestoreParams object
// with the ability to set a custom HTTPClient for a request.
func NewBarbicanRestoreParamsWithHTTPClient(client *http.Client) *BarbicanRestoreParams {
	return &BarbicanRestoreParams{
		HTTPClient: client,
	}
}

/*
BarbicanRestoreParams contains all the parameters to send to the API endpoint

	for the barbican restore operation.

	Typically these are written to a http.Request.
*/
type BarbicanRestoreParams struct {

	/* ReturnRecords.

	   The default is false.  If set to true, the records are returned.
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning. When doing a POST, PATCH, or DELETE operation on a single record, the default is 0 seconds.  This means that if an asynchronous operation is started, the server immediately returns HTTP code 202 (Accepted) along with a link to the job.  If a non-zero value is specified for POST, PATCH, or DELETE operations, ONTAP waits that length of time to see if the job completes so it can return something other than 202.
	*/
	ReturnTimeout *int64

	/* UUID.

	   UUID of the existing Barbican KMS configuration.
	*/
	UUID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the barbican restore params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *BarbicanRestoreParams) WithDefaults() *BarbicanRestoreParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the barbican restore params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *BarbicanRestoreParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(false)

		returnTimeoutDefault = int64(0)
	)

	val := BarbicanRestoreParams{
		ReturnRecords: &returnRecordsDefault,
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the barbican restore params
func (o *BarbicanRestoreParams) WithTimeout(timeout time.Duration) *BarbicanRestoreParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the barbican restore params
func (o *BarbicanRestoreParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the barbican restore params
func (o *BarbicanRestoreParams) WithContext(ctx context.Context) *BarbicanRestoreParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the barbican restore params
func (o *BarbicanRestoreParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the barbican restore params
func (o *BarbicanRestoreParams) WithHTTPClient(client *http.Client) *BarbicanRestoreParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the barbican restore params
func (o *BarbicanRestoreParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithReturnRecords adds the returnRecords to the barbican restore params
func (o *BarbicanRestoreParams) WithReturnRecords(returnRecords *bool) *BarbicanRestoreParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the barbican restore params
func (o *BarbicanRestoreParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the barbican restore params
func (o *BarbicanRestoreParams) WithReturnTimeout(returnTimeout *int64) *BarbicanRestoreParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the barbican restore params
func (o *BarbicanRestoreParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithUUID adds the uuid to the barbican restore params
func (o *BarbicanRestoreParams) WithUUID(uuid string) *BarbicanRestoreParams {
	o.SetUUID(uuid)
	return o
}

// SetUUID adds the uuid to the barbican restore params
func (o *BarbicanRestoreParams) SetUUID(uuid string) {
	o.UUID = uuid
}

// WriteToRequest writes these params to a swagger request
func (o *BarbicanRestoreParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	// path param uuid
	if err := r.SetPathParam("uuid", o.UUID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
