// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// BarbicanRestoreReader is a Reader for the BarbicanRestore structure.
type BarbicanRestoreReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *BarbicanRestoreReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 201:
		result := NewBarbicanRestoreCreated()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 202:
		result := NewBarbicanRestoreAccepted()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewBarbicanRestoreDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewBarbicanRestoreCreated creates a BarbicanRestoreCreated with default headers values
func NewBarbicanRestoreCreated() *BarbicanRestoreCreated {
	return &BarbicanRestoreCreated{}
}

/*
BarbicanRestoreCreated describes a response with status code 201, with default header values.

Created
*/
type BarbicanRestoreCreated struct {

	/* Useful for tracking the resource location
	 */
	Location string

	Payload *models.BarbicanJobLinkResponse
}

// IsSuccess returns true when this barbican restore created response has a 2xx status code
func (o *BarbicanRestoreCreated) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this barbican restore created response has a 3xx status code
func (o *BarbicanRestoreCreated) IsRedirect() bool {
	return false
}

// IsClientError returns true when this barbican restore created response has a 4xx status code
func (o *BarbicanRestoreCreated) IsClientError() bool {
	return false
}

// IsServerError returns true when this barbican restore created response has a 5xx status code
func (o *BarbicanRestoreCreated) IsServerError() bool {
	return false
}

// IsCode returns true when this barbican restore created response a status code equal to that given
func (o *BarbicanRestoreCreated) IsCode(code int) bool {
	return code == 201
}

// Code gets the status code for the barbican restore created response
func (o *BarbicanRestoreCreated) Code() int {
	return 201
}

func (o *BarbicanRestoreCreated) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /security/barbican-kms/{uuid}/restore][%d] barbicanRestoreCreated %s", 201, payload)
}

func (o *BarbicanRestoreCreated) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /security/barbican-kms/{uuid}/restore][%d] barbicanRestoreCreated %s", 201, payload)
}

func (o *BarbicanRestoreCreated) GetPayload() *models.BarbicanJobLinkResponse {
	return o.Payload
}

func (o *BarbicanRestoreCreated) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header Location
	hdrLocation := response.GetHeader("Location")

	if hdrLocation != "" {
		o.Location = hdrLocation
	}

	o.Payload = new(models.BarbicanJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewBarbicanRestoreAccepted creates a BarbicanRestoreAccepted with default headers values
func NewBarbicanRestoreAccepted() *BarbicanRestoreAccepted {
	return &BarbicanRestoreAccepted{}
}

/*
BarbicanRestoreAccepted describes a response with status code 202, with default header values.

Accepted
*/
type BarbicanRestoreAccepted struct {

	/* Useful for tracking the resource location
	 */
	Location string

	Payload *models.BarbicanJobLinkResponse
}

// IsSuccess returns true when this barbican restore accepted response has a 2xx status code
func (o *BarbicanRestoreAccepted) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this barbican restore accepted response has a 3xx status code
func (o *BarbicanRestoreAccepted) IsRedirect() bool {
	return false
}

// IsClientError returns true when this barbican restore accepted response has a 4xx status code
func (o *BarbicanRestoreAccepted) IsClientError() bool {
	return false
}

// IsServerError returns true when this barbican restore accepted response has a 5xx status code
func (o *BarbicanRestoreAccepted) IsServerError() bool {
	return false
}

// IsCode returns true when this barbican restore accepted response a status code equal to that given
func (o *BarbicanRestoreAccepted) IsCode(code int) bool {
	return code == 202
}

// Code gets the status code for the barbican restore accepted response
func (o *BarbicanRestoreAccepted) Code() int {
	return 202
}

func (o *BarbicanRestoreAccepted) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /security/barbican-kms/{uuid}/restore][%d] barbicanRestoreAccepted %s", 202, payload)
}

func (o *BarbicanRestoreAccepted) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /security/barbican-kms/{uuid}/restore][%d] barbicanRestoreAccepted %s", 202, payload)
}

func (o *BarbicanRestoreAccepted) GetPayload() *models.BarbicanJobLinkResponse {
	return o.Payload
}

func (o *BarbicanRestoreAccepted) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header Location
	hdrLocation := response.GetHeader("Location")

	if hdrLocation != "" {
		o.Location = hdrLocation
	}

	o.Payload = new(models.BarbicanJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewBarbicanRestoreDefault creates a BarbicanRestoreDefault with default headers values
func NewBarbicanRestoreDefault(code int) *BarbicanRestoreDefault {
	return &BarbicanRestoreDefault{
		_statusCode: code,
	}
}

/*
	BarbicanRestoreDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 65539817 | The Barbican Key Management Service is not configured. |
| 65539842 | Failed to restore the SVM-KEK on at least one node. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type BarbicanRestoreDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this barbican restore default response has a 2xx status code
func (o *BarbicanRestoreDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this barbican restore default response has a 3xx status code
func (o *BarbicanRestoreDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this barbican restore default response has a 4xx status code
func (o *BarbicanRestoreDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this barbican restore default response has a 5xx status code
func (o *BarbicanRestoreDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this barbican restore default response a status code equal to that given
func (o *BarbicanRestoreDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the barbican restore default response
func (o *BarbicanRestoreDefault) Code() int {
	return o._statusCode
}

func (o *BarbicanRestoreDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /security/barbican-kms/{uuid}/restore][%d] barbican_restore default %s", o._statusCode, payload)
}

func (o *BarbicanRestoreDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /security/barbican-kms/{uuid}/restore][%d] barbican_restore default %s", o._statusCode, payload)
}

func (o *BarbicanRestoreDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *BarbicanRestoreDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
