// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// ClusterAccountAdProxyCreateReader is a Reader for the ClusterAccountAdProxyCreate structure.
type ClusterAccountAdProxyCreateReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *ClusterAccountAdProxyCreateReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 201:
		result := NewClusterAccountAdProxyCreateCreated()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewClusterAccountAdProxyCreateDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewClusterAccountAdProxyCreateCreated creates a ClusterAccountAdProxyCreateCreated with default headers values
func NewClusterAccountAdProxyCreateCreated() *ClusterAccountAdProxyCreateCreated {
	return &ClusterAccountAdProxyCreateCreated{}
}

/*
ClusterAccountAdProxyCreateCreated describes a response with status code 201, with default header values.

Created
*/
type ClusterAccountAdProxyCreateCreated struct {

	/* Useful for tracking the resource location
	 */
	Location string
}

// IsSuccess returns true when this cluster account ad proxy create created response has a 2xx status code
func (o *ClusterAccountAdProxyCreateCreated) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this cluster account ad proxy create created response has a 3xx status code
func (o *ClusterAccountAdProxyCreateCreated) IsRedirect() bool {
	return false
}

// IsClientError returns true when this cluster account ad proxy create created response has a 4xx status code
func (o *ClusterAccountAdProxyCreateCreated) IsClientError() bool {
	return false
}

// IsServerError returns true when this cluster account ad proxy create created response has a 5xx status code
func (o *ClusterAccountAdProxyCreateCreated) IsServerError() bool {
	return false
}

// IsCode returns true when this cluster account ad proxy create created response a status code equal to that given
func (o *ClusterAccountAdProxyCreateCreated) IsCode(code int) bool {
	return code == 201
}

// Code gets the status code for the cluster account ad proxy create created response
func (o *ClusterAccountAdProxyCreateCreated) Code() int {
	return 201
}

func (o *ClusterAccountAdProxyCreateCreated) Error() string {
	return fmt.Sprintf("[POST /security/authentication/cluster/ad-proxy][%d] clusterAccountAdProxyCreateCreated", 201)
}

func (o *ClusterAccountAdProxyCreateCreated) String() string {
	return fmt.Sprintf("[POST /security/authentication/cluster/ad-proxy][%d] clusterAccountAdProxyCreateCreated", 201)
}

func (o *ClusterAccountAdProxyCreateCreated) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header Location
	hdrLocation := response.GetHeader("Location")

	if hdrLocation != "" {
		o.Location = hdrLocation
	}

	return nil
}

// NewClusterAccountAdProxyCreateDefault creates a ClusterAccountAdProxyCreateDefault with default headers values
func NewClusterAccountAdProxyCreateDefault(code int) *ClusterAccountAdProxyCreateDefault {
	return &ClusterAccountAdProxyCreateDefault{
		_statusCode: code,
	}
}

/*
	ClusterAccountAdProxyCreateDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 2621516 | This operation is only supported on a data SVM. |
| 2621706 | The specified `svm.uuid` and `svm.name` refer to different SVMs. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type ClusterAccountAdProxyCreateDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this cluster account ad proxy create default response has a 2xx status code
func (o *ClusterAccountAdProxyCreateDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this cluster account ad proxy create default response has a 3xx status code
func (o *ClusterAccountAdProxyCreateDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this cluster account ad proxy create default response has a 4xx status code
func (o *ClusterAccountAdProxyCreateDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this cluster account ad proxy create default response has a 5xx status code
func (o *ClusterAccountAdProxyCreateDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this cluster account ad proxy create default response a status code equal to that given
func (o *ClusterAccountAdProxyCreateDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the cluster account ad proxy create default response
func (o *ClusterAccountAdProxyCreateDefault) Code() int {
	return o._statusCode
}

func (o *ClusterAccountAdProxyCreateDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /security/authentication/cluster/ad-proxy][%d] cluster_account_ad_proxy_create default %s", o._statusCode, payload)
}

func (o *ClusterAccountAdProxyCreateDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /security/authentication/cluster/ad-proxy][%d] cluster_account_ad_proxy_create default %s", o._statusCode, payload)
}

func (o *ClusterAccountAdProxyCreateDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *ClusterAccountAdProxyCreateDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
