// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// ClusterAccountAdProxyModifyReader is a Reader for the ClusterAccountAdProxyModify structure.
type ClusterAccountAdProxyModifyReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *ClusterAccountAdProxyModifyReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewClusterAccountAdProxyModifyOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewClusterAccountAdProxyModifyDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewClusterAccountAdProxyModifyOK creates a ClusterAccountAdProxyModifyOK with default headers values
func NewClusterAccountAdProxyModifyOK() *ClusterAccountAdProxyModifyOK {
	return &ClusterAccountAdProxyModifyOK{}
}

/*
ClusterAccountAdProxyModifyOK describes a response with status code 200, with default header values.

OK
*/
type ClusterAccountAdProxyModifyOK struct {
}

// IsSuccess returns true when this cluster account ad proxy modify o k response has a 2xx status code
func (o *ClusterAccountAdProxyModifyOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this cluster account ad proxy modify o k response has a 3xx status code
func (o *ClusterAccountAdProxyModifyOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this cluster account ad proxy modify o k response has a 4xx status code
func (o *ClusterAccountAdProxyModifyOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this cluster account ad proxy modify o k response has a 5xx status code
func (o *ClusterAccountAdProxyModifyOK) IsServerError() bool {
	return false
}

// IsCode returns true when this cluster account ad proxy modify o k response a status code equal to that given
func (o *ClusterAccountAdProxyModifyOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the cluster account ad proxy modify o k response
func (o *ClusterAccountAdProxyModifyOK) Code() int {
	return 200
}

func (o *ClusterAccountAdProxyModifyOK) Error() string {
	return fmt.Sprintf("[PATCH /security/authentication/cluster/ad-proxy][%d] clusterAccountAdProxyModifyOK", 200)
}

func (o *ClusterAccountAdProxyModifyOK) String() string {
	return fmt.Sprintf("[PATCH /security/authentication/cluster/ad-proxy][%d] clusterAccountAdProxyModifyOK", 200)
}

func (o *ClusterAccountAdProxyModifyOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewClusterAccountAdProxyModifyDefault creates a ClusterAccountAdProxyModifyDefault with default headers values
func NewClusterAccountAdProxyModifyDefault(code int) *ClusterAccountAdProxyModifyDefault {
	return &ClusterAccountAdProxyModifyDefault{
		_statusCode: code,
	}
}

/*
	ClusterAccountAdProxyModifyDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 2621516 | This operation is only supported on a data SVM. |
| 2621706 | The specified `svm.uuid` and `svm.name` refer to different SVMs. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type ClusterAccountAdProxyModifyDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this cluster account ad proxy modify default response has a 2xx status code
func (o *ClusterAccountAdProxyModifyDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this cluster account ad proxy modify default response has a 3xx status code
func (o *ClusterAccountAdProxyModifyDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this cluster account ad proxy modify default response has a 4xx status code
func (o *ClusterAccountAdProxyModifyDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this cluster account ad proxy modify default response has a 5xx status code
func (o *ClusterAccountAdProxyModifyDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this cluster account ad proxy modify default response a status code equal to that given
func (o *ClusterAccountAdProxyModifyDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the cluster account ad proxy modify default response
func (o *ClusterAccountAdProxyModifyDefault) Code() int {
	return o._statusCode
}

func (o *ClusterAccountAdProxyModifyDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /security/authentication/cluster/ad-proxy][%d] cluster_account_ad_proxy_modify default %s", o._statusCode, payload)
}

func (o *ClusterAccountAdProxyModifyDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /security/authentication/cluster/ad-proxy][%d] cluster_account_ad_proxy_modify default %s", o._statusCode, payload)
}

func (o *ClusterAccountAdProxyModifyDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *ClusterAccountAdProxyModifyDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
