// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// ClusterLdapModifyReader is a Reader for the ClusterLdapModify structure.
type ClusterLdapModifyReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *ClusterLdapModifyReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewClusterLdapModifyOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewClusterLdapModifyDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewClusterLdapModifyOK creates a ClusterLdapModifyOK with default headers values
func NewClusterLdapModifyOK() *ClusterLdapModifyOK {
	return &ClusterLdapModifyOK{}
}

/*
ClusterLdapModifyOK describes a response with status code 200, with default header values.

OK
*/
type ClusterLdapModifyOK struct {
}

// IsSuccess returns true when this cluster ldap modify o k response has a 2xx status code
func (o *ClusterLdapModifyOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this cluster ldap modify o k response has a 3xx status code
func (o *ClusterLdapModifyOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this cluster ldap modify o k response has a 4xx status code
func (o *ClusterLdapModifyOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this cluster ldap modify o k response has a 5xx status code
func (o *ClusterLdapModifyOK) IsServerError() bool {
	return false
}

// IsCode returns true when this cluster ldap modify o k response a status code equal to that given
func (o *ClusterLdapModifyOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the cluster ldap modify o k response
func (o *ClusterLdapModifyOK) Code() int {
	return 200
}

func (o *ClusterLdapModifyOK) Error() string {
	return fmt.Sprintf("[PATCH /security/authentication/cluster/ldap][%d] clusterLdapModifyOK", 200)
}

func (o *ClusterLdapModifyOK) String() string {
	return fmt.Sprintf("[PATCH /security/authentication/cluster/ldap][%d] clusterLdapModifyOK", 200)
}

func (o *ClusterLdapModifyOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewClusterLdapModifyDefault creates a ClusterLdapModifyDefault with default headers values
func NewClusterLdapModifyDefault(code int) *ClusterLdapModifyDefault {
	return &ClusterLdapModifyDefault{
		_statusCode: code,
	}
}

/*
	ClusterLdapModifyDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 4915203    | The specified LDAP schema does not exist. |
| 262222     | The specified LDAP servers contain duplicate server entries. |
| 4915229    | DNS resolution failed due to an internal error. Contact technical support if this issue persists. |
| 4915231    | DNS resolution failed for one or more of the specified LDAP servers. Verify that a valid DNS server is configured. |
| 23724132   | DNS resolution failed for all the specified LDAP servers. Verify that a valid DNS server is configured. |
| 4915234    | Specified LDAP server is not supported because it is one of the following: multicast, loopback, 0.0.0.0, or broadcast. |
| 4915248    | LDAP servers cannot be empty or "-". Specified FQDN is not valid because it is empty or "-" or it contains either special characters or "-" at the start or end of the domain. |
| 4915251    | STARTTLS and LDAPS cannot be used together |
| 4915257    | The LDAP configuration is not valid. Verify that the Distinguished Names and bind password are correct. |
| 4915258    | The LDAP configuration is not valid. Verify that the servers are reachable and that the network configuration is correct. |
| 23724130   | Cannot use an IPv6 name server address because there are no IPv6 interfaces. |
| 4915252    | LDAP referral is not supported with STARTTLS, with session security levels sign, seal or with LDAPS. |
| 4915244    | RPC failure occurred during validation of the LDAP configuration. |
| 4915265    | The specified bind password or bind DN is invalid |
*/
type ClusterLdapModifyDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this cluster ldap modify default response has a 2xx status code
func (o *ClusterLdapModifyDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this cluster ldap modify default response has a 3xx status code
func (o *ClusterLdapModifyDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this cluster ldap modify default response has a 4xx status code
func (o *ClusterLdapModifyDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this cluster ldap modify default response has a 5xx status code
func (o *ClusterLdapModifyDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this cluster ldap modify default response a status code equal to that given
func (o *ClusterLdapModifyDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the cluster ldap modify default response
func (o *ClusterLdapModifyDefault) Code() int {
	return o._statusCode
}

func (o *ClusterLdapModifyDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /security/authentication/cluster/ldap][%d] cluster_ldap_modify default %s", o._statusCode, payload)
}

func (o *ClusterLdapModifyDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /security/authentication/cluster/ldap][%d] cluster_ldap_modify default %s", o._statusCode, payload)
}

func (o *ClusterLdapModifyDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *ClusterLdapModifyDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
