// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// ClusterNisModifyReader is a Reader for the ClusterNisModify structure.
type ClusterNisModifyReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *ClusterNisModifyReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewClusterNisModifyOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewClusterNisModifyDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewClusterNisModifyOK creates a ClusterNisModifyOK with default headers values
func NewClusterNisModifyOK() *ClusterNisModifyOK {
	return &ClusterNisModifyOK{}
}

/*
ClusterNisModifyOK describes a response with status code 200, with default header values.

OK
*/
type ClusterNisModifyOK struct {
}

// IsSuccess returns true when this cluster nis modify o k response has a 2xx status code
func (o *ClusterNisModifyOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this cluster nis modify o k response has a 3xx status code
func (o *ClusterNisModifyOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this cluster nis modify o k response has a 4xx status code
func (o *ClusterNisModifyOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this cluster nis modify o k response has a 5xx status code
func (o *ClusterNisModifyOK) IsServerError() bool {
	return false
}

// IsCode returns true when this cluster nis modify o k response a status code equal to that given
func (o *ClusterNisModifyOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the cluster nis modify o k response
func (o *ClusterNisModifyOK) Code() int {
	return 200
}

func (o *ClusterNisModifyOK) Error() string {
	return fmt.Sprintf("[PATCH /security/authentication/cluster/nis][%d] clusterNisModifyOK", 200)
}

func (o *ClusterNisModifyOK) String() string {
	return fmt.Sprintf("[PATCH /security/authentication/cluster/nis][%d] clusterNisModifyOK", 200)
}

func (o *ClusterNisModifyOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewClusterNisModifyDefault creates a ClusterNisModifyDefault with default headers values
func NewClusterNisModifyDefault(code int) *ClusterNisModifyDefault {
	return &ClusterNisModifyDefault{
		_statusCode: code,
	}
}

/*
	ClusterNisModifyDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 1966253    | IPv6 is not enabled in the cluster .|
| 3276964    | The NIS domain name or NIS server domain is too long. The maximum supported for domain name is 64 characters and the maximum supported for NIS server domain is 255 characters. |
| 3276933    | A maximum of 10 NIS servers can be configured per SVM. |
| 23724109   | DNS resolution failed for one or more specified servers.  |
| 23724112   | DNS resolution failed due to an internal error. Contact technical support if this issue persists. |
| 23724132   | DNS resolution failed for all the specified servers.  |
| 23724130   | Cannot use an IPv6 name server address because there are no IPv6 interfaces |
*/
type ClusterNisModifyDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this cluster nis modify default response has a 2xx status code
func (o *ClusterNisModifyDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this cluster nis modify default response has a 3xx status code
func (o *ClusterNisModifyDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this cluster nis modify default response has a 4xx status code
func (o *ClusterNisModifyDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this cluster nis modify default response has a 5xx status code
func (o *ClusterNisModifyDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this cluster nis modify default response a status code equal to that given
func (o *ClusterNisModifyDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the cluster nis modify default response
func (o *ClusterNisModifyDefault) Code() int {
	return o._statusCode
}

func (o *ClusterNisModifyDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /security/authentication/cluster/nis][%d] cluster_nis_modify default %s", o._statusCode, payload)
}

func (o *ClusterNisModifyDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /security/authentication/cluster/nis][%d] cluster_nis_modify default %s", o._statusCode, payload)
}

func (o *ClusterNisModifyDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *ClusterNisModifyDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
