// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// NewCreateCertificateSigningRequestParams creates a new CreateCertificateSigningRequestParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewCreateCertificateSigningRequestParams() *CreateCertificateSigningRequestParams {
	return &CreateCertificateSigningRequestParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewCreateCertificateSigningRequestParamsWithTimeout creates a new CreateCertificateSigningRequestParams object
// with the ability to set a timeout on a request.
func NewCreateCertificateSigningRequestParamsWithTimeout(timeout time.Duration) *CreateCertificateSigningRequestParams {
	return &CreateCertificateSigningRequestParams{
		timeout: timeout,
	}
}

// NewCreateCertificateSigningRequestParamsWithContext creates a new CreateCertificateSigningRequestParams object
// with the ability to set a context for a request.
func NewCreateCertificateSigningRequestParamsWithContext(ctx context.Context) *CreateCertificateSigningRequestParams {
	return &CreateCertificateSigningRequestParams{
		Context: ctx,
	}
}

// NewCreateCertificateSigningRequestParamsWithHTTPClient creates a new CreateCertificateSigningRequestParams object
// with the ability to set a custom HTTPClient for a request.
func NewCreateCertificateSigningRequestParamsWithHTTPClient(client *http.Client) *CreateCertificateSigningRequestParams {
	return &CreateCertificateSigningRequestParams{
		HTTPClient: client,
	}
}

/*
CreateCertificateSigningRequestParams contains all the parameters to send to the API endpoint

	for the create certificate signing request operation.

	Typically these are written to a http.Request.
*/
type CreateCertificateSigningRequestParams struct {

	/* Info.

	   CSR info specification
	*/
	Info *models.CertificateSigningRequest

	/* ReturnRecords.

	   The default is false.  If set to true, the records are returned.
	*/
	ReturnRecords *bool

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the create certificate signing request params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *CreateCertificateSigningRequestParams) WithDefaults() *CreateCertificateSigningRequestParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the create certificate signing request params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *CreateCertificateSigningRequestParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(false)
	)

	val := CreateCertificateSigningRequestParams{
		ReturnRecords: &returnRecordsDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the create certificate signing request params
func (o *CreateCertificateSigningRequestParams) WithTimeout(timeout time.Duration) *CreateCertificateSigningRequestParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the create certificate signing request params
func (o *CreateCertificateSigningRequestParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the create certificate signing request params
func (o *CreateCertificateSigningRequestParams) WithContext(ctx context.Context) *CreateCertificateSigningRequestParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the create certificate signing request params
func (o *CreateCertificateSigningRequestParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the create certificate signing request params
func (o *CreateCertificateSigningRequestParams) WithHTTPClient(client *http.Client) *CreateCertificateSigningRequestParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the create certificate signing request params
func (o *CreateCertificateSigningRequestParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithInfo adds the info to the create certificate signing request params
func (o *CreateCertificateSigningRequestParams) WithInfo(info *models.CertificateSigningRequest) *CreateCertificateSigningRequestParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the create certificate signing request params
func (o *CreateCertificateSigningRequestParams) SetInfo(info *models.CertificateSigningRequest) {
	o.Info = info
}

// WithReturnRecords adds the returnRecords to the create certificate signing request params
func (o *CreateCertificateSigningRequestParams) WithReturnRecords(returnRecords *bool) *CreateCertificateSigningRequestParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the create certificate signing request params
func (o *CreateCertificateSigningRequestParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WriteToRequest writes these params to a swagger request
func (o *CreateCertificateSigningRequestParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Info != nil {
		if err := r.SetBodyParam(o.Info); err != nil {
			return err
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
