// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// DcnCertificateGetReader is a Reader for the DcnCertificateGet structure.
type DcnCertificateGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *DcnCertificateGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewDcnCertificateGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewDcnCertificateGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewDcnCertificateGetOK creates a DcnCertificateGetOK with default headers values
func NewDcnCertificateGetOK() *DcnCertificateGetOK {
	return &DcnCertificateGetOK{}
}

/*
DcnCertificateGetOK describes a response with status code 200, with default header values.

OK
*/
type DcnCertificateGetOK struct {
	Payload *models.DcnCertificate
}

// IsSuccess returns true when this dcn certificate get o k response has a 2xx status code
func (o *DcnCertificateGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this dcn certificate get o k response has a 3xx status code
func (o *DcnCertificateGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this dcn certificate get o k response has a 4xx status code
func (o *DcnCertificateGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this dcn certificate get o k response has a 5xx status code
func (o *DcnCertificateGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this dcn certificate get o k response a status code equal to that given
func (o *DcnCertificateGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the dcn certificate get o k response
func (o *DcnCertificateGetOK) Code() int {
	return 200
}

func (o *DcnCertificateGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /dcn/security/client][%d] dcnCertificateGetOK %s", 200, payload)
}

func (o *DcnCertificateGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /dcn/security/client][%d] dcnCertificateGetOK %s", 200, payload)
}

func (o *DcnCertificateGetOK) GetPayload() *models.DcnCertificate {
	return o.Payload
}

func (o *DcnCertificateGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.DcnCertificate)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDcnCertificateGetDefault creates a DcnCertificateGetDefault with default headers values
func NewDcnCertificateGetDefault(code int) *DcnCertificateGetDefault {
	return &DcnCertificateGetDefault{
		_statusCode: code,
	}
}

/*
DcnCertificateGetDefault describes a response with status code -1, with default header values.

Error
*/
type DcnCertificateGetDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this dcn certificate get default response has a 2xx status code
func (o *DcnCertificateGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this dcn certificate get default response has a 3xx status code
func (o *DcnCertificateGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this dcn certificate get default response has a 4xx status code
func (o *DcnCertificateGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this dcn certificate get default response has a 5xx status code
func (o *DcnCertificateGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this dcn certificate get default response a status code equal to that given
func (o *DcnCertificateGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the dcn certificate get default response
func (o *DcnCertificateGetDefault) Code() int {
	return o._statusCode
}

func (o *DcnCertificateGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /dcn/security/client][%d] dcn_certificate_get default %s", o._statusCode, payload)
}

func (o *DcnCertificateGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /dcn/security/client][%d] dcn_certificate_get default %s", o._statusCode, payload)
}

func (o *DcnCertificateGetDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *DcnCertificateGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
