// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// DcnNodeCertificateGetReader is a Reader for the DcnNodeCertificateGet structure.
type DcnNodeCertificateGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *DcnNodeCertificateGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewDcnNodeCertificateGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewDcnNodeCertificateGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewDcnNodeCertificateGetOK creates a DcnNodeCertificateGetOK with default headers values
func NewDcnNodeCertificateGetOK() *DcnNodeCertificateGetOK {
	return &DcnNodeCertificateGetOK{}
}

/*
DcnNodeCertificateGetOK describes a response with status code 200, with default header values.

OK
*/
type DcnNodeCertificateGetOK struct {
	Payload *models.DcnNodeCertificate
}

// IsSuccess returns true when this dcn node certificate get o k response has a 2xx status code
func (o *DcnNodeCertificateGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this dcn node certificate get o k response has a 3xx status code
func (o *DcnNodeCertificateGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this dcn node certificate get o k response has a 4xx status code
func (o *DcnNodeCertificateGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this dcn node certificate get o k response has a 5xx status code
func (o *DcnNodeCertificateGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this dcn node certificate get o k response a status code equal to that given
func (o *DcnNodeCertificateGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the dcn node certificate get o k response
func (o *DcnNodeCertificateGetOK) Code() int {
	return 200
}

func (o *DcnNodeCertificateGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /dcn/security/node/certificates/{dcn-node-name}][%d] dcnNodeCertificateGetOK %s", 200, payload)
}

func (o *DcnNodeCertificateGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /dcn/security/node/certificates/{dcn-node-name}][%d] dcnNodeCertificateGetOK %s", 200, payload)
}

func (o *DcnNodeCertificateGetOK) GetPayload() *models.DcnNodeCertificate {
	return o.Payload
}

func (o *DcnNodeCertificateGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.DcnNodeCertificate)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDcnNodeCertificateGetDefault creates a DcnNodeCertificateGetDefault with default headers values
func NewDcnNodeCertificateGetDefault(code int) *DcnNodeCertificateGetDefault {
	return &DcnNodeCertificateGetDefault{
		_statusCode: code,
	}
}

/*
DcnNodeCertificateGetDefault describes a response with status code -1, with default header values.

Error
*/
type DcnNodeCertificateGetDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this dcn node certificate get default response has a 2xx status code
func (o *DcnNodeCertificateGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this dcn node certificate get default response has a 3xx status code
func (o *DcnNodeCertificateGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this dcn node certificate get default response has a 4xx status code
func (o *DcnNodeCertificateGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this dcn node certificate get default response has a 5xx status code
func (o *DcnNodeCertificateGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this dcn node certificate get default response a status code equal to that given
func (o *DcnNodeCertificateGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the dcn node certificate get default response
func (o *DcnNodeCertificateGetDefault) Code() int {
	return o._statusCode
}

func (o *DcnNodeCertificateGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /dcn/security/node/certificates/{dcn-node-name}][%d] dcn_node_certificate_get default %s", o._statusCode, payload)
}

func (o *DcnNodeCertificateGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /dcn/security/node/certificates/{dcn-node-name}][%d] dcn_node_certificate_get default %s", o._statusCode, payload)
}

func (o *DcnNodeCertificateGetDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *DcnNodeCertificateGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
