// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewDcnNodeCertificateModifyCollectionParams creates a new DcnNodeCertificateModifyCollectionParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewDcnNodeCertificateModifyCollectionParams() *DcnNodeCertificateModifyCollectionParams {
	return &DcnNodeCertificateModifyCollectionParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewDcnNodeCertificateModifyCollectionParamsWithTimeout creates a new DcnNodeCertificateModifyCollectionParams object
// with the ability to set a timeout on a request.
func NewDcnNodeCertificateModifyCollectionParamsWithTimeout(timeout time.Duration) *DcnNodeCertificateModifyCollectionParams {
	return &DcnNodeCertificateModifyCollectionParams{
		timeout: timeout,
	}
}

// NewDcnNodeCertificateModifyCollectionParamsWithContext creates a new DcnNodeCertificateModifyCollectionParams object
// with the ability to set a context for a request.
func NewDcnNodeCertificateModifyCollectionParamsWithContext(ctx context.Context) *DcnNodeCertificateModifyCollectionParams {
	return &DcnNodeCertificateModifyCollectionParams{
		Context: ctx,
	}
}

// NewDcnNodeCertificateModifyCollectionParamsWithHTTPClient creates a new DcnNodeCertificateModifyCollectionParams object
// with the ability to set a custom HTTPClient for a request.
func NewDcnNodeCertificateModifyCollectionParamsWithHTTPClient(client *http.Client) *DcnNodeCertificateModifyCollectionParams {
	return &DcnNodeCertificateModifyCollectionParams{
		HTTPClient: client,
	}
}

/*
DcnNodeCertificateModifyCollectionParams contains all the parameters to send to the API endpoint

	for the dcn node certificate modify collection operation.

	Typically these are written to a http.Request.
*/
type DcnNodeCertificateModifyCollectionParams struct {

	/* ContinueOnFailure.

	   Continue even when the operation fails on one of the records.
	*/
	ContinueOnFailure *bool

	/* DcnCertName.

	   Filter by dcn-cert-name
	*/
	DcnCertName *string

	/* DcnNodeName.

	   Filter by dcn-node-name
	*/
	DcnNodeName *string

	/* Info.

	   Info specification
	*/
	Info DcnNodeCertificateModifyCollectionBody

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* SerialRecords.

	   Perform the operation on the records synchronously.
	*/
	SerialRecords *bool

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the dcn node certificate modify collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *DcnNodeCertificateModifyCollectionParams) WithDefaults() *DcnNodeCertificateModifyCollectionParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the dcn node certificate modify collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *DcnNodeCertificateModifyCollectionParams) SetDefaults() {
	var (
		continueOnFailureDefault = bool(false)

		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)

		serialRecordsDefault = bool(false)
	)

	val := DcnNodeCertificateModifyCollectionParams{
		ContinueOnFailure: &continueOnFailureDefault,
		ReturnRecords:     &returnRecordsDefault,
		ReturnTimeout:     &returnTimeoutDefault,
		SerialRecords:     &serialRecordsDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the dcn node certificate modify collection params
func (o *DcnNodeCertificateModifyCollectionParams) WithTimeout(timeout time.Duration) *DcnNodeCertificateModifyCollectionParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the dcn node certificate modify collection params
func (o *DcnNodeCertificateModifyCollectionParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the dcn node certificate modify collection params
func (o *DcnNodeCertificateModifyCollectionParams) WithContext(ctx context.Context) *DcnNodeCertificateModifyCollectionParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the dcn node certificate modify collection params
func (o *DcnNodeCertificateModifyCollectionParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the dcn node certificate modify collection params
func (o *DcnNodeCertificateModifyCollectionParams) WithHTTPClient(client *http.Client) *DcnNodeCertificateModifyCollectionParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the dcn node certificate modify collection params
func (o *DcnNodeCertificateModifyCollectionParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithContinueOnFailure adds the continueOnFailure to the dcn node certificate modify collection params
func (o *DcnNodeCertificateModifyCollectionParams) WithContinueOnFailure(continueOnFailure *bool) *DcnNodeCertificateModifyCollectionParams {
	o.SetContinueOnFailure(continueOnFailure)
	return o
}

// SetContinueOnFailure adds the continueOnFailure to the dcn node certificate modify collection params
func (o *DcnNodeCertificateModifyCollectionParams) SetContinueOnFailure(continueOnFailure *bool) {
	o.ContinueOnFailure = continueOnFailure
}

// WithDcnCertName adds the dcnCertName to the dcn node certificate modify collection params
func (o *DcnNodeCertificateModifyCollectionParams) WithDcnCertName(dcnCertName *string) *DcnNodeCertificateModifyCollectionParams {
	o.SetDcnCertName(dcnCertName)
	return o
}

// SetDcnCertName adds the dcnCertName to the dcn node certificate modify collection params
func (o *DcnNodeCertificateModifyCollectionParams) SetDcnCertName(dcnCertName *string) {
	o.DcnCertName = dcnCertName
}

// WithDcnNodeName adds the dcnNodeName to the dcn node certificate modify collection params
func (o *DcnNodeCertificateModifyCollectionParams) WithDcnNodeName(dcnNodeName *string) *DcnNodeCertificateModifyCollectionParams {
	o.SetDcnNodeName(dcnNodeName)
	return o
}

// SetDcnNodeName adds the dcnNodeName to the dcn node certificate modify collection params
func (o *DcnNodeCertificateModifyCollectionParams) SetDcnNodeName(dcnNodeName *string) {
	o.DcnNodeName = dcnNodeName
}

// WithInfo adds the info to the dcn node certificate modify collection params
func (o *DcnNodeCertificateModifyCollectionParams) WithInfo(info DcnNodeCertificateModifyCollectionBody) *DcnNodeCertificateModifyCollectionParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the dcn node certificate modify collection params
func (o *DcnNodeCertificateModifyCollectionParams) SetInfo(info DcnNodeCertificateModifyCollectionBody) {
	o.Info = info
}

// WithReturnRecords adds the returnRecords to the dcn node certificate modify collection params
func (o *DcnNodeCertificateModifyCollectionParams) WithReturnRecords(returnRecords *bool) *DcnNodeCertificateModifyCollectionParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the dcn node certificate modify collection params
func (o *DcnNodeCertificateModifyCollectionParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the dcn node certificate modify collection params
func (o *DcnNodeCertificateModifyCollectionParams) WithReturnTimeout(returnTimeout *int64) *DcnNodeCertificateModifyCollectionParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the dcn node certificate modify collection params
func (o *DcnNodeCertificateModifyCollectionParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithSerialRecords adds the serialRecords to the dcn node certificate modify collection params
func (o *DcnNodeCertificateModifyCollectionParams) WithSerialRecords(serialRecords *bool) *DcnNodeCertificateModifyCollectionParams {
	o.SetSerialRecords(serialRecords)
	return o
}

// SetSerialRecords adds the serialRecords to the dcn node certificate modify collection params
func (o *DcnNodeCertificateModifyCollectionParams) SetSerialRecords(serialRecords *bool) {
	o.SerialRecords = serialRecords
}

// WriteToRequest writes these params to a swagger request
func (o *DcnNodeCertificateModifyCollectionParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.ContinueOnFailure != nil {

		// query param continue_on_failure
		var qrContinueOnFailure bool

		if o.ContinueOnFailure != nil {
			qrContinueOnFailure = *o.ContinueOnFailure
		}
		qContinueOnFailure := swag.FormatBool(qrContinueOnFailure)
		if qContinueOnFailure != "" {

			if err := r.SetQueryParam("continue_on_failure", qContinueOnFailure); err != nil {
				return err
			}
		}
	}

	if o.DcnCertName != nil {

		// query param dcn-cert-name
		var qrDcnCertName string

		if o.DcnCertName != nil {
			qrDcnCertName = *o.DcnCertName
		}
		qDcnCertName := qrDcnCertName
		if qDcnCertName != "" {

			if err := r.SetQueryParam("dcn-cert-name", qDcnCertName); err != nil {
				return err
			}
		}
	}

	if o.DcnNodeName != nil {

		// query param dcn-node-name
		var qrDcnNodeName string

		if o.DcnNodeName != nil {
			qrDcnNodeName = *o.DcnNodeName
		}
		qDcnNodeName := qrDcnNodeName
		if qDcnNodeName != "" {

			if err := r.SetQueryParam("dcn-node-name", qDcnNodeName); err != nil {
				return err
			}
		}
	}
	if err := r.SetBodyParam(o.Info); err != nil {
		return err
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.SerialRecords != nil {

		// query param serial_records
		var qrSerialRecords bool

		if o.SerialRecords != nil {
			qrSerialRecords = *o.SerialRecords
		}
		qSerialRecords := swag.FormatBool(qrSerialRecords)
		if qSerialRecords != "" {

			if err := r.SetQueryParam("serial_records", qSerialRecords); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
