// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// DcnNodeCertificateModifyCollectionReader is a Reader for the DcnNodeCertificateModifyCollection structure.
type DcnNodeCertificateModifyCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *DcnNodeCertificateModifyCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewDcnNodeCertificateModifyCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		return nil, runtime.NewAPIError("[PATCH /dcn/security/node/certificates] dcn_node_certificate_modify_collection", response, response.Code())
	}
}

// NewDcnNodeCertificateModifyCollectionOK creates a DcnNodeCertificateModifyCollectionOK with default headers values
func NewDcnNodeCertificateModifyCollectionOK() *DcnNodeCertificateModifyCollectionOK {
	return &DcnNodeCertificateModifyCollectionOK{}
}

/*
DcnNodeCertificateModifyCollectionOK describes a response with status code 200, with default header values.

OK
*/
type DcnNodeCertificateModifyCollectionOK struct {
	Payload *models.ErrorResponse
}

// IsSuccess returns true when this dcn node certificate modify collection o k response has a 2xx status code
func (o *DcnNodeCertificateModifyCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this dcn node certificate modify collection o k response has a 3xx status code
func (o *DcnNodeCertificateModifyCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this dcn node certificate modify collection o k response has a 4xx status code
func (o *DcnNodeCertificateModifyCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this dcn node certificate modify collection o k response has a 5xx status code
func (o *DcnNodeCertificateModifyCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this dcn node certificate modify collection o k response a status code equal to that given
func (o *DcnNodeCertificateModifyCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the dcn node certificate modify collection o k response
func (o *DcnNodeCertificateModifyCollectionOK) Code() int {
	return 200
}

func (o *DcnNodeCertificateModifyCollectionOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /dcn/security/node/certificates][%d] dcnNodeCertificateModifyCollectionOK %s", 200, payload)
}

func (o *DcnNodeCertificateModifyCollectionOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /dcn/security/node/certificates][%d] dcnNodeCertificateModifyCollectionOK %s", 200, payload)
}

func (o *DcnNodeCertificateModifyCollectionOK) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *DcnNodeCertificateModifyCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
DcnNodeCertificateModifyCollectionBody dcn node certificate modify collection body
swagger:model DcnNodeCertificateModifyCollectionBody
*/
type DcnNodeCertificateModifyCollectionBody struct {

	// links
	Links *models.DcnNodeCertificateResponseInlineRecordsInlineArrayItemInlineLinks `json:"_links,omitempty"`

	// Certificate name used by DCN.
	// Example: dcn-node1-cert
	DcnCertName *string `json:"dcn-cert-name,omitempty"`

	// The DCN node name.
	// Example: dcn-node1
	// Read Only: true
	DcnNodeName *string `json:"dcn-node-name,omitempty"`

	// dcn node certificate response inline records
	DcnNodeCertificateResponseInlineRecords []*models.DcnNodeCertificateResponseInlineRecordsInlineArrayItem `json:"records,omitempty"`
}

// Validate validates this dcn node certificate modify collection body
func (o *DcnNodeCertificateModifyCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateDcnNodeCertificateResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *DcnNodeCertificateModifyCollectionBody) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *DcnNodeCertificateModifyCollectionBody) validateDcnNodeCertificateResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.DcnNodeCertificateResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.DcnNodeCertificateResponseInlineRecords); i++ {
		if swag.IsZero(o.DcnNodeCertificateResponseInlineRecords[i]) { // not required
			continue
		}

		if o.DcnNodeCertificateResponseInlineRecords[i] != nil {
			if err := o.DcnNodeCertificateResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this dcn node certificate modify collection body based on the context it is used
func (o *DcnNodeCertificateModifyCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateDcnNodeName(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateDcnNodeCertificateResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *DcnNodeCertificateModifyCollectionBody) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *DcnNodeCertificateModifyCollectionBody) contextValidateDcnNodeName(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"dcn-node-name", "body", o.DcnNodeName); err != nil {
		return err
	}

	return nil
}

func (o *DcnNodeCertificateModifyCollectionBody) contextValidateDcnNodeCertificateResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.DcnNodeCertificateResponseInlineRecords); i++ {

		if o.DcnNodeCertificateResponseInlineRecords[i] != nil {
			if err := o.DcnNodeCertificateResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *DcnNodeCertificateModifyCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *DcnNodeCertificateModifyCollectionBody) UnmarshalBinary(b []byte) error {
	var res DcnNodeCertificateModifyCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
DcnNodeCertificateResponseInlineRecordsInlineArrayItem dcn node certificate response inline records inline array item
swagger:model dcn_node_certificate_response_inline_records_inline_array_item
*/
type DcnNodeCertificateResponseInlineRecordsInlineArrayItem struct {

	// links
	Links *models.DcnNodeCertificateResponseInlineRecordsInlineArrayItemInlineLinks `json:"_links,omitempty"`

	// Certificate name used by DCN.
	// Example: dcn-node1-cert
	DcnCertName *string `json:"dcn-cert-name,omitempty"`

	// The DCN node name.
	// Example: dcn-node1
	// Read Only: true
	DcnNodeName *string `json:"dcn-node-name,omitempty"`
}

// Validate validates this dcn node certificate response inline records inline array item
func (o *DcnNodeCertificateResponseInlineRecordsInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *DcnNodeCertificateResponseInlineRecordsInlineArrayItem) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this dcn node certificate response inline records inline array item based on the context it is used
func (o *DcnNodeCertificateResponseInlineRecordsInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateDcnNodeName(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *DcnNodeCertificateResponseInlineRecordsInlineArrayItem) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (o *DcnNodeCertificateResponseInlineRecordsInlineArrayItem) contextValidateDcnNodeName(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "dcn-node-name", "body", o.DcnNodeName); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *DcnNodeCertificateResponseInlineRecordsInlineArrayItem) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *DcnNodeCertificateResponseInlineRecordsInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res DcnNodeCertificateResponseInlineRecordsInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
DcnNodeCertificateResponseInlineRecordsInlineArrayItemInlineLinks dcn node certificate response inline records inline array item inline links
swagger:model dcn_node_certificate_response_inline_records_inline_array_item_inline__links
*/
type DcnNodeCertificateResponseInlineRecordsInlineArrayItemInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this dcn node certificate response inline records inline array item inline links
func (o *DcnNodeCertificateResponseInlineRecordsInlineArrayItemInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *DcnNodeCertificateResponseInlineRecordsInlineArrayItemInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this dcn node certificate response inline records inline array item inline links based on the context it is used
func (o *DcnNodeCertificateResponseInlineRecordsInlineArrayItemInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *DcnNodeCertificateResponseInlineRecordsInlineArrayItemInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *DcnNodeCertificateResponseInlineRecordsInlineArrayItemInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *DcnNodeCertificateResponseInlineRecordsInlineArrayItemInlineLinks) UnmarshalBinary(b []byte) error {
	var res DcnNodeCertificateResponseInlineRecordsInlineArrayItemInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
