// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewDuoGetParams creates a new DuoGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewDuoGetParams() *DuoGetParams {
	return &DuoGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewDuoGetParamsWithTimeout creates a new DuoGetParams object
// with the ability to set a timeout on a request.
func NewDuoGetParamsWithTimeout(timeout time.Duration) *DuoGetParams {
	return &DuoGetParams{
		timeout: timeout,
	}
}

// NewDuoGetParamsWithContext creates a new DuoGetParams object
// with the ability to set a context for a request.
func NewDuoGetParamsWithContext(ctx context.Context) *DuoGetParams {
	return &DuoGetParams{
		Context: ctx,
	}
}

// NewDuoGetParamsWithHTTPClient creates a new DuoGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewDuoGetParamsWithHTTPClient(client *http.Client) *DuoGetParams {
	return &DuoGetParams{
		HTTPClient: client,
	}
}

/*
DuoGetParams contains all the parameters to send to the API endpoint

	for the duo get operation.

	Typically these are written to a http.Request.
*/
type DuoGetParams struct {

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* OwnerUUID.

	   Account owner UUID.
	*/
	OwnerUUID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the duo get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *DuoGetParams) WithDefaults() *DuoGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the duo get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *DuoGetParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the duo get params
func (o *DuoGetParams) WithTimeout(timeout time.Duration) *DuoGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the duo get params
func (o *DuoGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the duo get params
func (o *DuoGetParams) WithContext(ctx context.Context) *DuoGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the duo get params
func (o *DuoGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the duo get params
func (o *DuoGetParams) WithHTTPClient(client *http.Client) *DuoGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the duo get params
func (o *DuoGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithFields adds the fields to the duo get params
func (o *DuoGetParams) WithFields(fields []string) *DuoGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the duo get params
func (o *DuoGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithOwnerUUID adds the ownerUUID to the duo get params
func (o *DuoGetParams) WithOwnerUUID(ownerUUID string) *DuoGetParams {
	o.SetOwnerUUID(ownerUUID)
	return o
}

// SetOwnerUUID adds the ownerUuid to the duo get params
func (o *DuoGetParams) SetOwnerUUID(ownerUUID string) {
	o.OwnerUUID = ownerUUID
}

// WriteToRequest writes these params to a swagger request
func (o *DuoGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	// path param owner.uuid
	if err := r.SetPathParam("owner.uuid", o.OwnerUUID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamDuoGet binds the parameter fields
func (o *DuoGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}
